/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller.visit.component.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmAttachment;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.SfaClientData;
import com.biz.crm.base.SfaClientHelper;
import com.biz.crm.base.attachment.ISfaAttachmentService;
import com.biz.crm.base.attachment.SfaAttachmentEntity;
import com.biz.crm.base.utils.SfaAttachmentUtil;
import com.biz.crm.eunm.sfa.AttachmentBizTypeEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepRedisExecutor;
import com.biz.crm.moblie.controller.visit.component.VisitDataDurabilityService;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.moblie.controller.visit.req.ClientReq;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorWorkbenchLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.StoreCheckStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.StepExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.StoreCheckStepExecuteDataResp;
import com.biz.crm.moblie.controller.workbench.req.StoreCheckWorkbenchDataReq;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.UUIDGenerator;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitstep.model.SfaVisitStepStoreCheckEntity;
import com.biz.crm.visitstep.model.SfaVisitStepStoreCheckEsData;
import com.biz.crm.visitstep.model.SfaVisitStepStoreCheckRedisData;
import com.biz.crm.visitstep.repositories.SfaVisitStepStoreCheckEsDataRepositories;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstep.service.ISfaVisitStepStoreCheckService;
import com.biz.crm.visitstep.service.impl.SfaVisitStepStoreCheckServiceImpl;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@ConditionalOnMissingBean(name={"storeCheckVisitStepExecutorExpandImpl"})
public class StoreCheckVisitStepExecutor<ExecuteReq extends StoreCheckStepExecuteData>
extends AbstractVisitStepRedisExecutor<ExecuteReq, StoreCheckStepExecuteDataResp, ExecutorLoadReq> {
    private static final Logger log = LoggerFactory.getLogger(StoreCheckVisitStepExecutor.class);
    @Resource
    private SfaVisitStepStoreCheckEsDataRepositories sfaVisitStepStoreCheckEsDataRepositories;
    @Resource
    private SfaVisitStepStoreCheckServiceImpl sfaVisitStepStoreCheckServiceImpl;
    @Resource
    private ISfaVisitStepStoreCheckService sfaVisitStepStoreCheckService;
    @Resource
    private ISfaAttachmentService sfaAttachmentService;

    @Override
    protected VisitDataDurabilityService getVisitDataDurabilityService() {
        return this.sfaVisitStepStoreCheckServiceImpl;
    }

    @Override
    protected String visitStepRegistry() {
        return SfaVisitEnum.visitStep.VISIT_STEP_STORE_CHECK.getVal();
    }

    @Override
    public void execute(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        this.check(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        SfaVisitStepStoreCheckRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        this.buildEntity(sfaVisitPlanInfoEntity, redisData);
        redisData.setVisitPlanInfoId(sfaVisitPlanInfoEntity.getId());
        redisData.setLineEnum(SfaVisitEnum.VISIT_OFF_LINE.online);
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode(), visitRedisHashKey.getVisitBigType());
        this.redisService.hmset(redisData.redisHash(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode()).toString(), redisData.buildRedisDataForWrite(), 1296000L);
    }

    @Override
    public void executeOffLine(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        super.check(visitStepExecuteReq);
        SfaVisitStepStoreCheckRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        this.buildEntity(sfaVisitPlanInfoEntity, redisData);
        redisData.setVisitPlanInfoId(sfaVisitPlanInfoEntity.getId());
        redisData.setLineEnum(SfaVisitEnum.VISIT_OFF_LINE.offline);
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode(), visitRedisHashKey.getVisitBigType());
        this.redisService.hmset(redisData.redisHash(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode()).toString(), redisData.buildRedisDataForWrite(), 1296000L);
    }

    public void executeForWorkbench(VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        String id = UUIDGenerator.generate();
        visitStepExecuteReq.setRedisHashKey(id);
        this.check(null, visitStepExecuteReq);
        SfaVisitStepStoreCheckRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        StoreCheckWorkbenchDataReq dataReq = (StoreCheckWorkbenchDataReq)visitStepExecuteReq.getStepExecuteData();
        this.buildEntity(dataReq, redisData);
        redisData.setLineEnum(SfaVisitEnum.VISIT_OFF_LINE.online);
        redisData.setId(id);
        redisData.setVisitPlanInfoId(id);
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        this.dataDurability(Lists.newArrayList((Object[])new SfaVisitStepStoreCheckRedisData[]{redisData}), fromRespVo);
    }

    protected SfaVisitStepStoreCheckRedisData buildRedisData(VisitStepExecuteReq<? extends StoreCheckStepExecuteData> visitStepExecuteReq) {
        StoreCheckStepExecuteData executeData = visitStepExecuteReq.getStepExecuteData();
        SfaVisitStepStoreCheckRedisData redisData = (SfaVisitStepStoreCheckRedisData)CrmBeanUtil.copy((Object)executeData, SfaVisitStepStoreCheckRedisData.class);
        redisData.setRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        redisData.setFormId(visitStepExecuteReq.getFormId());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        redisData.setStepCode(fromRespVo.getStepCode());
        redisData.setRegularShelfDisplayList(executeData.getRegularShelfDisplayList());
        redisData.setMaterialDisplayList(executeData.getMaterialDisplayList());
        redisData.setPriceList(executeData.getPriceList());
        SfaAttachmentUtil.copy(executeData, redisData);
        return redisData;
    }

    @Override
    protected StoreCheckStepExecuteDataResp doLoad(ExecutorLoadReq redisHashKey) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(redisHashKey.getRedisHashKey());
        this.loadAndCheckSfaVisitPlanInfoEntity(redisHashKey.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(redisHashKey.getFormId());
        SfaVisitStepStoreCheckRedisData redisData = (SfaVisitStepStoreCheckRedisData)this.redisService.hmget(SfaVisitStepStoreCheckRedisData.getInstance().redisHash(redisHashKey.getRedisHashKey(), fromRespVo.getStepCode()).toString(), (Object)redisHashKey.getRedisHashKey());
        if (null == redisData) {
            redisData = new SfaVisitStepStoreCheckRedisData(){
                {
                    ArrayList list = Lists.newArrayList();
                    this.setRegularShelfDisplayList(list);
                    this.setMaterialDisplayList(list);
                    this.setPriceList(list);
                    this.initAttachmentExt6();
                }
            };
        }
        StoreCheckStepExecuteDataResp dataResp = (StoreCheckStepExecuteDataResp)CrmBeanUtil.copy((Object)redisData, StoreCheckStepExecuteDataResp.class);
        dataResp.setRegularShelfDisplayList(redisData.getRegularShelfDisplayList());
        dataResp.setMaterialDisplayList(redisData.getMaterialDisplayList());
        dataResp.setPriceList(redisData.getPriceList());
        SfaAttachmentUtil.copy(redisData, dataResp);
        dataResp.setSfaVisitStepFrom(fromRespVo);
        this.controlDataToObj(dataResp);
        return dataResp;
    }

    @Override
    public StepExecuteDataResp getEsDataByVisitPlanInfo(String visitPlanInfoId, String stepCode) {
        SfaVisitStepStoreCheckEsData esData = this.sfaVisitStepStoreCheckEsDataRepositories.findByVisitPlanInfoIdAndStepCode(visitPlanInfoId, stepCode);
        return esData;
    }

    @Override
    public StepExecuteDataResp getEsDataById(String id) {
        Optional optional = this.sfaVisitStepStoreCheckEsDataRepositories.findById(id);
        if (optional.isPresent()) {
            return (StepExecuteDataResp)optional.get();
        }
        throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u6570\u636e\u8be6\u7ec6\u4fe1\u606f!");
    }

    @Override
    protected StoreCheckStepExecuteDataResp doLoadEditPageForWorkbench(ExecutorWorkbenchLoadReq loadParam) {
        String bizId = loadParam.getBizId();
        String visitPlanInfoId = loadParam.getVisitPlanInfoId();
        if (StringUtils.isNotBlank((CharSequence)visitPlanInfoId)) {
            if (StringUtils.isBlank((CharSequence)loadParam.getStepCode())) {
                throw new BusinessException("\u6b65\u9aa4\u7f16\u7801\u4e3a\u7a7a");
            }
            return this.buildDataResp(visitPlanInfoId, loadParam.getStepCode(), null);
        }
        if (StringUtils.isBlank((CharSequence)bizId)) {
            SfaClientData clientData = SfaClientHelper.loadClientData(loadParam.getClientType(), loadParam.getClientCode());
            if (StringUtils.isBlank((CharSequence)loadParam.getStepCode())) {
                throw new BusinessException("\u6b65\u9aa4\u7f16\u7801\u4e3a\u7a7a");
            }
            StoreCheckStepExecuteDataResp dataResp = new StoreCheckStepExecuteDataResp(){
                {
                    ArrayList list = Lists.newArrayList();
                    this.setRegularShelfDisplayList(list);
                    this.setMaterialDisplayList(list);
                    this.setPriceList(list);
                    this.initAttachmentExt6();
                }
            };
            dataResp.setSfaVisitStepFrom(this.getFormData(loadParam.getClientType(), loadParam.getStepCode(), loadParam.getVisitBigType(), clientData.getClientSubclass()));
            return dataResp;
        }
        return this.buildDataResp(null, null, bizId);
    }

    protected StoreCheckStepExecuteDataResp buildDataResp(String visitPlanInfoId, String stepCode, String bizId) {
        SfaVisitStepStoreCheckEntity entity = (SfaVisitStepStoreCheckEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sfaVisitStepStoreCheckService.lambdaQuery().eq(StringUtils.isNotBlank((CharSequence)visitPlanInfoId), SfaVisitStepStoreCheckEntity::getVisitPlanInfoId, (Object)visitPlanInfoId)).eq(StringUtils.isNotBlank((CharSequence)stepCode), SfaVisitStepStoreCheckEntity::getStepCode, (Object)stepCode)).eq(StringUtils.isNotBlank((CharSequence)bizId), BaseIdEntity::getId, (Object)bizId)).one();
        ArrayList type = Lists.newArrayList((Object[])new String[]{AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_REGULAR_SHELF_DISPLAY.getVal(), AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_MATERIAL_DISPLAY.getVal(), AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_PRICE.getVal()});
        StoreCheckStepExecuteDataResp dataResp = (StoreCheckStepExecuteDataResp)CrmBeanUtil.copy((Object)entity, StoreCheckStepExecuteDataResp.class);
        Map<String, List<SfaAttachmentEntity>> attachmentMap = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sfaAttachmentService.lambdaQuery().eq(SfaAttachmentEntity::getBizId, (Object)entity.getId())).in(SfaAttachmentEntity::getAttachmentBizType, (Collection)type)).list().stream().collect(Collectors.groupingBy(SfaAttachmentEntity::getAttachmentBizType));
        attachmentMap.entrySet().forEach(data -> {
            List attachments = CrmBeanUtil.copyList((List)((List)data.getValue()), CrmAttachment.class);
            if (AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_REGULAR_SHELF_DISPLAY.getVal().equals(data.getKey())) {
                dataResp.setRegularShelfDisplayList(attachments);
            } else if (AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_PRICE.getVal().equals(data.getKey())) {
                dataResp.setPriceList(attachments);
            } else if (AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_MATERIAL_DISPLAY.getVal().equals(data.getKey())) {
                dataResp.setMaterialDisplayList(attachments);
            }
        });
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(entity.getFormId());
        if (fromRespVo != null) {
            dataResp.setSfaVisitStepFrom(fromRespVo);
        }
        this.controlDataToObj(dataResp);
        return dataResp;
    }

    private StoreCheckStepExecuteDataResp buildDataResp(SfaVisitStepStoreCheckEsData redisData) {
        if (null == redisData) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u6570\u636e\u8be6\u7ec6\u4fe1\u606f!");
        }
        StoreCheckStepExecuteDataResp dataResp = (StoreCheckStepExecuteDataResp)CrmBeanUtil.copy((Object)redisData, StoreCheckStepExecuteDataResp.class);
        dataResp.setRegularShelfDisplayList(redisData.getRegularShelfDisplayList());
        dataResp.setMaterialDisplayList(redisData.getMaterialDisplayList());
        dataResp.setPriceList(redisData.getPriceList());
        SfaAttachmentUtil.copy(redisData, dataResp);
        dataResp.setSfaVisitStepFrom(redisData.getSfaVisitStepFrom());
        return dataResp;
    }

    protected void buildEntity(ClientReq sfaVisitPlanInfoEntity, SfaVisitStepStoreCheckRedisData storeCheckRedisData) {
        this.checkClientReq(sfaVisitPlanInfoEntity);
        CrmBaseEntity.buildDefEntityData((CrmBaseEntity)storeCheckRedisData);
        StringJoiner checkType = new StringJoiner(",");
        StringJoiner checkTypeDesc = new StringJoiner(",");
        if (!CollectionUtils.isEmpty(storeCheckRedisData.getRegularShelfDisplayList())) {
            checkType.add(AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_REGULAR_SHELF_DISPLAY.getVal());
            checkTypeDesc.add(AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_REGULAR_SHELF_DISPLAY.getDesc());
        }
        if (!CollectionUtils.isEmpty(storeCheckRedisData.getMaterialDisplayList())) {
            checkType.add(AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_MATERIAL_DISPLAY.getVal());
            checkTypeDesc.add(AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_MATERIAL_DISPLAY.getDesc());
        }
        if (!CollectionUtils.isEmpty(storeCheckRedisData.getPriceList())) {
            checkType.add(AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_PRICE.getVal());
            checkTypeDesc.add(AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_PRICE.getDesc());
        }
        storeCheckRedisData.setCheckType(checkType.toString());
        storeCheckRedisData.setCheckTypeDesc(checkTypeDesc.toString());
        if (sfaVisitPlanInfoEntity instanceof SfaVisitPlanInfoEntity) {
            this.buildClientData(storeCheckRedisData, (SfaVisitPlanInfoEntity)sfaVisitPlanInfoEntity);
        } else {
            this.buildClientData(storeCheckRedisData, sfaVisitPlanInfoEntity.getClientCode(), sfaVisitPlanInfoEntity.getClientType());
        }
        storeCheckRedisData.setCheckTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        storeCheckRedisData.setCheckDate(LocalDateTime.now().format(CrmDateUtils.yyyyMMdd));
        storeCheckRedisData.setCheckYearMonth(LocalDateTime.now().format(CrmDateUtils.yyyyMM));
        storeCheckRedisData.setCheckYear(LocalDateTime.now().format(CrmDateUtils.yyyy));
        UserRedis userRedis = UserUtils.getUser();
        storeCheckRedisData.setUserName(userRedis.getUsername());
        storeCheckRedisData.setRealName(userRedis.getUsername());
        storeCheckRedisData.setPosCode(userRedis.getPoscode());
        storeCheckRedisData.setPosName(userRedis.getPosname());
        storeCheckRedisData.setOrgCode(userRedis.getOrgcode());
        storeCheckRedisData.setOrgName(userRedis.getOrgname());
    }

    protected void check(SfaVisitPlanInfoEntity entity, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        this.controlDataTrans(visitStepExecuteReq);
        StoreCheckStepExecuteData storeCheckStepExecuteData = (StoreCheckStepExecuteData)visitStepExecuteReq.getStepExecuteData();
        if (null == storeCheckStepExecuteData) {
            throw new BusinessException("\u6267\u884c\u6570\u636e\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)storeCheckStepExecuteData.getCheckAddress())) {
            throw new BusinessException("\u5b9a\u4f4d\u5730\u5740\u4fe1\u606f\u4e3a\u7a7a");
        }
        super.checkLongitudeAndLatitude(visitStepExecuteReq, entity, storeCheckStepExecuteData.getLongitude(), storeCheckStepExecuteData.getLatitude());
        this.checkPics(storeCheckStepExecuteData.getRegularShelfDisplayList(), 1, 5, "\u5e38\u89c4\u8d27\u67b6\u9648\u5217");
        this.checkPics(storeCheckStepExecuteData.getMaterialDisplayList(), 1, 5, "\u7269\u6599\u9648\u5217\u4e3a\u7a7a");
        this.checkPics(storeCheckStepExecuteData.getPriceList(), 1, 5, "\u4ef7\u683c\u7b7e\u4e3a\u7a7a");
    }

    @Override
    protected List<? extends VisitStepListener.VisitStepListenerCommittedData> loadRedisDataList(ExecutorLoadReq loadParam) {
        SfaVisitStepStoreCheckRedisData redisData = (SfaVisitStepStoreCheckRedisData)this.redisService.hmget(SfaVisitStepStoreCheckRedisData.getInstance().redisHash(loadParam.getRedisHashKey(), loadParam.getStepCode()).toString(), (Object)loadParam.getRedisHashKey());
        if (null == redisData) {
            log.warn("\u5c06\u6570\u636e\u4f20\u8f93\u5230ES: \u6ca1\u6709\u6267\u884c\u6570\u636e\u9700\u8981\u4f20\u8f93\uff08\u53ef\u80fd\u7528\u6237\u6ca1\u6709\u6267\u884c\u8be5\u6b65\u9aa4\uff09\uff0cexecutorLoadReq={}", (Object)JsonPropertyUtil.toJsonString((Object)((Object)loadParam)));
            return null;
        }
        return Lists.newArrayList((Object[])new SfaVisitStepStoreCheckRedisData[]{redisData});
    }
}

