/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.service.impl;

import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.CrmRedisHashKeyVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.mdm.productlevel.MdmProductLevelFeign;
import com.biz.crm.moblie.service.ISfaVisitOffLineService;
import com.biz.crm.moblie.visitoffline.SfaVisitOffLineComponent;
import com.biz.crm.moblie.visitoffline.stepcomponent.photoutil.SfaVisitStepOffLineUtil;
import com.biz.crm.moblie.visitoffline.stepdatavo.req.SfaVisitOffLineReqVo;
import com.biz.crm.nebular.activiti.vo.AttachmentOffLineVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductBySfaReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductBySfaRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRespVo;
import com.biz.crm.nebular.sfa.visitstep.visitoffline.VisitOffLineDataVo;
import com.biz.crm.nebular.sfa.visitstep.visitoffline.VisitOfflineReqVo;
import com.biz.crm.nebular.sfa.visitstep.visitoffline.VisitStepOffLienVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.ProductLevelUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoRedisData;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"SfaVisitOffLineServiceExpandImpl"})
public class SfaVisitOffLineServiceImpl
implements ISfaVisitOffLineService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitOffLineServiceImpl.class);
    private static final String REDIS_HASH_KEY = "visit_off_line";
    private static final Long REDIS_EXPIRE_TIME = 7200L;
    @Resource
    private RedisService redisService;
    @Resource
    private SfaVisitOffLineComponent sfaVisitOffLineComponent;
    @Resource
    private MdmProductFeign mdmProductFeign;
    @Resource
    private MdmProductLevelFeign mdmProductLevelFeign;

    @Override
    public VisitOffLineDataVo getVisitOffLineData(CrmRedisHashKeyVo redisHashKeyVo) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(redisHashKeyVo.getRedisHashKey());
        SfaVisitStepOffLineUtil util = new SfaVisitStepOffLineUtil();
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = (SfaVisitPlanInfoEntity)this.redisService.hmget(util.getRedisHashKey(visitRedisHashKey.getVisitBigType()), (Object)util.getFiled(visitRedisHashKey.getClientCode(), visitRedisHashKey.getVisitBigType()));
        SfaVisitPlanInfoRedisData doingData = (SfaVisitPlanInfoRedisData)this.redisService.hmget(SfaVisitPlanInfoRedisData.getInstance().redisHashCurrent(sfaVisitPlanInfoEntity.getVisitDate(), visitRedisHashKey.getVisitBigType()).toString(), (Object)redisHashKeyVo.getRedisHashKey());
        VisitOffLineDataVo dataVo = (VisitOffLineDataVo)CrmBeanUtil.copy((Object)((Object)doingData.getSfaVisitPlanInfoExecuteRedisData()), VisitOffLineDataVo.class);
        dataVo.setClientPhoto(doingData.getClientPhoto());
        List stepOffLienVos = CrmBeanUtil.copyList(doingData.getStep(), VisitStepOffLienVo.class);
        List<VisitOfflineReqVo> stepCodeList = stepOffLienVos.stream().map(data -> {
            VisitOfflineReqVo reqVo = VisitOfflineReqVo.builder().stepCode(data.getStepCode()).visitPlanInfoId(sfaVisitPlanInfoEntity.getId()).clientCode(sfaVisitPlanInfoEntity.getClientCode()).clientType(sfaVisitPlanInfoEntity.getClientType()).formId(data.getFormId()).redisHashKey(redisHashKeyVo.getRedisHashKey()).build();
            return reqVo;
        }).collect(Collectors.toList());
        Map<String, Object> stepMap = this.sfaVisitOffLineComponent.buildVisitStepData(stepCodeList);
        for (VisitStepOffLienVo data2 : stepOffLienVos) {
            if (!stepMap.containsKey(data2.getStepCode())) continue;
            data2.setExecuteData(stepMap.get(data2.getStepCode()));
        }
        dataVo.setSteps(stepOffLienVos);
        dataVo.setProductRespVos(this.getProductList());
        dataVo.setProductLevelVoList(this.getProductLevel());
        return dataVo;
    }

    @Override
    public void saveVisitOffLineData(List<SfaVisitOffLineReqVo> reqVoList) {
        ArrayList<SfaVisitOffLineReqVo> dataList = new ArrayList<SfaVisitOffLineReqVo>();
        reqVoList.forEach(data -> {
            AssertUtils.isNotEmpty((String)data.getStepCode(), (String)"\u62dc\u8bbf\u6b65\u9aa4\u7f16\u7801\u4e3a\u7a7a");
            if (null != data.getReq()) {
                dataList.add((SfaVisitOffLineReqVo)data);
            }
        });
        String resultMsg = this.sfaVisitOffLineComponent.saveSfaVisitStepData(dataList);
        if (null != resultMsg && resultMsg.length() > 0) {
            throw new BusinessException(resultMsg);
        }
    }

    @Override
    public void saveOffLineFile(List<AttachmentOffLineVo> list) {
        Map<String, List<AttachmentOffLineVo>> fileMap = list.stream().collect(Collectors.groupingBy(AttachmentOffLineVo::getKeyFields));
        this.sfaVisitOffLineComponent.saveOffLineFile(fileMap);
    }

    private List<MdmProductBySfaRespVo> getProductList() {
        MdmProductBySfaReqVo reqVo = new MdmProductBySfaReqVo();
        reqVo.setPageSize(Integer.valueOf(-1));
        PageResult pageResult = (PageResult)ApiResultUtil.objResult((Result)this.mdmProductFeign.findProductListSourceSfa(reqVo), (boolean)true);
        if (null == pageResult) {
            throw new BusinessException("\u5546\u54c1\u4e3a\u7a7a");
        }
        return pageResult.getData();
    }

    private List<VisitOffLineDataVo.MdmProductLevelVo> getProductLevel() {
        Result result = this.mdmProductLevelFeign.getAllProductLevelList();
        List productLevelRespVoList = (List)ApiResultUtil.objResult((Result)result, (boolean)result.isSuccess());
        List<VisitOffLineDataVo.MdmProductLevelVo> productLevelOne = productLevelRespVoList.stream().filter(data -> null == data.getParentCode() || "".equals(data.getParentCode())).map(data -> {
            VisitOffLineDataVo.MdmProductLevelVo levelVo = (VisitOffLineDataVo.MdmProductLevelVo)CrmBeanUtil.copy((Object)data, VisitOffLineDataVo.MdmProductLevelVo.class);
            return levelVo;
        }).collect(Collectors.toList());
        Map<String, List<MdmProductLevelRespVo>> levelTwoMap = productLevelRespVoList.stream().filter(data -> StringUtils.isNotEmpty((String)data.getParentCode())).collect(Collectors.groupingBy(MdmProductLevelRespVo::getParentCode));
        ArrayList productLevelCodeList = new ArrayList();
        levelTwoMap.entrySet().forEach(data -> {
            List productLevelCode = ((List)data.getValue()).stream().map(MdmProductLevelRespVo::getProductLevelCode).collect(Collectors.toList());
            productLevelCodeList.addAll(productLevelCode);
        });
        Result productResult = this.mdmProductFeign.queryBatchByProductLevelCodeList(productLevelCodeList);
        Map<String, List<MdmProductRespVo>> mdmProductMap = ((List)ApiResultUtil.objResult((Result)productResult, (boolean)productResult.isSuccess())).stream().collect(Collectors.groupingBy(MdmProductRespVo::getProductLevelCode));
        productLevelOne.forEach(data -> {
            if (levelTwoMap.containsKey(data.getProductLevelCode())) {
                List levelVoList = CrmBeanUtil.copyList((List)((List)levelTwoMap.get(data.getProductLevelCode())), VisitOffLineDataVo.MdmProductLevelVo.class);
                levelVoList.forEach(levelTwo -> {
                    ArrayList levelCodeList = ProductLevelUtil.getChildrenProductLevelListExcludeSelf((String)levelTwo.getProductLevelCode()).stream().filter(pd -> null != pd).map(MdmProductLevelRespVo::getProductLevelCode).collect(Collectors.toList());
                    if (!CollectionUtil.listNotEmptyNotSizeZero(levelCodeList)) {
                        levelCodeList = Lists.newArrayList((Object[])new String[]{levelTwo.getProductLevelCode()});
                    }
                    ArrayList productList = new ArrayList();
                    levelCodeList.forEach(levelCode -> {
                        if (mdmProductMap.containsKey(levelCode)) {
                            List pdList = CrmBeanUtil.copyList((List)((List)mdmProductMap.get(levelCode)), VisitOffLineDataVo.MdmProductVo.class);
                            productList.addAll(pdList);
                        }
                    });
                    if (CollectionUtil.listNotEmptyNotSizeZero(productList)) {
                        levelTwo.setProductList(productList);
                    }
                });
                data.setProductLevelList(levelVoList);
            }
        });
        return productLevelOne;
    }

    private String buildRedisHashKey(String redisHashKey, String visitPlanInfoId) {
        return "visit_off_line:" + visitPlanInfoId + LocalDate.now().format(CrmDateUtils.yyyyMMdd);
    }

    private Map<String, VisitOffLineDataVo> buildRedisMap(String visitPlanInfoId, VisitOffLineDataVo vo) {
        String now = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        HashMap<String, VisitOffLineDataVo> map = new HashMap<String, VisitOffLineDataVo>();
        String key = visitPlanInfoId + ":" + now;
        map.put(key, vo);
        return map;
    }
}

