/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.visitoffline.stepcomponent;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.attachment.SfaAttachmentEntity;
import com.biz.crm.base.utils.SfaAttachmentUtil;
import com.biz.crm.eunm.sfa.AttachmentBizTypeEnum;
import com.biz.crm.moblie.controller.visit.component.impl.StoreCheckVisitStepExecutor;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.StoreCheckStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.step.StoreCheckStepExecuteDataResp;
import com.biz.crm.moblie.visitoffline.SfaVisitStepOffLineStrategy;
import com.biz.crm.moblie.visitoffline.stepcomponent.photoutil.SfaVisitStepOffLineUtil;
import com.biz.crm.moblie.visitoffline.stepdatavo.SfaVisitStepStoreCheckVo;
import com.biz.crm.moblie.visitoffline.stepdatavo.req.SfaVisitOffLinePhotoVo;
import com.biz.crm.moblie.visitoffline.stepdatavo.req.VisitStepOffLineExecuteReq;
import com.biz.crm.nebular.activiti.vo.AttachmentOffLineVo;
import com.biz.crm.nebular.sfa.visitstep.visitoffline.VisitOfflineReqVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.biz.crm.visitstep.model.SfaVisitStepStoreCheckEntity;
import com.biz.crm.visitstep.service.ISfaVisitStepStoreCheckService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

@Component(value="sfa_step_code_store_check_expandBean")
@ConditionalOnMissingBean(name={"SfaStepStoreCheckComponentExpandImpl"})
public class SfaStepStoreCheckComponent
implements SfaVisitStepOffLineStrategy {
    private static final Logger log = LoggerFactory.getLogger(SfaStepStoreCheckComponent.class);
    private static String STEP_CODE;
    private static final String REGULAR_SHELF_DISPLAY = "\u5e38\u89c4\u8d27\u67b6\u9648\u5217";
    private static final String MATERIAL_DISPLAY = "\u7269\u6599\u9648\u5217";
    private static final String PRICE_DISPLAY = "\u4ef7\u683c\u6807\u7b7e";
    @Resource
    private StoreCheckVisitStepExecutor storeCheckVisitStepExecutor;
    @Resource
    private ISfaVisitStepStoreCheckService sfaVisitStepStoreCheckService;

    public Object buildVisitStepOffLineData(VisitOfflineReqVo reqVo) {
        SfaVisitStepStoreCheckVo vo = new SfaVisitStepStoreCheckVo();
        SfaVisitStepOffLineUtil util = new SfaVisitStepOffLineUtil(this.getStepCode(), reqVo.getVisitPlanInfoId());
        ExecutorLoadReq req = (ExecutorLoadReq)((Object)CrmBeanUtil.copy((Object)reqVo, ExecutorLoadReq.class));
        StoreCheckStepExecuteDataResp dataResp = (StoreCheckStepExecuteDataResp)this.storeCheckVisitStepExecutor.load(req);
        vo.setSfaVisitStepFrom(dataResp.getSfaVisitStepFrom());
        SfaVisitOffLinePhotoVo regularShelfDisplay = SfaVisitOffLinePhotoVo.builder().key(REGULAR_SHELF_DISPLAY).photoKey(util.getPhotoOffLineKey(AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_REGULAR_SHELF_DISPLAY.getVal(), AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_REGULAR_SHELF_DISPLAY.getDesc())).build();
        SfaVisitOffLinePhotoVo materialDisplay = SfaVisitOffLinePhotoVo.builder().key(MATERIAL_DISPLAY).photoKey(util.getPhotoOffLineKey(AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_MATERIAL_DISPLAY.getVal(), AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_MATERIAL_DISPLAY.getDesc())).build();
        SfaVisitOffLinePhotoVo checkPrice = SfaVisitOffLinePhotoVo.builder().key(PRICE_DISPLAY).photoKey(util.getPhotoOffLineKey(AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_PRICE.getVal(), AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_PRICE.getDesc())).build();
        ArrayList offLinePhotoVoList = Lists.newArrayList((Object[])new SfaVisitOffLinePhotoVo[]{regularShelfDisplay, materialDisplay, checkPrice});
        vo.setOffLinePhotoKey(offLinePhotoVoList);
        return vo;
    }

    @Override
    public Result saveVisitStepOffLine(VisitStepOffLineExecuteReq req) {
        Result result = new Result();
        try {
            VisitStepExecuteReq visitStepExecuteReq = (VisitStepExecuteReq)CrmBeanUtil.copy((Object)req, VisitStepExecuteReq.class);
            StoreCheckStepExecuteData executeData = (StoreCheckStepExecuteData)JSONObject.parseObject((String)JSONObject.toJSONString((Object)req.getStepExecuteData()), StoreCheckStepExecuteData.class);
            visitStepExecuteReq.setStepExecuteData(executeData);
            this.storeCheckVisitStepExecutor.executeOffLine(visitStepExecuteReq);
        }
        catch (BusinessException e) {
            log.error("\u5e97\u9762\u68c0\u67e5\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMsg());
            result.setSuccess(false);
            result.setMessage("\u5e97\u9762\u68c0\u67e5:\u9519\u8bef\u4fe1\u606f[" + e.getMsg() + "]");
        }
        return result;
    }

    @Override
    public void saveVisitStepOffLineFile(List<AttachmentOffLineVo> list, SfaVisitStepOffLineUtil util) {
        SfaVisitStepStoreCheckEntity entity = (SfaVisitStepStoreCheckEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sfaVisitStepStoreCheckService.lambdaQuery().eq(SfaVisitStepStoreCheckEntity::getVisitPlanInfoId, (Object)util.getVisitPlanInfoId())).eq(SfaVisitStepStoreCheckEntity::getStepCode, (Object)util.getStepCode())).select(new SFunction[]{BaseIdEntity::getId}).one();
        if (null != entity) {
            List<SfaAttachmentEntity> fileEntity = list.stream().map(data -> {
                SfaAttachmentEntity file = (SfaAttachmentEntity)((Object)((Object)CrmBeanUtil.copy((Object)data, SfaAttachmentEntity.class)));
                file.setBizId(entity.getId());
                file.setAttachmentBizType(util.getType());
                file.setAttachmentBizTypeName(util.getTypeName());
                return file;
            }).collect(Collectors.toList());
            SfaAttachmentUtil.insert(fileEntity);
        }
    }

    @Override
    public String getStepCode() {
        return STEP_CODE;
    }

    @Override
    public void setStepCode(String stepCode) {
        STEP_CODE = stepCode;
    }
}

