/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpmact.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.nebular.sfa.tpmact.SfaTpmActTerminalVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActDetailExecuteRespVo;
import com.biz.crm.tpmact.mapper.SfaTpmActDetailExecuteMapper;
import com.biz.crm.tpmact.model.SfaTpmActDetailExecuteEntity;
import com.biz.crm.tpmact.service.ISfaTpmActDetailExecuteService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"SfaTpmActDetailExecuteServiceExpandImpl"})
public class SfaTpmActDetailExecuteServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaTpmActDetailExecuteMapper, SfaTpmActDetailExecuteEntity>
implements ISfaTpmActDetailExecuteService {
    private static final Logger log = LoggerFactory.getLogger(SfaTpmActDetailExecuteServiceImpl.class);
    @Resource
    private SfaTpmActDetailExecuteMapper sfaTpmActDetailExecuteMapper;

    @Override
    public void saveTpmActExecute(SfaTpmActDetailExecuteRespVo respVo) {
        SfaTpmActDetailExecuteEntity executeEntity = (SfaTpmActDetailExecuteEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaTpmActDetailExecuteEntity::getActDetailCode, (Object)respVo.getActDetailCode())).eq(SfaTpmActDetailExecuteEntity::getTerminalCode, (Object)respVo.getTerminalCode())).one());
        if (executeEntity != null) {
            return;
        }
        executeEntity = new SfaTpmActDetailExecuteEntity();
        executeEntity.setActDetailCode(respVo.getActDetailCode());
        executeEntity.setTerminalCode(respVo.getTerminalCode());
        this.save((Object)executeEntity);
    }

    @Override
    public void resolvingHistoryData() {
        ArrayList executeEntityList = new ArrayList();
        List<SfaTpmActTerminalVo> actTerminalVos = this.sfaTpmActDetailExecuteMapper.findTpmActTerminal();
        if (CollectionUtil.listNotEmptyNotSizeZero(actTerminalVos)) {
            Map<String, List> actTerminalMap = actTerminalVos.stream().collect(Collectors.groupingBy(SfaTpmActTerminalVo::getActDetailCode)).entrySet().stream().collect(Collectors.toMap(data -> (String)data.getKey(), data -> {
                HashSet terminalCodes = new HashSet();
                ((List)data.getValue()).forEach(x -> {
                    if (StringUtils.isNotEmpty((String)x.getTreatyTerminalCode())) {
                        terminalCodes.add(x.getTreatyTerminalCode());
                    }
                    if (StringUtils.isNotEmpty((String)x.getOrderTerminalCode())) {
                        terminalCodes.add(x.getOrderTerminalCode());
                    }
                    if (StringUtils.isNotEmpty((String)x.getCollectTerminalCode())) {
                        terminalCodes.add(x.getCollectTerminalCode());
                    }
                });
                return new ArrayList(terminalCodes);
            }));
            actTerminalMap.entrySet().forEach(data -> ((List)data.getValue()).forEach(x -> {
                SfaTpmActDetailExecuteEntity entity = new SfaTpmActDetailExecuteEntity();
                entity.setTerminalCode((String)x);
                entity.setActDetailCode((String)data.getKey());
                executeEntityList.add(entity);
            }));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(executeEntityList)) {
            this.saveBatch(executeEntityList);
        }
    }
}

