/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitinfo.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.collection.controller.resp.VisitStepResp;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoStepFormRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.visitinfo.mapper.SfaVisitInfoStepFormMapper;
import com.biz.crm.visitinfo.mapper.SfaVisitPlanInfoMapper;
import com.biz.crm.visitinfo.model.SfaVisitInfoStepFormEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.service.ISfaVisitInfoStepFormService;
import com.biz.crm.visitinfo.stepformcomponent.SfaVisitPlanInfoStepFormComponent;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"SfaVisitInfoStepFormServiceExpandImpl"})
public class SfaVisitInfoStepFormServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaVisitInfoStepFormMapper, SfaVisitInfoStepFormEntity>
implements ISfaVisitInfoStepFormService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitInfoStepFormServiceImpl.class);
    @Resource
    private SfaVisitInfoStepFormMapper sfaVisitInfoStepFormMapper;
    @Resource
    private SfaVisitPlanInfoMapper sfaVisitPlanInfoMapper;
    @Resource
    private SfaVisitPlanInfoStepFormComponent sfaVisitPlanInfoStepFormComponent;
    private static final Integer PAGE_SIZE = 500;

    @Override
    public void saveSfaVisitInfoForm(List<VisitStepResp> list, SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity) {
        String visitPlanInfoId = sfaVisitPlanInfoEntity.getId();
        String visitPlanInfoCode = sfaVisitPlanInfoEntity.getVisitPlanCode();
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaVisitInfoStepFormEntity.class).eq(SfaVisitInfoStepFormEntity::getVisitPlanInfoId, (Object)visitPlanInfoId)).eq(SfaVisitInfoStepFormEntity::getVisitPlanCode, (Object)visitPlanInfoCode);
        List formList = this.sfaVisitInfoStepFormMapper.selectList((Wrapper)wrapper);
        if (CollectionUtil.listEmpty((List)formList)) {
            List entities = list.stream().filter(l -> !l.getStepCode().equals(SfaVisitEnum.SfaStepCode.SFA_STEP_CODE_IN_STORE.getVal()) && !l.getStepCode().equals(SfaVisitEnum.SfaStepCode.SFA_STEP_CODE_OUT_STORE.getVal())).map(l -> {
                SfaVisitInfoStepFormEntity entity = (SfaVisitInfoStepFormEntity)((Object)((Object)CrmBeanUtil.copy((Object)l, SfaVisitInfoStepFormEntity.class)));
                entity.setVisitPlanInfoId(visitPlanInfoId);
                entity.setVisitPlanCode(visitPlanInfoCode);
                entity.setSortNum(l.getSort());
                return entity;
            }).collect(Collectors.toList());
            this.saveBatch(entities);
        }
    }

    @Override
    public void updateVisitStepStatus(String stepCode, String visitPlanInfoId) {
        SfaVisitInfoStepFormEntity formEntity = (SfaVisitInfoStepFormEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitInfoStepFormEntity::getVisitPlanInfoId, (Object)visitPlanInfoId)).eq(SfaVisitInfoStepFormEntity::getStepCode, (Object)stepCode)).one());
        if (formEntity != null) {
            formEntity.setIsSuccessDesc(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getDesc());
            formEntity.setIsSuccess(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getVal());
            this.updateById((Object)formEntity);
        }
    }

    @Override
    public void resolvingVisitPlanInfoStepForm(String visitDate) {
        List<Object> list;
        AssertUtils.isNotEmpty((String)visitDate, (String)"\u89e3\u6790\u8fc7\u53bb\u62dc\u8bbf\u660e\u7ec6\u6570\u636e\u7684\u65e5\u671f\u4e3a\u7a7a");
        Page page = new Page(1L, (long)PAGE_SIZE.intValue());
        List<SfaVisitPlanInfoStepFormRespVo> formList = this.sfaVisitPlanInfoMapper.findVisitPlanInfoStepFormList((Page<SfaVisitPlanInfoStepFormRespVo>)page, visitDate);
        if (!CollectionUtil.listNotEmptyNotSizeZero(formList)) {
            return;
        }
        List<SfaVisitPlanInfoStepFormRespVo> list2 = formList.stream().collect(Collectors.groupingBy(SfaVisitPlanInfoStepFormRespVo::getVisitPlanInfoId)).entrySet().stream().map(data -> (SfaVisitPlanInfoStepFormRespVo)((List)data.getValue()).get(0)).collect(Collectors.toList());
        list2 = this.sfaVisitPlanInfoStepFormComponent.getVisitPlanInfoRedisDataByEs(list2);
        this.sfaVisitPlanInfoStepFormComponent.resolvingStepForm(list2);
        Integer size = 0;
        if (page.getTotal() > (long)PAGE_SIZE.intValue()) {
            size = (int)page.getTotal() / PAGE_SIZE;
            if ((int)page.getTotal() % PAGE_SIZE > 0) {
                size = size + 2;
            } else {
                Integer n = size;
                Integer n2 = size = Integer.valueOf(size + 1);
            }
        }
        for (int i = 2; i < size && CollectionUtil.listNotEmptyNotSizeZero(list = this.getVisitPlanInfoList(i, visitDate)); ++i) {
            list = formList.stream().collect(Collectors.groupingBy(SfaVisitPlanInfoStepFormRespVo::getVisitPlanInfoId)).entrySet().stream().map(data -> (SfaVisitPlanInfoStepFormRespVo)((List)data.getValue()).get(0)).collect(Collectors.toList());
            list = this.sfaVisitPlanInfoStepFormComponent.getVisitPlanInfoRedisDataByEs(list);
            this.sfaVisitPlanInfoStepFormComponent.resolvingStepForm(list);
        }
    }

    private List<SfaVisitPlanInfoStepFormRespVo> getVisitPlanInfoList(Integer num, String visitDate) {
        Page page = new Page((long)num.intValue(), (long)PAGE_SIZE.intValue());
        return this.sfaVisitPlanInfoMapper.findVisitPlanInfoStepFormList((Page<SfaVisitPlanInfoStepFormRespVo>)page, visitDate);
    }
}

