/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitnote.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitGroupReqVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitGroupRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.visitnote.service.ISfaVisitGroupService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sfaVisitGroupController"})
@Api(tags={"\u7ebf\u8def\u7ec4\u7ba1\u7406 "})
public class SfaVisitGroupController {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitGroupController.class);
    @Autowired
    private ISfaVisitGroupService sfaVisitGroupService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<SfaVisitGroupRespVo>> list(@RequestBody SfaVisitGroupReqVo sfaVisitGroupReqVo) {
        PageResult<SfaVisitGroupRespVo> result = this.sfaVisitGroupService.findList(sfaVisitGroupReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u8be6\u60c5")
    @GetMapping(value={"/queryDetailById"})
    @CrmLog
    @CrmDictMethod
    public Result<SfaVisitGroupRespVo> queryDetailById(@RequestParam String id) {
        SfaVisitGroupRespVo respVo = this.sfaVisitGroupService.queryDetailById(id);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @PostMapping(value={"/query"})
    @CrmLog
    public Result<SfaVisitGroupRespVo> query(@RequestBody SfaVisitGroupReqVo sfaVisitGroupReqVo) {
        SfaVisitGroupRespVo respVo = this.sfaVisitGroupService.query(sfaVisitGroupReqVo);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody SfaVisitGroupReqVo sfaVisitGroupReqVo) {
        this.sfaVisitGroupService.save(sfaVisitGroupReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody SfaVisitGroupReqVo sfaVisitGroupReqVo) {
        this.sfaVisitGroupService.update(sfaVisitGroupReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        this.sfaVisitGroupService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        this.sfaVisitGroupService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        this.sfaVisitGroupService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }
}

