/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksummary.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.sfa.worksummary.req.SfaWorkSummaryLikeReqVo;
import com.biz.crm.nebular.sfa.worksummary.resp.SfaWorkSummaryLikeRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.util.ValidateUtils;
import com.biz.crm.worksummary.mapper.SfaWorkSummaryCommentMapper;
import com.biz.crm.worksummary.mapper.SfaWorkSummaryLikeMapper;
import com.biz.crm.worksummary.mapper.SfaWorkSummaryPrimaryMapper;
import com.biz.crm.worksummary.model.SfaWorkSummaryCommentEntity;
import com.biz.crm.worksummary.model.SfaWorkSummaryLikeEntity;
import com.biz.crm.worksummary.model.SfaWorkSummaryPrimaryEntity;
import com.biz.crm.worksummary.service.ISfaWorkSummaryLikeService;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"SfaWorkSummaryLikeServiceExpandImpl"})
public class SfaWorkSummaryLikeServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaWorkSummaryLikeMapper, SfaWorkSummaryLikeEntity>
implements ISfaWorkSummaryLikeService {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkSummaryLikeServiceImpl.class);
    @Resource
    private SfaWorkSummaryLikeMapper sfaWorkSummaryLikeMapper;
    @Autowired
    private MdmPositionFeign mdmPositionFeign;
    @Autowired
    private SfaWorkSummaryPrimaryMapper sfaWorkSummaryPrimaryMapper;
    @Autowired
    private SfaWorkSummaryCommentMapper sfaWorkSummaryCommentMapper;

    @Override
    public PageResult<SfaWorkSummaryLikeRespVo> findList(SfaWorkSummaryLikeReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<SfaWorkSummaryLikeRespVo> list = this.sfaWorkSummaryLikeMapper.findList((Page<SfaWorkSummaryLikeRespVo>)page, reqVo);
        if (!CollectionUtils.isEmpty(list)) {
            HashSet createCodes = Sets.newHashSet();
            list.forEach(o -> createCodes.add(o.getCreateCode()));
            MdmPositionUserOrgReqVo userQueryVo = new MdmPositionUserOrgReqVo();
            userQueryVo.setPrimaryFlag("1");
            userQueryVo.setUserNameList(createCodes.stream().collect(Collectors.toList()));
            List userOrgRespVos = (List)ApiResultUtil.objResult((Result)this.mdmPositionFeign.findPositionUserOrgList(userQueryVo));
            Map userOrgRespVoMap = userOrgRespVos.stream().collect(Collectors.toMap(MdmPositionUserOrgRespVo::getUserName, Function.identity()));
            list.forEach(o -> {
                String businessId = o.getId();
                String id = o.getId();
                MdmPositionUserOrgRespVo userOrgRespVo = (MdmPositionUserOrgRespVo)userOrgRespVoMap.get(o.getCreateCode());
                o.setPhoto(userOrgRespVo.getUserHeadUrl());
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaWorkSummaryLikeRespVo query(SfaWorkSummaryLikeReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public SfaWorkSummaryLikeRespVo save(SfaWorkSummaryLikeReqVo reqVo) {
        SfaWorkSummaryLikeRespVo respVo = new SfaWorkSummaryLikeRespVo();
        ValidateUtils.validate((Object)reqVo.getBusinessId(), (String)"\u88ab\u70b9\u8d5e\u6570\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
        UserRedis user = UserUtils.getUser();
        SfaWorkSummaryPrimaryEntity summaryPrimaryEntity = (SfaWorkSummaryPrimaryEntity)((Object)this.sfaWorkSummaryPrimaryMapper.selectById((Serializable)((Object)reqVo.getBusinessId())));
        if (!ObjectUtils.isEmpty((Object)((Object)summaryPrimaryEntity))) {
            reqVo.setSummaryId(summaryPrimaryEntity.getId());
        } else {
            SfaWorkSummaryCommentEntity summaryCommentEntity = (SfaWorkSummaryCommentEntity)((Object)this.sfaWorkSummaryCommentMapper.selectById((Serializable)((Object)reqVo.getBusinessId())));
            if (!ObjectUtils.isEmpty((Object)((Object)summaryCommentEntity))) {
                reqVo.setSummaryId(summaryCommentEntity.getSummaryId());
            } else {
                throw new BusinessException("businessId\u6570\u636e\u5f02\u5e38");
            }
        }
        LambdaQueryWrapper build = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaWorkSummaryLikeEntity::getBusinessId, (Object)reqVo.getBusinessId())).eq(SfaWorkSummaryLikeEntity::getSummaryId, (Object)reqVo.getSummaryId())).eq(CrmBaseEntity::getCreateCode, (Object)user.getUsername());
        SfaWorkSummaryLikeEntity sfaWorkSummaryLikeEntity = (SfaWorkSummaryLikeEntity)((Object)this.sfaWorkSummaryLikeMapper.selectOne((Wrapper)build));
        if (ObjectUtils.isEmpty((Object)((Object)sfaWorkSummaryLikeEntity))) {
            SfaWorkSummaryLikeEntity entity = (SfaWorkSummaryLikeEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaWorkSummaryLikeEntity.class));
            this.save((Object)entity);
        } else {
            this.sfaWorkSummaryLikeMapper.deleteById((Serializable)((Object)sfaWorkSummaryLikeEntity.getId()));
        }
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaWorkSummaryLikeReqVo reqVo) {
        SfaWorkSummaryLikeEntity entity = (SfaWorkSummaryLikeEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaWorkSummaryLikeReqVo reqVo) {
        List sfaWorkSummaryLikeEntities = this.sfaWorkSummaryLikeMapper.selectBatchIds(reqVo.getIds());
        if (!CollectionUtils.isEmpty((Collection)sfaWorkSummaryLikeEntities)) {
            sfaWorkSummaryLikeEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaWorkSummaryLikeEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaWorkSummaryLikeReqVo reqVo) {
        List sfaWorkSummaryLikeEntities = this.sfaWorkSummaryLikeMapper.selectBatchIds(reqVo.getIds());
        if (!CollectionUtils.isEmpty((Collection)sfaWorkSummaryLikeEntities)) {
            sfaWorkSummaryLikeEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaWorkSummaryLikeEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaWorkSummaryLikeReqVo reqVo) {
        List sfaWorkSummaryLikeEntities = this.sfaWorkSummaryLikeMapper.selectBatchIds(reqVo.getIds());
        if (!CollectionUtils.isEmpty((Collection)sfaWorkSummaryLikeEntities)) {
            sfaWorkSummaryLikeEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaWorkSummaryLikeEntities);
    }
}

