/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cache.util;

import com.biz.crm.base.BusinessException;
import com.biz.crm.integral.service.SfaIntegralDetailService;
import com.biz.crm.nebular.sfa.integral.resp.SfaIntegralUserRankRespVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IntegralUserUtil {
    public static final String redisKey = "SFAINTEGRALDETAILSERVICE:COUNTINTEGRALNUMBYUSERNAME:v1:";
    @Autowired
    private RedisService redisService;
    @Autowired
    private SfaIntegralDetailService sfaIntegralDetailService;

    public String getKey(String userName) {
        if (StringUtils.isEmpty((String)userName)) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        return redisKey + userName;
    }

    public void deleteKey(String userName) {
        this.redisService.del(new String[]{this.getKey(userName)});
    }

    public void setObj(SfaIntegralUserRankRespVo vo) {
        String key = this.getKey(vo.getUserName());
        this.redisService.setHours(key, (Object)vo, 1L);
    }

    public SfaIntegralUserRankRespVo getObj(String userName) {
        Object o = this.redisService.get(this.getKey(userName));
        if (o == null) {
            return this.compensate(userName);
        }
        SfaIntegralUserRankRespVo vo = (SfaIntegralUserRankRespVo)o;
        if (StringUtils.isEmpty((String)vo.getUserName())) {
            return null;
        }
        return vo;
    }

    public SfaIntegralUserRankRespVo compensate(String userName) {
        SfaIntegralUserRankRespVo vo = this.sfaIntegralDetailService.countIntegralNumByUserNameRedis(null);
        vo = vo == null ? new SfaIntegralUserRankRespVo() : vo;
        vo.setUserName(userName);
        this.setObj(vo);
        return vo;
    }
}

