/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.service.impl;

import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.moblie.controller.visit.req.step.HelpScoreStepExecuteData;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.es.permission.EsDataPermission;
import com.biz.crm.visitstep.repositories.SfaVisitStepHelpScoreEsDataRepositories;
import com.biz.crm.visitstep.req.GetHelpVisitEvaluateTableReq;
import com.biz.crm.visitstep.resp.SfaHelpVisitEvaluateTableRespVo;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;

@Service
public class SfaVisitStepHelpScoreTableEsImpl {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitStepHelpScoreTableEsImpl.class);
    @Resource
    private SfaVisitStepHelpScoreEsDataRepositories sfaVisitStepHelpScoreEsDataRepositories;

    @EsDataPermission(userName="userName.keyword", position="posCode.keyword", org="orgCode.keyword", customer="clientCode.keyword")
    public PageResult<SfaHelpVisitEvaluateTableRespVo> getHelpVisitEvaluateTableResult(GetHelpVisitEvaluateTableReq req) {
        Page result = this.sfaVisitStepHelpScoreEsDataRepositories.search((SearchQuery)req.buildQuery());
        List respVos = CrmBeanUtil.copyList((List)result.getContent(), SfaHelpVisitEvaluateTableRespVo.class);
        if (CollectionUtil.listNotEmpty((List)respVos)) {
            respVos.forEach(o -> {
                List<HelpScoreStepExecuteData.HelpScoreDetailReqVo> helpScoreDetailList = o.getHelpScoreDetailList();
                if (CollectionUtil.listEmpty(helpScoreDetailList)) {
                    o.setHelpVisitPassRate(BigDecimal.ZERO.toString());
                }
                long stepCodeNum = helpScoreDetailList.stream().map(HelpScoreStepExecuteData.HelpScoreDetailReqVo::getStepCode).count();
                long passNum = helpScoreDetailList.stream().filter(h -> YesNoEnum.yesNoEnum.ONE.getValue().equals(h.getQualified())).count();
                BigDecimal passRate = BigDecimal.valueOf(passNum).divide(BigDecimal.valueOf(stepCodeNum), 2, 4).multiply(new BigDecimal(100));
                o.setHelpVisitPassRate(passRate.toString());
            });
        }
        return PageResult.builder().data(respVos).count(Long.valueOf(result.getTotalElements())).build();
    }
}

