/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.visitoffline.stepcomponent;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.attachment.SfaAttachmentEntity;
import com.biz.crm.base.utils.SfaAttachmentUtil;
import com.biz.crm.moblie.controller.visit.component.impl.StockInventoryVisitStepExecutor;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.StockInventoryStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.step.StockInventoryStepExecuteDataResp;
import com.biz.crm.moblie.visitoffline.SfaVisitStepOffLineStrategy;
import com.biz.crm.moblie.visitoffline.stepcomponent.photoutil.SfaVisitStepOffLineUtil;
import com.biz.crm.moblie.visitoffline.stepdatavo.SfaVisitStepStockVo;
import com.biz.crm.moblie.visitoffline.stepdatavo.req.VisitStepOffLineExecuteReq;
import com.biz.crm.nebular.activiti.vo.AttachmentOffLineVo;
import com.biz.crm.nebular.sfa.visitstep.visitoffline.VisitOfflineReqVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockInventoryEntity;
import com.biz.crm.visitstepdetail.service.ISfaVisitStepStockInventoryService;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

@Component(value="sfa_step_code_stock_expandBean")
@ConditionalOnMissingBean(name={"SfaStepStockComponentExpandImpl"})
public class SfaStepStockComponent
implements SfaVisitStepOffLineStrategy {
    private static final Logger log = LoggerFactory.getLogger(SfaStepStockComponent.class);
    private static String STEP_CODE;
    @Resource
    private StockInventoryVisitStepExecutor stockInventoryVisitStepExecutor;
    @Resource
    private ISfaVisitStepStockInventoryService sfaVisitStepStockInventoryService;

    public Object buildVisitStepOffLineData(VisitOfflineReqVo reqVo) {
        SfaVisitStepStockVo vo = new SfaVisitStepStockVo();
        ExecutorLoadReq req = (ExecutorLoadReq)((Object)CrmBeanUtil.copy((Object)reqVo, ExecutorLoadReq.class));
        StockInventoryStepExecuteDataResp dataResp = (StockInventoryStepExecuteDataResp)this.stockInventoryVisitStepExecutor.load(req);
        vo.setSfaVisitStepFrom(dataResp.getSfaVisitStepFrom());
        return vo;
    }

    @Override
    public Result saveVisitStepOffLine(VisitStepOffLineExecuteReq req) {
        Result result = new Result();
        try {
            VisitStepExecuteReq visitStepExecuteReq = (VisitStepExecuteReq)CrmBeanUtil.copy((Object)req, VisitStepExecuteReq.class);
            StockInventoryStepExecuteData executeData = (StockInventoryStepExecuteData)JSONObject.parseObject((String)JSONObject.toJSONString((Object)req.getStepExecuteData()), StockInventoryStepExecuteData.class);
            visitStepExecuteReq.setStepExecuteData(executeData);
            this.stockInventoryVisitStepExecutor.executeOffLine(visitStepExecuteReq);
        }
        catch (BusinessException e) {
            log.warn("\u5e93\u5b58\u76d8\u70b9\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMsg());
            result.setSuccess(false);
            result.setMessage("\u5e93\u5b58\u76d8\u70b9:\u9519\u8bef\u4fe1\u606f[" + e.getMsg() + "]");
        }
        return result;
    }

    @Override
    public void saveVisitStepOffLineFile(List<AttachmentOffLineVo> list, SfaVisitStepOffLineUtil util) {
        SfaVisitStepStockInventoryEntity entity = (SfaVisitStepStockInventoryEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sfaVisitStepStockInventoryService.lambdaQuery().eq(SfaVisitStepStockInventoryEntity::getVisitPlanInfoId, (Object)util.getVisitPlanInfoId())).eq(SfaVisitStepStockInventoryEntity::getStepCode, (Object)util.getStepCode())).select(new SFunction[]{BaseIdEntity::getId}).one();
        if (null != entity) {
            List<SfaAttachmentEntity> fileEntity = list.stream().map(data -> {
                SfaAttachmentEntity file = (SfaAttachmentEntity)((Object)((Object)CrmBeanUtil.copy((Object)data, SfaAttachmentEntity.class)));
                file.setBizId(entity.getId());
                file.setAttachmentBizType(util.getType());
                file.setAttachmentBizTypeName(util.getTypeName());
                return file;
            }).collect(Collectors.toList());
            SfaAttachmentUtil.insert(fileEntity);
        }
    }

    @Override
    public String getStepCode() {
        return STEP_CODE;
    }

    @Override
    public void setStepCode(String stepCode) {
        STEP_CODE = stepCode;
    }
}

