/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.integral.controller;

import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.integral.controller.SfaIntegralSaveUtil;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.mdm.position.req.MdmPositionPageReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionPageRespVo;
import com.biz.crm.nebular.sfa.integral.req.SfaIntegralDetailMqVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.JobHelper;
import com.biz.crm.util.PageDataAdviser;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import java.time.LocalDate;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class SfaIntegralDetailMQSend
implements JobHelper.JobExecutor {
    private static final Logger log = LoggerFactory.getLogger(SfaIntegralDetailMQSend.class);
    @Resource
    private MdmPositionFeign mdmPositionFeign;
    @Resource
    private JobHelper jobHelper;

    @Transactional
    public void executeJob(Object jobParam) {
        this.doSettlementJob();
    }

    public void integralDetailJob(String executeDate) {
        if (StringUtils.isEmpty((String)executeDate)) {
            executeDate = LocalDate.now().plusMonths(-1L).format(CrmDateUtils.yyyyMMdd);
        }
        JobHelper.JobContext context = new JobHelper.JobContext();
        context.setJob(JobHelper.Job.INTEGRAL_DETAIL_JOB);
        context.setExecutorBeanClass(SfaIntegralDetailMQSend.class);
        this.jobHelper.executeJobSaveContext(context);
    }

    public void doSettlementJob() {
        PageDataAdviser pageDataAdviser = new PageDataAdviser(this.jobHelper.getJobBizDataPageSize());
        long total = this.jobHelper.getJobBizDataPageSize();
        while (pageDataAdviser.hasNext(Long.valueOf(total))) {
            MdmPositionPageReqVo reqVo = new MdmPositionPageReqVo();
            reqVo.setPageNum(pageDataAdviser.nextPage());
            reqVo.setPageSize(pageDataAdviser.getPageSize());
            PageResult pageResult = (PageResult)ApiResultUtil.objResult((Result)this.mdmPositionFeign.positionAndUserPage(reqVo), (boolean)true);
            List users = pageResult.getData();
            this.sfaIntegralDetailMQSend(users);
            total = pageResult.getCount();
        }
    }

    private void sfaIntegralDetailMQSend(List<MdmPositionPageRespVo> userList) {
        userList.forEach(u -> {
            if (StringUtils.isEmpty((String)u.getUserName()) || StringUtils.isEmpty((String)u.getPositionCode())) {
                return;
            }
            SfaIntegralSaveUtil.saveIntegralDetail((SfaIntegralDetailMqVo)CrmBeanUtil.copy((Object)u, SfaIntegralDetailMqVo.class));
        });
    }
}

