/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.base;

import com.biz.crm.service.RedisService;
import com.biz.crm.util.JobHelper;
import com.biz.crm.util.JsonPropertyUtil;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order
public class SfaJobListener
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(SfaJobListener.class);
    @Resource
    private RedisService redisService;
    @Resource
    private JobHelper jobHelper;
    @Value(value="${job.runScheduledTask:false}")
    private Boolean runScheduledTask;

    public void onApplicationEvent(ApplicationReadyEvent applicationReadyEvent) {
        if (!this.runScheduledTask.booleanValue()) {
            log.warn("SFA\u4efb\u52a1\u6062\u590d\u76d1\u542c\u5668\uff1a \u8be5\u5e94\u7528\u5b9e\u4f8b\u914d\u7f6e[job.runScheduledTask=false],\u8df3\u8fc7\u4efb\u52a1\u6062\u590d");
            return;
        }
        log.warn("SFA\u4efb\u52a1\u6062\u590d\u76d1\u542c\u5668\uff1a \u5f00\u59cb\u6062\u590d\u4efb\u52a1\u6267\u884c\u73af\u5883...");
        Map jobs = this.redisService.hmget(JobHelper.redisHash);
        log.warn("SFA\u4efb\u52a1\u6062\u590d\u76d1\u542c\u5668\uff1a \u8ba1\u5212\u6062\u590d\u4efb\u52a1\uff1ajobs = {}", (Object)JsonPropertyUtil.toJsonString((Object)jobs));
        this.doJobs(jobs);
    }

    protected void doJobs(Map<String, JobHelper.JobContext> jobs) {
        jobs.forEach((job, jobContext) -> this.jobHelper.executeJobAsync(jobContext));
    }
}

