/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.service.impl;

import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.utils.PointUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.enums.SfaCustomerDistanceEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.gaode.vo.GaodeNearbyVo;
import com.biz.crm.gaode.vo.QueryAroundVo;
import com.biz.crm.map.model.req.SfaTencentMapData;
import com.biz.crm.map.model.resp.SfaTencentMapDataRespVo;
import com.biz.crm.map.service.SfaTencentMapDataService;
import com.biz.crm.mdm.map.MdmTerminalCustomerElasticsearchFeign;
import com.biz.crm.mdm.poi.MdmAmapPoiFeign;
import com.biz.crm.moblie.controller.visit.req.GetVisitListReq;
import com.biz.crm.moblie.controller.visit.resp.SfaVisitResp;
import com.biz.crm.moblie.service.ISfaNearbyCustomerService;
import com.biz.crm.nebular.mdm.dict.resp.DictDataVo;
import com.biz.crm.nebular.mdm.poi.req.MdmAmapPoiDistanceReqVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmTerminalCustomerElasticsearchPageReqVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalCustomerElasticsearchRespVo;
import com.biz.crm.nebular.sfa.moblie.req.SfaNearbyCustomerReqVo;
import com.biz.crm.sfa.map.GaoDeFeign;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.PageDataAdviser;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
@ConditionalOnMissingBean(name={"sfaNearbyCustomerServiceExpandImpl"})
public class SfaNearbyCustomerServiceImpl
implements ISfaNearbyCustomerService {
    private static final Logger log = LoggerFactory.getLogger(SfaNearbyCustomerServiceImpl.class);
    @Resource
    private GaoDeFeign gaoDeFeign;
    @Resource
    private MdmTerminalCustomerElasticsearchFeign mdmTerminalCustomerElasticsearchFeign;
    @Resource
    private ISfaVisitPlanInfoService sfaVisitPlanInfoService;
    @Resource
    private SfaTencentMapDataService sfaTencentMapDataService;
    @Resource
    private MdmAmapPoiFeign mdmAmapPoiFeign;

    protected List<SfaVisitResp.SfaVisitPlanInfoResp> loadCustomers(SfaNearbyCustomerReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getMapData())) {
            reqVo.setMapData(SfaVisitEnum.mapData.GAODE_MAP_DATA.getCode());
        }
        List<SfaVisitResp.SfaVisitPlanInfoResp> respList = SfaVisitEnum.mapData.GAODE_MAP_DATA.getCode().equals(reqVo.getMapData()) ? this.gaodeDataConvert(this.getGaodeNearbyData(reqVo)) : (SfaVisitEnum.mapData.GAODE_MAP_POI_DATA.getCode().equals(reqVo.getMapData()) ? this.gaodeDataConvert(this.getGaodePoiNearbyData(reqVo)) : this.tencentDataConvert(this.getTencentData(reqVo)));
        return respList;
    }

    private List<MdmTerminalCustomerElasticsearchRespVo> getAllClientFromMdm(String[] point) {
        List result = Lists.newArrayList();
        MdmTerminalCustomerElasticsearchPageReqVo mdmTerminalCustomerElasticsearchPageReqVo = new MdmTerminalCustomerElasticsearchPageReqVo();
        PageDataAdviser pageDataAdviser = new PageDataAdviser(500);
        mdmTerminalCustomerElasticsearchPageReqVo.setPageNum(pageDataAdviser.nextPage());
        mdmTerminalCustomerElasticsearchPageReqVo.setPageSize(Integer.valueOf(500));
        PageResult<MdmTerminalCustomerElasticsearchRespVo> mdmResult = this.getDataFromMdm(mdmTerminalCustomerElasticsearchPageReqVo, point);
        if (mdmResult != null) {
            result = mdmResult.getData();
            while (pageDataAdviser.hasNext(mdmResult.getCount())) {
                mdmTerminalCustomerElasticsearchPageReqVo.setPageSize(Integer.valueOf(500));
                mdmTerminalCustomerElasticsearchPageReqVo.setPageNum(pageDataAdviser.nextPage());
                PageResult<MdmTerminalCustomerElasticsearchRespVo> list = this.getDataFromMdm(mdmTerminalCustomerElasticsearchPageReqVo, point);
                if (null == result) continue;
                result.addAll(list.getData());
            }
        }
        return result;
    }

    @Override
    public SfaVisitResp findNotCooperationCustomerList(SfaNearbyCustomerReqVo reqVo) {
        List<SfaVisitResp.SfaVisitPlanInfoResp> planInfoEntities;
        String[] point = this.doCheckParam(reqVo);
        List<SfaVisitResp.SfaVisitPlanInfoResp> respList = this.loadCustomers(reqVo);
        LinkedHashMap collect = respList.stream().collect(Collectors.toMap(SfaVisitResp.SfaVisitPlanInfoResp::getClientCode, Function.identity(), (oldVal, newVal) -> oldVal, LinkedHashMap::new));
        List<MdmTerminalCustomerElasticsearchRespVo> list = this.getAllClientFromMdm(point);
        if (CollectionUtil.listNotEmpty(list)) {
            list.forEach(o -> {
                if (collect.containsKey(o.getAmapId())) {
                    collect.remove(o.getAmapId(), collect.get(o.getAmapId()));
                }
            });
        }
        if (CollectionUtil.listNotEmpty(planInfoEntities = this.visitPlanToday(point, SfaVisitEnum.VisitBigType.UNFAMILIAR_VISIT.getVal(), reqVo.getVisitTime()))) {
            planInfoEntities.forEach(plan -> {
                if (collect.containsKey(plan.getClientCode())) {
                    SfaVisitResp.SfaVisitPlanInfoResp sfaVisitPlanInfoResp = (SfaVisitResp.SfaVisitPlanInfoResp)((Object)((Object)collect.get(plan.getClientCode())));
                    plan.setDistance(sfaVisitPlanInfoResp.getDistance());
                    plan.setClientAddress(sfaVisitPlanInfoResp.getClientAddress());
                    plan.setClientPhone(sfaVisitPlanInfoResp.getClientPhone());
                    plan.setLongitude(sfaVisitPlanInfoResp.getLongitude());
                    plan.setLatitude(sfaVisitPlanInfoResp.getLatitude());
                    plan.setBusiType(sfaVisitPlanInfoResp.getBusiType());
                    plan.setBusiLabel(sfaVisitPlanInfoResp.getBusiLabel());
                    plan.setChannel(sfaVisitPlanInfoResp.getChannel());
                    collect.put(plan.getClientCode(), plan);
                }
            });
        }
        List<SfaVisitResp.SfaVisitPlanInfoResp> respVos = collect.values().stream().collect(Collectors.toList());
        SfaVisitResp sfaVisitResp = new SfaVisitResp();
        sfaVisitResp.setPlanInfoEntities(respVos);
        return sfaVisitResp;
    }

    public List<GaodeNearbyVo> getGaodeNearbyData(SfaNearbyCustomerReqVo reqVo) {
        QueryAroundVo queryAroundVo = new QueryAroundVo();
        queryAroundVo.setLocation(reqVo.getLocation()).setRadius(null).setKeywords(null).setOffset(reqVo.getPageSize().toString()).setPage(reqVo.getPageNum().toString());
        List distanceList = DictUtil.list((String)SfaCustomerDistanceEnum.SFA_CUSTOMER_DISTANCE_ENUM.getDesc());
        if (CollectionUtil.listNotEmpty((List)distanceList)) {
            String radius = ((DictDataVo)distanceList.get(0)).getDictValue();
            queryAroundVo.setRadius(radius);
        }
        if (StringUtils.isNotEmpty((String)reqVo.getClientName())) {
            queryAroundVo.setKeywords(reqVo.getClientName());
        } else {
            List keywordList = DictUtil.list((String)SfaVisitEnum.customerKeyword.CUSTOMER_KEYWORD_ENUM.getDesc());
            if (CollectionUtil.listNotEmpty((List)keywordList)) {
                String keywords = keywordList.stream().map(e -> e.getDictValue()).collect(Collectors.joining("|"));
                queryAroundVo.setKeywords(keywords);
            }
        }
        PageResult result = (PageResult)ApiResultUtil.objResult((Result)this.gaoDeFeign.queryAround(queryAroundVo));
        if (ObjectUtils.isEmpty((Object)result)) {
            if (StringUtils.isNotEmpty((String)reqVo.getClientName())) {
                return Lists.newArrayList();
            }
            throw new BusinessException("\u83b7\u53d6\u5730\u56fe\u6570\u636e\u5931\u8d25\uff01");
        }
        return result.getData();
    }

    public List<GaodeNearbyVo> getGaodePoiNearbyData(SfaNearbyCustomerReqVo reqVo) {
        List distanceList = DictUtil.list((String)SfaCustomerDistanceEnum.SFA_CUSTOMER_DISTANCE_ENUM.getDesc());
        String radius = "20000";
        if (CollectionUtil.listNotEmpty((List)distanceList)) {
            radius = ((DictDataVo)distanceList.get(0)).getDictValue();
        }
        MdmAmapPoiDistanceReqVo distanceReqVo = new MdmAmapPoiDistanceReqVo();
        distanceReqVo.setPageNum(reqVo.getPageNum());
        distanceReqVo.setPageSize(reqVo.getPageSize());
        distanceReqVo.setDistance(radius);
        distanceReqVo.setPoiName(reqVo.getClientName());
        String location = reqVo.getLocation();
        distanceReqVo.setLongitude(location.substring(0, location.indexOf(",")));
        distanceReqVo.setLatitude(location.substring(location.indexOf(",") + 1));
        Result result = this.mdmAmapPoiFeign.findAmapPoiDistancePageList(distanceReqVo);
        if (!result.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff1a" + result.getMessage());
        }
        if (CollectionUtil.listEmpty((List)((PageResult)result.getResult()).getData())) {
            return Lists.newArrayList();
        }
        return ((PageResult)result.getResult()).getData().stream().map(x -> {
            GaodeNearbyVo vo = (GaodeNearbyVo)CrmBeanUtil.copy((Object)x, GaodeNearbyVo.class);
            vo.setLocation(x.getLatitude() + "," + x.getLongitude());
            vo.setName(x.getPoiName());
            vo.setPcode(x.getAmapProvinceCode());
            vo.setPname(x.getAmapProvinceName());
            vo.setCitycode(x.getAmapCityCode());
            vo.setCityname(x.getAmapCityName());
            vo.setAdcode(x.getAmapDistrictCode());
            vo.setAdname(x.getAmapDistrictName());
            vo.setAddress(x.getAddress());
            vo.setType(x.getTypeName());
            vo.setTypecode(x.getTypeCode());
            vo.setDistance(new BigDecimal(x.getDistance()).divide(new BigDecimal("1000"), 3, RoundingMode.HALF_UP).toString());
            return vo;
        }).collect(Collectors.toList());
    }

    public List<SfaVisitResp.SfaVisitPlanInfoResp> gaodeDataConvert(List<GaodeNearbyVo> gaodeData) {
        if (CollectionUtil.listEmpty(gaodeData)) {
            return Lists.newArrayList();
        }
        List<SfaVisitResp.SfaVisitPlanInfoResp> respList = gaodeData.stream().map(m -> {
            SfaVisitResp.SfaVisitPlanInfoResp o = new SfaVisitResp.SfaVisitPlanInfoResp();
            o.setClientCode(m.getId());
            o.setRedisHashKey("NONE");
            o.setLongitude(new BigDecimal(m.getLongitude()));
            o.setLatitude(new BigDecimal(m.getLatitude()));
            o.setClientAddress(m.getAddress());
            o.setClientPhone(m.getTel());
            o.setClientName(m.getName());
            o.setDistance(new BigDecimal(m.getDistance()).divide(new BigDecimal("1000"), 3, RoundingMode.HALF_UP));
            return o;
        }).collect(Collectors.toList());
        respList.forEach(o -> {
            Map map = SfaVisitEnum.visitButton.buildVisitUnfamiliarButton((String)UserUtils.getUser().getUsername(), (String)LocalDate.now().toString(), (String)SfaVisitEnum.visitStatus.V1.getVal());
            o.setButtons(map);
        });
        return respList;
    }

    public List<SfaVisitResp.SfaVisitPlanInfoResp> visitPlanToday(String[] point, String visitBigType, String visitTime) {
        UserRedis userRedis = UserUtils.getUser();
        GetVisitListReq req = new GetVisitListReq();
        req.setVisitUserName(userRedis.getUsername());
        req.setVisitPositionCode(userRedis.getPoscode());
        req.setVisitDate(LocalDate.now().toString());
        if (StringUtils.isNotEmpty((String)visitTime)) {
            try {
                LocalDate.parse(visitTime, CrmDateUtils.yyyyMMdd);
            }
            catch (Exception e) {
                throw new BusinessException("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
            }
            req.setVisitDate(visitTime);
        }
        req.setLongitude(new BigDecimal(point[0]));
        req.setLatitude(new BigDecimal(point[1]));
        req.setVisitBigType(visitBigType);
        List<SfaVisitResp.SfaVisitPlanInfoResp> planInfoEntities = this.sfaVisitPlanInfoService.getVisitInfoList(req).getPlanInfoEntities();
        return planInfoEntities;
    }

    public PageResult<MdmTerminalCustomerElasticsearchRespVo> getDataFromMdm(MdmTerminalCustomerElasticsearchPageReqVo mdmReqVo, String[] split) {
        List distanceList = DictUtil.list((String)SfaCustomerDistanceEnum.SFA_CUSTOMER_DISTANCE_ENUM.getDesc());
        AssertUtils.isNotEmpty((Collection)distanceList, (String)"\u7f3a\u5931\u6570\u636e\u5b57\u5178");
        String radius = ((DictDataVo)distanceList.get(0)).getDictValue();
        mdmReqVo.setLongitude(split[0]).setLatitude(split[1]).setDistance(Double.valueOf(Double.parseDouble(radius)));
        PageResult mdmResult = (PageResult)ApiResultUtil.objResult((Result)this.mdmTerminalCustomerElasticsearchFeign.list(mdmReqVo), (boolean)true);
        return mdmResult;
    }

    @Override
    public SfaVisitResp findCooperationCustomerList(SfaNearbyCustomerReqVo reqVo) {
        String[] point = this.doCheckParam(reqVo);
        UserRedis userRedis = UserUtils.getUser();
        MdmTerminalCustomerElasticsearchPageReqVo mdmTerminalCustomerElasticsearchPageReqVo = new MdmTerminalCustomerElasticsearchPageReqVo();
        mdmTerminalCustomerElasticsearchPageReqVo.setPositionCodes(userRedis.getPoscode()).setPageNum(reqVo.getPageNum()).setPageSize(reqVo.getPageSize()).setName(reqVo.getClientName());
        PageResult<MdmTerminalCustomerElasticsearchRespVo> list = this.getDataFromMdm(mdmTerminalCustomerElasticsearchPageReqVo, point);
        if (CollectionUtil.listEmpty((List)list.getData())) {
            return new SfaVisitResp();
        }
        Map<String, MdmTerminalCustomerElasticsearchRespVo> clientMap = list.getData().stream().collect(Collectors.toMap(MdmTerminalCustomerElasticsearchRespVo::getCode, a -> a, (k1, k2) -> k1));
        List<SfaVisitResp.SfaVisitPlanInfoResp> planInfoEntities = this.visitPlanToday(point, SfaVisitEnum.VisitBigType.VISIT.getVal(), reqVo.getVisitTime());
        Map<Object, Object> collect = new HashMap();
        if (CollectionUtil.listNotEmpty(planInfoEntities)) {
            collect = planInfoEntities.stream().collect(Collectors.toMap(SfaVisitResp.SfaVisitPlanInfoResp::getClientCode, a -> a, (k1, k2) -> k1));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String o : clientMap.keySet()) {
            if (!CollectionUtils.isEmpty(collect) && collect.containsKey(o)) {
                map.put(o, collect.get(o));
                continue;
            }
            Map mapButton = SfaVisitEnum.visitButton.buildVisitButton((String)userRedis.getUsername(), (String)LocalDate.now().toString(), (String)SfaVisitEnum.visitStatus.V1.getVal());
            SfaVisitResp.SfaVisitPlanInfoResp resp = this.setParam(clientMap.get(o), mapButton);
            map.put(o, (Object)resp);
        }
        List sfaVisitPlanInfoRespVos = map.values().stream().collect(Collectors.toList());
        List<SfaVisitResp.SfaVisitPlanInfoResp> result = sfaVisitPlanInfoRespVos.stream().sorted(Comparator.nullsLast(Comparator.comparing(SfaVisitResp.SfaVisitPlanInfoResp::getDistance, Comparator.nullsLast(BigDecimal::compareTo)))).collect(Collectors.toList());
        SfaVisitResp sfaVisitResp = new SfaVisitResp();
        sfaVisitResp.setPlanInfoEntities(result);
        return sfaVisitResp;
    }

    public SfaVisitResp.SfaVisitPlanInfoResp setParam(MdmTerminalCustomerElasticsearchRespVo m, Map<String, String> mapButton) {
        SfaVisitResp.SfaVisitPlanInfoResp resp = (SfaVisitResp.SfaVisitPlanInfoResp)((Object)CrmBeanUtil.copy((Object)m, SfaVisitResp.SfaVisitPlanInfoResp.class));
        resp.setDistance(new BigDecimal(m.getDistance()).divide(new BigDecimal("1000"), 3, RoundingMode.HALF_UP));
        resp.setLongitude(new BigDecimal(m.getLongitude()));
        resp.setLatitude(new BigDecimal(m.getLatitude()));
        resp.setClientContacts(m.getContactName());
        resp.setClientCode(m.getCode());
        resp.setClientName(m.getName());
        resp.setClientPhone(m.getContactPhone());
        resp.setClientAddress(m.getAddress());
        resp.setButtons(mapButton);
        resp.setRedisHashKey("NONE");
        resp.setVisitStatus(SfaVisitEnum.visitStatus.V1.getVal());
        resp.setVisitStatusName(SfaVisitEnum.visitStatus.V1.getDesc());
        return resp;
    }

    public String[] doCheckParam(SfaNearbyCustomerReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getPageNum().toString(), (String)"\u6bcf\u9875\u6570\u636e\u7684\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getPageSize().toString(), (String)"\u9875\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        return PointUtil.splitString(reqVo.getLocation());
    }

    public List<SfaTencentMapDataRespVo> getTencentData(SfaNearbyCustomerReqVo reqVo) {
        PageResult<SfaTencentMapDataRespVo> mapDataServiceList;
        List distanceList;
        String[] split = this.doCheckParam(reqVo);
        SfaTencentMapData.SfaTencentMapDataReqVo dataReqVo = new SfaTencentMapData.SfaTencentMapDataReqVo();
        dataReqVo.setPageNum(reqVo.getPageNum());
        dataReqVo.setPageSize(reqVo.getPageSize());
        dataReqVo.setLng(split[0]);
        dataReqVo.setLat(split[1]);
        if (StringUtils.isNotEmpty((String)reqVo.getClientName())) {
            dataReqVo.setPoiTitle(reqVo.getClientName());
        }
        if (CollectionUtil.listNotEmpty((List)(distanceList = DictUtil.list((String)SfaCustomerDistanceEnum.SFA_CUSTOMER_DISTANCE_ENUM.getDesc())))) {
            String radius = ((DictDataVo)distanceList.get(0)).getDictValue();
            dataReqVo.setDistance(radius);
        }
        if (ObjectUtils.isEmpty(mapDataServiceList = this.sfaTencentMapDataService.findList(dataReqVo))) {
            if (StringUtils.isNotEmpty((String)reqVo.getClientName())) {
                return Lists.newArrayList();
            }
            throw new BusinessException("\u83b7\u53d6\u5730\u56fe\u6570\u636e\u5931\u8d25\uff01");
        }
        return mapDataServiceList.getData();
    }

    public List<SfaVisitResp.SfaVisitPlanInfoResp> tencentDataConvert(List<SfaTencentMapDataRespVo> data) {
        if (CollectionUtil.listEmpty(data)) {
            return Lists.newArrayList();
        }
        List<SfaVisitResp.SfaVisitPlanInfoResp> respList = data.stream().map(m -> {
            SfaVisitResp.SfaVisitPlanInfoResp o = new SfaVisitResp.SfaVisitPlanInfoResp();
            o.setClientCode(m.getMapId());
            o.setRedisHashKey("NONE");
            o.setLongitude(new BigDecimal(m.getLongitude()));
            o.setLatitude(new BigDecimal(m.getLatitude()));
            o.setClientAddress(m.getAddress());
            o.setClientName(m.getName());
            o.setBusiLabel(m.getBusiLabel());
            o.setChannel(m.getChannel());
            o.setBusiType(m.getBusiType());
            o.setDistance(new BigDecimal(m.getDistance()).divide(new BigDecimal("1000"), 3, RoundingMode.HALF_UP));
            return o;
        }).collect(Collectors.toList());
        respList.forEach(o -> {
            Map map = SfaVisitEnum.visitButton.buildVisitUnfamiliarButton((String)UserUtils.getUser().getUsername(), (String)LocalDate.now().toString(), (String)SfaVisitEnum.visitStatus.V1.getVal());
            o.setButtons(map);
        });
        return respList;
    }
}

