/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.enums.SfaLogTypeEnum;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.eunm.tpm.ActivityReleaseNeedEnum;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.sfa.picture.req.SfaVisitPictureReqVo;
import com.biz.crm.nebular.sfa.picture.resp.SfaVisitPictureRespVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaLogRecordReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepColletProductReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepColletReportReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepColletItemRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepColletProductRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepColletReportRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepColletRespVo;
import com.biz.crm.picture.mapper.SfaVisitPictureMapper;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.visitstep.mapper.SfaVisitStepColletItemMapper;
import com.biz.crm.visitstep.mapper.SfaVisitStepColletMapper;
import com.biz.crm.visitstep.mapper.SfaVisitStepColletProductMapper;
import com.biz.crm.visitstep.model.SfaVisitStepColletProductEntity;
import com.biz.crm.visitstep.service.ISfaLogRecordService;
import com.biz.crm.visitstep.service.ISfaVisitStepColletProductService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"sfaVisitStepColletProductServiceExpandImpl"})
public class SfaVisitStepColletProductServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaVisitStepColletProductMapper, SfaVisitStepColletProductEntity>
implements ISfaVisitStepColletProductService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitStepColletProductServiceImpl.class);
    @Resource
    private SfaVisitStepColletProductMapper sfaVisitStepColletProductMapper;
    @Resource
    private SfaVisitStepColletItemMapper sfaVisitStepColletItemMapper;
    @Resource
    private ISfaLogRecordService sfaLogRecordService;
    @Resource
    private SfaVisitStepColletMapper sfaVisitStepColletMapper;
    @Resource
    private SfaVisitPictureMapper sfaVisitPictureMapper;
    @Resource
    private MdmOrgFeign mdmOrgFeign;

    @Override
    public PageResult<SfaVisitStepColletProductRespVo> findList(SfaVisitStepColletProductReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        reqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        List<SfaVisitStepColletProductRespVo> list = this.sfaVisitStepColletProductMapper.findList((Page<SfaVisitStepColletRespVo>)page, reqVo);
        list.forEach(f -> f.setEnableValue(CrmEnableStatusEnum.getDesc((String)f.getEnableStatus())));
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaVisitStepColletProductRespVo> findListProduct(SfaVisitStepColletProductReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        reqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        List<SfaVisitStepColletProductRespVo> list = this.sfaVisitStepColletProductMapper.findListProduct((Page<SfaVisitStepColletRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaVisitStepColletReportRespVo> findReportFormsList(SfaVisitStepColletReportReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitStepColletReportRespVo> list = this.sfaVisitStepColletMapper.findReportList((Page<SfaVisitStepColletReportRespVo>)page, reqVo);
        list.stream().forEach(data -> {
            data.setClientTypeDescribe(ActivityReleaseNeedEnum.getStatusName((String)data.getClientType()));
            data.setCreateDate(data.getCreateDate() + " " + data.getCreateDateSecond());
        });
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaVisitStepColletReportRespVo findReportFormsOne(String id) {
        MdmOrgRespVo result;
        AssertUtils.isNotEmpty((String)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        SfaVisitStepColletReportRespVo byId = this.sfaVisitStepColletMapper.findReportOneById(id);
        if (!Objects.isNull(byId)) {
            List<SfaVisitStepColletItemRespVo> list = this.sfaVisitStepColletItemMapper.findListByClientId(id);
            byId.setItemRespVos(list);
            SfaVisitPictureReqVo pictureReqVo = new SfaVisitPictureReqVo();
            pictureReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            pictureReqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
            pictureReqVo.setBusinessId(id);
            pictureReqVo.setPicType(SfaVisitEnum.visitPicType.CONTEND_COMMODITY_PIC.getVal());
            List<SfaVisitPictureRespVo> pictureList = this.sfaVisitPictureMapper.findSfaVisitPictureList(pictureReqVo);
            byId.setPictureRespVos(pictureList);
        }
        if (!Objects.isNull(result = (MdmOrgRespVo)this.mdmOrgFeign.getParentOrg(null, byId.getCreateOrgCode()).getResult())) {
            byId.setClientArea(result.getOrgName());
        }
        byId.setClientTypeDescribe(ActivityReleaseNeedEnum.getStatusName((String)byId.getClientType()));
        return byId;
    }

    @Override
    public SfaVisitStepColletProductRespVo query(String id) {
        SfaVisitStepColletProductEntity byId = (SfaVisitStepColletProductEntity)((Object)this.getById((Serializable)((Object)id)));
        return (SfaVisitStepColletProductRespVo)CrmBeanUtil.copy((Object)((Object)byId), SfaVisitStepColletProductRespVo.class);
    }

    @Override
    public void save(SfaVisitStepColletProductReqVo sfaVisitStepColletProductReqVo) {
        SfaVisitStepColletProductEntity copy = (SfaVisitStepColletProductEntity)((Object)CrmBeanUtil.copy((Object)sfaVisitStepColletProductReqVo, SfaVisitStepColletProductEntity.class));
        copy.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        copy.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        copy.setContendProductCode(CodeUtil.generateCode((String)CodeRuleEnum.SFA_CONTEND_PRODUCT_CODE.getCode()));
        this.save((Object)copy);
    }

    @Override
    public void update(SfaVisitStepColletProductReqVo sfaVisitStepColletProductReqVo) {
        SfaVisitStepColletProductEntity copy = (SfaVisitStepColletProductEntity)((Object)CrmBeanUtil.copy((Object)sfaVisitStepColletProductReqVo, SfaVisitStepColletProductEntity.class));
        copy.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        this.updateById((Object)copy);
        SfaLogRecordReqVo reqVo = new SfaLogRecordReqVo();
        reqVo.setBusinessId(copy.getId());
        reqVo.setLogType(SfaLogTypeEnum.COMPETE_MERCHANDISE_LOG.getCode());
        this.sfaLogRecordService.save(reqVo);
    }

    @Override
    public void deleteBatch(List<String> ids) {
        List sfaVisitStepColletProductEntities = this.sfaVisitStepColletProductMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepColletProductEntities)) {
            sfaVisitStepColletProductEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaVisitStepColletProductEntities);
    }

    @Override
    public void enableBatch(List<String> ids) {
        List sfaVisitStepColletProductEntities = this.sfaVisitStepColletProductMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepColletProductEntities)) {
            sfaVisitStepColletProductEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaVisitStepColletProductEntities);
    }

    @Override
    public void disableBatch(List<String> ids) {
        List sfaVisitStepColletProductEntities = this.sfaVisitStepColletProductMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepColletProductEntities)) {
            sfaVisitStepColletProductEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaVisitStepColletProductEntities);
    }

    private boolean strCompare(String strSource, String condition) {
        return strSource.indexOf(condition) >= 0;
    }
}

