/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.base.utils;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmAttachment;
import com.biz.crm.base.CrmAttachmentContainer3;
import com.biz.crm.base.CrmAttachmentContainer6;
import com.biz.crm.base.attachment.ISfaAttachmentService;
import com.biz.crm.base.attachment.SfaAttachmentEntity;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.eunm.sfa.AttachmentBizTypeEnum;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class SfaAttachmentUtil {
    private static ISfaAttachmentService sfaAttachmentService = (ISfaAttachmentService)SpringApplicationContextUtil.getApplicationContext().getBean(ISfaAttachmentService.class);

    private SfaAttachmentUtil() {
    }

    public static List<SfaAttachmentEntity> build(List<CrmAttachment> attachments, AttachmentBizTypeEnum bizType, String bizId) {
        if (null == bizType) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u9644\u4ef6\u4e1a\u52a1\u7c7b\u578b");
        }
        return SfaAttachmentUtil.build(attachments, bizType.getVal(), bizType.getDesc(), bizId);
    }

    public static List<SfaAttachmentEntity> build(List<CrmAttachment> attachments, String bizType, String bizTypeName, String bizId) {
        if (CollectionUtils.isEmpty(attachments)) {
            return Lists.newArrayList();
        }
        if (StringUtils.isBlank((CharSequence)bizType)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u9644\u4ef6\u4e1a\u52a1\u7c7b\u578b");
        }
        if (StringUtils.isBlank((CharSequence)bizId)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u9644\u4ef6\u4e1a\u52a1ID");
        }
        List<SfaAttachmentEntity> entities = attachments.stream().map(v -> {
            SfaAttachmentEntity entity = (SfaAttachmentEntity)((Object)((Object)CrmBeanUtil.copy((Object)v, SfaAttachmentEntity.class)));
            entity.setAttachmentBizType(bizType);
            entity.setAttachmentBizTypeName(bizTypeName);
            entity.setBizId(bizId);
            return entity;
        }).collect(Collectors.toList());
        return entities;
    }

    public static void copy(CrmAttachmentContainer6 source, CrmAttachmentContainer6 target) {
        if (null == source || null == target) {
            return;
        }
        source.setAttachmentExt1(target.getAttachmentExt1());
        source.setAttachmentExt2(target.getAttachmentExt2());
        source.setAttachmentExt3(target.getAttachmentExt3());
        source.setAttachmentExt4(target.getAttachmentExt4());
        source.setAttachmentExt5(target.getAttachmentExt5());
        source.setAttachmentExt6(target.getAttachmentExt6());
    }

    public static void copy(CrmAttachmentContainer3 source, CrmAttachmentContainer3 target) {
        if (null == source || null == target) {
            return;
        }
        source.setAttachmentExt1(target.getAttachmentExt1());
        source.setAttachmentExt2(target.getAttachmentExt2());
        source.setAttachmentExt3(target.getAttachmentExt3());
    }

    public static List<SfaAttachmentEntity> build(CrmAttachmentContainer6 container6) {
        if (!SfaAttachmentUtil.checkContainer((CrmAttachmentContainer3)container6)) {
            return Lists.newArrayList();
        }
        String bizId = container6.getId();
        String attachmentNameScope = container6.attachmentNameScope();
        List<SfaAttachmentEntity> list = SfaAttachmentUtil.build((CrmAttachmentContainer3)container6);
        String bizType = attachmentNameScope + "ATTACHMENT_EXT4";
        list.addAll(SfaAttachmentUtil.build(container6.getAttachmentExt4(), bizType, bizType, bizId));
        bizType = attachmentNameScope + "ATTACHMENT_EXT5";
        list.addAll(SfaAttachmentUtil.build(container6.getAttachmentExt5(), bizType, bizType, bizId));
        bizType = attachmentNameScope + "ATTACHMENT_EXT6";
        list.addAll(SfaAttachmentUtil.build(container6.getAttachmentExt6(), bizType, bizType, bizId));
        return list;
    }

    public static List<SfaAttachmentEntity> build(CrmAttachmentContainer3 container3) {
        if (!SfaAttachmentUtil.checkContainer(container3)) {
            return Lists.newArrayList();
        }
        ArrayList list = Lists.newArrayList();
        String bizId = container3.getId();
        String attachmentNameScope = container3.attachmentNameScope();
        String bizType = attachmentNameScope + "ATTACHMENT_EXT1";
        list.addAll(SfaAttachmentUtil.build(container3.getAttachmentExt1(), bizType, bizType, bizId));
        bizType = attachmentNameScope + "ATTACHMENT_EXT2";
        list.addAll(SfaAttachmentUtil.build(container3.getAttachmentExt2(), bizType, bizType, bizId));
        bizType = attachmentNameScope + "ATTACHMENT_EXT3";
        list.addAll(SfaAttachmentUtil.build(container3.getAttachmentExt3(), bizType, bizType, bizId));
        return list;
    }

    protected static boolean checkContainer(CrmAttachmentContainer3 container3) {
        if (null == container3) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)container3.getId())) {
            return false;
        }
        return !StringUtils.isBlank((CharSequence)container3.attachmentNameScope());
    }

    public static List<SfaAttachmentEntity> insert(CrmAttachmentContainer3 container3) {
        if (null == container3) {
            return Lists.newArrayList();
        }
        List<SfaAttachmentEntity> entities = container3 instanceof CrmAttachmentContainer6 ? SfaAttachmentUtil.build((CrmAttachmentContainer6)container3) : SfaAttachmentUtil.build(container3);
        return SfaAttachmentUtil.insert(entities);
    }

    public static List<SfaAttachmentEntity> insert(List<CrmAttachment> attachments, AttachmentBizTypeEnum bizType, String bizId) {
        List<SfaAttachmentEntity> entities = SfaAttachmentUtil.build(attachments, bizType, bizId);
        return SfaAttachmentUtil.insert(entities);
    }

    public static List<SfaAttachmentEntity> insert(List<CrmAttachment> attachments, String bizType, String bizTypeName, String bizId) {
        List<SfaAttachmentEntity> entities = SfaAttachmentUtil.build(attachments, bizType, bizTypeName, bizId);
        return SfaAttachmentUtil.insert(entities);
    }

    public static List<SfaAttachmentEntity> insert(List<SfaAttachmentEntity> attachments) {
        if (CollectionUtils.isEmpty(attachments)) {
            return Lists.newArrayList();
        }
        sfaAttachmentService.saveOrUpdateBatch(attachments, 50);
        return attachments;
    }

    public static void del(AttachmentBizTypeEnum bizType, String bizId) {
        if (null == bizType) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u9644\u4ef6\u4e1a\u52a1\u7c7b\u578b");
        }
        if (StringUtils.isBlank((CharSequence)bizId)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u9644\u4ef6\u4e1a\u52a1ID");
        }
        sfaAttachmentService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaAttachmentEntity.class).eq(SfaAttachmentEntity::getBizId, (Object)bizId)).eq(SfaAttachmentEntity::getAttachmentBizType, (Object)bizType.getVal()));
    }

    public static void delByBizIdInBizTypeEnums(List<AttachmentBizTypeEnum> bizTypeEnums, String bizId) {
        if (CollectionUtils.isEmpty(bizTypeEnums)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u9644\u4ef6\u4e1a\u52a1\u7c7b\u578b");
        }
        if (StringUtils.isBlank((CharSequence)bizId)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u9644\u4ef6\u4e1a\u52a1ID");
        }
        sfaAttachmentService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaAttachmentEntity.class).eq(SfaAttachmentEntity::getBizId, (Object)bizId)).in(SfaAttachmentEntity::getAttachmentBizType, (Collection)bizTypeEnums.stream().map(AttachmentBizTypeEnum::getVal).collect(Collectors.toList())));
    }

    public static void del(String bizType, String bizId) {
        if (StringUtils.isBlank((CharSequence)bizType)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u9644\u4ef6\u4e1a\u52a1\u7c7b\u578b");
        }
        if (StringUtils.isBlank((CharSequence)bizId)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u9644\u4ef6\u4e1a\u52a1ID");
        }
        sfaAttachmentService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaAttachmentEntity.class).eq(SfaAttachmentEntity::getBizId, (Object)bizId)).eq(SfaAttachmentEntity::getAttachmentBizType, (Object)bizType));
    }

    public static void delByBizIdInBizTypes(List<String> bizTypes, String bizId) {
        if (CollectionUtils.isEmpty(bizTypes)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u9644\u4ef6\u4e1a\u52a1\u7c7b\u578b");
        }
        if (StringUtils.isBlank((CharSequence)bizId)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u9644\u4ef6\u4e1a\u52a1ID");
        }
        sfaAttachmentService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaAttachmentEntity.class).eq(SfaAttachmentEntity::getBizId, (Object)bizId)).in(SfaAttachmentEntity::getAttachmentBizType, bizTypes));
    }

    public static void delByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        sfaAttachmentService.removeByIds(ids);
    }

    public static List<SfaAttachmentEntity> getList(AttachmentBizTypeEnum bizType, String bizId) {
        if (null == bizType) {
            return Lists.newArrayList();
        }
        return SfaAttachmentUtil.getList(bizType.getVal(), bizId);
    }

    public static List<SfaAttachmentEntity> getList(String bizType, String bizId) {
        if (StringUtils.isBlank((CharSequence)bizType)) {
            return Lists.newArrayList();
        }
        if (StringUtils.isBlank((CharSequence)bizId)) {
            return Lists.newArrayList();
        }
        return sfaAttachmentService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaAttachmentEntity.class).eq(SfaAttachmentEntity::getBizId, (Object)bizId)).eq(SfaAttachmentEntity::getAttachmentBizType, (Object)bizType));
    }

    public static List<SfaAttachmentEntity> getList(AttachmentBizTypeEnum bizType, List<String> bizIds) {
        if (null == bizType) {
            return Lists.newArrayList();
        }
        return SfaAttachmentUtil.getList(bizType.getVal(), bizIds);
    }

    public static List<SfaAttachmentEntity> getList(String bizType, List<String> bizIds) {
        if (StringUtils.isBlank((CharSequence)bizType)) {
            return Lists.newArrayList();
        }
        if (CollectionUtils.isEmpty(bizIds)) {
            return Lists.newArrayList();
        }
        return sfaAttachmentService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaAttachmentEntity.class).in(SfaAttachmentEntity::getBizId, bizIds)).eq(SfaAttachmentEntity::getAttachmentBizType, (Object)bizType));
    }
}

