/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksign.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.UUIDGenerator;
import com.biz.crm.worksign.model.SfaWorkSignRecordEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignRuleEntity;
import com.biz.crm.worksignrule.service.impl.ExecuteSignRuleContext;
import java.time.LocalTime;
import java.util.List;
import javax.persistence.Index;
import org.apache.commons.lang3.StringUtils;

@TableName(value="sfa_work_sign_rule_info")
@CrmTable(name="sfa_work_sign_rule_info", tableNote="\u8003\u52e4\u89c4\u5219\u660e\u7ec6\u8868", indexes={@Index(name="SFA_WORK_SIGN_RULE_INFO_INDEX3", columnList="id,rule_code,rule_name")})
public class SfaWorkSignRuleInfoEntity
extends CrmExtTenEntity<SfaWorkSignRuleInfoEntity> {
    @CrmColumn(name="user_name", length=100, note="\u4eba\u5458\u8d26\u53f7 \u4eba\u5458\u8d26\u53f7")
    private String userName;
    @CrmColumn(name="real_name", length=200, note="\u4eba\u5458\u540d\u79f0 \u4eba\u5458\u540d\u79f0")
    private String realName;
    @CrmColumn(name="pos_code", length=64, note="\u804c\u4f4d\u7f16\u7801 \u804c\u4f4d\u7f16\u7801")
    private String posCode;
    @CrmColumn(name="pos_name", length=200, note="\u804c\u4f4d\u540d\u79f0 \u804c\u4f4d\u540d\u79f0")
    private String posName;
    @CrmColumn(name="org_code", length=64, note="\u7ec4\u7ec7\u7f16\u7801 \u7ec4\u7ec7\u7f16\u7801")
    private String orgCode;
    @CrmColumn(name="org_name", length=200, note="\u7ec4\u7ec7\u540d\u79f0 \u7ec4\u7ec7\u540d\u79f0")
    private String orgName;
    @CrmColumn(name="parent_org_code", length=32, note="\u4e0a\u7ea7\u7ec4\u7ec7\u7f16\u7801 \u7ec4\u7ec7\u7f16\u7801")
    private String parentOrgCode;
    @CrmColumn(name="parent_org_name", length=64, note="\u4e0a\u7ea7\u7ec4\u7ec7\u540d\u79f0 \u7ec4\u7ec7\u540d\u79f0")
    private String parentOrgName;
    @CrmColumn(name="rule_code", length=64, note="\u89c4\u5219\u7f16\u7801 \u89c4\u5219\u7f16\u7801")
    private String ruleCode;
    @CrmColumn(name="rule_name", length=200, note="\u89c4\u5219\u540d\u79f0 \u89c4\u5219\u540d\u79f0")
    private String ruleName;
    @CrmColumn(name="rule_type", length=64, note="\u89c4\u5219\u7c7b\u578b \u89c4\u5219\u7c7b\u578b STATIC:\u56fa\u5b9a\u65f6\u95f4\u4e0a\u4e0b\u73ed\u89c4\u5219/FREE_TIME:\u81ea\u7531\u65f6\u95f4\u4e0a\u4e0b\u73ed\u89c4\u5219")
    private String ruleType;
    @CrmColumn(name="non_working_day_sign_astrict", length=4, note="\u5de5\u4f5c\u65e5\u8c03\u6574\u7533\u8bf7\u65f6\u662f\u5426\u9075\u5faa\u6b64\u89c4\u5219(\u524d\u7aef\u6c14\u6ce1)\uff08Y/N \u9ed8\u8ba4N\uff09")
    private String nonWorkingDaySignAstrict;
    @CrmColumn(name="rule_date", length=32, note="\u8003\u52e4\u65e5\u671f \u8003\u52e4\u65e5\u671f\uff08yyyy-MM-dd\uff09")
    private String ruleDate;
    @CrmColumn(name="rule_year", length=10, note="\u8003\u52e4\u65e5\u671f \u8003\u52e4\u65e5\u671f\uff08yyyy\uff09")
    private String ruleYear;
    @CrmColumn(name="rule_month", length=10, note="\u8003\u52e4\u65e5\u671f \u8003\u52e4\u65e5\u671f\uff08MM\uff09")
    private String ruleMonth;
    @CrmColumn(name="rule_year_month", length=16, note="\u8003\u52e4\u65e5\u671f \u8003\u52e4\u65e5\u671f\uff08yyyy-MM\uff09")
    private String ruleYearMonth;
    @CrmColumn(name="electron_fence", length=64, note="\u7535\u5b50\u56f4\u680f;\u7535\u5b50\u56f4\u680f(NONE:\u65e0\u7535\u5b50\u56f4\u680f/OUT_SIGN_EX:\u5141\u8bb8\u8303\u56f4\u5916\u6253\u5361\uff0c\u5730\u70b9\u8bb0\u5f55\u4e3a\u5f02\u5e38/OUT_SIGN_OK:\u5141\u8bb8\u8303\u56f4\u5916\u6253\u5361\uff0c\u5730\u70b9\u8bb0\u5f55\u4e3a\u6b63\u5e38/NO_OUT_SIGN:\u4e0d\u5141\u8bb8\u8303\u56f4\u5916\u6253\u5361)")
    private String electronFence;
    @CrmColumn(name="gooff_work_sign_astrict", length=64, note="\u4e0b\u73ed\u6253\u5361\u9650\u5236\uff1a(NO_SIGN:\u4e0b\u73ed\u4e0d\u9700\u8981\u6253\u5361;GOTO_WORK_REQUIRED:\u4e0b\u73ed\u9700\u8981\u6253\u5361\uff0c\u4e14\u5fc5\u987b\u6253\u4e0a\u73ed\u5361\u624d\u80fd\u6253\u4e0b\u73ed\u5361;GOTO_WORK_NO_REQUIRED:\u4e0b\u73ed\u9700\u8981\u6253\u5361\uff0c\u65e0\u9700\u6253\u4e0a\u73ed\u5361\uff0c\u5c31\u80fd\u6253\u4e0b\u73ed\u5361)")
    private String gooffWorkSignAstrict;
    @CrmColumn(name="wsr_photograph", length=4, note="\u62cd\u7167\u6253\u5361;\u62cd\u7167\u6253\u5361(Y:\u5458\u5de5\u6253\u5361\u65f6\u5fc5\u987b\u62cd\u7167)")
    private String wsrPhotograph;
    @CrmColumn(name="sign_must", length=10, note="\u662f\u5426\u5de5\u4f5c\u65e5(Y:\u662f,N:\u5426)")
    private String signMust;
    @CrmColumn(name="sign_or_non_type", length=20, note="\u6253\u5361\u6216\u4e0d\u6253\u5361\u7c7b\u578b(10:\u5de5\u4f5c\u65e5\u6253\u5361\uff0c\uff0c11:\u7279\u6b8a\u65e5\u671f\u6253\u5361\uff0c20:\u975e\u5de5\u4f5c\u65e5\u4e0d\u6253\u5361,21:\u7279\u6b8a\u65e5\u671f\u4e0d\u6253\u5361,22:\u8282\u5047\u65e5\u4e0d\u6253\u5361)")
    private String signOrNonType;
    @CrmColumn(name="used_status", length=4, note="\u662f\u5426\u5df2\u7ecf\u4f7f\u7528(Y:\u5df2\u7ecf\u6253\u5361,N:\u672a\u5904\u7406)\uff0c\u5982\u679c\u91cd\u65b0\u65b0\u751f\u6210\u6839\u636e\u8be5\u5b57\u6bb5\u5224\u65ad")
    private String usedStatus;
    @TableField(exist=false)
    private List<SfaWorkSignRecordEntity> sfaWorkSignRecords;

    public SfaWorkSignRecordEntity checkSignTime(boolean isClockIn, List<SfaWorkSignRecordEntity> recordEntity) {
        if (YesNoEnum.yesNoEnum.NO.getValue().equals(this.signMust) && YesNoEnum.yesNoEnum.NO.getValue().equals(this.nonWorkingDaySignAstrict)) {
            return recordEntity.get(0);
        }
        for (SfaWorkSignRecordEntity record : recordEntity) {
            LocalTime localTime;
            String startTimeStr = record.getSfaSignTimeBegin();
            String endTimeStr = record.getSfaSignTimeEnd();
            if (StringUtils.isBlank((CharSequence)startTimeStr)) {
                startTimeStr = record.getSfaSignTime();
            }
            if (StringUtils.isBlank((CharSequence)endTimeStr)) {
                String string = endTimeStr = isClockIn ? "12:00:00" : "23:59:59";
            }
            if ("00:00:00".equals(endTimeStr)) {
                endTimeStr = "23:59:59";
            }
            if ((localTime = LocalTime.now()).compareTo(LocalTime.parse(startTimeStr, CrmDateUtils.HHmmss)) < 0 || localTime.compareTo(LocalTime.parse(endTimeStr, CrmDateUtils.HHmmss)) > 0) continue;
            return record;
        }
        String tag = isClockIn ? "\u7b7e\u5230" : "\u7b7e\u9000";
        throw new BusinessException("\u5f53\u524d\u65f6\u95f4\u4e0d\u80fd" + tag);
    }

    public static SfaWorkSignRuleInfoEntity buildRuleInfoEntity(ExecuteSignRuleContext context, SfaWorkSignRuleEntity entity, MdmPositionUserOrgRespVo positionRespVo) {
        SfaWorkSignRuleInfoEntity infoEntity = SfaWorkSignRuleInfoEntity.buildRuleInfoEntity(entity, context.getSignDate());
        infoEntity.setOrgCode(context.getOrgCodeNow());
        infoEntity.setOrgName(context.getOrgNameNow());
        infoEntity.setParentOrgCode(context.getParentOrgCodeNow());
        infoEntity.setParentOrgName(context.getParentOrgNameNow());
        infoEntity.setPosCode(positionRespVo.getPositionCode());
        infoEntity.setPosName(positionRespVo.getPositionName());
        infoEntity.setRealName(positionRespVo.getFullName());
        infoEntity.setUserName(positionRespVo.getUserName());
        return infoEntity;
    }

    public static SfaWorkSignRuleInfoEntity buildRuleInfoEntity(SfaWorkSignRuleEntity entity, String signDate) {
        SfaWorkSignRuleInfoEntity infoEntity = new SfaWorkSignRuleInfoEntity();
        infoEntity.setId(UUIDGenerator.generate());
        infoEntity.setWsrPhotograph(entity.getWsrPhotograph());
        infoEntity.setRuleType(entity.getRuleType());
        infoEntity.setElectronFence(entity.getElectronFence());
        infoEntity.setRuleCode(entity.getRuleCode());
        infoEntity.setRuleName(entity.getRuleName());
        infoEntity.setGooffWorkSignAstrict(entity.getGooffWorkSignAstrict());
        infoEntity.setNonWorkingDaySignAstrict(entity.getNonWorkingDaySignAstrict());
        infoEntity.setUsedStatus(YesNoEnum.yesNoEnum.NO.getValue());
        infoEntity.setRuleDate(signDate);
        if (StringUtils.isNotBlank((CharSequence)signDate)) {
            String year = signDate.substring(0, 4);
            String month = signDate.substring(6, 7).replaceAll("^(0+)", "");
            String yearMonth = signDate.substring(0, 7);
            infoEntity.setRuleYear(year);
            infoEntity.setRuleMonth(month);
            infoEntity.setRuleYearMonth(yearMonth);
        }
        return infoEntity;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getRealName() {
        return this.realName;
    }

    public String getPosCode() {
        return this.posCode;
    }

    public String getPosName() {
        return this.posName;
    }

    public String getOrgCode() {
        return this.orgCode;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public String getParentOrgCode() {
        return this.parentOrgCode;
    }

    public String getParentOrgName() {
        return this.parentOrgName;
    }

    public String getRuleCode() {
        return this.ruleCode;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public String getRuleType() {
        return this.ruleType;
    }

    public String getNonWorkingDaySignAstrict() {
        return this.nonWorkingDaySignAstrict;
    }

    public String getRuleDate() {
        return this.ruleDate;
    }

    public String getRuleYear() {
        return this.ruleYear;
    }

    public String getRuleMonth() {
        return this.ruleMonth;
    }

    public String getRuleYearMonth() {
        return this.ruleYearMonth;
    }

    public String getElectronFence() {
        return this.electronFence;
    }

    public String getGooffWorkSignAstrict() {
        return this.gooffWorkSignAstrict;
    }

    public String getWsrPhotograph() {
        return this.wsrPhotograph;
    }

    public String getSignMust() {
        return this.signMust;
    }

    public String getSignOrNonType() {
        return this.signOrNonType;
    }

    public String getUsedStatus() {
        return this.usedStatus;
    }

    public List<SfaWorkSignRecordEntity> getSfaWorkSignRecords() {
        return this.sfaWorkSignRecords;
    }

    public SfaWorkSignRuleInfoEntity setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setRealName(String realName) {
        this.realName = realName;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setPosCode(String posCode) {
        this.posCode = posCode;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setPosName(String posName) {
        this.posName = posName;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setOrgCode(String orgCode) {
        this.orgCode = orgCode;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setOrgName(String orgName) {
        this.orgName = orgName;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setRuleCode(String ruleCode) {
        this.ruleCode = ruleCode;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setRuleName(String ruleName) {
        this.ruleName = ruleName;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setRuleType(String ruleType) {
        this.ruleType = ruleType;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setNonWorkingDaySignAstrict(String nonWorkingDaySignAstrict) {
        this.nonWorkingDaySignAstrict = nonWorkingDaySignAstrict;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setRuleDate(String ruleDate) {
        this.ruleDate = ruleDate;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setRuleYear(String ruleYear) {
        this.ruleYear = ruleYear;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setRuleMonth(String ruleMonth) {
        this.ruleMonth = ruleMonth;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setRuleYearMonth(String ruleYearMonth) {
        this.ruleYearMonth = ruleYearMonth;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setElectronFence(String electronFence) {
        this.electronFence = electronFence;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setGooffWorkSignAstrict(String gooffWorkSignAstrict) {
        this.gooffWorkSignAstrict = gooffWorkSignAstrict;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setWsrPhotograph(String wsrPhotograph) {
        this.wsrPhotograph = wsrPhotograph;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setSignMust(String signMust) {
        this.signMust = signMust;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setSignOrNonType(String signOrNonType2) {
        this.signOrNonType = signOrNonType2;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setUsedStatus(String usedStatus) {
        this.usedStatus = usedStatus;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setSfaWorkSignRecords(List<SfaWorkSignRecordEntity> sfaWorkSignRecords) {
        this.sfaWorkSignRecords = sfaWorkSignRecords;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SfaWorkSignRuleInfoEntity)) {
            return false;
        }
        SfaWorkSignRuleInfoEntity other = (SfaWorkSignRuleInfoEntity)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$realName = this.getRealName();
        String other$realName = other.getRealName();
        if (this$realName == null ? other$realName != null : !this$realName.equals(other$realName)) {
            return false;
        }
        String this$posCode = this.getPosCode();
        String other$posCode = other.getPosCode();
        if (this$posCode == null ? other$posCode != null : !this$posCode.equals(other$posCode)) {
            return false;
        }
        String this$posName = this.getPosName();
        String other$posName = other.getPosName();
        if (this$posName == null ? other$posName != null : !this$posName.equals(other$posName)) {
            return false;
        }
        String this$orgCode = this.getOrgCode();
        String other$orgCode = other.getOrgCode();
        if (this$orgCode == null ? other$orgCode != null : !this$orgCode.equals(other$orgCode)) {
            return false;
        }
        String this$orgName = this.getOrgName();
        String other$orgName = other.getOrgName();
        if (this$orgName == null ? other$orgName != null : !this$orgName.equals(other$orgName)) {
            return false;
        }
        String this$parentOrgCode = this.getParentOrgCode();
        String other$parentOrgCode = other.getParentOrgCode();
        if (this$parentOrgCode == null ? other$parentOrgCode != null : !this$parentOrgCode.equals(other$parentOrgCode)) {
            return false;
        }
        String this$parentOrgName = this.getParentOrgName();
        String other$parentOrgName = other.getParentOrgName();
        if (this$parentOrgName == null ? other$parentOrgName != null : !this$parentOrgName.equals(other$parentOrgName)) {
            return false;
        }
        String this$ruleCode = this.getRuleCode();
        String other$ruleCode = other.getRuleCode();
        if (this$ruleCode == null ? other$ruleCode != null : !this$ruleCode.equals(other$ruleCode)) {
            return false;
        }
        String this$ruleName = this.getRuleName();
        String other$ruleName = other.getRuleName();
        if (this$ruleName == null ? other$ruleName != null : !this$ruleName.equals(other$ruleName)) {
            return false;
        }
        String this$ruleType = this.getRuleType();
        String other$ruleType = other.getRuleType();
        if (this$ruleType == null ? other$ruleType != null : !this$ruleType.equals(other$ruleType)) {
            return false;
        }
        String this$nonWorkingDaySignAstrict = this.getNonWorkingDaySignAstrict();
        String other$nonWorkingDaySignAstrict = other.getNonWorkingDaySignAstrict();
        if (this$nonWorkingDaySignAstrict == null ? other$nonWorkingDaySignAstrict != null : !this$nonWorkingDaySignAstrict.equals(other$nonWorkingDaySignAstrict)) {
            return false;
        }
        String this$ruleDate = this.getRuleDate();
        String other$ruleDate = other.getRuleDate();
        if (this$ruleDate == null ? other$ruleDate != null : !this$ruleDate.equals(other$ruleDate)) {
            return false;
        }
        String this$ruleYear = this.getRuleYear();
        String other$ruleYear = other.getRuleYear();
        if (this$ruleYear == null ? other$ruleYear != null : !this$ruleYear.equals(other$ruleYear)) {
            return false;
        }
        String this$ruleMonth = this.getRuleMonth();
        String other$ruleMonth = other.getRuleMonth();
        if (this$ruleMonth == null ? other$ruleMonth != null : !this$ruleMonth.equals(other$ruleMonth)) {
            return false;
        }
        String this$ruleYearMonth = this.getRuleYearMonth();
        String other$ruleYearMonth = other.getRuleYearMonth();
        if (this$ruleYearMonth == null ? other$ruleYearMonth != null : !this$ruleYearMonth.equals(other$ruleYearMonth)) {
            return false;
        }
        String this$electronFence = this.getElectronFence();
        String other$electronFence = other.getElectronFence();
        if (this$electronFence == null ? other$electronFence != null : !this$electronFence.equals(other$electronFence)) {
            return false;
        }
        String this$gooffWorkSignAstrict = this.getGooffWorkSignAstrict();
        String other$gooffWorkSignAstrict = other.getGooffWorkSignAstrict();
        if (this$gooffWorkSignAstrict == null ? other$gooffWorkSignAstrict != null : !this$gooffWorkSignAstrict.equals(other$gooffWorkSignAstrict)) {
            return false;
        }
        String this$wsrPhotograph = this.getWsrPhotograph();
        String other$wsrPhotograph = other.getWsrPhotograph();
        if (this$wsrPhotograph == null ? other$wsrPhotograph != null : !this$wsrPhotograph.equals(other$wsrPhotograph)) {
            return false;
        }
        String this$signMust = this.getSignMust();
        String other$signMust = other.getSignMust();
        if (this$signMust == null ? other$signMust != null : !this$signMust.equals(other$signMust)) {
            return false;
        }
        String this$signOrNonType = this.getSignOrNonType();
        String other$signOrNonType = other.getSignOrNonType();
        if (this$signOrNonType == null ? other$signOrNonType != null : !this$signOrNonType.equals(other$signOrNonType)) {
            return false;
        }
        String this$usedStatus = this.getUsedStatus();
        String other$usedStatus = other.getUsedStatus();
        if (this$usedStatus == null ? other$usedStatus != null : !this$usedStatus.equals(other$usedStatus)) {
            return false;
        }
        List<SfaWorkSignRecordEntity> this$sfaWorkSignRecords = this.getSfaWorkSignRecords();
        List<SfaWorkSignRecordEntity> other$sfaWorkSignRecords = other.getSfaWorkSignRecords();
        return !(this$sfaWorkSignRecords == null ? other$sfaWorkSignRecords != null : !((Object)this$sfaWorkSignRecords).equals(other$sfaWorkSignRecords));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SfaWorkSignRuleInfoEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $realName = this.getRealName();
        result = result * 59 + ($realName == null ? 43 : $realName.hashCode());
        String $posCode = this.getPosCode();
        result = result * 59 + ($posCode == null ? 43 : $posCode.hashCode());
        String $posName = this.getPosName();
        result = result * 59 + ($posName == null ? 43 : $posName.hashCode());
        String $orgCode = this.getOrgCode();
        result = result * 59 + ($orgCode == null ? 43 : $orgCode.hashCode());
        String $orgName = this.getOrgName();
        result = result * 59 + ($orgName == null ? 43 : $orgName.hashCode());
        String $parentOrgCode = this.getParentOrgCode();
        result = result * 59 + ($parentOrgCode == null ? 43 : $parentOrgCode.hashCode());
        String $parentOrgName = this.getParentOrgName();
        result = result * 59 + ($parentOrgName == null ? 43 : $parentOrgName.hashCode());
        String $ruleCode = this.getRuleCode();
        result = result * 59 + ($ruleCode == null ? 43 : $ruleCode.hashCode());
        String $ruleName = this.getRuleName();
        result = result * 59 + ($ruleName == null ? 43 : $ruleName.hashCode());
        String $ruleType = this.getRuleType();
        result = result * 59 + ($ruleType == null ? 43 : $ruleType.hashCode());
        String $nonWorkingDaySignAstrict = this.getNonWorkingDaySignAstrict();
        result = result * 59 + ($nonWorkingDaySignAstrict == null ? 43 : $nonWorkingDaySignAstrict.hashCode());
        String $ruleDate = this.getRuleDate();
        result = result * 59 + ($ruleDate == null ? 43 : $ruleDate.hashCode());
        String $ruleYear = this.getRuleYear();
        result = result * 59 + ($ruleYear == null ? 43 : $ruleYear.hashCode());
        String $ruleMonth = this.getRuleMonth();
        result = result * 59 + ($ruleMonth == null ? 43 : $ruleMonth.hashCode());
        String $ruleYearMonth = this.getRuleYearMonth();
        result = result * 59 + ($ruleYearMonth == null ? 43 : $ruleYearMonth.hashCode());
        String $electronFence = this.getElectronFence();
        result = result * 59 + ($electronFence == null ? 43 : $electronFence.hashCode());
        String $gooffWorkSignAstrict = this.getGooffWorkSignAstrict();
        result = result * 59 + ($gooffWorkSignAstrict == null ? 43 : $gooffWorkSignAstrict.hashCode());
        String $wsrPhotograph = this.getWsrPhotograph();
        result = result * 59 + ($wsrPhotograph == null ? 43 : $wsrPhotograph.hashCode());
        String $signMust = this.getSignMust();
        result = result * 59 + ($signMust == null ? 43 : $signMust.hashCode());
        String $signOrNonType = this.getSignOrNonType();
        result = result * 59 + ($signOrNonType == null ? 43 : $signOrNonType.hashCode());
        String $usedStatus = this.getUsedStatus();
        result = result * 59 + ($usedStatus == null ? 43 : $usedStatus.hashCode());
        List<SfaWorkSignRecordEntity> $sfaWorkSignRecords = this.getSfaWorkSignRecords();
        result = result * 59 + ($sfaWorkSignRecords == null ? 43 : ((Object)$sfaWorkSignRecords).hashCode());
        return result;
    }
}

