/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.actscheme.controller;

import com.biz.crm.actscheme.service.ISfaActSchemeService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.actscheme.req.SfaActSchemeReqVo;
import com.biz.crm.nebular.sfa.actscheme.resp.SfaActSchemeRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sfaActSchemeController"})
@Api(tags={"\u6d3b\u52a8\u65b9\u6848;"})
public class SfaActSchemeController {
    private static final Logger log = LoggerFactory.getLogger(SfaActSchemeController.class);
    @Autowired
    private ISfaActSchemeService sfaActSchemeService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<SfaActSchemeRespVo>> list(@RequestBody SfaActSchemeReqVo sfaActSchemeReqVo) {
        PageResult<SfaActSchemeRespVo> result = this.sfaActSchemeService.findList(sfaActSchemeReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u8be6\u60c5")
    @GetMapping(value={"/queryDetailById"})
    @CrmLog
    public Result<SfaActSchemeRespVo> queryDetailById(@RequestParam String id) {
        SfaActSchemeRespVo respVo = this.sfaActSchemeService.queryDetailById(id);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @PostMapping(value={"/query"})
    @CrmLog
    public Result<SfaActSchemeRespVo> query(@RequestBody SfaActSchemeReqVo sfaActSchemeReqVo) {
        SfaActSchemeRespVo respVo = this.sfaActSchemeService.query(sfaActSchemeReqVo);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u6839\u636e\u6267\u884cID\u67e5\u8be2\u65b9\u6848\u4fe1\u606f")
    @GetMapping(value={"/findSchemeByExecutionId/{executionId}"})
    @CrmLog
    public Result<SfaActSchemeRespVo> findSchemeByExecutionId(@PathVariable(value="executionId") String executionId) {
        SfaActSchemeRespVo result = this.sfaActSchemeService.findSchemeByExecutionId(executionId);
        return Result.ok((Object)result);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody SfaActSchemeReqVo sfaActSchemeReqVo) {
        this.sfaActSchemeService.save(sfaActSchemeReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody SfaActSchemeReqVo sfaActSchemeReqVo) {
        Result result = this.sfaActSchemeService.isUpdate(sfaActSchemeReqVo);
        if (!result.isSuccess()) {
            return result;
        }
        this.sfaActSchemeService.update(sfaActSchemeReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u662f\u5426\u5141\u8bb8\u66f4\u65b0")
    @PostMapping(value={"/isUpdate"})
    @CrmLog
    public Result isUpdate(@RequestBody SfaActSchemeReqVo sfaActSchemeReqVo) {
        Result result = this.sfaActSchemeService.isUpdate(sfaActSchemeReqVo);
        return result;
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        this.sfaActSchemeService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        this.sfaActSchemeService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        this.sfaActSchemeService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u6839\u636e\u5f53\u524d\u4eba\u5458\u67e5\u8be2\u53ef\u7533\u8bf7\u7684\u6d3b\u52a8\u65b9\u6848\u5217\u8868")
    @PostMapping(value={"/findPosList"})
    @CrmLog
    public Result<PageResult<SfaActSchemeRespVo>> findPosList(@RequestBody SfaActSchemeReqVo sfaActSchemeReqVo) {
        PageResult<SfaActSchemeRespVo> result = this.sfaActSchemeService.findPosList(sfaActSchemeReqVo);
        return Result.ok(result);
    }
}

