/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitinfo.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.mdm.user.MdmUserFeign;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.mdm.position.req.MdmPositionPageReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionPageRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.DistanceUtil;
import com.biz.crm.util.JobHelper;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.PageDataAdviser;
import com.biz.crm.util.Result;
import com.biz.crm.visitinfo.mapper.SfaVisitCompleteInfoMapper;
import com.biz.crm.visitinfo.model.SfaVisitCompleteInfoEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoExecuteRedisData;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoRedisData;
import com.biz.crm.visitinfo.repositories.SfaVisitPlanInfoEntityRepositories;
import com.biz.crm.visitinfo.repositories.SfaVisitPlanInfoRedisDataRepositories;
import com.biz.crm.visitinfo.req.VisitCompleteInfoSearchReqVo;
import com.biz.crm.visitinfo.resp.report.SfaVisitCompleteInfoRespVo;
import com.biz.crm.visitinfo.resp.report.SfaVisitPlanRouteRespVo;
import com.biz.crm.visitinfo.resp.report.SfaVisitRealRouteRespVo;
import com.biz.crm.visitinfo.resp.report.SfaVisitRouteRespVo;
import com.biz.crm.visitinfo.service.ISfaVisitCompleteInfoService;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"SfaVisitCompleteInfoServiceExpandImpl"})
public class SfaVisitCompleteInfoServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaVisitCompleteInfoMapper, SfaVisitCompleteInfoEntity>
implements JobHelper.JobExecutor,
ISfaVisitCompleteInfoService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitCompleteInfoServiceImpl.class);
    @Resource
    private SfaVisitPlanInfoEntityRepositories sfaVisitPlanInfoEntityRepositories;
    @Resource
    private SfaVisitCompleteInfoMapper sfaVisitCompleteInfoMapper;
    @Resource
    private SfaVisitPlanInfoRedisDataRepositories sfaVisitPlanInfoRedisDataRepositories;
    @Resource
    private MdmUserFeign mdmUserFeign;
    @Resource
    private MdmPositionFeign mdmPositionFeign;
    @Resource
    private JobHelper jobHelper;
    @Resource
    private RocketMQProducer rocketMQProducer;
    @Resource
    private ISfaVisitPlanInfoService sfaVisitPlanInfoService;
    @Value(value="${sfa.remote.schema.mdm}")
    private String mdm;

    @Override
    public PageResult<SfaVisitCompleteInfoRespVo> getVisitCompleteInfoDailyList(VisitCompleteInfoSearchReqVo visitCompleteInfoSearchReqVo) {
        Page page = new Page((long)visitCompleteInfoSearchReqVo.getPageNum().intValue(), (long)visitCompleteInfoSearchReqVo.getPageSize().intValue());
        List<SfaVisitCompleteInfoRespVo> infoEntities = this.sfaVisitCompleteInfoMapper.getVisitCompleteInfoDailyList((Page<VisitCompleteInfoSearchReqVo>)page, visitCompleteInfoSearchReqVo, this.mdm);
        List result = CrmBeanUtil.copyList(infoEntities, SfaVisitCompleteInfoRespVo.class);
        return PageResult.builder().count(Long.valueOf(page.getTotal())).data(result).build();
    }

    @Override
    public PageResult<SfaVisitCompleteInfoRespVo> getVisitCompleteInfoMonthList(VisitCompleteInfoSearchReqVo visitCompleteInfoSearchReqVo) {
        Page page = new Page((long)visitCompleteInfoSearchReqVo.getPageNum().intValue(), (long)visitCompleteInfoSearchReqVo.getPageSize().intValue());
        List<SfaVisitCompleteInfoRespVo> visitCompleteInfoMonthList = this.sfaVisitCompleteInfoMapper.getVisitCompleteInfoMonthList((Page<SfaVisitCompleteInfoRespVo>)page, visitCompleteInfoSearchReqVo, this.mdm);
        visitCompleteInfoMonthList.forEach(x -> {
            if (x.getPlanCompleteVisitNum() != null && x.getPlanCompleteVisitNum() > 0) {
                x.setCompleteVisitPercent(new BigDecimal(x.getRealCompleteVisitNum()).divide(new BigDecimal(x.getPlanCompleteVisitNum()), 2, 4).multiply(new BigDecimal(100)).toString());
            }
            if (x.getPlanCompleteHelpVisitNum() != null && x.getPlanCompleteHelpVisitNum() > 0) {
                x.setCompleteHelpVisitPercent(new BigDecimal(x.getRealCompleteHelpVisitNum()).divide(new BigDecimal(x.getPlanCompleteHelpVisitNum()), 2, 4).multiply(new BigDecimal(100)).toString());
            }
        });
        List sfaVisitCompleteInfoRespVos = CrmBeanUtil.copyList(visitCompleteInfoMonthList, SfaVisitCompleteInfoRespVo.class);
        return PageResult.builder().count(Long.valueOf(page.getTotal())).data(sfaVisitCompleteInfoRespVos).build();
    }

    public void executeJob(Object jobParam) {
        this.doPlanInfoSettlementJob((String)jobParam);
    }

    @Override
    public void planInfoSettlementForWeb(String visitDateTemp) {
        this.planInfoSettlementJob(visitDateTemp);
    }

    @Override
    public void planInfoSettlementForJob(String visitDateTemp) {
        this.planInfoSettlementJob(visitDateTemp);
    }

    protected void planInfoSettlementJob(String visitDateTemp) {
        if (StringUtils.isBlank((CharSequence)visitDateTemp)) {
            visitDateTemp = LocalDate.now().plusDays(-1L).format(CrmDateUtils.yyyyMMdd);
        }
        JobHelper.JobContext context = new JobHelper.JobContext();
        context.setJob(JobHelper.Job.VISIT_DAY_RATE_JOB);
        context.setExecutorBeanClass(SfaVisitCompleteInfoServiceImpl.class);
        context.setJobParam((Object)visitDateTemp);
        this.jobHelper.executeJobSaveContext(context);
    }

    protected void doPlanInfoSettlementJob(String visitDate) {
        PageDataAdviser pageDataAdviser = new PageDataAdviser(this.jobHelper.getJobBizDataPageSize());
        long total = this.jobHelper.getJobBizDataPageSize();
        while (pageDataAdviser.hasNext(Long.valueOf(total))) {
            MdmPositionPageReqVo reqVo = new MdmPositionPageReqVo();
            reqVo.setPageNum(pageDataAdviser.nextPage());
            reqVo.setPageSize(pageDataAdviser.getPageSize());
            PageResult pageResult = (PageResult)ApiResultUtil.objResult((Result)this.mdmPositionFeign.positionAndUserPage(reqVo), (boolean)true);
            List users = pageResult.getData();
            this.sendMq(users, visitDate);
            total = pageResult.getCount();
        }
    }

    protected void sendMq(List<MdmPositionPageRespVo> users, String visitDate) {
        RocketMQMessageBody mqMessageBody = new RocketMQMessageBody();
        ArrayList<SfaVisitCompleteInfoEntity> entityList = new ArrayList<SfaVisitCompleteInfoEntity>();
        for (MdmPositionPageRespVo mdmPositionPageRespVo : users) {
            SfaVisitCompleteInfoEntity completeInfoEntity = new SfaVisitCompleteInfoEntity();
            completeInfoEntity.setVisitDate(visitDate);
            String visitUserName = mdmPositionPageRespVo.getUserName();
            String visitPositionCode = mdmPositionPageRespVo.getPositionCode();
            String visitPositionName = mdmPositionPageRespVo.getPositionName();
            if (StringUtils.isBlank((CharSequence)visitUserName)) continue;
            if (StringUtils.isBlank((CharSequence)visitPositionCode)) {
                visitPositionCode = visitUserName;
                visitPositionName = mdmPositionPageRespVo.getFullName();
            }
            completeInfoEntity.setVisitUserName(visitUserName);
            completeInfoEntity.setVisitRealName(mdmPositionPageRespVo.getFullName());
            completeInfoEntity.setVisitPosCode(visitPositionCode);
            completeInfoEntity.setVisitPosName(visitPositionName);
            completeInfoEntity.setVisitOrgName(mdmPositionPageRespVo.getOrgName());
            completeInfoEntity.setVisitOrgCode(mdmPositionPageRespVo.getOrgCode());
            completeInfoEntity.setVisitParentOrgName(mdmPositionPageRespVo.getParentOrgName());
            completeInfoEntity.setVisitParentOrgCode(mdmPositionPageRespVo.getParentOrgCode());
            entityList.add(completeInfoEntity);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(entityList)) {
            mqMessageBody.setMsgBody(JsonPropertyUtil.toJsonStringNotEmptyVal(entityList));
            mqMessageBody.setTag("VISIT_DAY_RATE_SETTLEMENT");
            this.rocketMQProducer.convertAndSend(mqMessageBody);
        }
    }

    @Override
    public Result<SfaVisitRouteRespVo> dailyCompleteInfo(String date, String posCode) {
        SfaVisitRealRouteRespVo sfaVisitRealRouteRespVo;
        MdmUserRespVo mdmUserRespVo;
        SfaVisitPlanRouteRespVo sfaVisitPlanRouteRespVo;
        MdmUserRespVo mdmUserRespVo2;
        AssertUtils.isNotEmpty((String)date, (String)"\u5165\u53c2date\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)posCode, (String)"\u5165\u53c2posCode\u4e3a\u7a7a");
        List<SfaVisitPlanInfoEntity> visitPlanInfoEntities = this.sfaVisitPlanInfoEntityRepositories.findByVisitPosCodeAndVisitDateAndVisitBigType(posCode, date, SfaVisitEnum.VisitBigType.VISIT.getVal(), Sort.by((String[])new String[]{"visitSort"}).ascending());
        List sfaVisitPlanRouteRespVos = CrmBeanUtil.copyList(visitPlanInfoEntities, SfaVisitPlanRouteRespVo.class);
        if (CollectionUtil.listNotEmpty((List)sfaVisitPlanRouteRespVos) && (mdmUserRespVo2 = (MdmUserRespVo)ApiResultUtil.objResult((Result)this.mdmUserFeign.query(new MdmUserReqVo().setUserName((sfaVisitPlanRouteRespVo = (SfaVisitPlanRouteRespVo)sfaVisitPlanRouteRespVos.get(0)).getVisitUserName())))) != null) {
            String visitUserPhone = mdmUserRespVo2.getUserPhone();
            sfaVisitPlanRouteRespVos.forEach(data -> data.setVisitUserPhone(visitUserPhone));
        }
        ArrayList<SfaVisitRealRouteRespVo> sfaVisitRealRouteRespVos = new ArrayList<SfaVisitRealRouteRespVo>();
        List<SfaVisitPlanInfoRedisData> visitRealInfoEntities = this.sfaVisitPlanInfoRedisDataRepositories.findByVisitPosCodeAndVisitDateAndVisitBigTypeAndVisitStatus(posCode, date, SfaVisitEnum.VisitBigType.VISIT.getVal(), SfaVisitEnum.visitStatus.V3.getVal());
        if (CollectionUtil.listNotEmpty(visitRealInfoEntities)) {
            visitRealInfoEntities.forEach(item -> {
                SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData = item.getSfaVisitPlanInfoExecuteRedisData();
                SfaVisitRealRouteRespVo routeRespVo = (SfaVisitRealRouteRespVo)CrmBeanUtil.copy((Object)((Object)sfaVisitPlanInfoExecuteRedisData), SfaVisitRealRouteRespVo.class);
                routeRespVo.setLatitude(sfaVisitPlanInfoExecuteRedisData.getOutStoreLatitude());
                routeRespVo.setLongitude(sfaVisitPlanInfoExecuteRedisData.getOutStoreLongitude());
                routeRespVo.setVisitDate(sfaVisitPlanInfoExecuteRedisData.getInStore());
                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                LocalDateTime inStore = LocalDateTime.parse(sfaVisitPlanInfoExecuteRedisData.getInStore(), df);
                LocalDateTime outStore = LocalDateTime.parse(sfaVisitPlanInfoExecuteRedisData.getOutStore(), df);
                long inStoreMilli = inStore.toInstant(ZoneOffset.ofHours(8)).toEpochMilli();
                long outStoreMilli = outStore.toInstant(ZoneOffset.ofHours(8)).toEpochMilli();
                LocalDateTime inStoreTimeOut = Instant.ofEpochMilli(outStoreMilli - inStoreMilli).atZone(ZoneOffset.ofHours(8)).toLocalDateTime();
                routeRespVo.setInStoreTime(inStoreTimeOut.format(CrmDateUtils.HHmmss));
                if (item.getLatitude() != null && item.getLongitude() != null && null != sfaVisitPlanInfoExecuteRedisData.getOutStoreLatitude() && null != sfaVisitPlanInfoExecuteRedisData.getOutStoreLongitude()) {
                    double latitude = item.getLatitude().doubleValue();
                    double longitude = item.getLongitude().doubleValue();
                    double outStoreLatitude = sfaVisitPlanInfoExecuteRedisData.getOutStoreLatitude().doubleValue();
                    double outStoreLongitude = sfaVisitPlanInfoExecuteRedisData.getOutStoreLongitude().doubleValue();
                    double distance = DistanceUtil.getDistance((double)latitude, (double)longitude, (double)outStoreLatitude, (double)outStoreLongitude);
                    routeRespVo.setDistanceToPlan(distance + "");
                }
                sfaVisitRealRouteRespVos.add(routeRespVo);
            });
        }
        if (CollectionUtil.listNotEmpty(sfaVisitRealRouteRespVos) && (mdmUserRespVo = (MdmUserRespVo)ApiResultUtil.objResult((Result)this.mdmUserFeign.query(new MdmUserReqVo().setUserName((sfaVisitRealRouteRespVo = (SfaVisitRealRouteRespVo)sfaVisitRealRouteRespVos.get(0)).getVisitUserName())))) != null) {
            String visitUserPhone = mdmUserRespVo.getUserPhone();
            sfaVisitRealRouteRespVos.forEach(data -> data.setVisitUserPhone(visitUserPhone));
        }
        if (CollectionUtil.listNotEmpty(sfaVisitRealRouteRespVos)) {
            sfaVisitRealRouteRespVos.sort(Comparator.comparing(SfaVisitRealRouteRespVo::getOutStore));
        }
        SfaVisitRouteRespVo sfaVisitRouteRespVo = new SfaVisitRouteRespVo();
        sfaVisitRouteRespVo.setPlanInfoList(sfaVisitPlanRouteRespVos);
        sfaVisitRouteRespVo.setRealInfoList(sfaVisitRealRouteRespVos);
        return Result.ok((Object)sfaVisitRouteRespVo);
    }

    @Override
    public void brushVisitCompleteInfo() {
        Map<String, List<SfaVisitPlanInfoEntity>> visitPlanInfoMap = ((LambdaQueryChainWrapper)this.sfaVisitPlanInfoService.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).list().stream().collect(Collectors.groupingBy(x -> x.getVisitPosCode() + ":" + x.getVisitUserName() + ":" + x.getVisitOrgCode()));
        visitPlanInfoMap.forEach((k, v) -> this.planInfoComplete((List<SfaVisitPlanInfoEntity>)v));
    }

    private List<SfaVisitCompleteInfoEntity> planInfoComplete(List<SfaVisitPlanInfoEntity> planInfoEntityList) {
        ArrayList<SfaVisitCompleteInfoEntity> visitCompleteInfoEntityList = new ArrayList<SfaVisitCompleteInfoEntity>();
        Map<String, List<SfaVisitPlanInfoEntity>> visitBigTypeMap = planInfoEntityList.stream().filter(x -> SfaVisitEnum.visitType.PLAN_VISIT.getVal().equals(x.getVisitType())).collect(Collectors.groupingBy(SfaVisitPlanInfoEntity::getVisitBigType));
        visitBigTypeMap.forEach((k, v) -> {
            Map<String, List<SfaVisitPlanInfoEntity>> visitDateMap = v.stream().collect(Collectors.groupingBy(SfaVisitPlanInfoEntity::getVisitDate));
            visitDateMap.entrySet().forEach(x -> {
                final SfaVisitPlanInfoEntity infoEntity = (SfaVisitPlanInfoEntity)((List)x.getValue()).get(0);
                SfaVisitCompleteInfoEntity completeInfoEntity = new SfaVisitCompleteInfoEntity(){
                    {
                        this.setVisitUserName(infoEntity.getVisitUserName());
                        this.setVisitRealName(infoEntity.getVisitRealName());
                        this.setVisitPosCode(infoEntity.getVisitPosCode());
                        this.setVisitPosName(infoEntity.getVisitPosName());
                        this.setVisitOrgCode(infoEntity.getVisitOrgCode());
                        this.setVisitOrgName(infoEntity.getVisitOrgName());
                        this.setVisitParentOrgCode(infoEntity.getParentOrgCode());
                        this.setVisitParentOrgName(infoEntity.getParentOrgName());
                        this.setVisitDate(infoEntity.getVisitDate());
                        this.setVisitYearMonth(infoEntity.getVisitDateOfYearMonth());
                    }
                };
                if (SfaVisitEnum.VisitBigType.VISIT.getVal().equals(k)) {
                    SfaVisitCompleteInfoServiceImpl.countingInfoForVisit(completeInfoEntity, (List)x.getValue());
                } else if (SfaVisitEnum.VisitBigType.HELP_VISIT.getVal().equals(k)) {
                    SfaVisitCompleteInfoServiceImpl.countingInfoForHelpVisit(completeInfoEntity, (List)x.getValue());
                }
                visitCompleteInfoEntityList.add(completeInfoEntity);
            });
        });
        if (CollectionUtil.listNotEmptyNotSizeZero(visitCompleteInfoEntityList)) {
            this.saveBatch(visitCompleteInfoEntityList);
        }
        return visitCompleteInfoEntityList;
    }

    public static void countingInfoForHelpVisit(SfaVisitCompleteInfoEntity completeInfoEntity, List<SfaVisitPlanInfoEntity> planInfos) {
        if (null == planInfos) {
            planInfos = Lists.newArrayList();
        }
        for (SfaVisitPlanInfoEntity planInfo : planInfos) {
            if (SfaVisitEnum.HelpVisitStatus.ALREADY_SUCCESS.getVal().equals(planInfo.getVisitStatus())) {
                completeInfoEntity.addRealCompleteHelpVisitNum();
                continue;
            }
            if (SfaVisitEnum.HelpVisitStatus.NO_COMMIT.getVal().equals(planInfo.getVisitStatus()) || SfaVisitEnum.HelpVisitStatus.ALREADY_OVERDUE.getVal().equals(planInfo.getVisitStatus())) {
                completeInfoEntity.addNotCompleteHelpVisitNum();
                continue;
            }
            if (!SfaVisitEnum.HelpVisitStatus.EX.getVal().equals(planInfo.getVisitStatus())) continue;
            completeInfoEntity.addErrorCompleteHelpVisitNum();
        }
        completeInfoEntity.setPlanCompleteHelpVisitNum(planInfos.size());
        String completeHelpVisitPercent = "0";
        if (!Integer.valueOf(0).equals(completeInfoEntity.getPlanCompleteHelpVisitNum())) {
            completeHelpVisitPercent = BigDecimal.valueOf(completeInfoEntity.getRealCompleteHelpVisitNum().intValue()).divide(BigDecimal.valueOf(completeInfoEntity.getPlanCompleteHelpVisitNum().intValue()), 2, 4).multiply(BigDecimal.valueOf(100L)).toString();
        }
        completeInfoEntity.setCompleteHelpVisitPercent(completeHelpVisitPercent);
    }

    public static void countingInfoForVisit(SfaVisitCompleteInfoEntity completeInfoEntity, List<SfaVisitPlanInfoEntity> planInfos) {
        if (null == planInfos) {
            planInfos = Lists.newArrayList();
        }
        for (SfaVisitPlanInfoEntity planInfo : planInfos) {
            if (SfaVisitEnum.visitStatus.V3.getVal().equals(planInfo.getVisitStatus())) {
                completeInfoEntity.addRealCompleteVisitNum();
                continue;
            }
            if (SfaVisitEnum.visitStatus.V5.getVal().equals(planInfo.getVisitStatus()) || SfaVisitEnum.visitStatus.V6.getVal().equals(planInfo.getVisitStatus())) {
                completeInfoEntity.addNotCompleteVisitNum();
                continue;
            }
            if (!SfaVisitEnum.visitStatus.V4.getVal().equals(planInfo.getVisitStatus())) continue;
            completeInfoEntity.addErrorCompleteVisitNum();
        }
        completeInfoEntity.setPlanCompleteVisitNum(planInfos.size());
        String completeVisitPercent = "0";
        if (!Integer.valueOf(0).equals(completeInfoEntity.getPlanCompleteVisitNum())) {
            completeVisitPercent = BigDecimal.valueOf(completeInfoEntity.getRealCompleteVisitNum().intValue()).divide(BigDecimal.valueOf(completeInfoEntity.getPlanCompleteVisitNum().intValue()), 2, 4).multiply(BigDecimal.valueOf(100L)).toString();
        }
        completeInfoEntity.setCompleteVisitPercent(completeVisitPercent);
    }
}

