/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitinfo.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.collection.controller.resp.VisitStepResp;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoExecuteRedisData;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoRedisData;
import com.biz.crm.visitinfo.resp.report.VisitInfoReportResp;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class SfaVisitPlanInfoReportHelper {
    public void buildVisitInfoReport(SfaVisitPlanInfoRedisData planInfoRedisData, VisitInfoReportResp reportVo) {
        reportVo.setVisitStatus(planInfoRedisData.getVisitStatus());
        reportVo.setVisitStatusName(planInfoRedisData.getVisitStatusName());
        CrmBeanUtil.copyPropertiesIgnoreEmpty((Object)planInfoRedisData, (Object)((Object)reportVo));
        Map visitDetailStepMap = (Map)JSONObject.parseObject((String)reportVo.getVisitDetailStepJson(), Map.class);
        reportVo.setVisitDetailStep(visitDetailStepMap);
        reportVo.setStep(this.buildSteps(planInfoRedisData, false));
    }

    private List<VisitStepResp> buildSteps(SfaVisitPlanInfoRedisData planInfoRedisData, boolean summary) {
        List<VisitStepResp> stepTemp = planInfoRedisData.getStep();
        SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData = planInfoRedisData.getSfaVisitPlanInfoExecuteRedisData();
        ArrayList steps = Lists.newArrayList();
        VisitStepResp inStep = this.buildInStore(sfaVisitPlanInfoExecuteRedisData);
        VisitStepResp outStep = this.buildOutStore(sfaVisitPlanInfoExecuteRedisData);
        if (null != inStep) {
            steps.add(inStep);
        }
        if (null != stepTemp) {
            for (VisitStepResp stepResp : stepTemp) {
                if (!summary && SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_SUMMARY.getVal().equals(stepResp.getStepCode())) continue;
                VisitStepResp temp = VisitStepResp.build(stepResp);
                if (SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_SUMMARY.getVal().equals(stepResp.getStepCode())) {
                    VisitStepResp.SummaryData summaryData = new VisitStepResp.SummaryData();
                    summaryData.setSfaVisitStepFrom(sfaVisitPlanInfoExecuteRedisData.getSfaVisitStepFromAsSummary());
                    summaryData.setVisitDetailStep(sfaVisitPlanInfoExecuteRedisData.getVisitDetailStep());
                    summaryData.setVisitSummary(sfaVisitPlanInfoExecuteRedisData.getVisitSummary());
                    temp.setData((Object)summaryData);
                }
                steps.add(temp);
            }
        }
        if (null != outStep) {
            steps.add(outStep);
        }
        return steps;
    }

    private VisitStepResp buildInStore(SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData) {
        if (YesNoEnum.yesNoEnum.YES.getValue().equals(sfaVisitPlanInfoExecuteRedisData.getNeedInStoreStep())) {
            VisitStepResp.InOutData inData = new VisitStepResp.InOutData();
            CrmBeanUtil.copyExt10((Object)((Object)sfaVisitPlanInfoExecuteRedisData), (Object)((Object)inData));
            SfaVisitStepFromRespVo sfaVisitStepFromAsInStore = sfaVisitPlanInfoExecuteRedisData.getSfaVisitStepFromAsInStore();
            inData.setSfaVisitStepFrom(sfaVisitStepFromAsInStore);
            inData.setStoreAddress(sfaVisitPlanInfoExecuteRedisData.getInStoreAddress());
            inData.setStoreDateTime(sfaVisitPlanInfoExecuteRedisData.getInStore());
            inData.setStoreLatitude(sfaVisitPlanInfoExecuteRedisData.getInStoreLatitude());
            inData.setStoreLongitude(sfaVisitPlanInfoExecuteRedisData.getInStoreLongitude());
            inData.setStorePics(sfaVisitPlanInfoExecuteRedisData.getVisitInPics());
            VisitStepResp inStep = VisitStepResp.build(SfaVisitEnum.visitStep.VISIT_STEP_IN_STORE.getDesc(), SfaVisitEnum.visitStep.VISIT_STEP_IN_STORE.getVal(), null, (Object)inData);
            inStep.setIsSuccess(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getVal());
            inStep.setIsSuccessDesc(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getDesc());
            if (null != sfaVisitStepFromAsInStore) {
                inStep.setIcon(sfaVisitStepFromAsInStore.getIcon());
            }
            return inStep;
        }
        return null;
    }

    private VisitStepResp buildOutStore(SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData) {
        if (YesNoEnum.yesNoEnum.YES.getValue().equals(sfaVisitPlanInfoExecuteRedisData.getNeedOutStoreStep())) {
            VisitStepResp.InOutData outData = new VisitStepResp.InOutData();
            CrmBeanUtil.copyExt10((Object)((Object)sfaVisitPlanInfoExecuteRedisData), (Object)((Object)outData));
            SfaVisitStepFromRespVo sfaVisitStepFromAsOutStore = sfaVisitPlanInfoExecuteRedisData.getSfaVisitStepFromAsOutStore();
            outData.setSfaVisitStepFrom(sfaVisitStepFromAsOutStore);
            outData.setStoreAddress(sfaVisitPlanInfoExecuteRedisData.getOutStoreAddress());
            outData.setStoreDateTime(sfaVisitPlanInfoExecuteRedisData.getOutStore());
            outData.setStoreLatitude(sfaVisitPlanInfoExecuteRedisData.getOutStoreLatitude());
            outData.setStoreLongitude(sfaVisitPlanInfoExecuteRedisData.getOutStoreLongitude());
            outData.setStorePics(sfaVisitPlanInfoExecuteRedisData.getVisitOutPics());
            VisitStepResp outStep = VisitStepResp.build(SfaVisitEnum.visitStep.VISIT_STEP_OUT_STORE.getDesc(), SfaVisitEnum.visitStep.VISIT_STEP_OUT_STORE.getVal(), null, (Object)outData);
            outStep.setIsSuccess(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getVal());
            outStep.setIsSuccessDesc(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getDesc());
            if (null != sfaVisitStepFromAsOutStore) {
                outStep.setIcon(sfaVisitStepFromAsOutStore.getIcon());
            }
            return outStep;
        }
        return null;
    }

    public void buildVisitInfoReport(SfaVisitPlanInfoRedisData planInfoRedisData, VisitInfoReportResp reportVo, boolean summary) {
        reportVo.setVisitStatus(planInfoRedisData.getVisitStatus());
        reportVo.setVisitStatusName(planInfoRedisData.getVisitStatusName());
        CrmBeanUtil.copyPropertiesIgnoreEmpty((Object)planInfoRedisData, (Object)((Object)reportVo));
        Map visitDetailStepMap = (Map)JSONObject.parseObject((String)reportVo.getVisitDetailStepJson(), Map.class);
        reportVo.setVisitDetailStep(visitDetailStepMap);
        reportVo.setStep(this.buildSteps(planInfoRedisData, summary));
    }
}

