/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksign.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.nebular.sfa.worksign.req.SfaApplyAttachmentReqVo;
import com.biz.crm.util.StringUtils;
import com.biz.crm.worksign.mapper.SfaLeaveAttachmentMapper;
import com.biz.crm.worksign.model.SfaSignApplyAttachmentEntity;
import com.biz.crm.worksign.service.ISfaSignApplyAttachmentService;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"sfaSignApplyAttachmentServiceExpandImpl"})
public class SfaSignApplyAttachmentServiceImpl
extends ServiceImpl<SfaLeaveAttachmentMapper, SfaSignApplyAttachmentEntity>
implements ISfaSignApplyAttachmentService {
    private static final Logger log = LoggerFactory.getLogger(SfaSignApplyAttachmentServiceImpl.class);
    @Resource
    private SfaLeaveAttachmentMapper mapper;

    @Override
    public SfaSignApplyAttachmentEntity getEntity(String applyType, String sourceId) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaSignApplyAttachmentEntity::getApplyType, (Object)applyType)).eq(SfaSignApplyAttachmentEntity::getSourceId, (Object)sourceId);
        return (SfaSignApplyAttachmentEntity)((Object)this.mapper.selectOne((Wrapper)wrapper));
    }

    @Override
    public void save(String applyType, String sourceId, List<SfaApplyAttachmentReqVo> attachmentList) {
        List list;
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaSignApplyAttachmentEntity::getApplyType, (Object)applyType)).eq(SfaSignApplyAttachmentEntity::getSourceId, (Object)sourceId);
        this.mapper.delete((Wrapper)wrapper);
        if (attachmentList != null && (list = attachmentList.stream().filter(vo -> StringUtils.isNotEmpty((String)vo.getPicUrl()) || StringUtils.isNotEmpty((String)vo.getPicPath()) || StringUtils.isNotEmpty((String)vo.getPicDesc())).collect(Collectors.toList())) != null && list.size() > 0) {
            SfaSignApplyAttachmentEntity entity = new SfaSignApplyAttachmentEntity();
            entity.setApplyType(applyType);
            entity.setSourceId(sourceId);
            entity.setAttachmentListJson(JSON.toJSONString(list));
            this.save((Object)entity);
        }
    }
}

