/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitinfo.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoRespVo;
import com.biz.crm.util.PageUtil;
import com.biz.crm.visitinfo.mapper.SfaVisitPlanInfoMapper;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.repositories.SfaVisitPlanInfoEntityRepositories;
import com.biz.crm.visitinfo.req.GetVisitReportsPageReq;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SfaVisitPlanInfoServiceEsImpl {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitPlanInfoServiceEsImpl.class);
    @Resource
    private SfaVisitPlanInfoEntityRepositories sfaVisitPlanInfoEntityRepositories;
    @Resource
    private SfaVisitPlanInfoMapper sfaVisitPlanInfoMapper;
    @Value(value="${sfa.remote.schema.mdm}")
    private String mdm;

    public List<SfaVisitPlanInfoEntity> findByVisitPosCodeAndVisitDateAndVisitBigType(String visitPosCode, String visitDate, String visitBigType, Sort sort) {
        if (StringUtils.isBlank((CharSequence)visitBigType)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u62dc\u8bbf\u5927\u7c7b");
        }
        if (StringUtils.isBlank((CharSequence)visitPosCode)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u7528\u6237\u804c\u4f4d\u7f16\u7801");
        }
        if (StringUtils.isBlank((CharSequence)visitDate)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u65e5\u671f");
        }
        if (null == sort) {
            sort = Sort.by((String[])new String[]{"visitSort"}).ascending();
        }
        List<SfaVisitPlanInfoEntity> list = this.sfaVisitPlanInfoEntityRepositories.findByVisitPosCodeAndVisitDateAndVisitBigType(visitPosCode, visitDate, visitBigType, sort);
        return Lists.newArrayList(list);
    }

    public PageResult<SfaVisitPlanInfoRespVo> getVisitPlanInfoReportPage(GetVisitReportsPageReq req) {
        Page page = PageUtil.buildPage((Integer)req.getPageNum(), (Integer)req.getPageSize());
        List<SfaVisitPlanInfoRespVo> list = this.sfaVisitPlanInfoMapper.findVisitPlanInfoReport((Page<SfaVisitPlanInfoRespVo>)page, req, this.mdm);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    protected List<QueryBuilder> getVisitPlanInfoReportPageQueryBuilderExtend(GetVisitReportsPageReq req) {
        return null;
    }

    public void saveAll(Collection<SfaVisitPlanInfoEntity> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        this.sfaVisitPlanInfoEntityRepositories.saveAll(entities);
        this.sfaVisitPlanInfoEntityRepositories.refresh();
    }

    public void save(SfaVisitPlanInfoEntity entity) {
        if (null == entity) {
            return;
        }
        this.sfaVisitPlanInfoEntityRepositories.save(entity);
    }

    public List<SfaVisitPlanInfoEntity> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        builder.must((QueryBuilder)QueryBuilders.termsQuery((String)"id", (String[])ids.toArray(new String[ids.size()])));
        Iterable list = this.sfaVisitPlanInfoEntityRepositories.search((QueryBuilder)builder);
        return Lists.newArrayList((Iterable)list);
    }

    public SfaVisitPlanInfoEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u62dc\u8bbf\u8ba1\u5212ID");
        }
        Optional optional = this.sfaVisitPlanInfoEntityRepositories.findById(id);
        if (optional.isPresent()) {
            return (SfaVisitPlanInfoEntity)optional.get();
        }
        return null;
    }

    public void deleteByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.sfaVisitPlanInfoEntityRepositories.deleteByIdIn(ids);
        this.sfaVisitPlanInfoEntityRepositories.refresh();
    }

    public List<SfaVisitPlanInfoEntity> findByVisitPlanCode(String visitPlanCode) {
        if (StringUtils.isBlank((CharSequence)visitPlanCode)) {
            return Lists.newArrayList();
        }
        return this.sfaVisitPlanInfoEntityRepositories.findByVisitPlanCode(visitPlanCode);
    }

    public List<SfaVisitPlanInfoEntity> findByVisitPosCodeAndVisitDateAndVisitBigType(String visitPosCode, String visitDate, String visitBigType) {
        if (StringUtils.isBlank((CharSequence)visitPosCode) || StringUtils.isBlank((CharSequence)visitDate) || StringUtils.isBlank((CharSequence)visitBigType)) {
            return Lists.newArrayList();
        }
        return this.sfaVisitPlanInfoEntityRepositories.findByVisitPosCodeAndVisitDateAndVisitBigType(visitPosCode, visitDate, visitBigType);
    }

    public void delete(List<SfaVisitPlanInfoEntity> planInfos) {
        if (CollectionUtils.isEmpty(planInfos)) {
            return;
        }
        this.sfaVisitPlanInfoEntityRepositories.deleteAll(planInfos);
        this.sfaVisitPlanInfoEntityRepositories.refresh();
    }
}

