/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksignrule.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.worksign.model.SfaWorkSignRecordEntity;
import com.biz.crm.worksign.model.SfaWorkSignRuleInfoEntity;
import com.biz.crm.worksign.service.ISfaWorkSignRecordService;
import com.biz.crm.worksign.service.ISfaWorkSignRuleInfoService;
import com.biz.crm.worksignrule.service.impl.ExecuteSignRuleContext;
import java.time.LocalDate;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@ConditionalOnMissingBean(name={"signRuleResolveHelperExtend"})
public class SignRuleResolveHelper {
    private static final Logger log = LoggerFactory.getLogger(SignRuleResolveHelper.class);
    @Resource
    protected ISfaWorkSignRuleInfoService iSfaWorkSignRuleInfoService;
    @Resource
    protected ISfaWorkSignRecordService iSfaWorkSignRecordService;

    @Transactional
    public void saveSignRuleInfo(String baseExecuteDate, ExecuteSignRuleContext context) {
        this.delInfoAndRecord(context, baseExecuteDate);
        try {
            this.iSfaWorkSignRuleInfoService.saveBatchPartition(context.getRuleInfoEntities());
            this.iSfaWorkSignRecordService.saveBatchPartition(context.getRecordEntities());
        }
        catch (DuplicateKeyException e) {
            String msg = "\u4fdd\u5b58\u8003\u52e4\u6570\u636e\u5931\u8d25[" + e.getCause().getMessage() + "]";
            log.error(msg, (Throwable)e);
            throw new BusinessException(msg, (Throwable)e);
        }
    }

    protected void delInfoAndRecord(ExecuteSignRuleContext context, String ruleDate) {
        this.doDelInfoAndRecord(ruleDate);
        this.removeNotDel(context, ruleDate);
    }

    protected void doDelInfoAndRecord(String ruleDate) {
        LambdaQueryWrapper lambdaQueryWrapperOfInfo = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaWorkSignRuleInfoEntity.class).ge(SfaWorkSignRuleInfoEntity::getRuleDate, (Object)ruleDate)).ge(SfaWorkSignRuleInfoEntity::getRuleDate, (Object)LocalDate.now().format(CrmDateUtils.yyyyMMdd));
        LambdaQueryWrapper lambdaQueryWrapperOfRecord = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaWorkSignRecordEntity.class).ge(SfaWorkSignRecordEntity::getRuleDate, (Object)ruleDate)).ge(SfaWorkSignRecordEntity::getRuleDate, (Object)LocalDate.now().format(CrmDateUtils.yyyyMMdd));
        lambdaQueryWrapperOfInfo.eq(SfaWorkSignRuleInfoEntity::getUsedStatus, (Object)YesNoEnum.yesNoEnum.NO.getValue());
        this.iSfaWorkSignRuleInfoService.remove((Wrapper)lambdaQueryWrapperOfInfo);
        lambdaQueryWrapperOfRecord.eq(SfaWorkSignRecordEntity::getUsedStatus, (Object)YesNoEnum.yesNoEnum.NO.getValue());
        this.iSfaWorkSignRecordService.remove((Wrapper)lambdaQueryWrapperOfRecord);
    }

    protected void removeNotDel(ExecuteSignRuleContext context, String ruleDate) {
        LambdaQueryWrapper lambdaQueryWrapperOfInfo = (LambdaQueryWrapper)Wrappers.lambdaQuery(SfaWorkSignRuleInfoEntity.class).ge(SfaWorkSignRuleInfoEntity::getRuleDate, (Object)ruleDate);
        lambdaQueryWrapperOfInfo.eq(SfaWorkSignRuleInfoEntity::getUsedStatus, (Object)YesNoEnum.yesNoEnum.YES.getValue());
        lambdaQueryWrapperOfInfo.select(new SFunction[]{SfaWorkSignRuleInfoEntity::getUserName, SfaWorkSignRuleInfoEntity::getRuleDate});
        Set usersOfNotDel = this.iSfaWorkSignRuleInfoService.list((Wrapper)lambdaQueryWrapperOfInfo).stream().map(v -> v.getUserName() + "_" + v.getRuleDate()).collect(Collectors.toSet());
        List<SfaWorkSignRuleInfoEntity> infoEntities = context.getRuleInfoEntities().stream().filter(v -> !usersOfNotDel.contains(v.getUserName() + "_" + v.getRuleDate())).collect(Collectors.toList());
        context.setRuleInfoEntities(infoEntities);
        List<SfaWorkSignRecordEntity> recordEntities = context.getRecordEntities().stream().filter(v -> !usersOfNotDel.contains(v.getWsUserName() + "_" + v.getRuleDate())).collect(Collectors.toList());
        context.setRecordEntities(recordEntities);
    }
}

