/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.collection.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.collection.mapper.SfaInputConfigMapper;
import com.biz.crm.collection.model.SfaInputConfigEntity;
import com.biz.crm.collection.service.ISfaInputConfigService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.collection.req.SfaInputConfigReqVo;
import com.biz.crm.nebular.sfa.collection.resp.SfaInputConfigRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaInputConfigServiceExpandImpl"})
public class SfaInputConfigServiceImpl
extends ServiceImpl<SfaInputConfigMapper, SfaInputConfigEntity>
implements ISfaInputConfigService {
    private static final Logger log = LoggerFactory.getLogger(SfaInputConfigServiceImpl.class);
    @Resource
    private SfaInputConfigMapper sfaInputConfigMapper;

    @Override
    @CrmLog
    public PageResult<SfaInputConfigRespVo> findList(SfaInputConfigReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaInputConfigRespVo> list = this.sfaInputConfigMapper.findList((Page<SfaInputConfigRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @CrmLog
    public SfaInputConfigRespVo query(SfaInputConfigReqVo reqVo) {
        if (null == reqVo || StringUtils.isEmpty((String)reqVo.getId()) && CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getIds()) && StringUtils.isEmpty((String)reqVo.getLableCode())) {
            return new SfaInputConfigRespVo();
        }
        List list = this.findList(reqVo).getData();
        if (CollectionUtil.listEmpty((List)list)) {
            return new SfaInputConfigRespVo();
        }
        return (SfaInputConfigRespVo)list.get(0);
    }

    public void saveCheck(SfaInputConfigReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getLableName(), (String)"\u8bf7\u8f93\u5165\u63a7\u4ef6\u540d\u79f0");
        AssertUtils.isNotEmpty((String)reqVo.getInputType(), (String)"\u8bf7\u9009\u62e9\u63a7\u4ef6\u7c7b\u578b");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void save(SfaInputConfigReqVo reqVo) {
        this.saveCheck(reqVo);
        SfaInputConfigEntity entity = (SfaInputConfigEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaInputConfigEntity.class));
        String code = CodeUtil.createCode();
        entity.setLableCode(code);
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void update(SfaInputConfigReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getId())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SfaInputConfigEntity entity = (SfaInputConfigEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        if (Objects.isNull((Object)entity)) {
            throw new BusinessException("\u62dc\u8bbf\u63a7\u4ef6\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.saveCheck(reqVo);
        CrmBeanUtil.copyPropertiesIgnoreEmpty((Object)reqVo, (Object)((Object)entity));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void deleteBatch(SfaInputConfigReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List list = this.findList(reqVo).getData();
        if (CollectionUtil.listEmpty((List)list)) {
            throw new BusinessException("\u516c\u544a\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.sfaInputConfigMapper.deleteProductsByParams(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void enableBatch(SfaInputConfigReqVo reqVo) {
        List sfaInputConfigEntities;
        if (StringUtils.isEmpty((String)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotEmpty((String)reqVo.getId())) {
            List<String> ids = new ArrayList<String>();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getIds())) {
                ids = reqVo.getIds();
            }
            ids.add(reqVo.getId());
            reqVo.setIds(ids);
        }
        if (CollectionUtils.isNotEmpty((Collection)(sfaInputConfigEntities = this.sfaInputConfigMapper.selectBatchIds(reqVo.getIds())))) {
            sfaInputConfigEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaInputConfigEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void disableBatch(SfaInputConfigReqVo reqVo) {
        List sfaInputConfigEntities;
        if (StringUtils.isEmpty((String)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotEmpty((String)reqVo.getId())) {
            List<String> ids = new ArrayList<String>();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getIds())) {
                ids = reqVo.getIds();
            }
            ids.add(reqVo.getId());
            reqVo.setIds(ids);
        }
        if (CollectionUtils.isNotEmpty((Collection)(sfaInputConfigEntities = this.sfaInputConfigMapper.selectBatchIds(reqVo.getIds())))) {
            sfaInputConfigEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaInputConfigEntities);
    }
}

