/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.notice.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.notice.req.SfaNoticeReadReqVo;
import com.biz.crm.nebular.sfa.notice.resp.SfaNoticeReadRespVo;
import com.biz.crm.notice.mapper.SfaNoticeReadMapper;
import com.biz.crm.notice.model.SfaNoticeReadEntity;
import com.biz.crm.notice.service.ISfaNoticeReadService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaNoticeReadServiceExpandImpl"})
@Transactional
public class SfaNoticeReadServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaNoticeReadMapper, SfaNoticeReadEntity>
implements ISfaNoticeReadService {
    private static final Logger log = LoggerFactory.getLogger(SfaNoticeReadServiceImpl.class);
    @Resource
    private SfaNoticeReadMapper sfaNoticeReadMapper;

    @Override
    @CrmLog
    public PageResult<SfaNoticeReadRespVo> findList(SfaNoticeReadReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaNoticeReadRespVo> list = this.sfaNoticeReadMapper.findList((Page<SfaNoticeReadRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @CrmLog
    public SfaNoticeReadRespVo query(SfaNoticeReadReqVo reqVo) {
        return null;
    }

    @Override
    public void save(String noticeCode) {
        AssertUtils.isNotEmpty((String)noticeCode, (String)"\u516c\u544a\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        UserRedis user = UserUtils.getUser();
        String createCode = user.getUsername();
        String createPosCode = user.getPoscode();
        String createOrgCode = user.getOrgcode();
        SfaNoticeReadReqVo req = new SfaNoticeReadReqVo();
        req.setCreateCode(createCode);
        req.setCreatePosCode(createPosCode);
        req.setCreateOrgCode(createOrgCode);
        req.setNoticeCode(noticeCode);
        Integer count = this.sfaNoticeReadMapper.findReadSignCount(req);
        if (count == 0) {
            SfaNoticeReadEntity entity = new SfaNoticeReadEntity();
            entity.setPosCode(createPosCode);
            entity.setUserName(createCode);
            entity.setNoticeCode(noticeCode);
            this.save((Object)entity);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void update(SfaNoticeReadReqVo reqVo) {
        SfaNoticeReadEntity entity = (SfaNoticeReadEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @CrmLog
    public void deleteBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List sfaNoticeReadEntities = this.sfaNoticeReadMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaNoticeReadEntities)) {
            sfaNoticeReadEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaNoticeReadEntities);
    }

    @Override
    @CrmLog
    public void enableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List sfaNoticeReadEntities = this.sfaNoticeReadMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaNoticeReadEntities)) {
            sfaNoticeReadEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaNoticeReadEntities);
    }

    @Override
    @CrmLog
    public void disableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List sfaNoticeReadEntities = this.sfaNoticeReadMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaNoticeReadEntities)) {
            sfaNoticeReadEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaNoticeReadEntities);
    }
}

