/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitinfo.component;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.req.GetVisitListReq;
import com.biz.crm.mq.AbstractRocketMQConsumer;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.visitinfo.model.SfaVisitCompleteInfoEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.service.ISfaVisitCompleteInfoService;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@RocketMQMessageListener(topic="${rocketmq.topic}${rocketmq.environment-variable}", selectorExpression="VISIT_DAY_RATE_SETTLEMENT", consumerGroup="VISIT_DAY_RATE_SETTLEMENT${rocketmq.environment-variable}", consumeMode=ConsumeMode.CONCURRENTLY)
public class VisitDayRateSettlementConsumer
extends AbstractRocketMQConsumer {
    private static final Logger log = LoggerFactory.getLogger(VisitDayRateSettlementConsumer.class);
    @Resource
    protected ISfaVisitCompleteInfoService sfaVisitCompleteInfoService;
    @Resource
    protected ISfaVisitPlanInfoService sfaVisitPlanInfoService;

    protected Object handleMessage(RocketMQMessageBody message) {
        String msgBody = message.getMsgBody();
        List completeInfoEntityList = JsonPropertyUtil.toArray((String)msgBody, SfaVisitCompleteInfoEntity.class);
        completeInfoEntityList.forEach(x -> this.planInfoSettlement((SfaVisitCompleteInfoEntity)((Object)x)));
        return "\u7ed3\u7b97\u5b8c\u6210";
    }

    protected void planInfoSettlement(SfaVisitCompleteInfoEntity completeInfoEntity) {
        GetVisitListReq req = new GetVisitListReq();
        req.setVisitDate(completeInfoEntity.getVisitDate());
        req.setVisitUserName(completeInfoEntity.getVisitUserName());
        if (StringUtils.isBlank((CharSequence)completeInfoEntity.getVisitPosCode())) {
            completeInfoEntity.setVisitPosCode(completeInfoEntity.getVisitUserName());
            completeInfoEntity.setVisitPosName(completeInfoEntity.getVisitRealName());
        }
        req.setVisitPositionCode(completeInfoEntity.getVisitPosCode());
        req.setVisitBigType(SfaVisitEnum.VisitBigType.VISIT.getVal());
        List<SfaVisitPlanInfoEntity> planInfoOfVisit = this.sfaVisitPlanInfoService.doGetVisitInfoList(req).stream().filter(v -> SfaVisitEnum.visitType.PLAN_VISIT.getVal().equals(v.getVisitType())).collect(Collectors.toList());
        req.setVisitBigType(SfaVisitEnum.VisitBigType.HELP_VISIT.getVal());
        List<SfaVisitPlanInfoEntity> planInfoOfHelpVisit = this.sfaVisitPlanInfoService.doGetVisitInfoList(req).stream().filter(v -> SfaVisitEnum.visitType.PLAN_VISIT.getVal().equals(v.getVisitType())).collect(Collectors.toList());
        req.setVisitBigType(SfaVisitEnum.VisitBigType.UNFAMILIAR_VISIT.getVal());
        List<SfaVisitPlanInfoEntity> planInfoOfMoVisit = this.sfaVisitPlanInfoService.doGetVisitInfoList(req).stream().filter(v -> SfaVisitEnum.visitType.TEMP_VISIT.getVal().equals(v.getVisitType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(planInfoOfVisit) && CollectionUtils.isEmpty(planInfoOfHelpVisit) && CollectionUtils.isEmpty(planInfoOfMoVisit)) {
            return;
        }
        SfaVisitCompleteInfoEntity updateEntity = (SfaVisitCompleteInfoEntity)((Object)this.sfaVisitCompleteInfoService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaVisitCompleteInfoEntity.class).eq(SfaVisitCompleteInfoEntity::getVisitDate, (Object)req.getVisitDate())).eq(SfaVisitCompleteInfoEntity::getVisitPosCode, (Object)req.getVisitPositionCode())));
        if (null == updateEntity) {
            updateEntity = new SfaVisitCompleteInfoEntity();
        }
        SfaVisitCompleteInfoEntity.countingInfoForVisit(updateEntity, planInfoOfVisit);
        SfaVisitCompleteInfoEntity.countingInfoForHelpVisit(updateEntity, planInfoOfHelpVisit);
        SfaVisitCompleteInfoEntity.countingInfoForMoVisit(updateEntity, planInfoOfMoVisit);
        this.buildCompleteInfoEntity(updateEntity, completeInfoEntity);
        this.sfaVisitCompleteInfoService.saveOrUpdate((Object)updateEntity);
    }

    protected void buildCompleteInfoEntity(SfaVisitCompleteInfoEntity updateEntity, SfaVisitCompleteInfoEntity completeInfoEntity) {
        MdmOrgRespVo orgRespVo;
        updateEntity.setVisitUserName(completeInfoEntity.getVisitUserName());
        updateEntity.setVisitRealName(completeInfoEntity.getVisitRealName());
        updateEntity.setVisitPosCode(completeInfoEntity.getVisitPosCode());
        updateEntity.setVisitPosName(completeInfoEntity.getVisitPosName());
        updateEntity.setVisitOrgCode(completeInfoEntity.getVisitOrgCode());
        updateEntity.setVisitOrgName(completeInfoEntity.getVisitOrgName());
        if (StringUtils.isNotBlank((CharSequence)completeInfoEntity.getVisitOrgCode()) && null != (orgRespVo = OrgUtil.getOrgByCode((String)completeInfoEntity.getVisitOrgCode()))) {
            updateEntity.setVisitParentOrgCode(orgRespVo.getParentCode());
            updateEntity.setVisitParentOrgName(orgRespVo.getParentName());
        }
        updateEntity.setVisitDate(completeInfoEntity.getVisitDate());
        updateEntity.setVisitYearMonth(updateEntity.getVisitDate().substring(0, 7));
    }
}

