/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepActivityReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepActivityRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.visitstep.mapper.SfaVisitStepActivityMapper;
import com.biz.crm.visitstep.model.SfaVisitStepActivityEntity;
import com.biz.crm.visitstep.service.ISfaVisitStepActivityService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"sfaVisitStepActivityServiceExpandImpl"})
public class SfaVisitStepActivityServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaVisitStepActivityMapper, SfaVisitStepActivityEntity>
implements ISfaVisitStepActivityService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitStepActivityServiceImpl.class);
    @Resource
    private SfaVisitStepActivityMapper sfaVisitStepActivityMapper;

    @Override
    public PageResult<SfaVisitStepActivityRespVo> findList(SfaVisitStepActivityReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitStepActivityRespVo> list = this.sfaVisitStepActivityMapper.findList((Page<SfaVisitStepActivityRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<SfaVisitStepActivityRespVo> getListByVisitCode(String visitCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"enable_status", (Object)CrmEnableStatusEnum.ENABLE.getCode());
        queryWrapper.ne((Object)"del_flag", (Object)CrmDelFlagEnum.DELETE.getCode());
        List sfaVisitStepActivityEntities = this.list((Wrapper)queryWrapper);
        return CrmBeanUtil.copyList((List)sfaVisitStepActivityEntities, SfaVisitStepActivityRespVo.class);
    }

    @Override
    public SfaVisitStepActivityRespVo query(SfaVisitStepActivityReqVo reqVo) {
        SfaVisitStepActivityEntity sfaVisitStepActivityEntity = (SfaVisitStepActivityEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        return (SfaVisitStepActivityRespVo)CrmBeanUtil.copy((Object)((Object)sfaVisitStepActivityEntity), SfaVisitStepActivityRespVo.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaVisitStepActivityReqVo reqVo) {
        SfaVisitStepActivityEntity entity = (SfaVisitStepActivityEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitStepActivityEntity.class));
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaVisitStepActivityReqVo reqVo) {
        SfaVisitStepActivityEntity entity = (SfaVisitStepActivityEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        entity = (SfaVisitStepActivityEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitStepActivityEntity.class));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaVisitStepActivityReqVo reqVo) {
        List sfaVisitStepActivityEntities = this.sfaVisitStepActivityMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepActivityEntities)) {
            sfaVisitStepActivityEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaVisitStepActivityEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaVisitStepActivityReqVo reqVo) {
        List sfaVisitStepActivityEntities = this.sfaVisitStepActivityMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepActivityEntities)) {
            sfaVisitStepActivityEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaVisitStepActivityEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaVisitStepActivityReqVo reqVo) {
        List sfaVisitStepActivityEntities = this.sfaVisitStepActivityMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepActivityEntities)) {
            sfaVisitStepActivityEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaVisitStepActivityEntities);
    }
}

