/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitinfo.service.impl;

import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.moblie.controller.visit.req.GetVisitListReq;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.mdm.position.req.MdmPositionPageReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionPageRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitGroupRespVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitPlanRespVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.JobHelper;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.PageDataAdviser;
import com.biz.crm.util.PositionUtil;
import com.biz.crm.util.Result;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoRedisData;
import com.biz.crm.visitinfo.req.PlanInfoSettlementReq;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.biz.crm.visitinfo.service.impl.SfaVisitPlanInfoServiceEsImpl;
import com.biz.crm.visitnote.model.SfaVisitPlanEntity;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class VisitPlanInfoHelper
implements JobHelper.JobExecutor {
    private static final Logger log = LoggerFactory.getLogger(VisitPlanInfoHelper.class);
    @Resource
    private ISfaVisitPlanInfoService sfaVisitPlanInfoService;
    @Resource
    private RedisService redisService;
    @Resource
    private SfaVisitPlanInfoServiceEsImpl sfaVisitPlanInfoServiceEsImpl;
    @Resource
    private MdmPositionFeign mdmPositionFeign;
    @Resource
    private JobHelper jobHelper;
    @Resource
    private RocketMQProducer rocketMQProducer;

    public void executeJob(Object jobParam) {
        this.doPlanInfoSettlementJob((String)jobParam);
    }

    public void planInfoSettlementJob(String visitDateTemp) {
        if (StringUtils.isBlank((CharSequence)visitDateTemp)) {
            visitDateTemp = LocalDate.now().plusDays(-1L).format(CrmDateUtils.yyyyMMdd);
        }
        String visitDate = visitDateTemp;
        JobHelper.JobContext context = new JobHelper.JobContext();
        context.setJob(JobHelper.Job.PLAN_INFO_SETTLEMENT_JOB);
        context.setExecutorBeanClass(VisitPlanInfoHelper.class);
        context.setJobParam((Object)visitDate);
        this.jobHelper.executeJobSaveContext(context);
    }

    private void doPlanInfoSettlementJob(String visitDate) {
        PageDataAdviser pageDataAdviser = new PageDataAdviser(this.jobHelper.getJobBizDataPageSize());
        long total = this.jobHelper.getJobBizDataPageSize();
        while (pageDataAdviser.hasNext(Long.valueOf(total))) {
            MdmPositionPageReqVo reqVo = new MdmPositionPageReqVo();
            reqVo.setPageNum(pageDataAdviser.nextPage());
            reqVo.setPageSize(pageDataAdviser.getPageSize());
            PageResult pageResult = (PageResult)ApiResultUtil.objResult((Result)this.mdmPositionFeign.positionAndUserPage(reqVo), (boolean)true);
            List users = pageResult.getData();
            this.sendMq(users, visitDate);
            total = pageResult.getCount();
        }
    }

    private void sendMq(List<MdmPositionPageRespVo> users, String visitDate) {
        RocketMQMessageBody mqMessageBody = new RocketMQMessageBody();
        for (MdmPositionPageRespVo mdmPositionPageRespVo : users) {
            PlanInfoSettlementReq settlementReq = new PlanInfoSettlementReq();
            settlementReq.setVisitDate(visitDate);
            String visitUserName = mdmPositionPageRespVo.getUserName();
            String visitPositionCode = mdmPositionPageRespVo.getPositionCode();
            if (StringUtils.isBlank((CharSequence)visitPositionCode) || StringUtils.isBlank((CharSequence)visitUserName)) continue;
            settlementReq.setVisitPositionCode(visitPositionCode);
            settlementReq.setVisitUserName(visitUserName);
            mqMessageBody.setMsgBody(JsonPropertyUtil.toJsonStringNotEmptyVal((Object)settlementReq));
            mqMessageBody.setTag("VISIT_PLAN_INFO_SETTLEMENT");
            this.rocketMQProducer.convertAndSend(mqMessageBody);
        }
    }

    public void planInfoSettlementForWeb(PlanInfoSettlementReq req) {
        this.planInfoSettlement(req);
    }

    public void planInfoSettlementForJob(PlanInfoSettlementReq req) {
        this.planInfoSettlement(req);
    }

    public void planInfoSettlement(PlanInfoSettlementReq req) {
        List<SfaVisitPlanInfoEntity> planInfoEntities = this.loadUserVisitPlan(req);
        for (SfaVisitPlanInfoEntity planInfoEntity : planInfoEntities) {
            SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData = null;
            if (this.hasRedisData(planInfoEntity)) {
                sfaVisitPlanInfoRedisData = (SfaVisitPlanInfoRedisData)this.redisService.hmget(SfaVisitPlanInfoRedisData.getInstance().redisHash(planInfoEntity.getVisitDate(), planInfoEntity.getVisitUserName(), planInfoEntity.getVisitPosCode(), planInfoEntity.getVisitBigType()).toString(), (Object)planInfoEntity.getRedisHashKey());
            }
            this.sfaVisitPlanInfoService.dataDurability(planInfoEntity, sfaVisitPlanInfoRedisData);
            this.redisService.hmset(planInfoEntity.redisHash(planInfoEntity.getVisitDate(), planInfoEntity.getVisitUserName(), planInfoEntity.getVisitPosCode(), planInfoEntity.getVisitBigType()).toString(), planInfoEntity.buildRedisDataForWrite(), 1296000L);
            if (null == sfaVisitPlanInfoRedisData) continue;
            this.redisService.hmset(sfaVisitPlanInfoRedisData.redisHash(planInfoEntity.getVisitDate(), planInfoEntity.getVisitUserName(), planInfoEntity.getVisitPosCode(), planInfoEntity.getVisitBigType()).toString(), sfaVisitPlanInfoRedisData.buildRedisDataForWrite(), 1296000L);
        }
    }

    private boolean hasRedisData(SfaVisitPlanInfoEntity planInfoEntity) {
        return SfaVisitEnum.VisitBigType.HELP_VISIT.getVal().equals(planInfoEntity.getVisitBigType()) ? SfaVisitEnum.HelpVisitStatus.NO_COMMIT.getVal().equals(planInfoEntity.getVisitStatus()) : SfaVisitEnum.visitStatus.V5.getVal().equals(planInfoEntity.getVisitStatus());
    }

    private List<SfaVisitPlanInfoEntity> loadUserVisitPlan(PlanInfoSettlementReq settlementReq) {
        GetVisitListReq req = (GetVisitListReq)CrmBeanUtil.copy((Object)settlementReq, GetVisitListReq.class);
        req.setVisitBigType(SfaVisitEnum.VisitBigType.VISIT.getVal());
        List<SfaVisitPlanInfoEntity> planInfoTemps = this.sfaVisitPlanInfoService.doGetVisitInfoList(req);
        req.setVisitBigType(SfaVisitEnum.VisitBigType.HELP_VISIT.getVal());
        planInfoTemps.addAll(this.sfaVisitPlanInfoService.doGetVisitInfoList(req));
        req.setVisitBigType(SfaVisitEnum.VisitBigType.UNFAMILIAR_VISIT.getVal());
        planInfoTemps.addAll(this.sfaVisitPlanInfoService.doGetVisitInfoList(req));
        List<SfaVisitPlanInfoEntity> planInfoEntities = planInfoTemps.stream().filter(v -> {
            if (SfaVisitEnum.VisitBigType.HELP_VISIT.getVal().equals(v.getVisitBigType())) {
                if (SfaVisitEnum.HelpVisitStatus.READY_HELP_DEFENSE.getVal().equals(v.getVisitStatus())) {
                    v.setVisitStatus(SfaVisitEnum.HelpVisitStatus.ALREADY_OVERDUE.getVal());
                    v.setVisitStatusName(SfaVisitEnum.HelpVisitStatus.ALREADY_OVERDUE.getDesc());
                    return true;
                }
                if (SfaVisitEnum.HelpVisitStatus.IN_HELP_DEFENSE.getVal().equals(v.getVisitStatus())) {
                    v.setVisitStatus(SfaVisitEnum.HelpVisitStatus.NO_COMMIT.getVal());
                    v.setVisitStatusName(SfaVisitEnum.HelpVisitStatus.NO_COMMIT.getDesc());
                    v.setRemarks("\u8be5\u7528\u6237\u5728\u6267\u884c\u4e1a\u52a1\u65f6\u672a\u4e3b\u52a8\u63d0\u4ea4\u6267\u884c\u6570\u636e\uff08\u4efb\u52a1/\u540e\u53f0\u6279\u91cf\u7ed3\u7b97\uff09");
                    return true;
                }
            } else {
                if (SfaVisitEnum.visitStatus.V1.getVal().equals(v.getVisitStatus())) {
                    v.setVisitStatus(SfaVisitEnum.visitStatus.V6.getVal());
                    v.setVisitStatusName(SfaVisitEnum.visitStatus.V6.getDesc());
                    return true;
                }
                if (SfaVisitEnum.visitStatus.V2.getVal().equals(v.getVisitStatus())) {
                    v.setVisitStatus(SfaVisitEnum.visitStatus.V5.getVal());
                    v.setVisitStatusName(SfaVisitEnum.visitStatus.V5.getDesc());
                    v.setRemarks("\u8be5\u7528\u6237\u5728\u6267\u884c\u4e1a\u52a1\u65f6\u672a\u4e3b\u52a8\u63d0\u4ea4\u6267\u884c\u6570\u636e\uff08\u4efb\u52a1/\u540e\u53f0\u6279\u91cf\u7ed3\u7b97\uff09");
                    return true;
                }
            }
            return false;
        }).collect(Collectors.toList());
        return planInfoEntities;
    }

    public Map<String, Map<String, List<SfaVisitPlanInfoEntity>>> flushCounting(Map<String, Map<String, SfaVisitPlanInfoEntity>> daysPlanInfoTemp) {
        HashMap needDelete = Maps.newHashMap();
        for (Map.Entry<String, Map<String, SfaVisitPlanInfoEntity>> entry : daysPlanInfoTemp.entrySet()) {
            String redisHash = entry.getKey();
            SfaVisitPlanInfoEntity.VisitRedisHash visitRedisHash = new SfaVisitPlanInfoEntity.VisitRedisHash(redisHash);
            List<SfaVisitPlanInfoEntity> oldPlanOfEs = this.sfaVisitPlanInfoServiceEsImpl.findByVisitPosCodeAndVisitDateAndVisitBigType(visitRedisHash.getVisitPosCode(), visitRedisHash.getVisitDate(), visitRedisHash.getVisitBigType());
            Map oldPlanOfRedis = this.redisService.hmget(redisHash);
            this.compareAndCompensateForRedis(redisHash, oldPlanOfEs, oldPlanOfRedis);
            Map needDeletePlanInfos = (Map)needDelete.get(redisHash);
            if (null == needDeletePlanInfos) {
                needDeletePlanInfos = Maps.newHashMap();
            }
            Map<String, SfaVisitPlanInfoEntity> newPlan = entry.getValue();
            for (Map.Entry<String, SfaVisitPlanInfoEntity> entry2 : oldPlanOfRedis.entrySet()) {
                this.countingDifference(entry2, newPlan, needDeletePlanInfos);
            }
            needDelete.put(redisHash, needDeletePlanInfos);
        }
        return needDelete;
    }

    protected void countingDifference(Map.Entry<String, SfaVisitPlanInfoEntity> oldValueEntryOfRedis, Map<String, SfaVisitPlanInfoEntity> newPlan, Map<String, List<SfaVisitPlanInfoEntity>> needDeletePlanInfos) {
        SfaVisitPlanInfoEntity oldValue = oldValueEntryOfRedis.getValue();
        String oldValueRedisHashKey = oldValue.getRedisHashKey();
        if (!SfaVisitEnum.visitStatus.V1.getVal().equals(oldValue.getVisitStatus())) {
            newPlan.remove(oldValueRedisHashKey);
            return;
        }
        if (SfaVisitEnum.visitType.TEMP_VISIT.getVal().equals(oldValue.getVisitType())) {
            if (newPlan.containsKey(oldValueRedisHashKey)) {
                this.putDeletePlanInfos(needDeletePlanInfos, oldValue);
                return;
            }
            return;
        }
        if (newPlan.containsKey(oldValueRedisHashKey)) {
            newPlan.remove(oldValueRedisHashKey);
        } else {
            this.putDeletePlanInfos(needDeletePlanInfos, oldValue);
        }
    }

    protected void compareAndCompensateForRedis(String redisHash, List<SfaVisitPlanInfoEntity> oldPlanOfEs, Map<String, SfaVisitPlanInfoEntity> oldPlanOfRedis) {
        if (null == oldPlanOfRedis) {
            oldPlanOfRedis = Maps.newHashMap();
        }
        HashMap compensateOfRedis = Maps.newHashMap();
        for (SfaVisitPlanInfoEntity oldPlanOfE : oldPlanOfEs) {
            if (oldPlanOfRedis.containsKey(oldPlanOfE.getRedisHashKey())) continue;
            compensateOfRedis.put(oldPlanOfE.getRedisHashKey(), oldPlanOfE);
            oldPlanOfRedis.put(oldPlanOfE.getRedisHashKey(), oldPlanOfE);
        }
        this.saveToRedis(redisHash, compensateOfRedis, null);
    }

    public void saveToRedis(String redisHash, Map<String, SfaVisitPlanInfoEntity> objectObjectMap, Set<String> needDeleteRedisHashKeys) {
        boolean redis;
        if (!CollectionUtils.isEmpty(needDeleteRedisHashKeys)) {
            Object[] redisHashKeys = needDeleteRedisHashKeys.toArray(new String[needDeleteRedisHashKeys.size()]);
            this.redisService.hdel(redisHash, redisHashKeys);
        }
        if (objectObjectMap.size() > 0 && !(redis = this.redisService.hmset(redisHash, objectObjectMap, 1296000L))) {
            throw new BusinessException("\u89e3\u6790\u62dc\u8bbf\u8ba1\u5212\uff1a\u4fdd\u5b58redis\u5931\u8d25\uff01");
        }
    }

    private void putDeletePlanInfos(Map<String, List<SfaVisitPlanInfoEntity>> needDeletePlanInfos, SfaVisitPlanInfoEntity oldValue) {
        String oldValueRedisHashKey = oldValue.getRedisHashKey();
        ArrayList deletePlanInfos = needDeletePlanInfos.get(oldValueRedisHashKey);
        if (null == deletePlanInfos) {
            deletePlanInfos = Lists.newArrayList();
        }
        deletePlanInfos.add(oldValue);
        needDeletePlanInfos.put(oldValueRedisHashKey, deletePlanInfos);
    }

    public void loadUserDataForVisitGroup(List<SfaVisitGroupRespVo> list) {
        Set posCodes = list.stream().filter(v -> !Objects.equals(v.getUserName(), v.getPosCode())).map(SfaVisitGroupRespVo::getPosCode).collect(Collectors.toSet());
        Map<Object, Object> positionRespVoMap = posCodes.size() > 0 ? PositionUtil.getPositionByCodeList((List)Lists.newArrayList(posCodes)).stream().collect(Collectors.toMap(MdmPositionRespVo::getPositionCode, v -> v, (t, t2) -> t2)) : Maps.newHashMap();
        for (SfaVisitGroupRespVo sfaVisitPlanRespVo : list) {
            MdmPositionRespVo positionRespVo = (MdmPositionRespVo)positionRespVoMap.get(sfaVisitPlanRespVo.getPosCode());
            if (null == positionRespVo || !StringUtils.isNotBlank((CharSequence)positionRespVo.getUserName())) continue;
            sfaVisitPlanRespVo.setUserName(positionRespVo.getUserName());
            sfaVisitPlanRespVo.setFullName(positionRespVo.getFullName());
        }
    }

    public void loadUserDataForVisitGroup(SfaVisitGroupRespVo visitGroupRespVo) {
        if (Objects.equals(visitGroupRespVo.getUserName(), visitGroupRespVo.getPosCode())) {
            return;
        }
        MdmPositionRespVo positionRespVo = PositionUtil.getPositionByCode((String)visitGroupRespVo.getPosCode());
        if (null != positionRespVo && StringUtils.isNotBlank((CharSequence)positionRespVo.getUserName())) {
            visitGroupRespVo.setUserName(positionRespVo.getUserName());
            visitGroupRespVo.setFullName(positionRespVo.getFullName());
        }
    }

    public void loadUserDataForVisitPlanVo(List<SfaVisitPlanRespVo> list) {
        Set posCodes = list.stream().filter(v -> !Objects.equals(v.getVisitUserName(), v.getVisitPosCode())).map(SfaVisitPlanRespVo::getVisitPosCode).collect(Collectors.toSet());
        Map<Object, Object> positionRespVoMap = posCodes.size() > 0 ? PositionUtil.getPositionByCodeList((List)Lists.newArrayList(posCodes)).stream().collect(Collectors.toMap(MdmPositionRespVo::getPositionCode, v -> v, (t, t2) -> t2)) : Maps.newHashMap();
        for (SfaVisitPlanRespVo sfaVisitPlanRespVo : list) {
            MdmPositionRespVo positionRespVo = (MdmPositionRespVo)positionRespVoMap.get(sfaVisitPlanRespVo.getVisitPosCode());
            if (null == positionRespVo || !StringUtils.isNotBlank((CharSequence)positionRespVo.getUserName())) continue;
            sfaVisitPlanRespVo.setVisitUserName(positionRespVo.getUserName());
            sfaVisitPlanRespVo.setVisitRealName(positionRespVo.getFullName());
        }
    }

    public void loadUserDataForVisitPlanEntity(List<SfaVisitPlanEntity> list) {
        Set posCodes = list.stream().filter(v -> !Objects.equals(v.getVisitUserName(), v.getVisitPosCode())).map(SfaVisitPlanEntity::getVisitPosCode).collect(Collectors.toSet());
        Map<Object, Object> positionRespVoMap = posCodes.size() > 0 ? PositionUtil.getPositionByCodeList((List)Lists.newArrayList(posCodes)).stream().collect(Collectors.toMap(MdmPositionRespVo::getPositionCode, v -> v, (t, t2) -> t2)) : Maps.newHashMap();
        for (SfaVisitPlanEntity sfaVisitPlanRespVo : list) {
            MdmPositionRespVo positionRespVo = (MdmPositionRespVo)positionRespVoMap.get(sfaVisitPlanRespVo.getVisitPosCode());
            if (null == positionRespVo || !StringUtils.isNotBlank((CharSequence)positionRespVo.getUserName())) continue;
            sfaVisitPlanRespVo.setVisitUserName(positionRespVo.getUserName());
            sfaVisitPlanRespVo.setVisitRealName(positionRespVo.getFullName());
        }
    }
}

