/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller.visit.component;

import com.biz.crm.base.BusinessException;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class AbstractVisitStepListener
implements VisitStepListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractVisitStepListener.class);
    protected static final Map<String, Set<Class<? extends AbstractVisitStepListener>>> VISIT_STEP_LISTENER_CLASS_MAPPING = new HashMap<String, Set<Class<? extends AbstractVisitStepListener>>>();

    public static List<AbstractVisitStepListener> getListeners(String visitStepCode) {
        List<Class<? extends AbstractVisitStepListener>> clazz = AbstractVisitStepListener.getListenerClazz(visitStepCode);
        ArrayList listeners = Lists.newArrayList();
        for (Class<? extends AbstractVisitStepListener> aClass : clazz) {
            if (null == aClass) continue;
            AbstractVisitStepListener listener = (AbstractVisitStepListener)SpringApplicationContextUtil.getApplicationContext().getBean(aClass);
            if (null == listener) {
                log.warn("\u672a\u83b7\u53d6\u5230\u6b65\u9aa4\u76d1\u542c\u5668[" + aClass.getName() + "]\u7684\u5b9e\u4f8b,\u5ffd\u7565\u8be5\u76d1\u542c\u5668\uff01");
            }
            listeners.add(listener);
        }
        return listeners;
    }

    public static List<Class<? extends AbstractVisitStepListener>> getListenerClazz(String visitStepCode) {
        ArrayList classes = Lists.newArrayList();
        Set<Class<? extends AbstractVisitStepListener>> temp = VISIT_STEP_LISTENER_CLASS_MAPPING.get(visitStepCode);
        if (null != temp) {
            classes.addAll(temp);
        }
        if (null != (temp = VISIT_STEP_LISTENER_CLASS_MAPPING.get("LISTENER_ALL"))) {
            classes.addAll(temp);
        }
        return classes;
    }

    @PostConstruct
    public final void constructed() {
        Set<String> visitStepCodes = this.visitStepCodeRegistry();
        if (CollectionUtils.isEmpty(visitStepCodes)) {
            throw new BusinessException("\u62dc\u8bbf\u6b65\u9aa4\u76d1\u542c\u5668\u6ce8\u518c\u5931\u8d25: \u8bf7\u6307\u5b9a\u6b65\u9aa4\u76d1\u542c\u5668[" + this.getClass().getName() + "]\u7684\u62dc\u8bbf\u6b65\u9aa4\u7f16\u7801");
        }
        for (String visitStepCode : visitStepCodes) {
            if (StringUtils.isBlank((CharSequence)visitStepCode)) {
                throw new BusinessException("\u62dc\u8bbf\u6b65\u9aa4\u76d1\u542c\u5668\u6ce8\u518c\u5931\u8d25: \u76d1\u542c\u5668[" + this.getClass().getName() + "]\u6307\u5b9a\u4e86\u7a7a\u503c\u7684\u62dc\u8bbf\u6b65\u9aa4\u7f16\u7801");
            }
            HashSet classes = VISIT_STEP_LISTENER_CLASS_MAPPING.get(visitStepCode);
            if (null == classes) {
                classes = Sets.newHashSet();
            }
            classes.add(this.getClass());
            VISIT_STEP_LISTENER_CLASS_MAPPING.put(visitStepCode, classes);
        }
    }

    protected abstract Set<String> visitStepCodeRegistry();
}

