/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller.visit.component.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepRedisExecutor;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorWorkbenchLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.SummaryStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.StepExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.SummaryStepExecuteDataResp;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.LocationUtils;
import com.biz.crm.util.StringUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoExecuteRedisData;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoRedisData;
import com.biz.crm.visitstep.model.SfaVisitStepFromEntity;
import java.math.BigDecimal;
import java.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnMissingBean(name={"summaryVisitStepExecutorExpandImpl"})
public class SummaryVisitStepExecutor
extends AbstractVisitStepRedisExecutor<SummaryStepExecuteData, SummaryStepExecuteDataResp, ExecutorLoadReq> {
    private static final Logger log = LoggerFactory.getLogger(SummaryVisitStepExecutor.class);

    @Override
    protected String visitStepRegistry() {
        return SfaVisitEnum.visitStep.VISIT_STEP_SUMMARY.getVal();
    }

    @Override
    public void execute(VisitStepExecuteReq<SummaryStepExecuteData> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        String nowDate = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        this.check(sfaVisitPlanInfoEntity, visitStepExecuteReq, SfaVisitEnum.VISIT_OFF_LINE.online);
        SummaryStepExecuteData executeData = visitStepExecuteReq.getStepExecuteData();
        SfaVisitPlanInfoRedisData redisData = (SfaVisitPlanInfoRedisData)this.redisService.hmget(SfaVisitPlanInfoRedisData.getInstance().redisHashCurrent(nowDate, visitRedisHashKey.getVisitBigType()).toString(), (Object)visitStepExecuteReq.getRedisHashKey());
        redisData.setLineType(SfaVisitEnum.VISIT_OFF_LINE.online);
        SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData = redisData.getSfaVisitPlanInfoExecuteRedisData();
        sfaVisitPlanInfoExecuteRedisData.setFormIdAsSummary(visitStepExecuteReq.getFormId());
        sfaVisitPlanInfoExecuteRedisData.setVisitSummary(executeData.getVisitSummary());
        this.changeStepStatus(redisData, SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_SUMMARY.getVal());
        sfaVisitPlanInfoExecuteRedisData.setVisitDetailStep(redisData.summaryStepStatus());
        this.redisService.hmset(redisData.redisHashCurrent(nowDate, visitRedisHashKey.getVisitBigType()).toString(), redisData.buildRedisDataForWrite(), 1296000L);
    }

    @Override
    public void executeOffLine(VisitStepExecuteReq<SummaryStepExecuteData> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        String nowDate = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        this.check(sfaVisitPlanInfoEntity, visitStepExecuteReq, SfaVisitEnum.VISIT_OFF_LINE.offline);
        SummaryStepExecuteData executeData = visitStepExecuteReq.getStepExecuteData();
        SfaVisitPlanInfoRedisData redisData = (SfaVisitPlanInfoRedisData)this.redisService.hmget(SfaVisitPlanInfoRedisData.getInstance().redisHashCurrent(nowDate, visitRedisHashKey.getVisitBigType()).toString(), (Object)visitStepExecuteReq.getRedisHashKey());
        redisData.setLineType(SfaVisitEnum.VISIT_OFF_LINE.offline);
        SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData = redisData.getSfaVisitPlanInfoExecuteRedisData();
        sfaVisitPlanInfoExecuteRedisData.setFormIdAsSummary(visitStepExecuteReq.getFormId());
        sfaVisitPlanInfoExecuteRedisData.setVisitSummary(executeData.getVisitSummary());
        this.changeStepStatus(redisData, SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_SUMMARY.getVal());
        sfaVisitPlanInfoExecuteRedisData.setVisitDetailStep(redisData.summaryStepStatus());
        this.redisService.hmset(redisData.redisHashCurrent(nowDate, visitRedisHashKey.getVisitBigType()).toString(), redisData.buildRedisDataForWrite(), 1296000L);
    }

    protected void check(SfaVisitPlanInfoEntity entity, VisitStepExecuteReq<SummaryStepExecuteData> visitStepExecuteReq, SfaVisitEnum.VISIT_OFF_LINE lineType) {
        SfaVisitStepFromEntity stepFromEntity;
        super.check(visitStepExecuteReq);
        this.controlDataTrans(visitStepExecuteReq);
        SummaryStepExecuteData stepExecuteData = visitStepExecuteReq.getStepExecuteData();
        if (null == stepExecuteData) {
            throw new BusinessException("\u6267\u884c\u6570\u636e\u4e3a\u7a7a");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)stepExecuteData.getVisitSummary())) {
            throw new BusinessException("\u8bf7\u586b\u5199\u62dc\u8bbf\u603b\u7ed3");
        }
        if (lineType.equals((Object)SfaVisitEnum.VISIT_OFF_LINE.online) && entity != null && entity.getLatitude() != null && entity.getLatitude() != null && (stepFromEntity = (SfaVisitStepFromEntity)((Object)((LambdaQueryChainWrapper)this.sfaVisitStepFromService.lambdaQuery().eq(BaseIdEntity::getId, (Object)visitStepExecuteReq.getFormId())).one())) != null && stepFromEntity.getLocateType().equals(YesNoEnum.yesNoEnum.Y.getValue()) && StringUtils.isNotEmpty((String)stepFromEntity.getDistance())) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)stepExecuteData.getLongitude())) {
                throw new BusinessException("\u7ecf\u5ea6\u4e3a\u7a7a");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)stepExecuteData.getLatitude())) {
                throw new BusinessException("\u7eac\u5ea6\u4e3a\u7a7a");
            }
            BigDecimal distance = new BigDecimal(stepFromEntity.getDistance()).setScale(2, 5);
            log.info("\u5f53\u524d\u6b65\u9aa4\u914d\u7f6e\u7684\u8ddd\u79bb:{}", (Object)distance);
            log.info("\u5f53\u524d\u4f4d\u7f6e\u7684\u7ecf\u5ea6:{},\u7eac\u5ea6:{},\u62dc\u8bbf\u5ba2\u6237\u7684\u7ecf\u5ea6:{},\u7eac\u5ea6:{}", new Object[]{stepExecuteData.getLongitude(), stepExecuteData.getLatitude(), entity.getLongitude(), entity.getLatitude()});
            double data = LocationUtils.getDistance(new BigDecimal(stepExecuteData.getLongitude()), new BigDecimal(stepExecuteData.getLatitude()), entity.getLongitude(), entity.getLatitude());
            BigDecimal nowDistance = new BigDecimal(data).setScale(2, 5);
            log.info("\u5f53\u524d\u4f4d\u7f6e\u8ddd\u79bb\u62dc\u8bbf\u5ba2\u6237\u7684\u8ddd\u79bb:{}", (Object)nowDistance);
            if (distance.compareTo(nowDistance) == -1) {
                throw new BusinessException("\u60a8\u672a\u5728\u5ba2\u6237\u8ddd\u79bb" + distance + "M\u5185\uff0c\u8bf7\u524d\u5f80\u5ba2\u6237\u5730\u5740\u8fdb\u884c\u64cd\u4f5c\uff01");
            }
        }
    }

    @Override
    protected SummaryStepExecuteDataResp doLoad(ExecutorLoadReq redisHashKey) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)redisHashKey.getRedisHashKey())) {
            throw new BusinessException("redisHashKey\u4e3a\u7a7a");
        }
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(redisHashKey.getRedisHashKey());
        String nowDate = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        SfaVisitPlanInfoRedisData redisData = (SfaVisitPlanInfoRedisData)this.redisService.hmget(SfaVisitPlanInfoRedisData.getInstance().redisHashCurrent(nowDate, visitRedisHashKey.getVisitBigType()).toString(), (Object)redisHashKey.getRedisHashKey());
        if (null == redisData) {
            throw new BusinessException("\u4e0d\u5b58\u5728\u7684\u62dc\u8bbf\u8ba1\u5212\uff0c\u6216\u8be5\u8ba1\u5212\u4e0d\u5728\u4eca\u65e5\u8ba1\u5212\u5185\uff01");
        }
        SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData = redisData.getSfaVisitPlanInfoExecuteRedisData();
        SummaryStepExecuteDataResp dataResp = (SummaryStepExecuteDataResp)CrmBeanUtil.copy((Object)((Object)sfaVisitPlanInfoExecuteRedisData), SummaryStepExecuteDataResp.class);
        dataResp.setVisitDetailStep(redisData.summaryStepStatus());
        this.controlDataToObj(dataResp);
        return dataResp;
    }

    @Override
    protected SummaryStepExecuteDataResp doLoadEditPageForWorkbench(ExecutorWorkbenchLoadReq loadParam) {
        return null;
    }

    @Override
    public StepExecuteDataResp getEsDataById(String id) {
        return null;
    }

    @Override
    public StepExecuteDataResp getEsDataByVisitPlanInfo(String visitPlanInfoId, String stepCode) {
        return null;
    }
}

