/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller.visit.component.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmAttachment;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.SfaClientData;
import com.biz.crm.base.SfaClientHelper;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepRedisExecutor;
import com.biz.crm.moblie.controller.visit.component.VisitDataDurabilityService;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.moblie.controller.visit.req.ClientReq;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.CompetitorStepExecuteData;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorWorkbenchLoadReq;
import com.biz.crm.moblie.controller.visit.resp.StepExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.CompetitorStepExecuteDataResp;
import com.biz.crm.moblie.controller.workbench.req.CompetitorWorkbenchDataReq;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.LocationUtils;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UUIDGenerator;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitstep.model.SfaVisitStepColletEsData;
import com.biz.crm.visitstep.model.SfaVisitStepColletRedisData;
import com.biz.crm.visitstep.model.SfaVisitStepFromEntity;
import com.biz.crm.visitstep.repositories.SfaVisitStepColletEsDataRepositories;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstep.service.impl.SfaVisitStepColletServiceImpl;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
@ConditionalOnMissingBean(name={"competitorVisitStepExecutorExpandImpl"})
public class CompetitorVisitStepExecutor<ExecuteReq extends CompetitorStepExecuteData>
extends AbstractVisitStepRedisExecutor<ExecuteReq, CompetitorStepExecuteDataResp, ExecutorLoadReq> {
    private static final Logger log = LoggerFactory.getLogger(CompetitorVisitStepExecutor.class);
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Resource
    private MdmOrgFeign mdmOrgFeign;
    @Resource
    private SfaVisitStepColletEsDataRepositories sfaVisitStepColletEsDataRepositories;
    @Resource
    private SfaVisitStepColletServiceImpl sfaVisitStepColletService;

    @Override
    protected VisitDataDurabilityService getVisitDataDurabilityService() {
        return this.sfaVisitStepColletService;
    }

    @Override
    protected String visitStepRegistry() {
        return SfaVisitEnum.visitStep.VISIT_STEP_COMPETITOR.getVal();
    }

    @Override
    public void execute(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        this.check(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        SfaVisitStepColletRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        this.buildEntity(sfaVisitPlanInfoEntity, redisData);
        redisData.setFormId(visitStepExecuteReq.getFormId());
        redisData.setRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        redisData.setVisitPlanInfoId(sfaVisitPlanInfoEntity.getId());
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode(), visitRedisHashKey.getVisitBigType());
        this.redisService.hmset(redisData.redisHash(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode()).toString(), redisData.buildRedisDataForWrite(), 1296000L);
    }

    @Transactional
    public void executeForWorkbench(VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        String id = UUIDGenerator.generate();
        visitStepExecuteReq.setRedisHashKey(id);
        this.check(null, visitStepExecuteReq);
        SfaVisitStepColletRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        CompetitorWorkbenchDataReq dataReq = (CompetitorWorkbenchDataReq)visitStepExecuteReq.getStepExecuteData();
        this.buildEntity(dataReq, redisData);
        redisData.setId(id);
        redisData.setVisitPlanInfoId(id);
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        this.dataDurability(Lists.newArrayList((Object[])new SfaVisitStepColletRedisData[]{redisData}), fromRespVo);
    }

    protected SfaVisitStepColletRedisData buildRedisData(VisitStepExecuteReq<? extends CompetitorStepExecuteData> visitStepExecuteReq) {
        CompetitorStepExecuteData executeData = visitStepExecuteReq.getStepExecuteData();
        SfaVisitStepColletRedisData redisData = (SfaVisitStepColletRedisData)CrmBeanUtil.copy((Object)executeData, SfaVisitStepColletRedisData.class);
        redisData.setRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        redisData.setFormId(visitStepExecuteReq.getFormId());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        redisData.setStepCode(fromRespVo.getStepCode());
        redisData.setSfaVisitStepColletItemReqVos(executeData.getSfaVisitStepColletItemReqVos());
        redisData.setSfaVisitPictureReqVos(executeData.getSfaVisitPictureReqVos());
        return redisData;
    }

    protected void buildEntity(ClientReq sfaVisitPlanInfoEntity, SfaVisitStepColletRedisData redisData) {
        this.checkClientReq(sfaVisitPlanInfoEntity);
        CrmBaseEntity.buildDefEntityData((CrmBaseEntity)redisData);
        if (SfaVisitEnum.ClientType.TERMINAL.getVal().equals(sfaVisitPlanInfoEntity.getClientType())) {
            this.injectOrgInfoOfTerminal(sfaVisitPlanInfoEntity, redisData);
        } else {
            this.injectOrgInfoOfTerminalCustomer(sfaVisitPlanInfoEntity, redisData);
        }
        this.buildClientData(redisData, sfaVisitPlanInfoEntity.getClientCode(), sfaVisitPlanInfoEntity.getClientType());
        UserRedis userRedis = UserUtils.getUser();
        redisData.setUserName(userRedis.getUsername());
        redisData.setRealName(userRedis.getUsername());
        redisData.setPosCode(userRedis.getPoscode());
        redisData.setPosName(userRedis.getPosname());
        redisData.setOrgCode(userRedis.getOrgcode());
        redisData.setOrgName(userRedis.getOrgname());
    }

    private void injectOrgInfoOfTerminal(ClientReq sfaVisitPlanInfoEntity, SfaVisitStepColletRedisData redisData) {
        MdmTerminalVo clientVo = (MdmTerminalVo)this.mdmTerminalFeign.query(null, sfaVisitPlanInfoEntity.getClientCode()).getResult();
        if (null == clientVo) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5ba2\u6237\u6570\u636e[" + sfaVisitPlanInfoEntity.getClientCode() + "]");
        }
        MdmOrgRespVo resultParent = (MdmOrgRespVo)this.mdmOrgFeign.getParentOrg(null, clientVo.getOrgCode()).getResult();
        if (null != resultParent) {
            redisData.setClientAreaId(resultParent.getOrgCode());
            redisData.setClientArea(resultParent.getOrgName());
        }
        redisData.setClientOfficeId(clientVo.getOrgCode());
        redisData.setClientOffice(clientVo.getOrgName());
    }

    private void injectOrgInfoOfTerminalCustomer(ClientReq sfaVisitPlanInfoEntity, SfaVisitStepColletRedisData redisData) {
        MdmCustomerMsgRespVo clientVo = (MdmCustomerMsgRespVo)this.mdmCustomerMsgFeign.query(null, sfaVisitPlanInfoEntity.getClientCode()).getResult();
        if (null == clientVo) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5ba2\u6237\u6570\u636e[" + sfaVisitPlanInfoEntity.getClientCode() + "]");
        }
        MdmOrgRespVo resultParent = (MdmOrgRespVo)this.mdmOrgFeign.getParentOrg(null, clientVo.getOrgCode()).getResult();
        if (null != resultParent) {
            redisData.setClientAreaId(resultParent.getOrgCode());
            redisData.setClientArea(resultParent.getOrgName());
        }
        redisData.setClientOfficeId(clientVo.getOrgCode());
        redisData.setClientOffice(clientVo.getOrgName());
    }

    protected void check(SfaVisitPlanInfoEntity entity, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        SfaVisitStepFromEntity stepFromEntity;
        super.check(visitStepExecuteReq);
        CompetitorStepExecuteData stepExecuteData = (CompetitorStepExecuteData)visitStepExecuteReq.getStepExecuteData();
        if (null == stepExecuteData) {
            throw new BusinessException("\u6267\u884c\u6570\u636e\u4e3a\u7a7a");
        }
        if (entity != null && entity.getLatitude() != null && entity.getLatitude() != null && (stepFromEntity = (SfaVisitStepFromEntity)((Object)((LambdaQueryChainWrapper)this.sfaVisitStepFromService.lambdaQuery().eq(BaseIdEntity::getId, (Object)visitStepExecuteReq.getFormId())).one())) != null && stepFromEntity.getLocateType().equals(YesNoEnum.yesNoEnum.Y.getValue()) && StringUtils.isNotEmpty((String)stepFromEntity.getDistance())) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)stepExecuteData.getLongitude())) {
                throw new BusinessException("\u7ecf\u5ea6\u4e3a\u7a7a");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)stepExecuteData.getLatitude())) {
                throw new BusinessException("\u7eac\u5ea6\u4e3a\u7a7a");
            }
            BigDecimal distance = new BigDecimal(stepFromEntity.getDistance()).setScale(2, 5);
            log.info("\u5f53\u524d\u6b65\u9aa4\u914d\u7f6e\u7684\u8ddd\u79bb:{}", (Object)distance);
            log.info("\u5f53\u524d\u4f4d\u7f6e\u7684\u7ecf\u5ea6:{},\u7eac\u5ea6:{},\u62dc\u8bbf\u5ba2\u6237\u7684\u7ecf\u5ea6:{},\u7eac\u5ea6:{}", new Object[]{stepExecuteData.getLongitude(), stepExecuteData.getLatitude(), entity.getLongitude(), entity.getLatitude()});
            double data = LocationUtils.getDistance(new BigDecimal(stepExecuteData.getLongitude()), new BigDecimal(stepExecuteData.getLatitude()), entity.getLongitude(), entity.getLatitude());
            BigDecimal nowDistance = new BigDecimal(data).setScale(2, 5);
            log.info("\u5f53\u524d\u4f4d\u7f6e\u8ddd\u79bb\u62dc\u8bbf\u5ba2\u6237\u7684\u8ddd\u79bb:{}", (Object)nowDistance);
            if (distance.compareTo(nowDistance) == -1) {
                throw new BusinessException("\u60a8\u672a\u5728\u5ba2\u6237\u8ddd\u79bb" + distance + "M\u5185\uff0c\u8bf7\u524d\u5f80\u5ba2\u6237\u5730\u5740\u8fdb\u884c\u64cd\u4f5c\uff01");
            }
        }
        if (CollectionUtils.isEmpty(stepExecuteData.getSfaVisitStepColletItemReqVos())) {
            throw new BusinessException("\u7ade\u54c1\u5546\u54c1\u6e05\u5355\u4e3a\u7a7a");
        }
        List<CrmAttachment> sfaVisitPictureReqVos = stepExecuteData.getSfaVisitPictureReqVos();
        this.checkPics(sfaVisitPictureReqVos, 1, 5, "\u7ade\u54c1");
    }

    @Override
    protected CompetitorStepExecuteDataResp doLoad(ExecutorLoadReq redisHashKey) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(redisHashKey.getRedisHashKey());
        this.loadAndCheckSfaVisitPlanInfoEntity(redisHashKey.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(redisHashKey.getFormId());
        SfaVisitStepColletRedisData redisData = (SfaVisitStepColletRedisData)this.redisService.hmget(SfaVisitStepColletRedisData.getInstance().redisHash(redisHashKey.getRedisHashKey(), fromRespVo.getStepCode()).toString(), (Object)redisHashKey.getRedisHashKey());
        if (null == redisData) {
            redisData = new SfaVisitStepColletRedisData(){
                {
                    ArrayList list = Lists.newArrayList();
                    this.setSfaVisitPictureReqVos(list);
                    this.setSfaVisitStepColletItemReqVos(list);
                }
            };
        }
        CompetitorStepExecuteDataResp dataResp = (CompetitorStepExecuteDataResp)CrmBeanUtil.copy((Object)redisData, CompetitorStepExecuteDataResp.class);
        dataResp.setSfaVisitPictureReqVos(redisData.getSfaVisitPictureReqVos());
        dataResp.setSfaVisitStepColletItemReqVos(redisData.getSfaVisitStepColletItemReqVos());
        dataResp.setSfaVisitStepFrom(fromRespVo);
        return dataResp;
    }

    @Override
    public StepExecuteDataResp getEsDataById(String id) {
        Optional optional = this.sfaVisitStepColletEsDataRepositories.findById(id);
        if (optional.isPresent()) {
            return (StepExecuteDataResp)optional.get();
        }
        throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u6570\u636e\u8be6\u7ec6\u4fe1\u606f!");
    }

    @Override
    public StepExecuteDataResp getEsDataByVisitPlanInfo(String visitPlanInfoId, String stepCode) {
        SfaVisitStepColletEsData esData = this.sfaVisitStepColletEsDataRepositories.findByVisitPlanInfoIdAndStepCode(visitPlanInfoId, stepCode);
        return esData;
    }

    @Override
    protected CompetitorStepExecuteDataResp doLoadEditPageForWorkbench(ExecutorWorkbenchLoadReq loadParam) {
        String bizId = loadParam.getBizId();
        String visitPlanInfoId = loadParam.getVisitPlanInfoId();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)visitPlanInfoId)) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)loadParam.getStepCode())) {
                throw new BusinessException("\u6b65\u9aa4\u7f16\u7801\u4e3a\u7a7a");
            }
            SfaVisitStepColletEsData redisData = (SfaVisitStepColletEsData)this.getEsDataByVisitPlanInfo(visitPlanInfoId, loadParam.getStepCode());
            return this.buildDataResp(redisData);
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)bizId)) {
            SfaClientData clientData = SfaClientHelper.loadClientData(loadParam.getClientType(), loadParam.getClientCode());
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)loadParam.getStepCode())) {
                throw new BusinessException("\u6b65\u9aa4\u7f16\u7801\u4e3a\u7a7a");
            }
            CompetitorStepExecuteDataResp dataResp = new CompetitorStepExecuteDataResp(){
                {
                    ArrayList list = Lists.newArrayList();
                    this.setSfaVisitPictureReqVos(list);
                    this.setSfaVisitStepColletItemReqVos(list);
                }
            };
            dataResp.setSfaVisitStepFrom(this.getFormData(loadParam.getClientType(), loadParam.getStepCode(), loadParam.getVisitBigType(), clientData.getClientSubclass()));
            return dataResp;
        }
        SfaVisitStepColletEsData redisData = (SfaVisitStepColletEsData)this.getEsDataById(bizId);
        return this.buildDataResp(redisData);
    }

    private CompetitorStepExecuteDataResp buildDataResp(SfaVisitStepColletEsData redisData) {
        if (null == redisData) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u6570\u636e\u8be6\u7ec6\u4fe1\u606f!");
        }
        CompetitorStepExecuteDataResp dataResp = (CompetitorStepExecuteDataResp)CrmBeanUtil.copy((Object)redisData, CompetitorStepExecuteDataResp.class);
        dataResp.setSfaVisitPictureReqVos(redisData.getSfaVisitPictureReqVos());
        dataResp.setSfaVisitStepColletItemReqVos(redisData.getSfaVisitStepColletItemReqVos());
        dataResp.setSfaVisitStepFrom(redisData.getSfaVisitStepFrom());
        return dataResp;
    }

    @Override
    protected List<? extends VisitStepListener.VisitStepListenerCommittedData> loadRedisDataList(ExecutorLoadReq loadParam) {
        SfaVisitStepColletRedisData redisData = (SfaVisitStepColletRedisData)this.redisService.hmget(SfaVisitStepColletRedisData.getInstance().redisHash(loadParam.getRedisHashKey(), loadParam.getStepCode()).toString(), (Object)loadParam.getRedisHashKey());
        if (null == redisData) {
            log.warn("\u5c06\u6570\u636e\u4f20\u8f93\u5230ES: \u6ca1\u6709\u6267\u884c\u6570\u636e\u9700\u8981\u4f20\u8f93\uff08\u53ef\u80fd\u7528\u6237\u6ca1\u6709\u6267\u884c\u8be5\u6b65\u9aa4\uff09\uff0cexecutorLoadReq={}", (Object)JsonPropertyUtil.toJsonString((Object)((Object)loadParam)));
            return null;
        }
        return Lists.newArrayList((Object[])new SfaVisitStepColletRedisData[]{redisData});
    }
}

