/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitdealer.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.achievement.controller.AchievementRecordsMQSend;
import com.biz.crm.achievement.mapper.SfaAchievementAccomplishRecordMapper;
import com.biz.crm.aop.CrmAPIDiscard;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmAttachment;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.collection.controller.resp.VisitStepResp;
import com.biz.crm.collection.service.ISfaVisitRoleDirectoryService;
import com.biz.crm.common.CrmRedisHashKeyVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.moblie.controller.visit.req.SfaVisitExceptionReq;
import com.biz.crm.moblie.controller.visit.req.SfaVisitInOutReq;
import com.biz.crm.moblie.controller.visit.resp.SfaVisitExceptionResp;
import com.biz.crm.moblie.controller.visit.resp.SfaVisitExecuteResp;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactPageReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerCountReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerCountRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgContactPageRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactPageReqVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactPageVo;
import com.biz.crm.nebular.mdm.terminal.req.UpdateCoordinateReqVo;
import com.biz.crm.nebular.sfa.achievement.req.SfaAchievementAccomplishRecordReqVo;
import com.biz.crm.nebular.sfa.achievement.resp.SfaAchievementTimeTotalRespVo;
import com.biz.crm.nebular.sfa.collection.req.FindVisitDetailReqVo;
import com.biz.crm.nebular.sfa.collection.req.SfaVisitRoleConfigReqVo;
import com.biz.crm.nebular.sfa.collection.resp.SfaVisitRoleDirectoryRespVo;
import com.biz.crm.nebular.sfa.picture.req.SfaVisitPictureReqVo;
import com.biz.crm.nebular.sfa.picture.resp.SfaVisitPictureRespVo;
import com.biz.crm.nebular.sfa.visitdealer.req.SfaVisitDealerDetailReqVo;
import com.biz.crm.nebular.sfa.visitdealer.resp.SfaVisitDealerDetailRespVo;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoRespVo;
import com.biz.crm.picture.model.SfaVisitPictureEntity;
import com.biz.crm.picture.service.ISfaVisitPictureService;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.LocationUtils;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitdealer.mapper.SfaVisitDealerDetailMapper;
import com.biz.crm.visitdealer.model.SfaVisitDealerDetailEntity;
import com.biz.crm.visitdealer.service.ISfaVisitDealerDetailService;
import com.biz.crm.visitinfo.mapper.SfaVisitPlanInfoMapper;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoExecuteRedisData;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoRedisData;
import com.biz.crm.visitinfo.repositories.SfaVisitPlanInfoEntityRepositories;
import com.biz.crm.visitinfo.req.VisitPlanInfoEsReq;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstep.service.ISfaVisitStepFromService;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.QueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaVisitDealerDetailServiceExpandImpl"})
public class SfaVisitDealerDetailServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaVisitDealerDetailMapper, SfaVisitDealerDetailEntity>
implements ISfaVisitDealerDetailService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitDealerDetailServiceImpl.class);
    @Resource
    protected SfaVisitDealerDetailMapper sfaVisitDealerDetailMapper;
    @Resource
    protected SfaVisitPlanInfoMapper sfaVisitPlanInfoMapper;
    @Resource
    protected MdmOrgFeign mdmOrgFeign;
    @Resource
    protected MdmTerminalFeign mdmTerminalFeign;
    @Resource
    protected MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Resource
    protected ISfaVisitRoleDirectoryService sfaVisitRoleDirectoryService;
    @Resource
    protected RedisService redisService;
    @Resource
    protected ISfaVisitPlanInfoService sfaVisitPlanInfoService;
    @Resource
    protected ISfaVisitStepFromService sfaVisitStepFromService;
    @Resource
    protected SfaAchievementAccomplishRecordMapper achievementAccomplishRecordMapper;
    @Resource
    protected SfaVisitPlanInfoEntityRepositories sfaVisitPlanInfoEntityRepositories;
    @Autowired
    private ISfaVisitPictureService sfaVisitPictureService;

    @Override
    public PageResult<SfaVisitDealerDetailRespVo> findList(SfaVisitDealerDetailReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitDealerDetailRespVo> list = this.sfaVisitDealerDetailMapper.findList((Page<SfaVisitDealerDetailRespVo>)page, reqVo);
        for (final SfaVisitDealerDetailRespVo data : list) {
            SfaVisitPictureReqVo pictureReqVo = new SfaVisitPictureReqVo(){
                {
                    this.setBusinessId(data.getId());
                }
            };
            List<SfaVisitPictureRespVo> sfaVisitPictureRespVos = this.sfaVisitPictureService.findSfaVisitPictureList(pictureReqVo);
            if (!CollectionUtil.listNotEmptyNotSizeZero(sfaVisitPictureRespVos)) continue;
            data.setPhotoList(sfaVisitPictureRespVos);
            Map<String, List<SfaVisitPictureRespVo>> picMap = sfaVisitPictureRespVos.stream().collect(Collectors.groupingBy(SfaVisitPictureRespVo::getPicType));
            ArrayList inStorePicList = Lists.newArrayList();
            ArrayList outStorePicList = Lists.newArrayList();
            for (Map.Entry<String, List<SfaVisitPictureRespVo>> pic : picMap.entrySet()) {
                if (pic.getKey().equals(SfaVisitEnum.visitPicType.DEALER_IN_STORE_PIC.getVal())) {
                    pic.getValue().forEach(p -> inStorePicList.add(p.getPicUrl() + p.getPicPath()));
                    continue;
                }
                if (!pic.getKey().equals(SfaVisitEnum.visitPicType.DEALER_OUT_STORE_PIC.getVal())) continue;
                pic.getValue().forEach(p -> outStorePicList.add(p.getPicUrl() + p.getPicPath()));
            }
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Deprecated
    @CrmAPIDiscard
    public SfaVisitDealerDetailRespVo queryVisitDetailReportById(final String id) {
        final SfaVisitDealerDetailEntity sfaVisitDealerDetailEntity = (SfaVisitDealerDetailEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)id)).one());
        if (sfaVisitDealerDetailEntity == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u62dc\u8bbf\u660e\u7ec6\u62a5\u8868\u8be6\u7ec6\u4fe1\u606f");
        }
        FindVisitDetailReqVo reqVo = new FindVisitDetailReqVo(){
            {
                this.setVisitType(SfaVisitEnum.sfaVisitType.VISIT.getVal());
                this.setVisitId(id);
                this.setVisitUserName(sfaVisitDealerDetailEntity.getVisitUserName());
                this.setVisitPosCode(sfaVisitDealerDetailEntity.getVisitPosCode());
                this.setSfacusType(sfaVisitDealerDetailEntity.getClientType());
            }
        };
        List<SfaVisitRoleDirectoryRespVo> roleDirectoryRespVos = this.sfaVisitRoleDirectoryService.findVisitDetail(reqVo);
        Map<String, String> stepMap = this.stepVisitDetail(roleDirectoryRespVos);
        SfaVisitDealerDetailRespVo respVo = (SfaVisitDealerDetailRespVo)CrmBeanUtil.copy((Object)((Object)sfaVisitDealerDetailEntity), SfaVisitDealerDetailRespVo.class);
        respVo.setVisitDetailStep(stepMap);
        respVo.setRoleDirectoryRespVos(roleDirectoryRespVos);
        return respVo;
    }

    private Map<String, String> stepVisitDetail(List<SfaVisitRoleDirectoryRespVo> roleDirectoryRespVos) {
        HashMap<String, String> stepMap = new HashMap<String, String>();
        roleDirectoryRespVos.forEach(data -> stepMap.put("\u662f\u5426" + data.getDirectoryName(), data.getIsSuccessDesc()));
        return stepMap;
    }

    @Override
    @Deprecated
    @CrmAPIDiscard
    public SfaVisitDealerDetailRespVo query(final SfaVisitDealerDetailReqVo reqVo) {
        SfaVisitPictureReqVo pictureReqVo;
        List<SfaVisitPictureRespVo> sfaVisitPictureRespVos;
        if (null == reqVo || com.biz.crm.util.StringUtils.isEmpty((String)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            return new SfaVisitDealerDetailRespVo();
        }
        final SfaVisitDealerDetailRespVo sfaVisitDealerDetailRespVo = this.sfaVisitDealerDetailMapper.findSfaVisitDealerDetailRespVo(reqVo);
        if (sfaVisitDealerDetailRespVo == null) {
            return null;
        }
        String nowDate = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        if (!sfaVisitDealerDetailRespVo.getVisitDate().equals(nowDate)) {
            throw new BusinessException("\u4e0d\u662f\u5f53\u524d\u65f6\u95f4\u5185\u7684\u65e0\u6cd5\u8fdb\u884c\u62dc\u8bbf");
        }
        SfaVisitDealerDetailReqVo param = new SfaVisitDealerDetailReqVo(){
            {
                this.setVisitUserName(sfaVisitDealerDetailRespVo.getVisitUserName());
                this.setClientCode(sfaVisitDealerDetailRespVo.getClientCode());
                this.setId(reqVo.getId());
            }
        };
        String lastVisitSummary = this.sfaVisitDealerDetailMapper.selectSfaVisitDealerDetailLsatVisitSummary(param);
        if (com.biz.crm.util.StringUtils.isNotEmpty((String)lastVisitSummary)) {
            sfaVisitDealerDetailRespVo.setLastVisitSummary(lastVisitSummary);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(sfaVisitPictureRespVos = this.sfaVisitPictureService.findSfaVisitPictureList(pictureReqVo = new SfaVisitPictureReqVo(){
            {
                this.setBusinessId(reqVo.getId());
            }
        }))) {
            sfaVisitDealerDetailRespVo.setPhotoList(sfaVisitPictureRespVos);
        }
        return sfaVisitDealerDetailRespVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Deprecated
    @CrmAPIDiscard
    public void save(SfaVisitDealerDetailReqVo reqVo) {
        SfaVisitDealerDetailEntity entity = (SfaVisitDealerDetailEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitDealerDetailEntity.class));
        entity.setVisitDateMonth(LocalDate.now().format(CrmDateUtils.yyyyMM));
        this.save((Object)entity);
    }

    private SfaVisitPlanInfoEntity loadAndCheckPlanInfo(String redisHashKey, String visitBigType) {
        UserRedis userRedis = UserUtils.getUser();
        String nowDate = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = (SfaVisitPlanInfoEntity)this.redisService.hmget(SfaVisitPlanInfoEntity.getInstance().redisHashCurrent(nowDate, visitBigType).toString(), (Object)redisHashKey);
        if (null == sfaVisitPlanInfoEntity) {
            throw new BusinessException("\u4e0d\u5b58\u5728\u7684\u62dc\u8bbf\u8ba1\u5212\uff0c\u6216\u8be5\u8ba1\u5212\u4e0d\u5728\u4eca\u65e5\u8ba1\u5212\u5185\uff01");
        }
        if (!StringUtils.equals((CharSequence)sfaVisitPlanInfoEntity.getVisitPosCode(), (CharSequence)userRedis.getPoscode())) {
            throw new BusinessException("\u4f60\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u8be5\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u767b\u9646\u6216\u5207\u6362\u804c\u4f4d\u518d\u5c1d\u8bd5\uff01");
        }
        return sfaVisitPlanInfoEntity;
    }

    @Override
    @Transactional(readOnly=true)
    public SfaVisitExecuteResp getVisitSteps(CrmRedisHashKeyVo redisHashKeyVo) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(redisHashKeyVo.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckPlanInfo(redisHashKeyVo.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        if (SfaVisitEnum.visitStatus.V4.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())) {
            throw new BusinessException("\u8be5\u62dc\u8bbf\u8ba1\u5212\u5df2\u6807\u6ce8\u4e3a\u5f02\u5e38\u72b6\u6001\uff01");
        }
        if (SfaVisitEnum.visitStatus.V1.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())) {
            throw new BusinessException("\u8bf7\u5148\u8fdb\u5e97\u6253\u5361\uff01");
        }
        SfaVisitPlanInfoRedisData doingData = (SfaVisitPlanInfoRedisData)this.redisService.hmget(SfaVisitPlanInfoRedisData.getInstance().redisHashCurrent(sfaVisitPlanInfoEntity.getVisitDate(), visitRedisHashKey.getVisitBigType()).toString(), (Object)redisHashKeyVo.getRedisHashKey());
        SfaVisitExecuteResp executeResp = (SfaVisitExecuteResp)((Object)CrmBeanUtil.copy((Object)((Object)doingData.getSfaVisitPlanInfoExecuteRedisData()), SfaVisitExecuteResp.class));
        executeResp.setClientPhoto(doingData.getClientPhoto());
        executeResp.setSteps(doingData.getStep());
        return executeResp;
    }

    private SfaVisitPlanInfoRedisData stepStatusCheck(SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey) {
        SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData = (SfaVisitPlanInfoRedisData)this.redisService.hmget(SfaVisitPlanInfoRedisData.getInstance().redisHashCurrent(visitRedisHashKey.getVisitDate(), visitRedisHashKey.getVisitBigType()).toString(), (Object)visitRedisHashKey.getRedisHashKey());
        List<VisitStepResp> steps = sfaVisitPlanInfoRedisData.getStep();
        StringJoiner msg = new StringJoiner(",");
        for (VisitStepResp stepResp : steps) {
            if (!YesNoEnum.yesNoEnum.yes.getValue().equals(stepResp.getDoNot()) || SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getVal().equals(stepResp.getIsSuccess())) continue;
            msg.add(stepResp.getStepName());
        }
        if (msg.length() > 0) {
            throw new BusinessException("\u6b65\u9aa4[" + msg.toString() + "]\u4e3a\u5fc5\u505a\u9879!");
        }
        return sfaVisitPlanInfoRedisData;
    }

    private void injectOutStoreData(SfaVisitInOutReq inOutReq, SfaVisitPlanInfoExecuteRedisData planInfoExecuteRedisData, Map<String, VisitStepResp> roleVisitStepMap) {
        planInfoExecuteRedisData.setOutStore(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        YesNoEnum.yesNoEnum yesNoEnum2 = YesNoEnum.yesNoEnum.NO;
        if (roleVisitStepMap.containsKey(SfaVisitEnum.SfaStepCode.SFA_STEP_CODE_OUT_STORE.getVal())) {
            CrmBeanUtil.copyPropertiesIgnoreEmpty((Object)((Object)inOutReq), (Object)((Object)planInfoExecuteRedisData));
            yesNoEnum2 = YesNoEnum.yesNoEnum.YES;
            planInfoExecuteRedisData.setFormIdAsOutStore(inOutReq.getFormId());
            planInfoExecuteRedisData.setOutStoreAddress(inOutReq.getAddress());
            planInfoExecuteRedisData.setOutStoreLatitude(inOutReq.getLatitude());
            planInfoExecuteRedisData.setOutStoreLongitude(inOutReq.getLongitude());
            if (null == inOutReq.getVisitInOutPics()) {
                planInfoExecuteRedisData.setVisitOutPics(Lists.newArrayList());
            } else {
                planInfoExecuteRedisData.setVisitOutPics(inOutReq.getVisitInOutPics());
            }
        }
        planInfoExecuteRedisData.setNeedOutStoreStep(yesNoEnum2.getValue());
    }

    private void doVisitOutStore(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData) {
        this.sfaVisitPlanInfoService.dataDurability(sfaVisitPlanInfoEntity, sfaVisitPlanInfoRedisData);
        this.redisService.hmset(sfaVisitPlanInfoRedisData.redisHashCurrent(sfaVisitPlanInfoEntity.getVisitDate(), sfaVisitPlanInfoEntity.getVisitBigType()).toString(), sfaVisitPlanInfoRedisData.buildRedisDataForWrite(), 1296000L);
        this.redisService.hmset(sfaVisitPlanInfoEntity.redisHashCurrent(sfaVisitPlanInfoEntity.getVisitDate(), sfaVisitPlanInfoEntity.getVisitBigType()).toString(), sfaVisitPlanInfoEntity.buildRedisDataForWrite(), 1296000L);
        UserRedis user = UserUtils.getUser();
        SfaAchievementAccomplishRecordReqVo reqVo = (SfaAchievementAccomplishRecordReqVo)CrmBeanUtil.copy((Object)sfaVisitPlanInfoRedisData, SfaAchievementAccomplishRecordReqVo.class);
        reqVo.setRelationId(reqVo.getId()).setIndexCode(SfaVisitEnum.indexType.WDBF.getCode()).setCustomerCode(sfaVisitPlanInfoRedisData.getClientCode()).setUsername(user.getUsername()).setObjectPosCode(user.getPoscode()).setCreateOrgCode(user.getOrgcode());
        AchievementRecordsMQSend.saveAchievementRecordsMQ(reqVo);
    }

    private void buildFormData(SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData) {
        SfaVisitStepFromRespVo fromRespVo;
        SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData = sfaVisitPlanInfoRedisData.getSfaVisitPlanInfoExecuteRedisData();
        String formId = sfaVisitPlanInfoExecuteRedisData.getFormIdAsInStore();
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            fromRespVo = this.sfaVisitStepFromService.queryById(formId);
            if (null == fromRespVo) {
                throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8868\u5355\u914d\u7f6e\u6570\u636e");
            }
            sfaVisitPlanInfoExecuteRedisData.setSfaVisitStepFromAsInStore(fromRespVo);
        }
        if (StringUtils.isNotBlank((CharSequence)(formId = sfaVisitPlanInfoExecuteRedisData.getFormIdAsOutStore()))) {
            fromRespVo = this.sfaVisitStepFromService.queryById(formId);
            if (null == fromRespVo) {
                throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8868\u5355\u914d\u7f6e\u6570\u636e");
            }
            sfaVisitPlanInfoExecuteRedisData.setSfaVisitStepFromAsOutStore(fromRespVo);
        }
        if (StringUtils.isNotBlank((CharSequence)(formId = sfaVisitPlanInfoExecuteRedisData.getFormIdAsSummary()))) {
            fromRespVo = this.sfaVisitStepFromService.queryById(formId);
            if (null == fromRespVo) {
                throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8868\u5355\u914d\u7f6e\u6570\u636e");
            }
            sfaVisitPlanInfoExecuteRedisData.setSfaVisitStepFromAsSummary(fromRespVo);
        }
        sfaVisitPlanInfoExecuteRedisData.setVisitDetailStep(sfaVisitPlanInfoRedisData.summaryStepStatus());
    }

    @Override
    @Transactional
    public void visitOutStore(SfaVisitInOutReq inOutReq) {
        String visitStatusName;
        String visitStatus2;
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(inOutReq.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckPlanInfo(inOutReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        this.visitInfoStatusCheck(sfaVisitPlanInfoEntity);
        Map<String, VisitStepResp> roleVisitStepMap = this.sfaVisitRoleDirectoryService.findRoleVisitStepMap(sfaVisitPlanInfoEntity);
        if (roleVisitStepMap.containsKey(SfaVisitEnum.SfaStepCode.SFA_STEP_CODE_OUT_STORE.getVal())) {
            this.checkSaveParamForInOut(inOutReq, sfaVisitPlanInfoEntity);
        }
        SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData = this.stepStatusCheck(visitRedisHashKey);
        this.injectOutStoreData(inOutReq, sfaVisitPlanInfoRedisData.getSfaVisitPlanInfoExecuteRedisData(), roleVisitStepMap);
        this.buildFormData(sfaVisitPlanInfoRedisData);
        if (SfaVisitEnum.VisitBigType.HELP_VISIT.getVal().equals(sfaVisitPlanInfoEntity.getVisitBigType())) {
            visitStatus2 = SfaVisitEnum.HelpVisitStatus.ALREADY_SUCCESS.getVal();
            visitStatusName = SfaVisitEnum.HelpVisitStatus.ALREADY_SUCCESS.getDesc();
        } else {
            visitStatus2 = SfaVisitEnum.visitStatus.V3.getVal();
            visitStatusName = SfaVisitEnum.visitStatus.V3.getDesc();
        }
        sfaVisitPlanInfoRedisData.setVisitStatus(visitStatus2);
        sfaVisitPlanInfoRedisData.setVisitStatusName(visitStatusName);
        sfaVisitPlanInfoEntity.setVisitStatus(visitStatus2);
        sfaVisitPlanInfoEntity.setVisitStatusName(visitStatusName);
        this.doVisitOutStore(sfaVisitPlanInfoEntity, sfaVisitPlanInfoRedisData);
    }

    @Override
    @Transactional
    public SfaVisitExecuteResp visitInStore(SfaVisitInOutReq inOutReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(inOutReq.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckPlanInfo(inOutReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        this.visitInfoStatusCheck(sfaVisitPlanInfoEntity);
        Map<String, VisitStepResp> roleVisitStepMap = this.sfaVisitRoleDirectoryService.findRoleVisitStepMap(sfaVisitPlanInfoEntity);
        if (roleVisitStepMap.containsKey(SfaVisitEnum.SfaStepCode.SFA_STEP_CODE_IN_STORE.getVal())) {
            this.checkSaveParamForInOut(inOutReq, sfaVisitPlanInfoEntity);
        }
        if (!SfaVisitEnum.visitStatus.V1.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())) {
            SfaVisitPlanInfoRedisData doingData = (SfaVisitPlanInfoRedisData)this.redisService.hmget(SfaVisitPlanInfoRedisData.getInstance().redisHashCurrent(sfaVisitPlanInfoEntity.getVisitDate(), visitRedisHashKey.getVisitBigType()).toString(), (Object)inOutReq.getRedisHashKey());
            SfaVisitExecuteResp executeResp = (SfaVisitExecuteResp)((Object)CrmBeanUtil.copy((Object)((Object)doingData.getSfaVisitPlanInfoExecuteRedisData()), SfaVisitExecuteResp.class));
            executeResp.setSteps(doingData.getStep());
            return executeResp;
        }
        return this.doVisitInStore(inOutReq, sfaVisitPlanInfoEntity, roleVisitStepMap);
    }

    private SfaVisitPlanInfoExecuteRedisData buildExecuteRedisDataVisitBegin(SfaVisitInOutReq inOutReq, SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, Map<String, VisitStepResp> roleVisitStepMap) {
        SfaVisitPlanInfoExecuteRedisData planInfoExecuteRedisData = (SfaVisitPlanInfoExecuteRedisData)((Object)CrmBeanUtil.copy((Object)((Object)inOutReq), SfaVisitPlanInfoExecuteRedisData.class));
        SfaVisitPlanInfoExecuteRedisData.buildDefEntityData((CrmBaseEntity)planInfoExecuteRedisData);
        this.buildExecuteRedisData(sfaVisitPlanInfoEntity, planInfoExecuteRedisData);
        planInfoExecuteRedisData.setInStore(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        YesNoEnum.yesNoEnum yesNoEnum2 = YesNoEnum.yesNoEnum.NO;
        if (roleVisitStepMap.containsKey(SfaVisitEnum.SfaStepCode.SFA_STEP_CODE_IN_STORE.getVal())) {
            CrmBeanUtil.copyPropertiesIgnoreEmpty((Object)((Object)inOutReq), (Object)((Object)planInfoExecuteRedisData));
            planInfoExecuteRedisData.setFormIdAsInStore(inOutReq.getFormId());
            planInfoExecuteRedisData.setInStoreAddress(inOutReq.getAddress());
            planInfoExecuteRedisData.setInStoreLatitude(inOutReq.getLatitude());
            planInfoExecuteRedisData.setInStoreLongitude(inOutReq.getLongitude());
            if (null == inOutReq.getVisitInOutPics()) {
                planInfoExecuteRedisData.setVisitInPics(Lists.newArrayList());
            } else {
                planInfoExecuteRedisData.setVisitInPics(inOutReq.getVisitInOutPics());
            }
            yesNoEnum2 = YesNoEnum.yesNoEnum.YES;
        }
        planInfoExecuteRedisData.setNeedInStoreStep(yesNoEnum2.getValue());
        return planInfoExecuteRedisData;
    }

    private SfaVisitPlanInfoRedisData buildSfaVisitPlanInfoRedisData(SfaVisitInOutReq inOutReq, SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, Map<String, VisitStepResp> roleVisitStepMap) {
        String visitStatusName;
        String visitStatus2;
        SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData = this.buildExecuteRedisDataVisitBegin(inOutReq, sfaVisitPlanInfoEntity, roleVisitStepMap);
        SfaVisitPlanInfoRedisData planInfoRedisData = (SfaVisitPlanInfoRedisData)CrmBeanUtil.copy((Object)sfaVisitPlanInfoEntity, SfaVisitPlanInfoRedisData.class);
        planInfoRedisData.setSfaVisitPlanInfoExecuteRedisData(sfaVisitPlanInfoExecuteRedisData);
        if (SfaVisitEnum.VisitBigType.VISIT.getVal().equals(planInfoRedisData.getVisitBigType())) {
            visitStatus2 = SfaVisitEnum.visitStatus.V2.getVal();
            visitStatusName = SfaVisitEnum.visitStatus.V2.getDesc();
        } else {
            visitStatus2 = SfaVisitEnum.HelpVisitStatus.IN_HELP_DEFENSE.getVal();
            visitStatusName = SfaVisitEnum.HelpVisitStatus.IN_HELP_DEFENSE.getDesc();
        }
        planInfoRedisData.setVisitStatus(visitStatus2);
        planInfoRedisData.setVisitStatusName(visitStatusName);
        List<VisitStepResp> step = roleVisitStepMap.values().stream().filter(v -> !SfaVisitEnum.visitStep.VISIT_STEP_IN_STORE.getVal().equals(v.getPageCode()) && !SfaVisitEnum.visitStep.VISIT_STEP_OUT_STORE.getVal().equals(v.getPageCode())).sorted(Comparator.comparing(VisitStepResp::getSort)).collect(Collectors.toList());
        planInfoRedisData.setStep(step);
        return planInfoRedisData;
    }

    private SfaVisitExecuteResp doVisitInStore(SfaVisitInOutReq inOutReq, SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, Map<String, VisitStepResp> roleVisitStepMap) {
        SfaVisitPlanInfoRedisData planInfoRedisData = this.buildSfaVisitPlanInfoRedisData(inOutReq, sfaVisitPlanInfoEntity, roleVisitStepMap);
        SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData = planInfoRedisData.getSfaVisitPlanInfoExecuteRedisData();
        this.updateClientPoint(sfaVisitPlanInfoEntity, sfaVisitPlanInfoExecuteRedisData);
        String visitDate = sfaVisitPlanInfoEntity.getVisitDate();
        this.redisService.hmset(planInfoRedisData.redisHashCurrent(visitDate, planInfoRedisData.getVisitBigType()).toString(), planInfoRedisData.buildRedisDataForWrite(), 1296000L);
        sfaVisitPlanInfoEntity.setVisitStatus(planInfoRedisData.getVisitStatus());
        sfaVisitPlanInfoEntity.setVisitStatusName(planInfoRedisData.getVisitStatusName());
        this.redisService.hmset(sfaVisitPlanInfoEntity.redisHashCurrent(visitDate, sfaVisitPlanInfoEntity.getVisitBigType()).toString(), sfaVisitPlanInfoEntity.buildRedisDataForWrite(), 1296000L);
        SfaVisitExecuteResp executeResp = (SfaVisitExecuteResp)((Object)CrmBeanUtil.copy((Object)((Object)sfaVisitPlanInfoExecuteRedisData), SfaVisitExecuteResp.class));
        executeResp.setSteps(planInfoRedisData.getStep());
        return executeResp;
    }

    protected void updateClientPoint(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, final SfaVisitPlanInfoExecuteRedisData entity) {
        if (null == sfaVisitPlanInfoEntity.getLatitude() || null == sfaVisitPlanInfoEntity.getLongitude()) {
            if (null == entity.getInStoreLongitude() || null == entity.getInStoreLatitude()) {
                return;
            }
            if (SfaVisitEnum.ClientType.TERMINAL.getVal().equals(sfaVisitPlanInfoEntity.getClientType())) {
                ArrayList updateCoordinateReqVos = Lists.newArrayList((Object[])new UpdateCoordinateReqVo[]{new UpdateCoordinateReqVo(){
                    {
                        this.setTerminalCode(entity.getClientCode());
                        this.setLongitude(entity.getInStoreLongitude().toString());
                        this.setLatitude(entity.getInStoreLatitude().toString());
                    }
                }});
                Result result = this.mdmTerminalFeign.updateCoordinate((List)updateCoordinateReqVos);
                ApiResultUtil.checkResult((Result)result);
            } else {
                ArrayList mdmCustomerMsgReqVos = Lists.newArrayList((Object[])new MdmCustomerMsgReqVo[]{new MdmCustomerMsgReqVo(){
                    {
                        this.setCustomerCode(entity.getClientCode());
                        this.setLongitude(entity.getInStoreLongitude().toString());
                        this.setLatitude(entity.getInStoreLatitude().toString());
                    }
                }});
                Result result = this.mdmCustomerMsgFeign.updateCoordinate((List)mdmCustomerMsgReqVos);
                ApiResultUtil.checkResult((Result)result);
            }
        }
    }

    private void visitInfoStatusCheck(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity) {
        List planInfoEntities = (List)this.redisService.hmValues(sfaVisitPlanInfoEntity.redisHashCurrent(sfaVisitPlanInfoEntity.getVisitDate(), sfaVisitPlanInfoEntity.getVisitBigType()).toString());
        for (SfaVisitPlanInfoEntity planInfoEntity : planInfoEntities) {
            if (SfaVisitEnum.visitStatus.V1.getVal().equals(planInfoEntity.getVisitStatus())) continue;
            if (SfaVisitEnum.visitStatus.V2.getVal().equals(planInfoEntity.getVisitStatus()) && !sfaVisitPlanInfoEntity.getRedisHashKey().equals(planInfoEntity.getRedisHashKey())) {
                throw new BusinessException("[" + planInfoEntity.getClientName() + "]\u6b63\u5728\u62dc\u8bbf\u4e2d\uff0c\u8bf7\u5148\u5b8c\u6210\u8be5\u7f51\u70b9\u7684\u62dc\u8bbf\u4e1a\u52a1\uff01");
            }
            if (!SfaVisitEnum.visitStatus.V3.getVal().equals(planInfoEntity.getVisitStatus()) && !SfaVisitEnum.visitStatus.V4.getVal().equals(planInfoEntity.getVisitStatus()) || !sfaVisitPlanInfoEntity.getRedisHashKey().equals(planInfoEntity.getRedisHashKey())) continue;
            throw new BusinessException("\u8be5\u8ba1\u5212\u5df2\u5b8c\u6210\u6216\u5df2\u6807\u8bb0\u5f02\u5e38\u72b6\u6001\uff01");
        }
    }

    @Override
    public SfaVisitDealerDetailRespVo findVisitInStoreByVisitId(String visitId) {
        SfaVisitDealerDetailEntity sfaVisitDealerDetailEntity = (SfaVisitDealerDetailEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)visitId)).one());
        if (sfaVisitDealerDetailEntity == null) {
            SfaVisitDealerDetailRespVo sfaVisitDealerDetailRespVo = new SfaVisitDealerDetailRespVo();
            sfaVisitDealerDetailRespVo.setPhotoList((List)Lists.newArrayList());
            return sfaVisitDealerDetailRespVo;
        }
        SfaVisitDealerDetailRespVo sfaVisitDealerDetailRespVo = (SfaVisitDealerDetailRespVo)CrmBeanUtil.copy((Object)((Object)sfaVisitDealerDetailEntity), SfaVisitDealerDetailRespVo.class);
        List sfaVisitPictureEntityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sfaVisitPictureService.lambdaQuery().eq(SfaVisitPictureEntity::getBusinessId, (Object)visitId)).eq(SfaVisitPictureEntity::getPicType, (Object)SfaVisitEnum.visitPicType.DEALER_IN_STORE_PIC.getVal())).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)sfaVisitPictureEntityList)) {
            List sfaVisitPictureRespVos = CrmBeanUtil.copyList((List)sfaVisitPictureEntityList, SfaVisitPictureRespVo.class);
            sfaVisitDealerDetailRespVo.setPhotoList(sfaVisitPictureRespVos);
        }
        return sfaVisitDealerDetailRespVo;
    }

    @Override
    public SfaVisitDealerDetailRespVo findVisitOutStoreByVisitId(String visitId) {
        SfaVisitDealerDetailEntity sfaVisitDealerDetailEntity = (SfaVisitDealerDetailEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)visitId)).one());
        if (sfaVisitDealerDetailEntity == null) {
            SfaVisitDealerDetailRespVo sfaVisitDealerDetailRespVo = new SfaVisitDealerDetailRespVo();
            sfaVisitDealerDetailRespVo.setPhotoList((List)Lists.newArrayList());
            return sfaVisitDealerDetailRespVo;
        }
        SfaVisitDealerDetailRespVo sfaVisitDealerDetailRespVo = (SfaVisitDealerDetailRespVo)CrmBeanUtil.copy((Object)((Object)sfaVisitDealerDetailEntity), SfaVisitDealerDetailRespVo.class);
        List sfaVisitPictureEntityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sfaVisitPictureService.lambdaQuery().eq(SfaVisitPictureEntity::getBusinessId, (Object)visitId)).eq(SfaVisitPictureEntity::getPicType, (Object)SfaVisitEnum.visitPicType.DEALER_OUT_STORE_PIC.getVal())).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)sfaVisitPictureEntityList)) {
            List sfaVisitPictureRespVos = CrmBeanUtil.copyList((List)sfaVisitPictureEntityList, SfaVisitPictureRespVo.class);
            sfaVisitDealerDetailRespVo.setPhotoList(sfaVisitPictureRespVos);
        }
        return sfaVisitDealerDetailRespVo;
    }

    @Override
    public SfaVisitDealerDetailRespVo findVisitSummaryByVisitId(String visitId) {
        SfaVisitDealerDetailEntity sfaVisitDealerDetailEntity = (SfaVisitDealerDetailEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)visitId)).one());
        if (sfaVisitDealerDetailEntity == null) {
            return new SfaVisitDealerDetailRespVo();
        }
        SfaVisitDealerDetailRespVo sfaVisitDealerDetailRespVo = (SfaVisitDealerDetailRespVo)CrmBeanUtil.copy((Object)((Object)sfaVisitDealerDetailEntity), SfaVisitDealerDetailRespVo.class);
        return sfaVisitDealerDetailRespVo;
    }

    protected void checkSaveParamForInOut(SfaVisitInOutReq inOutReq, SfaVisitPlanInfoEntity entity) {
        if (StringUtils.isBlank((CharSequence)inOutReq.getFormId())) {
            throw new BusinessException("\u8868\u5355ID\u4e3a\u7a7a");
        }
        AssertUtils.isNotEmpty((String)inOutReq.getRedisHashKey(), (String)"redisHashKey\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)inOutReq.getAddress(), (String)"\u5b9a\u4f4d\u5730\u5740\u4e3a\u7a7a");
        if (null == inOutReq.getLatitude() || null == inOutReq.getLongitude()) {
            throw new BusinessException("\u5b9a\u4f4d\u7ecf\u7eac\u5ea6\u4e3a\u7a7a");
        }
        this.checkPoint(inOutReq, entity);
        List<CrmAttachment> visitInOutPics = inOutReq.getVisitInOutPics();
        if (org.springframework.util.CollectionUtils.isEmpty(visitInOutPics)) {
            throw new BusinessException("\u8fdb\u79bb\u5e97\u6253\u5361\u56fe\u7247\u4e3a\u7a7a");
        }
        if (visitInOutPics.size() > 5) {
            throw new BusinessException("\u8fdb\u79bb\u5e97\u6253\u5361\u56fe\u7247\u4e0d\u80fd\u8d85\u8fc75\u5f20");
        }
    }

    protected void checkPoint(SfaVisitInOutReq inOutReq, SfaVisitPlanInfoEntity entity) {
        SfaVisitStepFromRespVo stepFromEntity;
        if (entity != null && entity.getLatitude() != null && entity.getLatitude() != null && (stepFromEntity = this.sfaVisitStepFromService.queryById(inOutReq.getFormId())) != null && stepFromEntity.getLocateType().equals(YesNoEnum.yesNoEnum.Y.getValue()) && com.biz.crm.util.StringUtils.isNotEmpty((String)stepFromEntity.getDistance())) {
            BigDecimal distance = new BigDecimal(stepFromEntity.getDistance()).setScale(2, 5);
            log.info("\u5f53\u524d\u6b65\u9aa4\u914d\u7f6e\u7684\u8ddd\u79bb:{}", (Object)distance);
            log.info("\u5f53\u524d\u4f4d\u7f6e\u7684\u7ecf\u5ea6:{},\u7eac\u5ea6:{},\u62dc\u8bbf\u5ba2\u6237\u7684\u7ecf\u5ea6:{},\u7eac\u5ea6:{}", new Object[]{inOutReq.getLongitude(), inOutReq.getLatitude(), entity.getLongitude(), entity.getLatitude()});
            double data = LocationUtils.getDistance(inOutReq.getLongitude(), inOutReq.getLatitude(), entity.getLongitude(), entity.getLatitude());
            BigDecimal nowDistance = new BigDecimal(data).setScale(2, 5);
            log.info("\u5f53\u524d\u4f4d\u7f6e\u8ddd\u79bb\u62dc\u8bbf\u5ba2\u6237\u7684\u8ddd\u79bb:{}", (Object)nowDistance);
            if (distance.compareTo(nowDistance) == -1) {
                throw new BusinessException("\u60a8\u672a\u5728\u5ba2\u6237\u8ddd\u79bb" + distance + "M\u5185\uff0c\u8bf7\u524d\u5f80\u5ba2\u6237\u5730\u5740\u8fdb\u884c\u64cd\u4f5c\uff01");
            }
        }
    }

    private void buildExecuteRedisData(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, SfaVisitPlanInfoExecuteRedisData entity) {
        entity.setVisitPlanCode(sfaVisitPlanInfoEntity.getVisitPlanCode());
        UserRedis userRedis = UserUtils.getUser();
        entity.setVisitUserName(userRedis.getUsername());
        entity.setVisitRealName(userRedis.getRealname());
        entity.setVisitPosCode(userRedis.getPoscode());
        entity.setVisitPosName(userRedis.getPosname());
        entity.setCoverHelpOrgCode(sfaVisitPlanInfoEntity.getCoverHelpOrgCode());
        entity.setCoverHelpOrgName(sfaVisitPlanInfoEntity.getCoverHelpOrgName());
        entity.setCoverHelpPosCode(sfaVisitPlanInfoEntity.getCoverHelpPosCode());
        entity.setCoverHelpPosName(sfaVisitPlanInfoEntity.getCoverHelpPosName());
        entity.setCoverHelpRealName(sfaVisitPlanInfoEntity.getCoverHelpRealName());
        entity.setCoverHelpUserName(sfaVisitPlanInfoEntity.getCoverHelpUserName());
        entity.setHelpDefenseId(sfaVisitPlanInfoEntity.getVisitPlanCode());
        entity.setVisitOrgCode(sfaVisitPlanInfoEntity.getVisitOrgCode());
        entity.setVisitOrgName(sfaVisitPlanInfoEntity.getVisitOrgName());
        MdmOrgRespVo mdmOrgRespVo = OrgUtil.getOrgByCode((String)sfaVisitPlanInfoEntity.getVisitOrgCode());
        if (null != mdmOrgRespVo) {
            entity.setVisitParentOrgCode(mdmOrgRespVo.getParentCode());
            entity.setVisitParentOrgName(mdmOrgRespVo.getParentName());
        }
        entity.setVisitType(sfaVisitPlanInfoEntity.getVisitType());
        entity.setVisitTypeName(sfaVisitPlanInfoEntity.getVisitTypeName());
        entity.setVisitBigType(sfaVisitPlanInfoEntity.getVisitBigType());
        entity.setVisitBigTypeName(sfaVisitPlanInfoEntity.getVisitBigTypeName());
        entity.setVisitSort(sfaVisitPlanInfoEntity.getVisitSort());
        entity.setClientCode(sfaVisitPlanInfoEntity.getClientCode());
        entity.setClientAddress(sfaVisitPlanInfoEntity.getClientAddress());
        entity.setClientName(sfaVisitPlanInfoEntity.getClientName());
        entity.setClientPhone(sfaVisitPlanInfoEntity.getClientPhone());
        entity.setClientType(sfaVisitPlanInfoEntity.getClientType());
        entity.setClientTypeName(sfaVisitPlanInfoEntity.getClientTypeName());
        entity.setClientPhoto(sfaVisitPlanInfoEntity.getClientPhoto());
        entity.setVisitDate(sfaVisitPlanInfoEntity.getVisitDate());
        entity.setVisitDateOfYearMonth(sfaVisitPlanInfoEntity.getVisitDateOfYearMonth());
        entity.setVisitDateOfYear(sfaVisitPlanInfoEntity.getVisitDateOfYear());
        entity.setClientSubclass(sfaVisitPlanInfoEntity.getClientSubclass());
        entity.setClientSubclassName(sfaVisitPlanInfoEntity.getClientSubclassName());
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
    }

    @Override
    @Deprecated
    @CrmAPIDiscard
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaVisitDealerDetailReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u6570\u636e\u4e3b\u952e\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitSummary(), (String)"\u62dc\u8bbf\u603b\u7ed3\u4e3a\u7a7a");
        SfaVisitDealerDetailEntity entity = (SfaVisitDealerDetailEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        if (null == entity) {
            throw new BusinessException("\u67e5\u8be2\u62dc\u8bbf\u6570\u636e\u4e3a\u7a7a");
        }
        SfaVisitDealerDetailEntity entityUpdate = new SfaVisitDealerDetailEntity();
        entityUpdate.setId(entity.getId());
        entityUpdate.setVisitSummary(reqVo.getVisitSummary());
        this.updateById((Object)entityUpdate);
    }

    @CrmAPIDiscard
    private void checkUpdateParam(final SfaVisitDealerDetailReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u6570\u636e\u4e3b\u952e\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getOutStore(), (String)"\u79bb\u5e97\u65f6\u95f4\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getOutStoreAddress(), (String)"\u79bb\u5e97\u5730\u5740\u4e3a\u7a7a");
        if (null == reqVo.getOutStoreLatitude() || null == reqVo.getOutStoreLongitude()) {
            throw new BusinessException("\u79bb\u5e97\u5750\u6807\u4e3a\u7a7a");
        }
        final SfaVisitDealerDetailEntity entity = (SfaVisitDealerDetailEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        if (null == entity) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u62dc\u8bbf\u6570\u636e");
        }
        final UserRedis userRedis = UserUtils.getUser();
        SfaVisitRoleConfigReqVo sfaVisitRoleConfigReqVo = new SfaVisitRoleConfigReqVo(){
            {
                this.setVisitType(SfaVisitEnum.sfaVisitType.VISIT.getVal());
                this.setVisitId(reqVo.getId());
                this.setVisitPosCode(userRedis.getPoscode());
                this.setVisitUserName(userRedis.getUsername());
                this.setSfacusType(entity.getClientType());
            }
        };
        String redisHash = null;
        List<SfaVisitRoleDirectoryRespVo> sfaVisitRoleDirectoryRespVos = this.sfaVisitRoleDirectoryService.findVisitRoleDirectoryList(redisHash, null);
        List<SfaVisitRoleDirectoryRespVo> roleDirectoryList = sfaVisitRoleDirectoryRespVos.stream().filter(data -> data.getDoNot().equals(YesNoEnum.YesNoCodeNumberEnum.YES.getCode().toString())).collect(Collectors.toList());
        roleDirectoryList.forEach(data -> {
            if (data.getIsSuccess().equals(YesNoEnum.YesNoCodeNumberEnum.NO.getCode().toString())) {
                throw new BusinessException("\u62dc\u8bbf\u6b65\u9aa4\uff1a" + data.getDirectoryName() + "\u4e3a\u5fc5\u505a\u6b65\u9aa4,\u8bf7\u5b8c\u6210\u5728\u79bb\u5e97\u6253\u5361");
            }
        });
    }

    @Override
    @Transactional
    public SfaVisitExceptionResp visitException(SfaVisitExceptionReq exceptionReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(exceptionReq.getRedisHashKey());
        List<CrmAttachment> visitExceptionPics = exceptionReq.getVisitExceptionPics();
        if (org.springframework.util.CollectionUtils.isEmpty(visitExceptionPics)) {
            throw new BusinessException("\u5f02\u5e38\u63d0\u62a5\u56fe\u7247\u4e3a\u7a7a");
        }
        if (visitExceptionPics.size() > 5) {
            throw new BusinessException("\u5f02\u5e38\u63d0\u62a5\u56fe\u7247\u4e0d\u80fd\u8d85\u8fc75\u5f20");
        }
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckPlanInfo(exceptionReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        if (SfaVisitEnum.visitStatus.V2.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus()) || SfaVisitEnum.visitStatus.V3.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())) {
            throw new BusinessException("\u8be5\u8ba1\u5212\u5df2\u5728\u6267\u884c\u4e2d\u6216\u5df2\u5b8c\u6210\uff01");
        }
        if (SfaVisitEnum.visitStatus.V4.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())) {
            SfaVisitPlanInfoRedisData doingData = (SfaVisitPlanInfoRedisData)this.redisService.hmget(SfaVisitPlanInfoRedisData.getInstance().redisHashCurrent(sfaVisitPlanInfoEntity.getVisitDate(), visitRedisHashKey.getVisitBigType()).toString(), (Object)exceptionReq.getRedisHashKey());
            SfaVisitExceptionResp exceptionResp = (SfaVisitExceptionResp)((Object)CrmBeanUtil.copy((Object)((Object)doingData.getSfaVisitPlanInfoExecuteRedisData()), SfaVisitExceptionResp.class));
            exceptionResp.setVisitExceptionPics(doingData.getSfaVisitPlanInfoExecuteRedisData().getVisitExceptionPics());
            return exceptionResp;
        }
        return this.doVisitException(exceptionReq, sfaVisitPlanInfoEntity, sfaVisitPlanInfoEntity.getVisitDate());
    }

    private SfaVisitExceptionResp doVisitException(SfaVisitExceptionReq exceptionReq, SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, String nowDate) {
        String visitStatusName;
        String visitStatus2;
        SfaVisitPlanInfoExecuteRedisData planInfoExecuteRedisData = new SfaVisitPlanInfoExecuteRedisData();
        this.buildExecuteRedisData(sfaVisitPlanInfoEntity, planInfoExecuteRedisData);
        planInfoExecuteRedisData.setExceptionTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        CrmBeanUtil.copyPropertiesIgnoreEmpty((Object)((Object)exceptionReq), (Object)((Object)planInfoExecuteRedisData));
        if (null == exceptionReq.getVisitExceptionPics()) {
            planInfoExecuteRedisData.setVisitExceptionPics(Lists.newArrayList());
        } else {
            planInfoExecuteRedisData.setVisitExceptionPics(exceptionReq.getVisitExceptionPics());
        }
        SfaVisitPlanInfoRedisData planInfoRedisData = (SfaVisitPlanInfoRedisData)CrmBeanUtil.copy((Object)sfaVisitPlanInfoEntity, SfaVisitPlanInfoRedisData.class);
        planInfoRedisData.setSfaVisitPlanInfoExecuteRedisData(planInfoExecuteRedisData);
        if (SfaVisitEnum.VisitBigType.HELP_VISIT.getVal().equals(sfaVisitPlanInfoEntity.getVisitBigType())) {
            visitStatus2 = SfaVisitEnum.HelpVisitStatus.EX.getVal();
            visitStatusName = SfaVisitEnum.HelpVisitStatus.EX.getDesc();
        } else {
            visitStatus2 = SfaVisitEnum.visitStatus.V4.getVal();
            visitStatusName = SfaVisitEnum.visitStatus.V4.getDesc();
        }
        planInfoRedisData.setVisitStatus(visitStatus2);
        planInfoRedisData.setVisitStatusName(visitStatusName);
        sfaVisitPlanInfoEntity.setVisitStatus(visitStatus2);
        sfaVisitPlanInfoEntity.setVisitStatusName(visitStatusName);
        this.sfaVisitPlanInfoService.dataDurability(sfaVisitPlanInfoEntity, planInfoRedisData);
        this.redisService.hmset(planInfoRedisData.redisHashCurrent(nowDate, sfaVisitPlanInfoEntity.getVisitBigType()).toString(), planInfoRedisData.buildRedisDataForWrite(), 1296000L);
        this.redisService.hmset(sfaVisitPlanInfoEntity.redisHashCurrent(nowDate, sfaVisitPlanInfoEntity.getVisitBigType()).toString(), sfaVisitPlanInfoEntity.buildRedisDataForWrite(), 1296000L);
        SfaVisitExceptionResp exceptionResp = (SfaVisitExceptionResp)((Object)CrmBeanUtil.copy((Object)((Object)planInfoExecuteRedisData), SfaVisitExceptionResp.class));
        exceptionResp.setVisitExceptionPics(planInfoExecuteRedisData.getVisitExceptionPics());
        return exceptionResp;
    }

    private void checkExceptionSave(SfaVisitDealerDetailReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getExceptionTime(), (String)"\u5f02\u5e38\u63d0\u4ea4\u65f6\u95f4\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getExceptionDetail(), (String)"\u5f02\u5e38\u63cf\u8ff0\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getClientCode(), (String)"\u95e8\u5e97\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((Collection)reqVo.getPhotoList(), (String)"\u56fe\u7247\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitPlanCode(), (String)"\u62dc\u8bbf\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitUserName(), (String)"\u62dc\u8bbf\u4eba\u5458\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getClientCode(), (String)"\u62dc\u8bbf\u95e8\u5e97\u4fe1\u606f\u4e3a\u7a7a");
        Date date = new Date();
        Date exceptionTime = null;
        SimpleDateFormat ymd = new SimpleDateFormat("yyyy-MM-dd");
        try {
            String now = ymd.format(date);
            date = ymd.parse(now);
            exceptionTime = ymd.parse(reqVo.getExceptionTime());
        }
        catch (Exception e) {
            throw new BusinessException("\u8f6c\u6362\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
        }
        if (exceptionTime.getTime() != date.getTime()) {
            throw new BusinessException("\u8be5\u62dc\u8bbf\u8ba1\u5212\u4e0d\u662f\u5f53\u524d\u65f6\u95f4\u5185\u7684");
        }
    }

    @Override
    public void deleteBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e3a\u7a7a");
        }
        List sfaVisitDealerDetailEntities = this.sfaVisitDealerDetailMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitDealerDetailEntities)) {
            sfaVisitDealerDetailEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaVisitDealerDetailEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e3a\u7a7a");
        }
        List sfaVisitDealerDetailEntities = this.sfaVisitDealerDetailMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitDealerDetailEntities)) {
            sfaVisitDealerDetailEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaVisitDealerDetailEntities);
    }

    @Override
    public void disableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e3a\u7a7a");
        }
        List sfaVisitDealerDetailEntities = this.sfaVisitDealerDetailMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitDealerDetailEntities)) {
            sfaVisitDealerDetailEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaVisitDealerDetailEntities);
    }

    @Override
    public PageResult<SfaVisitDealerDetailRespVo> findDealerDetailReportList(SfaVisitDealerDetailReqVo reqVo) {
        final String orgCode = UserUtils.getUser().getOrgcode();
        MdmOrgReqVo mdmOrgReqVo = new MdmOrgReqVo(){
            {
                this.setOrgCode(orgCode);
            }
        };
        Result result = this.mdmOrgFeign.findSingleChildrenOrgList(mdmOrgReqVo);
        List orgCodeList = null;
        if (result != null && result.isSuccess() && CollectionUtil.listNotEmptyNotSizeZero((List)((List)result.getResult()))) {
            orgCodeList = ((List)result.getResult()).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
            reqVo.setVisitOrgCodeList(orgCodeList);
        }
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitDealerDetailRespVo> list = this.sfaVisitDealerDetailMapper.findList((Page<SfaVisitDealerDetailRespVo>)page, reqVo);
        list.forEach(data -> {
            SfaVisitPictureReqVo pictureReqVo = new SfaVisitPictureReqVo((SfaVisitDealerDetailRespVo)data){
                final /* synthetic */ SfaVisitDealerDetailRespVo val$data;
                {
                    this.val$data = sfaVisitDealerDetailRespVo;
                    this.setBusinessId(this.val$data.getId());
                }
            };
            List<SfaVisitPictureRespVo> sfaVisitPictureRespVos = this.sfaVisitPictureService.findSfaVisitPictureList(pictureReqVo);
            if (CollectionUtil.listNotEmptyNotSizeZero(sfaVisitPictureRespVos)) {
                data.setPhotoList(sfaVisitPictureRespVos);
            }
        });
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<SfaVisitPlanInfoRespVo> findSfaVisitMapComplete(SfaVisitPlanInfoReqVo reqVo) {
        List<SfaVisitPlanInfoRespVo> sfaVisitPlanInfoRespVoList;
        AssertUtils.isNotEmpty((String)reqVo.getVisitDate(), (String)"\u62dc\u8bbf\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        if (!com.biz.crm.util.StringUtils.isNotEmpty((String)reqVo.getVisitUserName())) {
            String username = UserUtils.getUser().getUsername();
            reqVo.setVisitUserName(username);
        }
        if (!CollectionUtil.listNotEmptyNotSizeZero(sfaVisitPlanInfoRespVoList = this.sfaVisitPlanInfoMapper.findSfaMapList(reqVo))) {
            return null;
        }
        final List customerCodes = sfaVisitPlanInfoRespVoList.stream().filter(data -> data.getClientType().equals(SfaVisitEnum.ClientType.DEALER.getVal())).map(SfaVisitPlanInfoRespVo::getClientCode).collect(Collectors.toList());
        final List terminalCodes = sfaVisitPlanInfoRespVoList.stream().filter(data -> data.getClientType().equals(SfaVisitEnum.ClientType.TERMINAL.getVal())).map(SfaVisitPlanInfoRespVo::getClientCode).collect(Collectors.toList());
        Map<Object, Object> customerMap = new HashMap();
        Map<Object, Object> terminalMap = new HashMap();
        Result customerResult = this.mdmCustomerMsgFeign.customerContactPage(new MdmCustomerContactPageReqVo(){
            {
                this.setCustomerCodeList(customerCodes);
                this.setPageSize(-1);
            }
        });
        Result terminalResult = this.mdmTerminalFeign.terminalContactPage(new MdmTerminalContactPageReqVo(){
            {
                this.setPageSize(-1);
                this.setTerminalCodeList(terminalCodes);
            }
        });
        ArrayList<SfaVisitPlanInfoRespVo> sfaVisitPlanInfoRespVos = new ArrayList<SfaVisitPlanInfoRespVo>();
        if (customerResult.isSuccess() && CollectionUtil.listNotEmptyNotSizeZero((List)((PageResult)customerResult.getResult()).getData())) {
            customerMap = ((PageResult)customerResult.getResult()).getData().stream().collect(Collectors.toMap(MdmCustomerMsgContactPageRespVo::getCustomerCode, Function.identity()));
        }
        if (terminalResult.isSuccess() && CollectionUtil.listNotEmptyNotSizeZero((List)((PageResult)terminalResult.getResult()).getData())) {
            terminalMap = ((PageResult)terminalResult.getResult()).getData().stream().collect(Collectors.toMap(MdmTerminalContactPageVo::getTerminalCode, Function.identity()));
        }
        for (SfaVisitPlanInfoRespVo data2 : sfaVisitPlanInfoRespVoList) {
            MdmTerminalContactPageVo mdmTerminal;
            MdmCustomerMsgContactPageRespVo mdmCustomer;
            if (null != customerMap && customerMap.size() > 0 && customerMap.containsKey(data2.getClientCode()) && com.biz.crm.util.StringUtils.isNotEmpty((String)(mdmCustomer = (MdmCustomerMsgContactPageRespVo)customerMap.get(data2.getClientCode())).getLongitude()) && com.biz.crm.util.StringUtils.isNotEmpty((String)mdmCustomer.getLatitude())) {
                data2.setLongitude(new BigDecimal(mdmCustomer.getLongitude()));
                data2.setLatitude(new BigDecimal(mdmCustomer.getLatitude()));
                sfaVisitPlanInfoRespVos.add(data2);
            }
            if (null == terminalMap || terminalMap.size() <= 0 || !terminalMap.containsKey(data2.getClientCode()) || !com.biz.crm.util.StringUtils.isNotEmpty((String)(mdmTerminal = (MdmTerminalContactPageVo)terminalMap.get(data2.getClientCode())).getLongitude()) || !com.biz.crm.util.StringUtils.isNotEmpty((String)mdmTerminal.getLatitude())) continue;
            data2.setLongitude(new BigDecimal(mdmTerminal.getLongitude()));
            data2.setLatitude(new BigDecimal(mdmTerminal.getLatitude()));
            sfaVisitPlanInfoRespVos.add(data2);
        }
        return sfaVisitPlanInfoRespVos;
    }

    private void updateCustomerAddress(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, final SfaVisitPlanInfoExecuteRedisData entity) {
        if (null == sfaVisitPlanInfoEntity.getLatitude() || null == sfaVisitPlanInfoEntity.getLongitude()) {
            if (null == entity.getInStoreLongitude() || null == entity.getInStoreLatitude()) {
                return;
            }
            ArrayList mdmCustomerMsgReqVos = Lists.newArrayList((Object[])new MdmCustomerMsgReqVo[]{new MdmCustomerMsgReqVo(){
                {
                    this.setCustomerCode(entity.getClientCode());
                    this.setLongitude(entity.getInStoreLongitude().toString());
                    this.setLatitude(entity.getInStoreLatitude().toString());
                }
            }});
            Result result = this.mdmCustomerMsgFeign.updateCoordinate((List)mdmCustomerMsgReqVos);
            ApiResultUtil.checkResult((Result)result);
        }
    }

    @Override
    public MdmCustomerCountRespVo findVisitNumber(MdmCustomerCountReqVo reqVo) {
        MdmCustomerCountRespVo mdmCustomerCountRespVo = new MdmCustomerCountRespVo();
        VisitPlanInfoEsReq req = new VisitPlanInfoEsReq();
        req.setPosCode(reqVo.getPosCode());
        req.setVisitBigType(SfaVisitEnum.VisitBigType.VISIT.getVal());
        req.setStartDate(reqVo.getStartDate());
        req.setEndDate(reqVo.getEndDate());
        Iterable sfaVisitPlanInfoEntities = this.sfaVisitPlanInfoEntityRepositories.search((QueryBuilder)req.buildQuery());
        BigDecimal planVisitNumber = BigDecimal.valueOf(Iterables.size((Iterable)sfaVisitPlanInfoEntities));
        if (null == planVisitNumber) {
            planVisitNumber = BigDecimal.ZERO;
        }
        mdmCustomerCountRespVo.setPlanVisitNumber(planVisitNumber);
        req.setVisitStatus(SfaVisitEnum.visitStatus.V3.getVal());
        Iterable sfaVisitPlanInfoAccomplishEntities = this.sfaVisitPlanInfoEntityRepositories.search((QueryBuilder)req.buildQuery());
        BigDecimal actualVisitNumber = BigDecimal.valueOf(Iterables.size((Iterable)sfaVisitPlanInfoAccomplishEntities));
        if (null == actualVisitNumber) {
            actualVisitNumber = BigDecimal.ZERO;
        }
        mdmCustomerCountRespVo.setActualVisitNumber(actualVisitNumber);
        BigDecimal visitCompletionRate = planVisitNumber.compareTo(BigDecimal.ZERO) > 0 ? actualVisitNumber.divide(planVisitNumber, 4, 4).multiply(new BigDecimal("100").setScale(2)) : BigDecimal.ZERO;
        mdmCustomerCountRespVo.setVisitCompletionRate(visitCompletionRate);
        BigDecimal placeOrderNumber = this.sfaVisitDealerDetailMapper.findPlaceOrderNumber(SfaVisitEnum.visitType.PLAN_VISIT.getVal(), CrmEnableStatusEnum.ENABLE.getCode(), SfaVisitEnum.visitStatus.V3.getVal(), reqVo.getPosCode(), reqVo.getStartDate(), reqVo.getEndDate());
        if (null == placeOrderNumber) {
            placeOrderNumber = BigDecimal.ZERO;
        }
        mdmCustomerCountRespVo.setPlaceOrderNumber(placeOrderNumber);
        BigDecimal salesReachRate = planVisitNumber.compareTo(BigDecimal.ZERO) > 0 ? placeOrderNumber.divide(planVisitNumber, 4, 4).multiply(new BigDecimal("100").setScale(2)) : BigDecimal.ZERO;
        mdmCustomerCountRespVo.setSalesReachRate(salesReachRate);
        List collect = StreamSupport.stream(sfaVisitPlanInfoAccomplishEntities.spliterator(), false).map(SfaVisitPlanInfoEntity::getClientCode).distinct().collect(Collectors.toList());
        BigDecimal visitCustNumber = BigDecimal.ZERO;
        if (CollectionUtil.listNotEmpty(collect)) {
            visitCustNumber = BigDecimal.valueOf(collect.size());
        }
        mdmCustomerCountRespVo.setVisitCustNumber(visitCustNumber);
        List<SfaAchievementTimeTotalRespVo> accomplishNum = this.achievementAccomplishRecordMapper.findPosCodeListAccomplishNum(Collections.singletonList(reqVo.getPosCode()), SfaVisitEnum.indexType.WDBF.getCode(), reqVo.getStartDate(), reqVo.getEndDate());
        BigDecimal visitTotalNumber = BigDecimal.ZERO;
        if (CollectionUtil.listNotEmpty(accomplishNum)) {
            visitTotalNumber = new BigDecimal(accomplishNum.get(0).getAccomplishNum());
        }
        mdmCustomerCountRespVo.setVisitTotalNumber(visitTotalNumber);
        return mdmCustomerCountRespVo;
    }
}

