/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksign.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.assistant.service.ISfaWorkSummaryService;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.checkin.model.SfaCheckInSignRecordPictureEntity;
import com.biz.crm.checkin.service.ISfaCheckInSignRecordPictureService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.eunm.sfa.SfaWorkSignEnum;
import com.biz.crm.eunm.sfa.SfaWorkSummaryEnum;
import com.biz.crm.eunm.sfa.WorkSignEnum;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkSummaryReqVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInSignRecordPictureRespVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaExceptionReportDetailReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaLeaveApplyDetailReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaLeaveApplySummaryReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaMonthSignReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaSignAddRecordSearchReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaSignDetailReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaWorkOvertimeDetailReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaWorkOvertimeSummaryReqVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaExceptionReportDetailRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaLeaveApplyDetailRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaLeaveApplySummaryRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaMonthSignDaysInfoRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaMonthSignRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaMonthWorkSignRecordRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaSignAddRecordInfoRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaSignDetailRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaWorkOvertimeDetailRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaWorkOvertimeSummaryRespVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaApplyTimeInfoReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditListLeaveCancelReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaLeaveCancelReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaTravelReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaAddSignTypeRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaLeaveCancelInfoRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaLeaveCancelRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaLeaveRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaTravelRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkOvertimeRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignRecordRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.SfaSignUtils;
import com.biz.crm.util.UserUtils;
import com.biz.crm.worksign.mapper.SfaLeaveMapper;
import com.biz.crm.worksign.mapper.SfaSignFormsMapper;
import com.biz.crm.worksign.mapper.SfaWorkOvertimeMapper;
import com.biz.crm.worksign.model.SfaExceptionReportEntity;
import com.biz.crm.worksign.model.SfaLeaveCancelEntity;
import com.biz.crm.worksign.model.SfaLeaveEntity;
import com.biz.crm.worksign.model.SfaWorkOvertimeTimeInfoEntity;
import com.biz.crm.worksign.model.SfaWorkSignPictureEntity;
import com.biz.crm.worksign.model.SfaWorkSignRecordEntity;
import com.biz.crm.worksign.model.SfaWorkSignRuleInfoEntity;
import com.biz.crm.worksign.service.ISfaExceptionReportService;
import com.biz.crm.worksign.service.ISfaLeaveCancelService;
import com.biz.crm.worksign.service.ISfaLeaveService;
import com.biz.crm.worksign.service.ISfaSignApplyAttachmentService;
import com.biz.crm.worksign.service.ISfaSignFormsService;
import com.biz.crm.worksign.service.ISfaTravelService;
import com.biz.crm.worksign.service.ISfaWorkOvertimeService;
import com.biz.crm.worksign.service.ISfaWorkOvertimeTimeInfoService;
import com.biz.crm.worksign.service.ISfaWorkSignPictureService;
import com.biz.crm.worksign.service.ISfaWorkSignRecordService;
import com.biz.crm.worksign.service.ISfaWorkSignRuleInfoService;
import com.biz.crm.worksign.service.component.MonthSignReportQueryContext;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class SfaSignFormsServiceImpl
implements ISfaSignFormsService {
    @Resource
    private SfaSignFormsMapper mapper;
    @Resource
    private ISfaWorkOvertimeService overtimeService;
    @Resource
    private SfaWorkOvertimeMapper overtimeMapper;
    @Resource
    private ISfaLeaveService leaveService;
    @Resource
    private ISfaLeaveCancelService cancelService;
    @Resource
    private ISfaWorkOvertimeTimeInfoService sfaWorkOvertimeTimeInfoService;
    @Resource
    private ISfaSignApplyAttachmentService sfaSignApplyAttachmentService;
    @Resource
    private SfaLeaveMapper leaveMapper;
    @Resource
    private ISfaExceptionReportService exceptionService;
    @Resource
    private ISfaTravelService travelService;
    @Resource
    private MdmPositionFeign mdmPositionFeign;
    @Resource
    ISfaLeaveCancelService leaveCancelService;
    @Resource
    ISfaCheckInSignRecordPictureService pictureService;
    @Resource
    ISfaWorkSignRuleInfoService sfaWorkSignRuleInfoService;
    @Resource
    ISfaWorkSignRecordService sfaWorkSignRecordService;
    @Resource
    private ISfaWorkSummaryService sfaWorkSummaryService;
    @Resource
    private ISfaWorkSignPictureService sfaWorkSignPictureService;
    @Resource
    private ISfaCheckInSignRecordPictureService sfaCheckInSignRecordPictureService;
    private static final String PLUS_STR = "+";
    private static final String LEAVE_STATUS_STATIC = "\u8bf7\u5047";
    private static final String WEEKEND_STATUS_STATIC = "\u4f11\u606f";
    private static final String OVERTIME_STATUS_STATIC = "\u52a0\u73ed";

    @Override
    public SfaSignAddRecordInfoRespVo getSignAddRecordInfo(SfaSignAddRecordSearchReqVo sfaSignAddRecordSearchReqVo) {
        if (com.biz.crm.util.StringUtils.isEmpty((String)sfaSignAddRecordSearchReqVo.getPosCode()) || com.biz.crm.util.StringUtils.isEmpty((String)sfaSignAddRecordSearchReqVo.getOrgCode()) || com.biz.crm.util.StringUtils.isEmpty((String)sfaSignAddRecordSearchReqVo.getRuleDate()) || com.biz.crm.util.StringUtils.isEmpty((String)sfaSignAddRecordSearchReqVo.getUserName())) {
            throw new BusinessException("\u4f20\u5165\u53c2\u6570\uff0c\u5b58\u5728\u7a7a\u503c");
        }
        SfaWorkSignRuleInfoEntity ruleInfoEntity = (SfaWorkSignRuleInfoEntity)((Object)this.sfaWorkSignRuleInfoService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaWorkSignRuleInfoEntity.class).eq(SfaWorkSignRuleInfoEntity::getRuleDate, (Object)sfaSignAddRecordSearchReqVo.getRuleDate())).eq(SfaWorkSignRuleInfoEntity::getUserName, (Object)sfaSignAddRecordSearchReqVo.getUserName())).eq(SfaWorkSignRuleInfoEntity::getOrgCode, (Object)sfaSignAddRecordSearchReqVo.getOrgCode())).eq(SfaWorkSignRuleInfoEntity::getPosCode, (Object)sfaSignAddRecordSearchReqVo.getPosCode())));
        if (ruleInfoEntity == null) {
            throw new BusinessException("\u672a\u627e\u5230\u76f8\u5173\u89c4\u5219");
        }
        List recordEntities = this.sfaWorkSignRecordService.list((Wrapper)Wrappers.lambdaQuery(SfaWorkSignRecordEntity.class).eq(SfaWorkSignRecordEntity::getWsRuleInfoId, (Object)ruleInfoEntity.getId()));
        List signTypeRespVos = CrmBeanUtil.copyList((List)recordEntities, SfaAddSignTypeRespVo.class);
        signTypeRespVos.forEach(data -> data.setWorkSignTypeName(SfaWorkSignEnum.WorkSignType.getDesc((String)data.getWorkSignType())));
        SfaSignAddRecordInfoRespVo infoRespVo = (SfaSignAddRecordInfoRespVo)CrmBeanUtil.copy((Object)((Object)ruleInfoEntity), SfaSignAddRecordInfoRespVo.class);
        infoRespVo.setRuleTypeName(SfaWorkSignEnum.WorkSignRuleType.getDesc((String)infoRespVo.getRuleType()));
        infoRespVo.setSfaAddSignTypeRespVoList(signTypeRespVos);
        return infoRespVo;
    }

    @Override
    public List<Map<String, String>> getWorkSignType() {
        List<Map<String, String>> list = this.mapper.getWorkSignType();
        if (CollectionUtil.listEmpty(list)) {
            list = new ArrayList<Map<String, String>>();
        }
        HashMap<String, String> clockInMap = new HashMap<String, String>();
        clockInMap.put("typeKey", SfaWorkSignEnum.WorkSignType.CLOCK_IN.getVal());
        clockInMap.put("typeValue", SfaWorkSignEnum.WorkSignType.CLOCK_IN.getDesc());
        list.add(clockInMap);
        HashMap<String, String> clockOutMap = new HashMap<String, String>();
        clockOutMap.put("typeKey", SfaWorkSignEnum.WorkSignType.CLOCK_OUT.getVal());
        clockOutMap.put("typeValue", SfaWorkSignEnum.WorkSignType.CLOCK_OUT.getDesc());
        list.add(clockOutMap);
        return list;
    }

    @Override
    public SfaSignDetailRespVo getSignInfo(String id, String ruleType) {
        AssertUtils.isNotEmpty((String)id, (String)"\u5165\u53c2id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)ruleType, (String)"\u5165\u53c2ruleType\u4e0d\u80fd\u4e3a\u7a7a");
        SfaSignDetailRespVo signInfo = this.mapper.getSignInfo(id, ruleType);
        if (null == signInfo) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be6\u60c5");
        }
        signInfo.setWorkSignStatusDesc(SfaWorkSignEnum.WorkSignStatus.getDesc((String)signInfo.getWorkSignStatus()));
        signInfo.setRuleTypeDesc(SfaWorkSignEnum.WorkSignRuleType.getDesc((String)signInfo.getRuleType()));
        if (com.biz.crm.util.StringUtils.isNotEmpty((String)signInfo.getWorkSignTime())) {
            signInfo.setWorkSignTime(signInfo.getRuleDate() + " " + signInfo.getWorkSignTime());
        } else {
            signInfo.setWorkSignTime(signInfo.getRuleDate());
        }
        if (SfaWorkSignEnum.WorkSignRuleType.FREE.getVal().equals(ruleType)) {
            List pictureEntities = this.sfaCheckInSignRecordPictureService.list((Wrapper)Wrappers.lambdaQuery(SfaCheckInSignRecordPictureEntity.class).eq(SfaCheckInSignRecordPictureEntity::getSignRecordId, (Object)id));
            List recordPictureRespVos = CrmBeanUtil.copyList((List)pictureEntities, SfaCheckInSignRecordPictureRespVo.class);
            signInfo.setSignPictures(recordPictureRespVos);
        } else {
            List pictureEntities = this.sfaWorkSignPictureService.list((Wrapper)Wrappers.lambdaQuery(SfaWorkSignPictureEntity.class).eq(SfaWorkSignPictureEntity::getWsRecordId, (Object)id));
            List recordPictureRespVos = CrmBeanUtil.copyList((List)pictureEntities, SfaCheckInSignRecordPictureRespVo.class);
            signInfo.setSignPictures(recordPictureRespVos);
        }
        signInfo.setWsPlaceStatus(SfaWorkSignEnum.wsPlaceStatusEnum.getDesc((String)signInfo.getWsPlaceStatus()));
        return signInfo;
    }

    @Override
    public PageResult<SfaSignDetailRespVo> signDetail(SfaSignDetailReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        reqVo.setRuleDateRange(LocalDate.now().format(CrmDateUtils.yyyyMMdd));
        List<SfaSignDetailRespVo> list = this.mapper.signDetail((Page<SfaSignDetailRespVo>)page, reqVo);
        if (list != null && list.size() > 0) {
            list.forEach(vo -> {
                vo.setWorkSignStatusDesc(SfaWorkSignEnum.WorkSignStatus.getDesc((String)vo.getWorkSignStatus()));
                vo.setRuleTypeDesc(SfaWorkSignEnum.WorkSignRuleType.getDesc((String)vo.getRuleType()));
                if (com.biz.crm.util.StringUtils.isNotEmpty((String)vo.getWorkSignTime())) {
                    vo.setWorkSignTime(vo.getRuleDate() + " " + vo.getWorkSignTime());
                } else {
                    vo.setWorkSignTime(vo.getRuleDate());
                }
                vo.setWsPlaceStatus(SfaWorkSignEnum.wsPlaceStatusEnum.getDesc((String)vo.getWsPlaceStatus()));
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    protected Map<String, SfaMonthSignRespVo> getUserMap(List<SfaMonthSignRespVo> list, SfaMonthSignReqVo reqVo) {
        String nowDay = new Integer(LocalDate.now().getDayOfMonth()).toString();
        LocalDate localDate = LocalDate.parse(reqVo.getYearMonth() + "-01");
        if (LocalDate.now().getMonthValue() != localDate.getMonthValue()) {
            nowDay = localDate.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth() + "";
        }
        HashMap<String, SfaMonthSignRespVo> userInfoMap = new HashMap<String, SfaMonthSignRespVo>();
        for (SfaMonthSignRespVo vo : list) {
            userInfoMap.put(vo.getUserName(), vo);
            vo.setNowDay(nowDay);
        }
        return userInfoMap;
    }

    protected MonthSignReportQueryContext loadMonthSignReportQueryContext(List<SfaMonthSignRespVo> list, SfaMonthSignReqVo reqVo) {
        Map<Object, Object> leaveIdDayMapOfLeaveCancel;
        MonthSignReportQueryContext context = new MonthSignReportQueryContext();
        context.setYearMonth(reqVo.getYearMonth());
        Map<String, SfaMonthSignRespVo> userInfoMap = this.getUserMap(list, reqVo);
        ArrayList<String> userNames = new ArrayList<String>(userInfoMap.keySet());
        Map<String, Map<String, SfaMonthWorkSignRecordRespVo>> userDayMapOfClockIn = this.mapper.monthSignDaysInfo(context.getYearMonth(), SfaWorkSignEnum.WorkSignType.CLOCK_IN.getVal(), userNames).stream().collect(Collectors.groupingBy(v -> v.getUserName() + v.getRuleDate(), Collectors.toMap(SfaMonthWorkSignRecordRespVo::getSfaSignTimeId, v -> v, (SfaMonthWorkSignRecordRespVo2, sfaMonthSignDaysInfoRespVo2) -> sfaMonthSignDaysInfoRespVo2)));
        Map<String, Map<String, SfaMonthWorkSignRecordRespVo>> userDayMapOfClockOut = this.mapper.monthSignDaysInfo(context.getYearMonth(), SfaWorkSignEnum.WorkSignType.CLOCK_OUT.getVal(), userNames).stream().collect(Collectors.groupingBy(v -> v.getUserName() + v.getRuleDate(), Collectors.toMap(SfaMonthWorkSignRecordRespVo::getSfaSignTimeId, v -> v, (SfaMonthWorkSignRecordRespVo2, sfaMonthSignDaysInfoRespVo2) -> sfaMonthSignDaysInfoRespVo2)));
        List leaveEntities = this.leaveMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaLeaveEntity.class).in(SfaLeaveEntity::getUserName, userNames)).ge(SfaLeaveEntity::getBeginTime, (Object)context.getBeginDate())).le(SfaLeaveEntity::getEndTime, (Object)context.getEndDate())).eq(SfaLeaveEntity::getBpmStatus, (Object)SfaCommonEnum.dataBpmStatus.PASS.getValue()));
        Map<String, MonthSignReportQueryContext.LeaveDetail> userDayMapOfLeave = this.resolveLeaveDetail(leaveEntities);
        if (leaveEntities.size() > 0) {
            List cancelEntities = ((LambdaQueryChainWrapper)this.cancelService.lambdaQuery().in(SfaLeaveCancelEntity::getLeaveId, (Collection)leaveEntities.stream().map(BaseIdEntity::getId).collect(Collectors.toList()))).list();
            leaveIdDayMapOfLeaveCancel = this.resolveLeaveCancelDetail(cancelEntities);
        } else {
            leaveIdDayMapOfLeaveCancel = Maps.newHashMap();
        }
        List overtimeTimeInfoEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sfaWorkOvertimeTimeInfoService.lambdaQuery().in(SfaWorkOvertimeTimeInfoEntity::getUserName, userNames)).between(SfaWorkOvertimeTimeInfoEntity::getOvertimeDate, (Object)context.getBeginDate(), (Object)context.getEndDate())).list();
        Map<String, MonthSignReportQueryContext.OvertimeTimeInfoDetail> userDayMapOfOvertimeTime = this.resolveOvertimeTimeInfoDetail(overtimeTimeInfoEntities);
        context.setUserInfoMap(userInfoMap);
        context.setUserDayMapOfClockIn(userDayMapOfClockIn);
        context.setUserDayMapOfClockOut(userDayMapOfClockOut);
        context.setUserDayMapOfLeave(userDayMapOfLeave);
        context.setLeaveIdDayMapOfLeaveCancel(leaveIdDayMapOfLeaveCancel);
        context.setUserDayMapOfOvertimeTime(userDayMapOfOvertimeTime);
        return context;
    }

    protected Map<String, SfaExceptionReportEntity> resolveUserDayMapOfExceptionReport(List<SfaExceptionReportEntity> exceptionReportEntities) {
        HashMap userDayMapOfExceptionReport = Maps.newHashMap();
        for (SfaExceptionReportEntity exceptionReportEntity : exceptionReportEntities) {
            LocalDate localDate;
            LocalDate begin = LocalDate.parse(exceptionReportEntity.getBeginTime(), CrmDateUtils.yyyyMMdd);
            LocalDate end = LocalDate.parse(exceptionReportEntity.getEndTime(), CrmDateUtils.yyyyMMdd);
            int i = 0;
            while ((localDate = begin.plusDays(i)).compareTo(end) <= 0) {
                String userDay = exceptionReportEntity.getUserName() + localDate.format(CrmDateUtils.yyyyMMdd);
                userDayMapOfExceptionReport.put(userDay, exceptionReportEntity);
                ++i;
            }
        }
        return userDayMapOfExceptionReport;
    }

    protected Map<String, MonthSignReportQueryContext.OvertimeTimeInfoDetail> resolveOvertimeTimeInfoDetail(List<SfaWorkOvertimeTimeInfoEntity> overtimeTimeInfoEntities) {
        HashMap userDayMapOfOvertimeTime = Maps.newHashMap();
        for (SfaWorkOvertimeTimeInfoEntity overtimeTimeInfoEntity : overtimeTimeInfoEntities) {
            MonthSignReportQueryContext.OvertimeTimeInfoDetail leaveDetail = MonthSignReportQueryContext.OvertimeTimeInfoDetail.build(overtimeTimeInfoEntity);
            String userDay = leaveDetail.getUserName() + leaveDetail.getLeaveDate();
            MonthSignReportQueryContext.OvertimeTimeInfoDetail leaveDetailResolved = (MonthSignReportQueryContext.OvertimeTimeInfoDetail)userDayMapOfOvertimeTime.get(userDay);
            if (null != leaveDetailResolved) {
                leaveDetail = MonthSignReportQueryContext.OvertimeTimeInfoDetail.merge(leaveDetailResolved, leaveDetail);
            }
            userDayMapOfOvertimeTime.put(userDay, leaveDetail);
        }
        return userDayMapOfOvertimeTime;
    }

    protected Map<String, MonthSignReportQueryContext.LeaveDetail> resolveLeaveDetail(List<SfaLeaveEntity> leaveEntities) {
        HashMap userDayMapOfLeave = Maps.newHashMap();
        for (SfaLeaveEntity leaveEntity : leaveEntities) {
            List timeInfoList = SfaSignUtils.fillTimeInfo((List)JSON.parseArray((String)leaveEntity.getTimeInfoListJson(), SfaApplyTimeInfoReqVo.class), (String)leaveEntity.getBeginTime(), (String)leaveEntity.getEndTime());
            for (SfaApplyTimeInfoReqVo timeInfoReqVo : timeInfoList) {
                MonthSignReportQueryContext.LeaveDetail leaveDetail = MonthSignReportQueryContext.LeaveDetail.build(timeInfoReqVo, leaveEntity);
                String userDay = leaveDetail.getUserName() + leaveDetail.getLeaveDate();
                MonthSignReportQueryContext.LeaveDetail leaveDetailResolved = (MonthSignReportQueryContext.LeaveDetail)userDayMapOfLeave.get(userDay);
                if (null != leaveDetailResolved) {
                    leaveDetail = MonthSignReportQueryContext.LeaveDetail.merge(leaveDetailResolved, leaveDetail);
                }
                userDayMapOfLeave.put(userDay, leaveDetail);
            }
        }
        return userDayMapOfLeave;
    }

    protected Map<String, MonthSignReportQueryContext.LeaveCancelDetail> resolveLeaveCancelDetail(List<SfaLeaveCancelEntity> leaveCancelEntities) {
        HashMap userDayMapOfLeave = Maps.newHashMap();
        for (SfaLeaveCancelEntity leaveCancelEntity : leaveCancelEntities) {
            List timeInfoList = SfaSignUtils.fillTimeInfo((List)JSON.parseArray((String)leaveCancelEntity.getTimeInfoListJson(), SfaApplyTimeInfoReqVo.class), (String)leaveCancelEntity.getBeginTime(), (String)leaveCancelEntity.getEndTime());
            for (SfaApplyTimeInfoReqVo timeInfoReqVo : timeInfoList) {
                MonthSignReportQueryContext.LeaveCancelDetail leaveDetail = MonthSignReportQueryContext.LeaveCancelDetail.build(timeInfoReqVo, leaveCancelEntity);
                String leaveIdDay = leaveDetail.getLeaveId() + leaveDetail.getLeaveDate();
                MonthSignReportQueryContext.LeaveCancelDetail leaveDetailResolved = (MonthSignReportQueryContext.LeaveCancelDetail)userDayMapOfLeave.get(leaveIdDay);
                if (null != leaveDetailResolved) {
                    leaveDetail = MonthSignReportQueryContext.LeaveCancelDetail.merge(leaveDetailResolved, leaveDetail);
                }
                userDayMapOfLeave.put(leaveIdDay, leaveDetail);
            }
        }
        return userDayMapOfLeave;
    }

    @Override
    public PageResult<SfaMonthSignRespVo> monthSign(SfaMonthSignReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaMonthSignRespVo> list = this.mapper.monthSignUserInfoForPage((Page<SfaMonthSignRespVo>)page, reqVo);
        this.loadMonthSignDetail(list, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<SfaMonthSignRespVo> monthSignListByUsers(SfaMonthSignReqVo reqVo) {
        List<SfaMonthSignRespVo> list = this.mapper.monthSignUserInfoForUser(reqVo);
        this.loadMonthSignDetail(list, reqVo);
        return list;
    }

    protected void loadMonthSignDetail(List<SfaMonthSignRespVo> list, SfaMonthSignReqVo reqVo) {
        if (list != null && list.size() > 0) {
            MonthSignReportQueryContext context = this.loadMonthSignReportQueryContext(list, reqVo);
            Map<String, Map<String, SfaMonthWorkSignRecordRespVo>> userDayMapOfClockIn = context.getUserDayMapOfClockIn();
            Map<String, Map<String, SfaMonthWorkSignRecordRespVo>> userDayMapOfClockOut = context.getUserDayMapOfClockOut();
            Map<String, MonthSignReportQueryContext.OvertimeTimeInfoDetail> userDayMapOfOvertimeTime = context.getUserDayMapOfOvertimeTime();
            Map<String, SfaMonthSignRespVo> userInfoMap = context.getUserInfoMap();
            userDayMapOfClockIn.forEach((userDay, clockInMap) -> {
                Map clockOutMap = (Map)userDayMapOfClockOut.get(userDay);
                if (null == clockOutMap) {
                    throw new BusinessException("\u6570\u636e\u5f02\u5e38\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u7b7e\u9000\u8003\u52e4\u8bb0\u5f55");
                }
                List<SfaMonthSignDaysInfoRespVo> daysInfoRespVos = this.collectSignDaysInfo(context, (Map<String, SfaMonthWorkSignRecordRespVo>)clockInMap, clockOutMap, (String)userDay);
                if (daysInfoRespVos.size() == 0) {
                    return;
                }
                MonthSignReportQueryContext.OvertimeTimeInfoDetail overtimeTimeInfoDetail = (MonthSignReportQueryContext.OvertimeTimeInfoDetail)userDayMapOfOvertimeTime.get(userDay);
                String overtimeType = null;
                if (null != overtimeTimeInfoDetail) {
                    overtimeType = overtimeTimeInfoDetail.getTimeType();
                }
                SfaMonthSignDaysInfoRespVo daysInfoRespVoTemp = daysInfoRespVos.get(0);
                int dayOfMonth = LocalDate.parse(daysInfoRespVoTemp.getRuleDate()).getDayOfMonth();
                String leaveTypeOfDay = this.getLeaveType(context, daysInfoRespVoTemp.getRuleDate(), (String)userDay);
                SfaMonthSignRespVo monthSign = (SfaMonthSignRespVo)userInfoMap.get(daysInfoRespVoTemp.getUserName());
                String signMust = null;
                for (SfaMonthSignDaysInfoRespVo daysInfoRespVo : daysInfoRespVos) {
                    signMust = daysInfoRespVo.getSignMust();
                    if (YesNoEnum.yesNoEnum.YES.getValue().equals(signMust)) {
                        if (WorkSignEnum.signOrNonType.SPECIAL_DAY_NO_SIGN.getValue().equals(daysInfoRespVo.getSignOrNonType())) {
                            daysInfoRespVo.setCiSignTime(daysInfoRespVo.getGotoTime());
                            daysInfoRespVo.setCoSignTime(daysInfoRespVo.getGooffTime());
                            daysInfoRespVo.setCiSignStatus(SfaWorkSignEnum.WorkSignStatus.OK.getVal());
                            daysInfoRespVo.setCoSignStatus(SfaWorkSignEnum.WorkSignStatus.OK.getVal());
                        }
                        this.signRuleStatus(monthSign, daysInfoRespVo, leaveTypeOfDay);
                        continue;
                    }
                    if (!com.biz.crm.util.StringUtils.isNotEmpty((String)overtimeType)) continue;
                    this.countingWorkTimes(monthSign, daysInfoRespVo, dayOfMonth);
                }
                if (YesNoEnum.yesNoEnum.YES.getValue().equals(signMust)) {
                    if (SfaCommonEnum.dataTimeType.ALL_DAY.getValue().equals(leaveTypeOfDay)) {
                        monthSign.addLeaveDays(BigDecimal.ONE);
                    } else if (SfaCommonEnum.dataTimeType.FORENOON.getValue().equals(leaveTypeOfDay)) {
                        monthSign.addLeaveDays(new BigDecimal(0.5));
                    } else if (SfaCommonEnum.dataTimeType.AFTERNOON.getValue().equals(leaveTypeOfDay)) {
                        monthSign.addLeaveDays(new BigDecimal(0.5));
                    }
                    this.countingLeaveStatus(monthSign, daysInfoRespVos, leaveTypeOfDay);
                } else {
                    this.nonSifnRuleStatus(monthSign, dayOfMonth, overtimeType);
                    if (StringUtils.isNotBlank((CharSequence)overtimeType)) {
                        this.countingSingDays(monthSign, daysInfoRespVos);
                    }
                }
            });
        }
    }

    protected void countingStatus(SfaMonthSignRespVo monthSign, SfaMonthSignDaysInfoRespVo dayInfo, String leaveType, int dayOfMonth) {
        String statusStr = SfaWorkSignEnum.SignRuleStatus.getDesc((String)dayInfo.signStatus());
        if (SfaCommonEnum.dataTimeType.ALL_DAY.getValue().equals(leaveType)) {
            statusStr = LEAVE_STATUS_STATIC;
        } else if (SfaCommonEnum.dataTimeType.FORENOON.getValue().equals(leaveType)) {
            statusStr = "\u8bf7\u5047+" + statusStr;
        } else if (SfaCommonEnum.dataTimeType.AFTERNOON.getValue().equals(leaveType)) {
            statusStr = statusStr + PLUS_STR + LEAVE_STATUS_STATIC;
        }
        this.setMonthSignValue(monthSign, "day" + dayOfMonth, statusStr, ",");
    }

    protected void countingLeaveStatus(SfaMonthSignRespVo monthSign, List<SfaMonthSignDaysInfoRespVo> daysInfoRespVos, String leaveType) {
        if (StringUtils.isNotBlank((CharSequence)leaveType)) {
            return;
        }
        boolean absenteeism = false;
        for (SfaMonthSignDaysInfoRespVo daysInfoRespVo : daysInfoRespVos) {
            monthSign.addGoToWorkDaysl(BigDecimal.ONE);
            String signStatus = daysInfoRespVo.signStatus();
            if (SfaWorkSignEnum.SignRuleStatus.LATE.getVal().equals(signStatus)) {
                monthSign.addLateDays(1);
            }
            if (SfaWorkSignEnum.SignRuleStatus.EARLY.getVal().equals(signStatus)) {
                monthSign.addEarlyDays(1);
            }
            if (SfaWorkSignEnum.SignRuleStatus.LATE_EARLY.getVal().equals(signStatus)) {
                monthSign.addLateDays(1);
                monthSign.addEarlyDays(1);
            }
            if (!SfaWorkSignEnum.SignRuleStatus.MORNING_TRUANCY.getVal().equals(signStatus) && !SfaWorkSignEnum.SignRuleStatus.MORNING_EARLY.getVal().equals(signStatus) && !SfaWorkSignEnum.SignRuleStatus.MORNING_NIGHT.getVal().equals(signStatus) && !SfaWorkSignEnum.SignRuleStatus.NIGHT_TRUANCY.getVal().equals(signStatus) && !SfaWorkSignEnum.SignRuleStatus.NIGHT_LATE.getVal().equals(signStatus)) continue;
            absenteeism = true;
        }
        if (absenteeism) {
            monthSign.addAbsenteeismDays(BigDecimal.ONE);
        }
        this.countingSingDays(monthSign, daysInfoRespVos);
    }

    protected void countingSingDays(SfaMonthSignRespVo monthSign, List<SfaMonthSignDaysInfoRespVo> daysInfoRespVos) {
        boolean normal = true;
        for (SfaMonthSignDaysInfoRespVo daysInfoRespVo : daysInfoRespVos) {
            String signStatus = daysInfoRespVo.signStatus();
            if (SfaWorkSignEnum.SignRuleStatus.ATTENDANCE.getVal().equals(signStatus)) continue;
            normal = false;
        }
        if (normal) {
            monthSign.addNormal(BigDecimal.ONE);
        }
    }

    protected List<SfaMonthSignDaysInfoRespVo> collectSignDaysInfo(MonthSignReportQueryContext context, Map<String, SfaMonthWorkSignRecordRespVo> clockInMap, Map<String, SfaMonthWorkSignRecordRespVo> clockOutMap, String userDay) {
        ArrayList daysInfoRespVos = Lists.newArrayList();
        clockInMap.forEach((sfaSignTimeId, clockIn) -> {
            SfaMonthWorkSignRecordRespVo clockOut = (SfaMonthWorkSignRecordRespVo)clockOutMap.get(sfaSignTimeId);
            if (null == clockOut) {
                throw new BusinessException("\u6570\u636e\u5f02\u5e38\uff0c\u6ca1\u6709\u67e5\u8be2\u5230[" + userDay + "]\u7684\u7b7e\u9000\u8003\u52e4\u8bb0\u5f55");
            }
            SfaMonthSignDaysInfoRespVo vo = (SfaMonthSignDaysInfoRespVo)CrmBeanUtil.copy((Object)clockIn, SfaMonthSignDaysInfoRespVo.class);
            vo.setCiSignTime(clockIn.getWorkSignTime());
            vo.setCiSignStatus(clockIn.getWorkSignStatus());
            vo.setGotoTime(clockIn.getSfaSignTime());
            vo.setCoSignTime(clockOut.getWorkSignTime());
            vo.setCoSignStatus(clockOut.getWorkSignStatus());
            vo.setGooffTime(clockOut.getSfaSignTime());
            daysInfoRespVos.add(vo);
        });
        return daysInfoRespVos.stream().sorted(new Comparator<SfaMonthSignDaysInfoRespVo>(){

            @Override
            public int compare(SfaMonthSignDaysInfoRespVo o1, SfaMonthSignDaysInfoRespVo o2) {
                String time2;
                String time1 = o1.getGotoTime();
                if (StringUtils.isBlank((CharSequence)time1)) {
                    time1 = "00:00:00";
                }
                if (StringUtils.isBlank((CharSequence)(time2 = o2.getGotoTime()))) {
                    time2 = "00:00:00";
                }
                LocalTime gotoTime1 = LocalTime.parse(time1, CrmDateUtils.HHmmss);
                LocalTime gotoTime2 = LocalTime.parse(time2, CrmDateUtils.HHmmss);
                return gotoTime2.compareTo(gotoTime1);
            }
        }).collect(Collectors.toList());
    }

    protected String getLeaveType(MonthSignReportQueryContext context, String ruleDate, String userDay) {
        MonthSignReportQueryContext.LeaveDetail leaveDetail = context.getUserDayMapOfLeave().get(userDay);
        if (null == leaveDetail) {
            return null;
        }
        Map<String, MonthSignReportQueryContext.LeaveCancelDetail> leaveIdDayMapOfLeaveCancel = context.getLeaveIdDayMapOfLeaveCancel();
        MonthSignReportQueryContext.LeaveCancelDetail leaveCancelDetail = leaveIdDayMapOfLeaveCancel.get(leaveDetail.getLeaveId() + ruleDate);
        String leaveType = leaveDetail.getLeaveType();
        String cancelType = null;
        if (null != leaveCancelDetail) {
            cancelType = leaveCancelDetail.getLeaveType();
        }
        if (com.biz.crm.util.StringUtils.isEmpty((String)leaveType)) {
            return null;
        }
        if (leaveType.equals(cancelType)) {
            return null;
        }
        if (com.biz.crm.util.StringUtils.isEmpty((String)cancelType)) {
            return leaveType;
        }
        if (SfaCommonEnum.dataTimeType.FORENOON.getValue().equals(cancelType)) {
            return SfaCommonEnum.dataTimeType.AFTERNOON.getValue();
        }
        return SfaCommonEnum.dataTimeType.FORENOON.getValue();
    }

    protected void signRuleStatus(SfaMonthSignRespVo monthSign, SfaMonthSignDaysInfoRespVo dayInfo, String leaveType) {
        int dayOfMonth = LocalDate.parse(dayInfo.getRuleDate()).getDayOfMonth();
        this.countingStatus(monthSign, dayInfo, leaveType, dayOfMonth);
        this.countingWorkTimes(monthSign, dayInfo, dayOfMonth);
    }

    protected void countingWorkTimes(SfaMonthSignRespVo monthSign, SfaMonthSignDaysInfoRespVo dayInfo, int dayOfMonth) {
        if (com.biz.crm.util.StringUtils.isNotEmpty((String)dayInfo.getCiSignTime()) && com.biz.crm.util.StringUtils.isNotEmpty((String)dayInfo.getCoSignTime())) {
            long time = ChronoUnit.MINUTES.between(LocalTime.parse(dayInfo.getCiSignTime()), LocalTime.parse(dayInfo.getCoSignTime()));
            int hour = (int)time / 6;
            float endTime = (float)hour / 10.0f;
            BigDecimal dayTime = new BigDecimal(endTime + "");
            monthSign.addAllTimes(dayTime);
            this.setMonthSignValue(monthSign, "dayTime" + dayOfMonth, dayTime, PLUS_STR);
        }
    }

    protected void nonSifnRuleStatus(SfaMonthSignRespVo monthSign, int dayOfMonth, String overtimeType) {
        String statusStr = WEEKEND_STATUS_STATIC;
        if (SfaCommonEnum.dataTimeType.ALL_DAY.getValue().equals(overtimeType)) {
            statusStr = OVERTIME_STATUS_STATIC;
            monthSign.addOvertimeDays(new BigDecimal(1));
        } else if (SfaCommonEnum.dataTimeType.FORENOON.getValue().equals(overtimeType)) {
            statusStr = "\u52a0\u73ed+" + statusStr;
            monthSign.addOvertimeDays(new BigDecimal(0.5));
            monthSign.addOffDays(new BigDecimal(0.5));
        } else if (SfaCommonEnum.dataTimeType.AFTERNOON.getValue().equals(overtimeType)) {
            statusStr = statusStr + PLUS_STR + OVERTIME_STATUS_STATIC;
            monthSign.addOvertimeDays(new BigDecimal(0.5));
            monthSign.addOffDays(new BigDecimal(0.5));
        } else {
            monthSign.addOffDays(BigDecimal.ONE);
        }
        this.setMonthSignValue(monthSign, "day" + dayOfMonth, statusStr, ",");
    }

    private void setMonthSignValue(SfaMonthSignRespVo monthSign, String key, Object value, String delimiter) {
        if (null == value) {
            return;
        }
        try {
            Class<?> c = monthSign.getClass();
            Field f = c.getDeclaredField(key);
            f.setAccessible(true);
            Object object = f.get(monthSign);
            if (null != object) {
                value = object.toString() + delimiter + value.toString();
            }
            f.set(monthSign, value.toString());
        }
        catch (Exception e) {
            throw new BusinessException("\u8003\u52e4\u540e\u53f0\u62a5\u9519", (Throwable)e);
        }
    }

    @Override
    public PageResult<SfaLeaveApplyDetailRespVo> leaveApplyDetail(SfaLeaveApplyDetailReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaLeaveApplyDetailRespVo> list = this.leaveMapper.leaveApplyDetail((Page<SfaLeaveApplyDetailRespVo>)page, reqVo);
        if (list != null && list.size() > 0) {
            List ids = list.stream().map(SfaLeaveApplyDetailRespVo::getId).collect(Collectors.toList());
            SfaLeaveCancelReqVo param = new SfaLeaveCancelReqVo();
            param.setLeaveIdList(ids);
            Map<String, List<SfaLeaveCancelRespVo>> cancelMap = this.leaveCancelService.findList(param).stream().collect(Collectors.groupingBy(SfaLeaveCancelRespVo::getLeaveId));
            list.forEach(vo -> {
                List temp = (List)cancelMap.get(vo.getId());
                if (null == temp) {
                    temp = Lists.newArrayList();
                }
                vo.setLeaveCancelRespVo(temp);
                vo.setBpmStatusName(SfaCommonEnum.dataBpmStatus.getDesc((String)vo.getBpmStatus()));
                vo.setLeaveTypeName(SfaCommonEnum.leaveTypeEnum.getDesc((String)vo.getLeaveType()));
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaLeaveApplySummaryRespVo> leaveApplySummary(SfaLeaveApplySummaryReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaLeaveApplySummaryRespVo> summarylist = this.leaveMapper.leaveApplySummary((Page<SfaLeaveApplySummaryRespVo>)page, reqVo);
        if (summarylist != null && summarylist.size() > 0) {
            Map<String, MdmPositionUserOrgRespVo> mdmUserMap = this.getUserOrgInfoByUserNames(summarylist.stream().map(SfaLeaveApplySummaryRespVo::getUserName).collect(Collectors.toList()));
            SfaLeaveApplyDetailReqVo detailReqVo = (SfaLeaveApplyDetailReqVo)CrmBeanUtil.copy((Object)reqVo, SfaLeaveApplyDetailReqVo.class);
            detailReqVo.setBeginTime(reqVo.getLeaveDateStart());
            detailReqVo.setEndTime(reqVo.getLeaveDateEnd());
            detailReqVo.setBpmStatus(SfaCommonEnum.dataBpmStatus.PASS.getValue());
            List<SfaLeaveApplyDetailRespVo> detailRespVoList = this.leaveMapper.leaveApplyDetail(null, detailReqVo);
            Map<String, List<SfaLeaveApplyDetailRespVo>> userDetailMap = detailRespVoList.stream().collect(Collectors.groupingBy(SfaLeaveApplyDetailRespVo::getUserName));
            SfaLeaveCancelReqVo cancelReqVo = new SfaLeaveCancelReqVo();
            cancelReqVo.setLeaveIdList(detailRespVoList.stream().map(SfaLeaveApplyDetailRespVo::getId).collect(Collectors.toList()));
            List<SfaLeaveCancelRespVo> leaveCancelRespVoList = this.cancelService.findList(cancelReqVo);
            Map<String, List<SfaLeaveCancelRespVo>> leaveCancelMap = leaveCancelRespVoList.stream().collect(Collectors.groupingBy(SfaLeaveCancelRespVo::getLeaveId));
            String beginTime = reqVo.getLeaveDateStart();
            String endTime = reqVo.getLeaveDateEnd();
            for (SfaLeaveApplySummaryRespVo summaryVo : summarylist) {
                MdmPositionUserOrgRespVo mdmUser = mdmUserMap.get(summaryVo.getUserName());
                if (mdmUser != null) {
                    summaryVo.setPosName(mdmUser.getPositionName());
                    summaryVo.setParentOrgName(mdmUser.getParentOrgName());
                    summaryVo.setOrgName(mdmUser.getOrgName());
                }
                List<SfaLeaveApplyDetailRespVo> list = userDetailMap.get(summaryVo.getUserName());
                for (SfaLeaveApplyDetailRespVo vo : list) {
                    BigDecimal count = SfaSignUtils.countCreateNewTimeInfo((String)beginTime, (String)endTime, (List)JSON.parseArray((String)vo.getTimeInfoListJson(), SfaApplyTimeInfoReqVo.class));
                    if (com.biz.crm.util.StringUtils.isNotEmpty((String)vo.getNonWorkDateListJson())) {
                        List nonWorkTimeInfoList = JSON.parseArray((String)vo.getNonWorkDateListJson(), SfaApplyTimeInfoReqVo.class);
                        for (SfaApplyTimeInfoReqVo sfaApplyTimeInfoReqVo : nonWorkTimeInfoList) {
                            BigDecimal nonWorkCount = SfaSignUtils.countCreateNewTimeInfo((String)beginTime, (String)endTime, Arrays.asList(sfaApplyTimeInfoReqVo));
                            count = count.subtract(nonWorkCount);
                        }
                    }
                    if (leaveCancelMap.get(vo.getId()) != null) {
                        List<SfaLeaveCancelRespVo> leaveCancelRespVoList1 = leaveCancelMap.get(vo.getId());
                        for (SfaLeaveCancelRespVo sfaLeaveCancelRespVo : leaveCancelRespVoList1) {
                            BigDecimal cancelWorkCount = SfaSignUtils.countCreateNewTimeInfo((String)beginTime, (String)endTime, (List)sfaLeaveCancelRespVo.getTimeInfoList());
                            count = count.subtract(cancelWorkCount);
                        }
                    }
                    if (SfaCommonEnum.leaveTypeEnum.ANNUAL_LEAVE.getVal().equals(vo.getLeaveType())) {
                        summaryVo.setAnnualLeave(summaryVo.getAnnualLeave().add(count));
                        continue;
                    }
                    if (SfaCommonEnum.leaveTypeEnum.PERSONAL_LEAVE.getVal().equals(vo.getLeaveType())) {
                        summaryVo.setPersonalLeave(summaryVo.getPersonalLeave().add(count));
                        continue;
                    }
                    if (SfaCommonEnum.leaveTypeEnum.MARRIAGE_LEAVE.getVal().equals(vo.getLeaveType())) {
                        summaryVo.setMarriageLeave(summaryVo.getMarriageLeave().add(count));
                        continue;
                    }
                    if (SfaCommonEnum.leaveTypeEnum.FUNERAL_LEAVE.getVal().equals(vo.getLeaveType())) {
                        summaryVo.setFuneralLeave(summaryVo.getFuneralLeave().add(count));
                        continue;
                    }
                    if (SfaCommonEnum.leaveTypeEnum.PATERNITY_LEAVE.getVal().equals(vo.getLeaveType())) {
                        summaryVo.setPaternityLeave(summaryVo.getPaternityLeave().add(count));
                        continue;
                    }
                    if (SfaCommonEnum.leaveTypeEnum.DAYS_OFF.getVal().equals(vo.getLeaveType())) {
                        summaryVo.setDaysOff(summaryVo.getDaysOff().add(count));
                        continue;
                    }
                    if (SfaCommonEnum.leaveTypeEnum.SICK_LEAVE.getVal().equals(vo.getLeaveType())) {
                        summaryVo.setSickLeave(summaryVo.getSickLeave().add(count));
                        continue;
                    }
                    if (!SfaCommonEnum.leaveTypeEnum.MATERNITY_LEAVE.getVal().equals(vo.getLeaveType())) continue;
                    summaryVo.setMaternityLeave(summaryVo.getMaternityLeave().add(count));
                }
            }
        }
        return PageResult.builder().data(summarylist).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaWorkOvertimeDetailRespVo> workOvertimeDetail(SfaWorkOvertimeDetailReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaWorkOvertimeDetailRespVo> list = this.overtimeMapper.workOvertimeDetail((Page<SfaWorkOvertimeDetailRespVo>)page, reqVo);
        if (list != null && list.size() > 0) {
            list.forEach(vo -> vo.setBpmStatusDesc(SfaCommonEnum.dataBpmStatus.getDesc((String)vo.getBpmStatus())));
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaWorkOvertimeSummaryRespVo> workOvertimeSummary(SfaWorkOvertimeSummaryReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        reqVo.setIndate(Integer.valueOf(this.overtimeService.getOvertimeIndate()));
        List<SfaWorkOvertimeSummaryRespVo> list = this.overtimeMapper.workOvertimeSummary((Page<SfaWorkOvertimeSummaryRespVo>)page, reqVo);
        if (list != null && list.size() > 0 && list.get(0) != null) {
            Map<String, MdmPositionUserOrgRespVo> mdmUserMap = this.getUserOrgInfoByUserNames(list.stream().map(SfaWorkOvertimeSummaryRespVo::getUserName).collect(Collectors.toList()));
            list.forEach(vo -> {
                MdmPositionUserOrgRespVo mdmUser = (MdmPositionUserOrgRespVo)mdmUserMap.get(vo.getUserName());
                if (mdmUser != null) {
                    vo.setPosName(mdmUser.getPositionName());
                    vo.setParentOrgName(mdmUser.getParentOrgName());
                    vo.setOrgName(mdmUser.getOrgName());
                    String orgCode = mdmUser.getOrgCode();
                    vo.setOrgName(mdmUser.getOrgName());
                    MdmOrgRespVo mdmOrgRespVo = OrgUtil.getOrgByCode((String)orgCode);
                    if (null != mdmOrgRespVo) {
                        vo.setParentOrgName(mdmOrgRespVo.getParentName());
                    }
                }
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaExceptionReportDetailRespVo> exceptionReportDetail(SfaExceptionReportDetailReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaExceptionReportDetailRespVo> list = this.mapper.exceptionReportDetail((Page<SfaExceptionReportDetailRespVo>)page, reqVo);
        ArrayList ids = Lists.newArrayList();
        for (SfaExceptionReportDetailRespVo sfaExceptionReportDetailRespVo : list) {
            ids.addAll(Stream.of(sfaExceptionReportDetailRespVo.getExceptionRecordIds().split(",")).collect(Collectors.toList()));
        }
        if (ids.size() > 0) {
            Map<String, SfaWorkSignRecordRespVo> recordRespVos = this.mapper.findRecordsById(ids).stream().collect(Collectors.toMap(UuidVo::getId, v -> v, (t, t2) -> t2));
            list.forEach(vo -> {
                List tempRecords = Stream.of(vo.getExceptionRecordIds().split(",")).collect(Collectors.toList()).stream().map(v -> (SfaWorkSignRecordRespVo)recordRespVos.get(v)).collect(Collectors.toList());
                tempRecords.sort((o1, o2) -> {
                    String time1 = o1.getSfaSignTime();
                    if (StringUtils.isBlank((CharSequence)time1)) {
                        time1 = "00:00:00";
                    }
                    LocalTime localTime1 = LocalTime.parse(time1, CrmDateUtils.HHmmss);
                    String time2 = o2.getSfaSignTime();
                    if (StringUtils.isBlank((CharSequence)time2)) {
                        time2 = "00:00:00";
                    }
                    LocalTime localTime2 = LocalTime.parse(time2, CrmDateUtils.HHmmss);
                    return localTime1.compareTo(localTime2);
                });
                String collect = tempRecords.stream().map(recordRespVo -> {
                    if (com.biz.crm.util.StringUtils.isNotEmpty((String)recordRespVo.getSfaSignTime())) {
                        return recordRespVo.getWorkSignDesc() + "(" + recordRespVo.getSfaSignTime() + ")";
                    }
                    return recordRespVo.getWorkSignDesc() + "()";
                }).collect(Collectors.joining("\u3001"));
                vo.setExceptionRecordType(collect);
                vo.setClockDate(vo.getBeginTime());
                vo.setBpmStatusDesc(SfaCommonEnum.dataBpmStatus.getDesc((String)vo.getBpmStatus()));
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaTravelRespVo> travelDetail(SfaTravelReqVo reqVo) {
        return this.travelService.findList(reqVo);
    }

    @Override
    public MdmPositionUserOrgRespVo getUserOrgInfo(String userName) {
        MdmPositionUserOrgReqVo positionUserOrgReqVo = new MdmPositionUserOrgReqVo();
        positionUserOrgReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        positionUserOrgReqVo.setUserName(userName);
        positionUserOrgReqVo.setPrimaryFlag(YesNoEnum.yesNoEnum.ONE.getValue());
        List userList = (List)ApiResultUtil.objResult((Result)this.mdmPositionFeign.findPositionUserOrgList(positionUserOrgReqVo), (boolean)true);
        if (userList == null || userList.size() == 0 || userList.get(0) == null) {
            throw new BusinessException("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (userList.size() != 1) {
            throw new BusinessException("\u7528\u6237\u4e3b\u804c\u4f4d\u5b58\u5728\u591a\u4e2a");
        }
        return (MdmPositionUserOrgRespVo)userList.get(0);
    }

    public Map<String, MdmPositionUserOrgRespVo> getUserOrgInfoByUserNames(List<String> userNameList) {
        MdmPositionUserOrgReqVo positionUserOrgReqVo = new MdmPositionUserOrgReqVo();
        positionUserOrgReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        positionUserOrgReqVo.setUserNameList(userNameList);
        positionUserOrgReqVo.setPrimaryFlag(YesNoEnum.yesNoEnum.ONE.getValue());
        List userList = (List)ApiResultUtil.objResult((Result)this.mdmPositionFeign.findPositionUserOrgList(positionUserOrgReqVo), (boolean)true);
        if (userList == null || userList.size() == 0 || userList.get(0) == null) {
            throw new BusinessException("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        return userList.stream().collect(Collectors.toMap(MdmPositionUserOrgRespVo::getUserName, v -> v, (t, t2) -> t2));
    }

    @Override
    public SfaWorkOvertimeRespVo queryOvertiem(String auditTaskId) {
        return this.overtimeService.queryByAuditTaskId(auditTaskId);
    }

    @Override
    public SfaLeaveRespVo queryleave(String auditTaskId) {
        return this.leaveService.queryByAuditTaskId(auditTaskId);
    }

    @Override
    public SfaExceptionReportDetailRespVo queryException(String auditTaskId) {
        SfaExceptionReportDetailRespVo respVo = this.mapper.queryByAuditTaskId(auditTaskId);
        AssertUtils.isNotNull((Object)respVo, (String)"\u8bb0\u5f55\u4e0d\u5b58\u5728");
        List<String> ids = Stream.of(respVo.getExceptionRecordIds().split(",")).collect(Collectors.toList());
        List<SfaWorkSignRecordRespVo> recordRespVos = this.mapper.findRecordsById(ids);
        AssertUtils.isNotNull(recordRespVos, (String)"\u8bb0\u5f55\u4e0d\u5b58\u5728");
        String collect = recordRespVos.stream().map(e -> {
            if (com.biz.crm.util.StringUtils.isNotEmpty((String)e.getWorkSignTime())) {
                return e.getWorkSignDesc() + "(" + e.getWorkSignTime() + ")";
            }
            return e.getWorkSignDesc() + "()";
        }).collect(Collectors.joining("\u3001"));
        respVo.setExceptionRecordType(collect);
        respVo.setClockDate(respVo.getBeginTime());
        respVo.setBpmStatusDesc(SfaCommonEnum.dataBpmStatus.getDesc((String)respVo.getBpmStatus()));
        return respVo;
    }

    @Override
    public SfaLeaveCancelInfoRespVo queryLeaveCancel(final String auditTaskId) {
        SfaAuditListLeaveCancelReqVo reqVo = new SfaAuditListLeaveCancelReqVo(){
            {
                this.setAuditTaskIdList(Arrays.asList(auditTaskId));
            }
        };
        PageResult<SfaLeaveCancelInfoRespVo> pageResult = this.leaveCancelService.findInfoList(reqVo);
        if (pageResult == null || pageResult.getCount() != 1L) {
            throw new BusinessException("\u5ba1\u6838\u4efb\u52a1ID\u9519\u8bef");
        }
        return (SfaLeaveCancelInfoRespVo)pageResult.getData().get(0);
    }

    @Override
    public SfaTravelRespVo queryTravel(String auditTaskId) {
        return this.travelService.queryByAuditTaskId(auditTaskId);
    }

    protected void dd(SfaMonthSignReqVo reqVo) {
    }

    @Override
    public SfaMonthSignRespVo appUserByMonthSign(SfaMonthSignReqVo reqVo) {
        if (null == reqVo) {
            reqVo = new SfaMonthSignReqVo();
            reqVo.setByUserName(UserUtils.getUser().getUsername());
            reqVo.setYearMonth(DateUtil.yyyy_MM.format(new Date()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqVo.getUserName())) {
            reqVo.setByUserName(reqVo.getUserName());
            reqVo.setUserName(null);
        }
        if (null != reqVo && com.biz.crm.util.StringUtils.isNotEmpty((String)reqVo.getTimeType()) && WorkSignEnum.TimeType.SY.getVal().equals(reqVo.getTimeType())) {
            Calendar c = Calendar.getInstance();
            c.setTime(new Date());
            c.add(2, -1);
            Date m = c.getTime();
            reqVo.setYearMonth(DateUtil.yyyy_MM.format(m));
        } else {
            reqVo.setYearMonth(DateUtil.yyyy_MM.format(new Date()));
        }
        List<SfaMonthSignRespVo> list = this.mapper.monthSignUserInfoForUser(reqVo);
        SfaMonthSignRespVo respVo = null;
        if (list != null && list.size() > 0) {
            this.loadMonthSignDetail(list, reqVo);
            respVo = list.get(0);
            SfaTravelReqVo sfaTravelReqVo = new SfaTravelReqVo();
            sfaTravelReqVo.setTravelUserNames(reqVo.getUserName());
            sfaTravelReqVo.setYearMonth(reqVo.getYearMonth());
            List<SfaTravelRespVo> sfaTravelRespVoList = this.travelService.findDataList(sfaTravelReqVo);
            if (CollectionUtil.listNotEmptyNotSizeZero(sfaTravelRespVoList)) {
                Integer travelDays = 0;
                for (SfaTravelRespVo travelRespVo : sfaTravelRespVoList) {
                    try {
                        int datsInt;
                        Date endDate = DateUtil.date_sdf.parse(travelRespVo.getEndTime());
                        Date beginDate = DateUtil.date_sdf.parse(travelRespVo.getBeginTime());
                        if (!travelRespVo.getBeginTime().contains(sfaTravelReqVo.getYearMonth())) {
                            beginDate = DateUtil.date_sdf.parse(sfaTravelReqVo.getYearMonth() + "-01");
                        }
                        if (endDate.getTime() > new Date().getTime()) {
                            endDate = new Date();
                        }
                        if ((datsInt = DateUtil.getDayCount((Date)beginDate, (Date)endDate)) < 0) {
                            datsInt = -1 * datsInt;
                        }
                        travelDays = travelDays + datsInt;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                respVo.setTravelDays(travelDays);
            }
            SfaWorkSummaryReqVo sfaWorkSummaryReqVo = new SfaWorkSummaryReqVo();
            sfaWorkSummaryReqVo.setUserCode(reqVo.getUserName());
            sfaWorkSummaryReqVo.setYearMonth(reqVo.getYearMonth());
            sfaWorkSummaryReqVo.setSummaryType(SfaWorkSummaryEnum.LectureType.DAILY.getVal());
            Integer dailyDays = this.sfaWorkSummaryService.getSfaWorkSummaryPrimaryByCount(sfaWorkSummaryReqVo);
            if (null == dailyDays) {
                dailyDays = 0;
            }
            respVo.setDailyDays(dailyDays);
            BigDecimal goToWorkDays = respVo.getGoToWorkDays();
            Integer notDailyDays = Integer.valueOf(goToWorkDays.toString()) - dailyDays;
            respVo.setNotDailyDays(notDailyDays);
        }
        if (null == respVo) {
            respVo = new SfaMonthSignRespVo();
        }
        return respVo;
    }
}

