/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.asexecution.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.actscheme.model.SfaActSchemePosApplyEntity;
import com.biz.crm.actscheme.service.ISfaActSchemePosApplyService;
import com.biz.crm.asexecution.mapper.SfaAsExecutionMapper;
import com.biz.crm.asexecution.model.SfaAsCashingEntity;
import com.biz.crm.asexecution.model.SfaAsCashingPictureEntity;
import com.biz.crm.asexecution.model.SfaAsCashingProductEntity;
import com.biz.crm.asexecution.model.SfaAsExecutionEntity;
import com.biz.crm.asexecution.model.SfaAsExecutionPictureEntity;
import com.biz.crm.asexecution.model.SfaAsExecutionProductEntity;
import com.biz.crm.asexecution.model.SfaAsStopEntity;
import com.biz.crm.asexecution.model.SfaAsTreatyConvertProductEntity;
import com.biz.crm.asexecution.model.SfaAsTreatyDisplayProductEntity;
import com.biz.crm.asexecution.model.SfaAsTreatyEntity;
import com.biz.crm.asexecution.model.SfaAsTreatySignEntity;
import com.biz.crm.asexecution.service.ISfaAsCashingPictureService;
import com.biz.crm.asexecution.service.ISfaAsCashingProductService;
import com.biz.crm.asexecution.service.ISfaAsCashingService;
import com.biz.crm.asexecution.service.ISfaAsExecutionPictureService;
import com.biz.crm.asexecution.service.ISfaAsExecutionProductService;
import com.biz.crm.asexecution.service.ISfaAsExecutionService;
import com.biz.crm.asexecution.service.ISfaAsStopService;
import com.biz.crm.asexecution.service.ISfaAsTreatyConvertProductService;
import com.biz.crm.asexecution.service.ISfaAsTreatyDisplayProductService;
import com.biz.crm.asexecution.service.ISfaAsTreatyService;
import com.biz.crm.asexecution.service.ISfaAsTreatySignService;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.SfaClientData;
import com.biz.crm.base.SfaClientHelper;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaActivityEnum;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.mdm.user.MdmUserFeign;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepListener;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.moblie.controller.visit.component.impl.OrderVisitStepExecutor;
import com.biz.crm.moblie.controller.workbench.req.OrderAsDataReq;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.nebular.sfa.actscheme.resp.SfaActSchemePosApplyRespVo;
import com.biz.crm.nebular.sfa.actscheme.resp.SfaActSchemeProductRespVo;
import com.biz.crm.nebular.sfa.asexecution.req.SfaAsCashingReqVo;
import com.biz.crm.nebular.sfa.asexecution.req.SfaAsExecuteOrderProductReqVo;
import com.biz.crm.nebular.sfa.asexecution.req.SfaAsExecutionDetailReqVo;
import com.biz.crm.nebular.sfa.asexecution.req.SfaAsExecutionProductReqVo;
import com.biz.crm.nebular.sfa.asexecution.req.SfaAsExecutionReqVo;
import com.biz.crm.nebular.sfa.asexecution.req.SfaAsStopReqVo;
import com.biz.crm.nebular.sfa.asexecution.req.SfaAsTreatyConvertProductReqVo;
import com.biz.crm.nebular.sfa.asexecution.req.SfaAsTreatyReqVo;
import com.biz.crm.nebular.sfa.asexecution.req.SfaAsTreatySignReqVo;
import com.biz.crm.nebular.sfa.asexecution.req.TemplateTreatyProductVo;
import com.biz.crm.nebular.sfa.asexecution.req.TemplateTreatyVo;
import com.biz.crm.nebular.sfa.asexecution.resp.SfaAsCashingPictureRespVo;
import com.biz.crm.nebular.sfa.asexecution.resp.SfaAsCashingProductRespVo;
import com.biz.crm.nebular.sfa.asexecution.resp.SfaAsCashingRespVo;
import com.biz.crm.nebular.sfa.asexecution.resp.SfaAsExecutionDetailRespVo;
import com.biz.crm.nebular.sfa.asexecution.resp.SfaAsExecutionPictureRespVo;
import com.biz.crm.nebular.sfa.asexecution.resp.SfaAsExecutionPictureTopVo;
import com.biz.crm.nebular.sfa.asexecution.resp.SfaAsExecutionProductRespVo;
import com.biz.crm.nebular.sfa.asexecution.resp.SfaAsExecutionProductTopVo;
import com.biz.crm.nebular.sfa.asexecution.resp.SfaAsExecutionRespVo;
import com.biz.crm.nebular.sfa.asexecution.resp.SfaAsStopRespVo;
import com.biz.crm.nebular.sfa.asexecution.resp.SfaAsTreatyRespVo;
import com.biz.crm.nebular.upload.vo.UploadVo;
import com.biz.crm.nebular.upload.vo.WordTemplateDataVo;
import com.biz.crm.upload.file.OfficeFileFeign;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.LocationUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.biz.crm.visitstep.model.SfaVisitStepFromEntity;
import com.biz.crm.visitstep.service.ISfaVisitStepFromService;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.sf.cglib.beans.BeanMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
@ConditionalOnMissingBean(name={"sfaAsExecutionServiceExpandImpl"})
@Transactional
public class SfaAsExecutionServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaAsExecutionMapper, SfaAsExecutionEntity>
implements ISfaAsExecutionService {
    private static final Logger log = LoggerFactory.getLogger(SfaAsExecutionServiceImpl.class);
    @Resource
    protected ISfaVisitPlanInfoService sfaVisitPlanInfoService;
    @Autowired
    private ISfaAsExecutionProductService sfaAsExecutionProductService;
    @Autowired
    private ISfaAsExecutionPictureService sfaAsExecutionPictureService;
    @Autowired
    private ISfaAsTreatySignService sfaAsTreatySignService;
    @Autowired
    private ISfaAsTreatyDisplayProductService sfaAsTreatyDisplayProductService;
    @Autowired
    private ISfaAsTreatyService sfaAsTreatyService;
    @Autowired
    private ISfaAsTreatyConvertProductService sfaAsTreatyConvertProductService;
    @Autowired
    private ISfaAsCashingService sfaAsCashingService;
    @Autowired
    private ISfaAsCashingProductService sfaAsCashingProductService;
    @Autowired
    private ISfaAsCashingPictureService sfaAsCashingPictureService;
    @Autowired
    private ISfaAsStopService sfaAsStopService;
    @Autowired
    private ISfaActSchemePosApplyService sfaActSchemePosApplyService;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Resource
    private MdmProductFeign mdmProductFeign;
    @Autowired
    private OfficeFileFeign officeFileFeign;
    @Resource
    private OrderVisitStepExecutor orderVisitStepExecutor;
    @Autowired
    private MdmUserFeign mdmUserFeign;
    @Autowired
    private ISfaVisitStepFromService sfaVisitStepFromService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveSfaAsTreaty(SfaAsTreatyReqVo reqVo) {
        List contactVos;
        UserRedis userRedis = UserUtils.getUser();
        MdmUserReqVo mdmUserReqVo = new MdmUserReqVo();
        mdmUserReqVo.setUserName(userRedis.getUsername());
        MdmUserRespVo mdmUserRespVo = (MdmUserRespVo)ApiResultUtil.objResult((Result)this.mdmUserFeign.query(mdmUserReqVo));
        reqVo.setCurrUserPhone(mdmUserRespVo.getUserPhone());
        AssertUtils.isNotEmpty((String)reqVo.getActivityCode(), (String)"\u6d3b\u52a8\u7f16\u7801\u4e3a\u7a7a");
        reqVo.setTreatySource(SfaCommonEnum.actTreatySource.SFA_PROGRAMME.getValue());
        SfaActSchemePosApplyEntity actSchemePosApplyEntity = (SfaActSchemePosApplyEntity)((Object)((LambdaQueryChainWrapper)this.sfaActSchemePosApplyService.lambdaQuery().eq(SfaActSchemePosApplyEntity::getActivityCode, (Object)reqVo.getActivityCode())).one());
        if (null == actSchemePosApplyEntity) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u6d3b\u52a8[" + reqVo.getActivityCode() + "]");
        }
        reqVo.setPaymentMethod(actSchemePosApplyEntity.getPaymentMethod());
        AssertUtils.isNotEmpty((String)reqVo.getTerminalCode(), (String)"\u7ec8\u7aef\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getTerminalName(), (String)"\u7ec8\u7aef\u540d\u79f0\u4e3a\u7a7a");
        List asTreatyList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sfaAsTreatyService.lambdaQuery().eq(SfaAsTreatyEntity::getActivityCode, (Object)reqVo.getActivityCode())).eq(SfaAsTreatyEntity::getTerminalCode, (Object)reqVo.getTerminalCode())).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)asTreatyList)) {
            throw new BusinessException("\u95e8\u5e97[" + reqVo.getTerminalCode() + "-" + reqVo.getTerminalName() + "],\u5bf9\u5e94\u6d3b\u52a8[" + reqVo.getActivityCode() + "],\u5df2\u7b7e\u7f72\u534f\u8bae,\u4e0d\u80fd\u91cd\u590d\u7b7e\u7f72");
        }
        AssertUtils.isNotEmpty((String)reqVo.getDisplayBrand(), (String)"\u9648\u5217\u54c1\u724c\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getDisplayPlace(), (String)"\u9648\u5217\u4f4d\u7f6e\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getDisplaySpecs(), (String)"\u9648\u5217\u89c4\u683c\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getDisplayNumber(), (String)"\u9648\u5217\u4ef6\u6570\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getDisplayStartTime(), (String)"\u9648\u5217\u5f00\u59cb\u65f6\u95f4\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getDisplayEndTime(), (String)"\u9648\u5217\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getCurrUserPhone(), (String)"\u4e1a\u52a1\u5458\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getDealerCode(), (String)"\u7ecf\u9500\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.isNotEmpty((String)reqVo.getDealerName(), (String)"\u7ecf\u9500\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        MdmTerminalVo mdmTerminalVo = (MdmTerminalVo)ApiResultUtil.objResult((Result)this.mdmTerminalFeign.query(null, reqVo.getTerminalCode()));
        reqVo.setTerminalAddr(mdmTerminalVo.getTerminalAddress());
        if (CollectionUtil.listNotEmpty((List)mdmTerminalVo.getContacts()) && CollectionUtil.listNotEmpty(contactVos = mdmTerminalVo.getContacts().stream().filter(o -> o.getContactMain().equals(YesNoEnum.yesNoEnum.ONE.getValue())).collect(Collectors.toList()))) {
            MdmTerminalContactVo terminalContactVo = (MdmTerminalContactVo)contactVos.get(0);
            reqVo.setTerminalPhone(terminalContactVo.getContactPhone());
        }
        LocalDate displayStartTime = null;
        LocalDate displayEndTime = null;
        LocalDate now = LocalDate.now();
        try {
            displayStartTime = LocalDate.parse(reqVo.getDisplayStartTime());
            displayEndTime = LocalDate.parse(reqVo.getDisplayEndTime());
        }
        catch (Exception e) {
            throw new BusinessException("\u9648\u5217\u65f6\u95f4\u9519\u8bef");
        }
        if (!displayStartTime.isBefore(displayEndTime)) {
            throw new BusinessException("\u9648\u5217\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u9648\u5217\u7ed3\u675f\u65f6\u95f4");
        }
        if (now.isAfter(displayEndTime)) {
            throw new BusinessException("\u9648\u5217\u7ed3\u675f\u65f6\u95f4\u4e0d\u53ef\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4");
        }
        AssertUtils.isNotEmpty((String)reqVo.getDisplayMonth(), (String)"\u9648\u5217\u6708\u4efd\u4e3a\u7a7a");
        if (SfaActivityEnum.paymentMethod.XJ.getVal().equals(actSchemePosApplyEntity.getPaymentMethod())) {
            if (null == reqVo.getMonthPayAmount()) {
                throw new BusinessException("\u6bcf\u6708\u652f\u4ed8\u73b0\u91d1\u4e3a\u7a7a");
            }
            if (null == reqVo.getTotalAmount()) {
                throw new BusinessException("\u5408\u8ba1\u5956\u52b1\u73b0\u91d1\u4e3a\u7a7a");
            }
            AssertUtils.isNotEmpty((String)reqVo.getPayee(), (String)"\u5956\u52b1\u6536\u6b3e\u4eba\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)reqVo.getContactPhone(), (String)"\u8054\u7cfb\u7535\u8bdd\u4e3a\u7a7a");
        } else {
            AssertUtils.isNotEmpty((Collection)reqVo.getAsTreatyConvertProductList(), (String)"\u8d27\u7269\u5151\u6362\u4ea7\u54c1\u4e3a\u7a7a");
        }
        if (null == reqVo.getAsTreatySign()) {
            throw new BusinessException("\u5e97\u4e3b\u7b7e\u5b57\u4e3a\u7a7a");
        }
        SfaAsTreatyEntity entity = (SfaAsTreatyEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaAsTreatyEntity.class));
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        entity.setTreatyCode(CodeUtil.generateCode((String)SfaCodeEnum.schemeCode.SCHEME_ACTIVITY_TREATY_CODE.getVal()));
        entity.setTreatyStatus(SfaActivityEnum.TreatyStatus.IN_EXECUTION.getVal());
        this.sfaAsTreatyService.save((Object)entity);
        String id = entity.getId();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getAsTreatyDisplayProductList())) {
            reqVo.getAsTreatyDisplayProductList().forEach(o -> o.setId(null));
            List asTreatyDisplayProductList = CrmBeanUtil.copyList((List)reqVo.getAsTreatyDisplayProductList(), SfaAsTreatyDisplayProductEntity.class);
            asTreatyDisplayProductList.forEach(data -> data.setTreatyId(id));
            this.sfaAsTreatyDisplayProductService.saveBatch(asTreatyDisplayProductList);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getAsTreatyConvertProductList())) {
            reqVo.getAsTreatyConvertProductList().forEach(o -> o.setId(null));
            List asTreatyConvertProductList = CrmBeanUtil.copyList((List)reqVo.getAsTreatyConvertProductList(), SfaAsTreatyConvertProductEntity.class);
            asTreatyConvertProductList.forEach(data -> {
                data.setTreatyId(id);
                if (com.biz.crm.util.StringUtils.isEmpty((String)data.getItemType())) {
                    throw new BusinessException("\u5546\u54c1\u884c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a(1:\u652f\u4ed8\u8d27\u54c1;2:\u5956\u52b1\u8d27\u54c1)");
                }
            });
            this.sfaAsTreatyConvertProductService.saveBatch(asTreatyConvertProductList);
        }
        SfaAsTreatySignEntity asTreatySignEntity = (SfaAsTreatySignEntity)((Object)CrmBeanUtil.copy((Object)reqVo.getAsTreatySign(), SfaAsTreatySignEntity.class));
        asTreatySignEntity.setTreatyId(id);
        asTreatySignEntity.setFileType(SfaActivityEnum.SignFileType.SIGN.getVal());
        this.sfaAsTreatySignService.save((Object)asTreatySignEntity);
        this.createPdf(reqVo, entity);
        if (com.biz.crm.util.StringUtils.isEmpty((String)entity.getUrlPath())) {
            throw new BusinessException("\u534f\u8baePDF\u6587\u4ef6\u751f\u6210\u5931\u8d25!");
        }
        this.sfaAsTreatyService.updateById((Object)entity);
        SfaAsStopReqVo asStopReqVo = (SfaAsStopReqVo)CrmBeanUtil.copy((Object)reqVo, SfaAsStopReqVo.class);
        asStopReqVo.setStopState(YesNoEnum.yesNoEnum.ZERO.getValue());
        this.saveAsStop(asStopReqVo);
    }

    private void createPdf(SfaAsTreatyReqVo reqVo, SfaAsTreatyEntity entity) {
        TemplateTreatyVo templateTreatyVo;
        SfaAsTreatySignReqVo asTreatySign = reqVo.getAsTreatySign();
        templateTreatyVo.setRemarks(com.biz.crm.util.StringUtils.isEmpty((String)(templateTreatyVo = (TemplateTreatyVo)CrmBeanUtil.copy((Object)reqVo, TemplateTreatyVo.class)).getRemarks()) ? "\u65e0" : templateTreatyVo.getRemarks());
        UserRedis userRedis = UserUtils.getUser();
        String currUserName = this.formatStrLength(userRedis.getRealname(), 10);
        String currUserPhone = templateTreatyVo.getCurrUserPhone();
        currUserPhone = currUserPhone + "&#160;&#160;&#160;&#160;&#160;&#160;";
        templateTreatyVo.setCurrUserPhone(currUserPhone);
        templateTreatyVo.setCurrUserName(currUserName);
        if (com.biz.crm.util.StringUtils.isEmpty((String)reqVo.getDisplayItem())) {
            templateTreatyVo.setDisplayInfo(reqVo.getDisplayBrand());
        } else if (CollectionUtil.listEmpty((List)reqVo.getAsTreatyDisplayProductList())) {
            templateTreatyVo.setDisplayInfo(reqVo.getDisplayItem());
        } else if (CollectionUtil.listNotEmpty((List)reqVo.getAsTreatyDisplayProductList())) {
            ArrayList productNames = Lists.newArrayList();
            reqVo.getAsTreatyDisplayProductList().forEach(o -> productNames.add(o.getProductName()));
            String displayInfo = Joiner.on((String)"\u3001").join((Iterable)productNames);
            templateTreatyVo.setDisplayInfo(displayInfo);
        }
        HashMap dataMap = Maps.newHashMap();
        if (templateTreatyVo != null) {
            BeanMap beanMap = BeanMap.create((Object)templateTreatyVo);
            for (Object key : beanMap.keySet()) {
                dataMap.put(key.toString(), beanMap.get(key));
            }
        }
        String[] startTime = reqVo.getDisplayStartTime().split("-");
        String[] endTime = reqVo.getDisplayEndTime().split("-");
        dataMap.put("startYear", startTime[0]);
        dataMap.put("startMonth", startTime[1]);
        dataMap.put("startDay", startTime[2]);
        dataMap.put("endYear", endTime[0]);
        dataMap.put("endMonth", endTime[1]);
        dataMap.put("endDay", endTime[2]);
        String date2Str = DateUtil.date2Str((SimpleDateFormat)DateUtil.date_sdf_wz);
        dataMap.put("currDate", date2Str);
        boolean equals = SfaActivityEnum.paymentMethod.XJ.getVal().equals(reqVo.getPaymentMethod());
        if (!equals) {
            List asTreatyConvertProductList = reqVo.getAsTreatyConvertProductList();
            Map<String, List<SfaAsTreatyConvertProductReqVo>> listMap = asTreatyConvertProductList.stream().collect(Collectors.groupingBy(SfaAsTreatyConvertProductReqVo::getItemType));
            listMap.forEach((k, v) -> {
                List productVos = v.stream().map(sfaAsTreatyConvertProductReqVo -> {
                    TemplateTreatyProductVo templateTreatyProductVo = (TemplateTreatyProductVo)CrmBeanUtil.copy((Object)sfaAsTreatyConvertProductReqVo, TemplateTreatyProductVo.class);
                    if (StringUtils.isBlank((CharSequence)templateTreatyProductVo.getSpec())) {
                        templateTreatyProductVo.setSpec("\u65e0");
                    }
                    return templateTreatyProductVo;
                }).collect(Collectors.toList());
                if (SfaActivityEnum.bpItemType.bp.getVal().equals(k)) {
                    dataMap.put("products", productVos);
                } else {
                    dataMap.put("gifts", productVos);
                }
            });
        }
        if (!dataMap.containsKey("gifts") || dataMap.get("gifts") == null) {
            dataMap.put("gifts", new ArrayList());
        } else {
            List temp = (List)dataMap.get("gifts");
            if (CollectionUtil.listNotEmptyNotSizeZero((List)temp)) {
                dataMap.put("gifts", temp);
            }
        }
        WordTemplateDataVo dataVo = new WordTemplateDataVo();
        dataVo.setLeftOffset(Integer.valueOf(340));
        dataVo.setTopOffset(Integer.valueOf(equals ? -10 : -20));
        dataVo.setTemplateName(equals ? SfaActivityEnum.TemplateType.MONEY.getVal() : SfaActivityEnum.TemplateType.PRODUCT.getVal());
        dataVo.setZipTemplateName(equals ? SfaActivityEnum.TemplateType.MONEY.getDesc() : SfaActivityEnum.TemplateType.PRODUCT.getDesc());
        dataVo.setFileName(entity.getTreatyCode());
        dataVo.setTabText("\u4ee3\u8868\uff08\u7b7e\u5b57\uff09");
        dataVo.setSginImageUrl(asTreatySign.getUrlPathPrefix() + asTreatySign.getUrlPath());
        dataVo.setDataMap((Map)dataMap);
        List uploadVos = (List)ApiResultUtil.objResult((Result)this.officeFileFeign.createWordDocxToPdfFile(dataVo), (boolean)true);
        if (!CollectionUtils.isEmpty((Collection)uploadVos)) {
            UploadVo uploadVo = (UploadVo)uploadVos.get(0);
            entity.setObjectName(uploadVo.getObjectName());
            entity.setUrlPath(uploadVo.getUrlPath());
            entity.setUrlPathPrefix(uploadVo.getUrlPathPrefix());
        }
    }

    private String formatStrLength(String str, int len) {
        int length = str.length();
        int j = len - length;
        for (int i = 0; i < j; ++i) {
            str = str + "&#160;";
        }
        return str;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveSfaAsExecution(SfaAsExecutionReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        AssertUtils.isNotEmpty((String)reqVo.getActivityCode(), (String)"\u6d3b\u52a8\u7f16\u7801\u4e3a\u7a7a");
        SfaActSchemePosApplyEntity actSchemePosApplyEntity = (SfaActSchemePosApplyEntity)((Object)((LambdaQueryChainWrapper)this.sfaActSchemePosApplyService.lambdaQuery().eq(SfaActSchemePosApplyEntity::getActivityCode, (Object)reqVo.getActivityCode())).one());
        if (null == actSchemePosApplyEntity) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u6d3b\u52a8[" + reqVo.getActivityCode() + "]");
        }
        AssertUtils.isNotEmpty((String)reqVo.getTerminalCode(), (String)"\u7ec8\u7aef\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getTerminalName(), (String)"\u7ec8\u7aef\u540d\u79f0\u4e3a\u7a7a");
        Result result = this.mdmTerminalFeign.query(null, reqVo.getTerminalCode());
        if (!result.isSuccess() || null == result.getResult()) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7ec8\u7aef[" + reqVo.getTerminalCode() + "]");
        }
        MdmTerminalVo terminalVo = (MdmTerminalVo)result.getResult();
        List asExecutionEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaAsExecutionEntity::getActivityCode, (Object)reqVo.getActivityCode())).eq(SfaAsExecutionEntity::getTerminalCode, (Object)reqVo.getTerminalCode())).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)asExecutionEntities)) {
            List asExecutionList = CrmBeanUtil.copyList((List)asExecutionEntities, SfaAsExecutionRespVo.class);
            reqVo.setParticipateInType(((SfaAsExecutionRespVo)asExecutionList.get(0)).getParticipateInType());
        } else {
            AssertUtils.isNotEmpty((String)reqVo.getParticipateInType(), (String)"\u53c2\u4e0e\u7c7b\u578b\u4e3a\u7a7a");
            if (!SfaActivityEnum.participateInType.GETMAP.containsKey(reqVo.getParticipateInType())) {
                throw new BusinessException("\u53c2\u4e0e\u7c7b\u578b\u6709\u8bef");
            }
        }
        AssertUtils.isNotEmpty((Collection)reqVo.getAsExecutionProductList(), (String)"\u65b9\u6848\u6d3b\u52a8\u6267\u884c\u4ea7\u54c1\u6570\u636e\u91c7\u96c6\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getDisplayType(), (String)"\u9648\u5217\u7c7b\u578b\u4e3a\u7a7a");
        reqVo.setUserName(user.getUsername());
        reqVo.setRealName(user.getRealname());
        reqVo.setPosCode(user.getPoscode());
        reqVo.setPosName(user.getPosname());
        reqVo.setOrgCode(user.getOrgcode());
        reqVo.setOrgName(user.getOrgname());
        AssertUtils.isNotEmpty((Collection)reqVo.getAsExecutionPictureList(), (String)"\u65b9\u6848\u6d3b\u52a8\u6267\u884c\u56fe\u7247\u4e3a\u7a7a");
        SfaAsExecutionEntity entity = (SfaAsExecutionEntity)CrmBeanUtil.copy((Object)reqVo, SfaAsExecutionEntity.class);
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        String now = LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss);
        entity.setExecutionDate(now);
        entity.setVisitPlanInfoId(reqVo.getVisitId());
        this.save(entity);
        String id = entity.getId();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getAsExecutionProductList())) {
            List contacts;
            List asExecutionProductList = CrmBeanUtil.copyList((List)reqVo.getAsExecutionProductList(), SfaAsExecutionProductEntity.class);
            asExecutionProductList.forEach(data -> {
                data.setId(null);
                data.setExecutionId(id);
            });
            this.sfaAsExecutionProductService.saveBatch(asExecutionProductList);
            OrderAsDataReq<OrderAsDataReq.OrderItemAsReqVo> dataReq = new OrderAsDataReq<OrderAsDataReq.OrderItemAsReqVo>();
            dataReq.setClientCode(terminalVo.getTerminalCode());
            dataReq.setClientName(terminalVo.getTerminalName());
            dataReq.setClientType(terminalVo.getTerminalType());
            List supplys = terminalVo.getSupplys();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)supplys)) {
                MdmTerminalSupplyVo supplyVo = (MdmTerminalSupplyVo)supplys.get(0);
                dataReq.setCustomerCode(supplyVo.getCustomerCode());
                dataReq.setCustomerName(supplyVo.getCustomerName());
            }
            if (CollectionUtil.listNotEmptyNotSizeZero((List)(contacts = terminalVo.getContacts()))) {
                MdmTerminalContactVo terminalContactVo = (MdmTerminalContactVo)contacts.get(0);
                for (MdmTerminalContactVo contact : contacts) {
                    if (!YesNoEnum.YesNoCodeNumberEnum.YES.getValue().equals(contact.getContactMain())) continue;
                    terminalContactVo = contact;
                }
                dataReq.setContacts(terminalContactVo.getContactName());
                dataReq.setTelephone(terminalContactVo.getContactPhone());
            }
            dataReq.setId(entity.getId());
            BigDecimal totalPrice = BigDecimal.ZERO;
            ArrayList<SfaActSchemeProductRespVo> sfaVisitStepOrderItems = new ArrayList<SfaActSchemeProductRespVo>();
            for (SfaAsExecutionProductReqVo productReqVo : reqVo.getAsExecutionProductList()) {
                if (ObjectUtils.isEmpty((Object)productReqVo.getPrice())) {
                    throw new BusinessException("\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a!");
                }
                if (ObjectUtils.isEmpty((Object)productReqVo.getProductNum())) {
                    throw new BusinessException("\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a!");
                }
                SfaActSchemeProductRespVo itemReqVo = (SfaActSchemeProductRespVo)CrmBeanUtil.copy((Object)productReqVo, SfaActSchemeProductRespVo.class);
                String productNum = productReqVo.getProductNum().toString();
                itemReqVo.setQuantity(new BigDecimal(productNum));
                MdmProductRespVo mdmProductRespVo = (MdmProductRespVo)this.mdmProductFeign.detail(null, productReqVo.getProductCode()).getResult();
                if (null != mdmProductRespVo) {
                    itemReqVo.setSeriesCode(mdmProductRespVo.getProductLevelCode());
                    itemReqVo.setSeriesName(mdmProductRespVo.getProductLevelName());
                    itemReqVo.setUnit(mdmProductRespVo.getSaleUnit());
                    itemReqVo.setUnitName(mdmProductRespVo.getSaleUnitName());
                }
                itemReqVo.setPrice(productReqVo.getPrice().toString());
                totalPrice = totalPrice.add(productReqVo.getPrice().multiply(itemReqVo.getQuantity()));
                sfaVisitStepOrderItems.add(itemReqVo);
            }
            dataReq.setTotalPrice(totalPrice);
            dataReq.setVisitPlanInfoId(reqVo.getVisitId());
            dataReq.setActSchemeProductList(sfaVisitStepOrderItems);
            this.orderVisitStepExecutor.executeForAs(dataReq);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getAsExecutionPictureList())) {
            List asExecutionPictureList = CrmBeanUtil.copyList((List)reqVo.getAsExecutionPictureList(), SfaAsExecutionPictureEntity.class);
            asExecutionPictureList.forEach(data -> data.setExecutionId(id));
            this.sfaAsExecutionPictureService.saveBatch(asExecutionPictureList);
        }
        this.visitProcess(reqVo.getVisitId());
        this.doListener(entity);
        SfaAsStopReqVo asStopReqVo = (SfaAsStopReqVo)CrmBeanUtil.copy((Object)reqVo, SfaAsStopReqVo.class);
        asStopReqVo.setStopState(YesNoEnum.yesNoEnum.ZERO.getValue());
        this.saveAsStop(asStopReqVo);
    }

    private void checkDistance(SfaAsExecutionReqVo reqVo, MdmTerminalVo terminalVo) {
        SfaVisitStepFromEntity stepFromEntity;
        if (terminalVo != null && terminalVo.getLatitude() != null && terminalVo.getLatitude() != null && (stepFromEntity = (SfaVisitStepFromEntity)((Object)((LambdaQueryChainWrapper)this.sfaVisitStepFromService.lambdaQuery().eq(BaseIdEntity::getId, (Object)reqVo.getFormId())).one())) != null && stepFromEntity.getLocateType().equals(YesNoEnum.yesNoEnum.Y.getValue()) && com.biz.crm.util.StringUtils.isNotEmpty((String)stepFromEntity.getDistance())) {
            if (StringUtils.isBlank((CharSequence)reqVo.getLongitude())) {
                throw new BusinessException("\u7ecf\u5ea6\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqVo.getLatitude())) {
                throw new BusinessException("\u7eac\u5ea6\u4e3a\u7a7a");
            }
            BigDecimal distance = new BigDecimal(stepFromEntity.getDistance()).setScale(2, 5);
            log.info("\u5f53\u524d\u6b65\u9aa4\u914d\u7f6e\u7684\u8ddd\u79bb:{}", (Object)distance);
            log.info("\u5f53\u524d\u4f4d\u7f6e\u7684\u7ecf\u5ea6:{},\u7eac\u5ea6:{},\u62dc\u8bbf\u5ba2\u6237\u7684\u7ecf\u5ea6:{},\u7eac\u5ea6:{}", new Object[]{reqVo.getLongitude(), reqVo.getLatitude(), terminalVo.getLongitude(), terminalVo.getLatitude()});
            double data = LocationUtils.getDistance(new BigDecimal(reqVo.getLongitude()), new BigDecimal(reqVo.getLatitude()), new BigDecimal(terminalVo.getLongitude()), new BigDecimal(terminalVo.getLatitude()));
            BigDecimal nowDistance = new BigDecimal(data).setScale(2, 5);
            log.info("\u5f53\u524d\u4f4d\u7f6e\u8ddd\u79bb\u62dc\u8bbf\u5ba2\u6237\u7684\u8ddd\u79bb:{}", (Object)nowDistance);
            if (distance.compareTo(nowDistance) == -1) {
                throw new BusinessException("\u60a8\u672a\u5728\u5ba2\u6237\u8ddd\u79bb" + distance + "M\u5185\uff0c\u8bf7\u524d\u5f80\u5ba2\u6237\u5730\u5740\u8fdb\u884c\u64cd\u4f5c\uff01");
            }
        }
    }

    protected void doListener(SfaAsExecutionEntity entity) {
        SfaAsExecutionEntity committedData = (SfaAsExecutionEntity)CrmBeanUtil.copy((Object)entity, SfaAsExecutionEntity.class);
        if (null == committedData) {
            return;
        }
        committedData.setId(committedData.getActivityCode());
        SfaClientData clientData = SfaClientHelper.loadClientDataNotRequired(committedData.getClientType(), committedData.getClientCode());
        if (null != clientData) {
            committedData.setClientSubclass(clientData.getClientSubclass());
            committedData.setClientSubclassName(clientData.getClientSubclassName());
        }
        String stepCode = SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_DEF_PROGRAMME.getVal();
        committedData.setStepCode(stepCode);
        ArrayList committedDataList = Lists.newArrayList((Object[])new VisitStepListener.VisitStepListenerCommittedData[]{committedData});
        List<AbstractVisitStepListener> listeners = AbstractVisitStepListener.getListeners(stepCode);
        for (AbstractVisitStepListener listener : listeners) {
            if (null == listener) continue;
            VisitStepListener.VisitStepListenerCommittedEvent committedEvent = new VisitStepListener.VisitStepListenerCommittedEvent();
            committedEvent.setEntities(committedDataList);
            listener.committed(committedEvent);
        }
    }

    protected void visitProcess(String visitId) {
        if (StringUtils.isBlank((CharSequence)visitId)) {
            return;
        }
        this.sfaVisitPlanInfoService.updateStepStatus(visitId, SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_DEF_PROGRAMME);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveSfaAsCashing(SfaAsCashingReqVo reqVo) {
        List contactVos;
        AssertUtils.isNotEmpty((String)reqVo.getActivityCode(), (String)"\u6d3b\u52a8\u7f16\u7801\u4e3a\u7a7a");
        SfaActSchemePosApplyEntity actSchemePosApplyEntity = (SfaActSchemePosApplyEntity)((Object)((LambdaQueryChainWrapper)this.sfaActSchemePosApplyService.lambdaQuery().eq(SfaActSchemePosApplyEntity::getActivityCode, (Object)reqVo.getActivityCode())).one());
        if (null == actSchemePosApplyEntity) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u6d3b\u52a8[" + reqVo.getActivityCode() + "]");
        }
        AssertUtils.isNotEmpty((String)reqVo.getTerminalCode(), (String)"\u7ec8\u7aef\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getTerminalName(), (String)"\u7ec8\u7aef\u540d\u79f0\u4e3a\u7a7a");
        MdmTerminalVo mdmTerminalVo = (MdmTerminalVo)ApiResultUtil.objResult((Result)this.mdmTerminalFeign.query(null, reqVo.getTerminalCode()));
        reqVo.setTerminalAddr(mdmTerminalVo.getTerminalAddress());
        if (CollectionUtil.listNotEmpty((List)mdmTerminalVo.getContacts()) && CollectionUtil.listNotEmpty(contactVos = mdmTerminalVo.getContacts().stream().filter(o -> o.getContactMain().equals(YesNoEnum.yesNoEnum.ONE.getValue())).collect(Collectors.toList()))) {
            MdmTerminalContactVo terminalContactVo = (MdmTerminalContactVo)contactVos.get(0);
            reqVo.setTerminalUser(terminalContactVo.getContactName());
            reqVo.setTerminalPhone(terminalContactVo.getContactPhone());
        }
        if (SfaActivityEnum.paymentMethod.XJ.getVal().equals(actSchemePosApplyEntity.getPaymentMethod())) {
            if (null == reqVo.getTransferAmount()) {
                throw new BusinessException("\u8f6c\u8d26\u91d1\u989d\u4e3a\u7a7a");
            }
        } else {
            AssertUtils.isNotEmpty((Collection)reqVo.getAsCashingProductList(), (String)"\u5151\u4ed8\u4ea7\u54c1\u4e3a\u7a7a");
        }
        AssertUtils.isNotEmpty((Collection)reqVo.getAsCashingPictureList(), (String)"\u6d3b\u52a8\u5151\u4ed8\u56fe\u7247\u4e3a\u7a7a");
        SfaAsCashingEntity entity = (SfaAsCashingEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaAsCashingEntity.class));
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        this.sfaAsCashingService.save((Object)entity);
        String id = entity.getId();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getAsCashingProductList())) {
            List asCashingEntityList = CrmBeanUtil.copyList((List)reqVo.getAsCashingProductList(), SfaAsCashingProductEntity.class);
            asCashingEntityList.forEach(data -> {
                data.setCashingId(id);
                data.setId(null);
            });
            this.sfaAsCashingProductService.saveBatch(asCashingEntityList);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getAsCashingPictureList())) {
            List asCashingPictureList = CrmBeanUtil.copyList((List)reqVo.getAsCashingPictureList(), SfaAsCashingPictureEntity.class);
            asCashingPictureList.forEach(data -> {
                data.setCashingId(id);
                data.setId(null);
            });
            this.sfaAsCashingPictureService.saveBatch(asCashingPictureList);
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.sfaAsTreatyService.lambdaUpdate().eq(SfaAsTreatyEntity::getActivityCode, (Object)reqVo.getActivityCode())).eq(SfaAsTreatyEntity::getTerminalCode, (Object)reqVo.getTerminalCode())).set(SfaAsTreatyEntity::getTreatyStatus, (Object)SfaActivityEnum.TreatyStatus.CASHED.getVal())).update();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveAsStop(SfaAsStopReqVo reqVo) {
        List asStopList;
        UserRedis user = UserUtils.getUser();
        AssertUtils.isNotEmpty((String)reqVo.getActivityCode(), (String)"\u6d3b\u52a8\u7f16\u7801\u4e3a\u7a7a");
        SfaActSchemePosApplyEntity actSchemePosApplyEntity = (SfaActSchemePosApplyEntity)((Object)((LambdaQueryChainWrapper)this.sfaActSchemePosApplyService.lambdaQuery().eq(SfaActSchemePosApplyEntity::getActivityCode, (Object)reqVo.getActivityCode())).one());
        if (null == actSchemePosApplyEntity) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u6d3b\u52a8[" + reqVo.getActivityCode() + "]");
        }
        AssertUtils.isNotEmpty((String)reqVo.getTerminalCode(), (String)"\u7ec8\u7aef\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getTerminalName(), (String)"\u7ec8\u7aef\u540d\u79f0\u4e3a\u7a7a");
        if (com.biz.crm.util.StringUtils.isEmpty((String)reqVo.getStopState())) {
            reqVo.setStopState(YesNoEnum.yesNoEnum.ONE.getValue());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(asStopList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sfaAsStopService.lambdaQuery().eq(SfaAsStopEntity::getActivityCode, (Object)reqVo.getActivityCode())).eq(SfaAsStopEntity::getTerminalCode, (Object)reqVo.getTerminalCode())).list()))) {
            SfaAsStopEntity entity = (SfaAsStopEntity)((Object)asStopList.get(0));
            entity.setStopState(reqVo.getStopState());
            String now = LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss);
            entity.setStopDate(now);
            this.sfaAsStopService.updateById((Object)entity);
        } else {
            SfaAsStopEntity entity = (SfaAsStopEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaAsStopEntity.class));
            entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
            String now = LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss);
            entity.setStopDate(now);
            entity.setUserName(user.getUsername());
            entity.setRealName(user.getRealname());
            entity.setPosCode(user.getPoscode());
            entity.setPosName(user.getPosname());
            entity.setOrgCode(user.getOrgcode());
            entity.setOrgName(user.getOrgname());
            this.sfaAsStopService.save((Object)entity);
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.sfaAsTreatyService.lambdaUpdate().eq(SfaAsTreatyEntity::getActivityCode, (Object)reqVo.getActivityCode())).eq(SfaAsTreatyEntity::getTerminalCode, (Object)reqVo.getTerminalCode())).set(SfaAsTreatyEntity::getTreatyStatus, (Object)SfaActivityEnum.TreatyStatus.END.getVal())).update();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public SfaAsExecutionDetailRespVo queryExecutionDetailByActivityCodeAndTerminalCode(SfaAsExecutionDetailReqVo reqVo) {
        SfaAsStopEntity asStopEntity;
        SfaAsCashingEntity asCashingEntity;
        SfaAsTreatyEntity asTreatyEntity;
        AssertUtils.isNotEmpty((String)reqVo.getActivityCode(), (String)"\u6d3b\u52a8\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getTerminalCode(), (String)"\u7ec8\u7aef\u7f16\u7801\u4e3a\u7a7a");
        SfaAsExecutionDetailRespVo respVo = new SfaAsExecutionDetailRespVo();
        SfaActSchemePosApplyRespVo actSchemePosApply = this.sfaActSchemePosApplyService.queryExecutionDetailByActivityCodeAndTerminalCode(reqVo.getActivityCode(), reqVo.getTerminalCode());
        respVo.setActSchemePosApply(actSchemePosApply);
        List asExecutionEntities = null;
        asExecutionEntities = com.biz.crm.util.StringUtils.isEmpty((String)reqVo.getVisitPlanInfoId()) ? ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaAsExecutionEntity::getActivityCode, (Object)reqVo.getActivityCode())).eq(SfaAsExecutionEntity::getTerminalCode, (Object)reqVo.getTerminalCode())).list() : ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaAsExecutionEntity::getActivityCode, (Object)reqVo.getActivityCode())).eq(SfaAsExecutionEntity::getTerminalCode, (Object)reqVo.getTerminalCode())).eq(SfaAsExecutionEntity::getVisitPlanInfoId, (Object)reqVo.getVisitPlanInfoId())).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)asExecutionEntities)) {
            Map displayTypeMap = actSchemePosApply.getDisplayTypeMap();
            List asExecutionList = CrmBeanUtil.copyList((List)asExecutionEntities, SfaAsExecutionRespVo.class);
            ArrayList<String> executionIds = new ArrayList<String>();
            for (SfaAsExecutionRespVo asExecution : asExecutionList) {
                executionIds.add(asExecution.getId());
            }
            Map<Object, Object> mapAsExecutionPicture = new HashMap();
            List asExecutionPictures = ((LambdaQueryChainWrapper)this.sfaAsExecutionPictureService.lambdaQuery().in(SfaAsExecutionPictureEntity::getExecutionId, executionIds)).list();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)asExecutionPictures)) {
                List asExecutionPictureList = CrmBeanUtil.copyList((List)asExecutionPictures, SfaAsExecutionPictureRespVo.class);
                asExecutionPictureList.forEach(o -> o.setDisplayTypeDesc((String)displayTypeMap.get(o.getDisplayType())));
                mapAsExecutionPicture = asExecutionPictureList.stream().collect(Collectors.groupingBy(SfaAsExecutionPictureRespVo::getExecutionId));
            }
            Map<Object, Object> mapAsExecutionProduct = new HashMap();
            List asExecutionProducts = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sfaAsExecutionProductService.lambdaQuery().in(SfaAsExecutionProductEntity::getExecutionId, executionIds)).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).list();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)asExecutionProducts)) {
                List asExecutionProductList = CrmBeanUtil.copyList((List)asExecutionProducts, SfaAsExecutionProductRespVo.class);
                mapAsExecutionProduct = asExecutionProductList.stream().collect(Collectors.groupingBy(SfaAsExecutionProductRespVo::getExecutionId));
            }
            for (SfaAsExecutionRespVo asExecution : asExecutionList) {
                String executionId = asExecution.getId();
                List asExecutionPictureRespVos = (List)mapAsExecutionPicture.get(executionId);
                Map<String, List<SfaAsExecutionPictureRespVo>> listMap = asExecutionPictureRespVos.stream().collect(Collectors.groupingBy(SfaAsExecutionPictureRespVo::getDisplayType));
                ArrayList pictureTopVos = Lists.newArrayList();
                listMap.forEach((k, v) -> {
                    SfaAsExecutionPictureRespVo pictureRespVo = (SfaAsExecutionPictureRespVo)v.get(0);
                    SfaAsExecutionPictureTopVo pictureTopVo = new SfaAsExecutionPictureTopVo();
                    pictureTopVo.setDisplayType(k);
                    pictureTopVo.setDisplayTypeDesc(pictureRespVo.getDisplayTypeDesc());
                    pictureTopVo.setExecutionId(pictureRespVo.getExecutionId());
                    pictureTopVo.setPictureRespVos(v);
                    pictureTopVos.add(pictureTopVo);
                });
                asExecution.setAsExecutionPictureTopVos((List)pictureTopVos);
                ArrayList productTopVos = Lists.newArrayList();
                List executionProductRespVos = (List)mapAsExecutionProduct.get(executionId);
                Map<String, List<SfaAsExecutionProductRespVo>> listProMap = executionProductRespVos.stream().collect(Collectors.groupingBy(SfaAsExecutionProductRespVo::getSetmealId));
                listProMap.forEach((k, v) -> {
                    SfaAsExecutionProductRespVo productRespVo = (SfaAsExecutionProductRespVo)v.get(0);
                    SfaAsExecutionProductTopVo productTopVo = new SfaAsExecutionProductTopVo();
                    productTopVo.setExecutionId(productRespVo.getExecutionId());
                    productTopVo.setSetmealId(productRespVo.getSetmealId());
                    productTopVo.setProductRespVos(v);
                    productTopVos.add(productTopVo);
                });
                asExecution.setAsExecutionProductTopVos((List)productTopVos);
                List<String> displayTypeList = Arrays.asList(asExecution.getDisplayType().split(","));
                ArrayList<String> displayTypeDescList = new ArrayList<String>();
                for (String displayType : displayTypeList) {
                    String s = (String)displayTypeMap.get(displayType);
                    if (!com.biz.crm.util.StringUtils.isNotEmpty((String)s)) continue;
                    displayTypeDescList.add(s);
                }
                String displayTypeDesc = Joiner.on((String)",").join(displayTypeDescList);
                asExecution.setDisplayTypeDesc(displayTypeDesc);
            }
            respVo.setAsExecutionList(asExecutionList);
        }
        if (null != (asTreatyEntity = (SfaAsTreatyEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sfaAsTreatyService.lambdaQuery().eq(SfaAsTreatyEntity::getActivityCode, (Object)reqVo.getActivityCode())).eq(SfaAsTreatyEntity::getTerminalCode, (Object)reqVo.getTerminalCode())).one()))) {
            SfaAsTreatyRespVo asTreaty = (SfaAsTreatyRespVo)CrmBeanUtil.copy((Object)((Object)asTreatyEntity), SfaAsTreatyRespVo.class);
            respVo.setAsTreaty(asTreaty);
        }
        if (null != (asCashingEntity = (SfaAsCashingEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sfaAsCashingService.lambdaQuery().eq(SfaAsCashingEntity::getActivityCode, (Object)reqVo.getActivityCode())).eq(SfaAsCashingEntity::getTerminalCode, (Object)reqVo.getTerminalCode())).one()))) {
            List asCashingPictureEntities;
            SfaAsCashingRespVo asCashing = (SfaAsCashingRespVo)CrmBeanUtil.copy((Object)((Object)asCashingEntity), SfaAsCashingRespVo.class);
            List asCashingProductEntities = ((LambdaQueryChainWrapper)this.sfaAsCashingProductService.lambdaQuery().eq(SfaAsCashingProductEntity::getCashingId, (Object)asCashing.getId())).list();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)asCashingProductEntities)) {
                List asCashingProductList = CrmBeanUtil.copyList((List)asCashingProductEntities, SfaAsCashingProductRespVo.class);
                asCashing.setAsCashingProductList(asCashingProductList);
            }
            if (CollectionUtil.listNotEmptyNotSizeZero((List)(asCashingPictureEntities = ((LambdaQueryChainWrapper)this.sfaAsCashingPictureService.lambdaQuery().eq(SfaAsCashingPictureEntity::getCashingId, (Object)asCashing.getId())).list()))) {
                List asCashingPictureList = CrmBeanUtil.copyList((List)asCashingPictureEntities, SfaAsCashingPictureRespVo.class);
                asCashing.setAsCashingPictureList(asCashingPictureList);
            }
            respVo.setAsCashing(asCashing);
        }
        if (null != (asStopEntity = (SfaAsStopEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sfaAsStopService.lambdaQuery().eq(SfaAsStopEntity::getActivityCode, (Object)reqVo.getActivityCode())).eq(SfaAsStopEntity::getTerminalCode, (Object)reqVo.getTerminalCode())).one()))) {
            SfaAsStopRespVo asStop = (SfaAsStopRespVo)CrmBeanUtil.copy((Object)((Object)asStopEntity), SfaAsStopRespVo.class);
            if (!ObjectUtils.isEmpty((Object)respVo.getAsCashing())) {
                asStop.setStopState("2");
            }
            respVo.setAsStop(asStop);
            if (!ObjectUtils.isEmpty((Object)((Object)asTreatyEntity))) {
                respVo.setParticipateInType(SfaActivityEnum.participateInType.A.getVal());
            } else {
                respVo.setParticipateInType(SfaActivityEnum.participateInType.F.getVal());
            }
        }
        return respVo;
    }

    @Override
    public void updateExecutionProduct(SfaAsExecuteOrderProductReqVo params) {
        String executeId = params.getExecuteId();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.sfaAsExecutionProductService.lambdaUpdate().eq(SfaAsExecutionProductEntity::getExecutionId, (Object)executeId)).set(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.DELETE.getCode())).update();
        ArrayList productEntities = Lists.newArrayList();
        params.getSfaActSchemeSetmealRespVos().forEach(o -> {
            List bp = o.getBpSchemeProductList();
            bp.forEach(b -> {
                SfaAsExecutionProductEntity entity = new SfaAsExecutionProductEntity();
                entity.setExecutionId(executeId);
                entity.setItmeType(b.getItmeType());
                if (com.biz.crm.util.StringUtils.isNotEmpty((String)b.getPrice())) {
                    entity.setPrice(new BigDecimal(b.getPrice()));
                }
                entity.setProductCode(b.getProductCode());
                entity.setProductName(b.getProductName());
                entity.setProductNum(b.getQuantity().toBigInteger());
                entity.setSetmealId(b.getSetmealId());
                productEntities.add(entity);
            });
            List zp = o.getZpSchemeProductList();
            zp.forEach(z -> {
                SfaAsExecutionProductEntity entity = new SfaAsExecutionProductEntity();
                entity.setExecutionId(executeId);
                entity.setItmeType(z.getItmeType());
                if (com.biz.crm.util.StringUtils.isNotEmpty((String)z.getPrice())) {
                    entity.setPrice(new BigDecimal(z.getPrice()));
                }
                entity.setProductCode(z.getProductCode());
                entity.setProductName(z.getProductName());
                entity.setProductNum(z.getQuantity().toBigInteger());
                entity.setSetmealId(z.getSetmealId());
                productEntities.add(entity);
            });
        });
        this.sfaAsExecutionProductService.saveBatch(productEntities);
    }

    @Override
    public List<SfaActSchemePosApplyRespVo> findActSchemeByVisitPlanInfoId(SfaAsExecutionDetailReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getVisitPlanInfoId(), (String)"\u62dc\u8bbfID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getTerminalCode(), (String)"\u7ec8\u7aef\u7f16\u7801\u4e3a\u7a7a");
        List asExecutionEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaAsExecutionEntity::getTerminalCode, (Object)reqVo.getTerminalCode())).eq(SfaAsExecutionEntity::getVisitPlanInfoId, (Object)reqVo.getVisitPlanInfoId())).list();
        if (CollectionUtil.listEmpty((List)asExecutionEntities)) {
            return new ArrayList<SfaActSchemePosApplyRespVo>();
        }
        Set activityCodes = asExecutionEntities.stream().map(SfaAsExecutionEntity::getActivityCode).collect(Collectors.toSet());
        List schemePosApplyEntities = ((LambdaQueryChainWrapper)this.sfaActSchemePosApplyService.lambdaQuery().in(SfaActSchemePosApplyEntity::getActivityCode, activityCodes)).list();
        return CrmBeanUtil.copyList((List)schemePosApplyEntities, SfaActSchemePosApplyRespVo.class);
    }
}

