/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.common.CrmRedisHashKeyVo;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.service.ISfaVisitOffLineService;
import com.biz.crm.moblie.visitoffline.SfaVisitOffLineComponent;
import com.biz.crm.nebular.sfa.visitstep.visitoffline.VisitOffLineDataVo;
import com.biz.crm.nebular.sfa.visitstep.visitoffline.VisitOfflineReqVo;
import com.biz.crm.nebular.sfa.visitstep.visitoffline.VisitStepOffLienVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitdealer.service.ISfaVisitDealerDetailService;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoRedisData;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"SfaVisitOffLineServiceExpandImpl"})
public class SfaVisitOffLineServiceImpl
implements ISfaVisitOffLineService {
    @Resource
    protected RedisService redisService;
    @Autowired
    private ISfaVisitDealerDetailService sfaVisitDealerDetailService;
    @Resource
    protected SfaVisitOffLineComponent sfaVisitOffLineComponent;

    @Override
    public VisitOffLineDataVo getVisitOffLineData(CrmRedisHashKeyVo redisHashKeyVo) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(redisHashKeyVo.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckPlanInfo(redisHashKeyVo.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        if (SfaVisitEnum.visitStatus.V4.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())) {
            throw new BusinessException("\u8be5\u62dc\u8bbf\u8ba1\u5212\u5df2\u6807\u6ce8\u4e3a\u5f02\u5e38\u72b6\u6001\uff01");
        }
        if (SfaVisitEnum.visitStatus.V1.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())) {
            throw new BusinessException("\u8bf7\u5148\u8fdb\u5e97\u6253\u5361\uff01");
        }
        SfaVisitPlanInfoRedisData doingData = (SfaVisitPlanInfoRedisData)this.redisService.hmget(SfaVisitPlanInfoRedisData.getInstance().redisHashCurrent(sfaVisitPlanInfoEntity.getVisitDate(), visitRedisHashKey.getVisitBigType()).toString(), (Object)redisHashKeyVo.getRedisHashKey());
        VisitOffLineDataVo dataVo = (VisitOffLineDataVo)CrmBeanUtil.copy((Object)((Object)doingData.getSfaVisitPlanInfoExecuteRedisData()), VisitOffLineDataVo.class);
        dataVo.setClientPhoto(doingData.getClientPhoto());
        List stepOffLienVos = CrmBeanUtil.copyList(doingData.getStep(), VisitStepOffLienVo.class);
        List<VisitOfflineReqVo> stepCodeList = stepOffLienVos.stream().map(data -> {
            VisitOfflineReqVo reqVo = VisitOfflineReqVo.builder().stepCode(data.getStepCode()).visitPlanInfoId(sfaVisitPlanInfoEntity.getId()).clientCode(sfaVisitPlanInfoEntity.getClientCode()).clientType(sfaVisitPlanInfoEntity.getClientType()).formId(data.getFormId()).redisHashKey(redisHashKeyVo.getRedisHashKey()).build();
            return reqVo;
        }).collect(Collectors.toList());
        Future<Map<String, Object>> future = this.sfaVisitOffLineComponent.buildVisitStepData(stepCodeList);
        Map<String, Object> stepMap = future.get();
        stepOffLienVos.forEach(data -> {
            if (stepMap.containsKey(data.getStepCode())) {
                data.setExecuteData(stepMap.get(data.getStepCode()));
            }
        });
        dataVo.setSteps(stepOffLienVos);
        return dataVo;
    }

    private SfaVisitPlanInfoEntity loadAndCheckPlanInfo(String redisHashKey, String visitBigType) {
        UserRedis userRedis = UserUtils.getUser();
        String nowDate = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = (SfaVisitPlanInfoEntity)this.redisService.hmget(SfaVisitPlanInfoEntity.getInstance().redisHashCurrent(nowDate, visitBigType).toString(), (Object)redisHashKey);
        if (null == sfaVisitPlanInfoEntity) {
            throw new BusinessException("\u4e0d\u5b58\u5728\u7684\u62dc\u8bbf\u8ba1\u5212\uff0c\u6216\u8be5\u8ba1\u5212\u4e0d\u5728\u4eca\u65e5\u8ba1\u5212\u5185\uff01");
        }
        if (!StringUtils.equals((CharSequence)sfaVisitPlanInfoEntity.getVisitPosCode(), (CharSequence)userRedis.getPoscode())) {
            throw new BusinessException("\u4f60\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u8be5\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u767b\u9646\u6216\u5207\u6362\u804c\u4f4d\u518d\u5c1d\u8bd5\uff01");
        }
        return sfaVisitPlanInfoEntity;
    }
}

