/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.visitoffline;

import com.biz.crm.moblie.visitoffline.SfaVisitStepOffLineValidator;
import com.biz.crm.nebular.sfa.visitstep.visitoffline.VisitOfflineReqVo;
import com.biz.crm.util.UserUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Component;

@Component
public class SfaVisitOffLineComponent {
    private static final Integer CORE_POOL_SIZE = 10;
    private static final Integer MAXIMUM_POOL_SIZE = 20;
    private static final Integer KEEP_ALIVE_TIME = 20;
    private static final Integer SIZE = 30;
    private static final BlockingQueue<Runnable> QUEUE = new LinkedBlockingQueue<Runnable>(SIZE);
    public static ThreadPoolExecutor THREAD_POOL_EXECUTOR = new ThreadPoolExecutor(CORE_POOL_SIZE, MAXIMUM_POOL_SIZE, KEEP_ALIVE_TIME.intValue(), TimeUnit.SECONDS, QUEUE);

    public Future<Map<String, Object>> buildVisitStepData(List<VisitOfflineReqVo> reqVos) {
        String token = UserUtils.getToken();
        Future<Map<String, Object>> future = THREAD_POOL_EXECUTOR.submit(() -> {
            UserUtils.setToken((String)token);
            HashMap map = new HashMap(reqVos.size());
            reqVos.forEach(data -> {
                VisitOfflineReqVo reqVo = VisitOfflineReqVo.builder().clientCode(data.getClientCode()).clientType(data.getClientType()).stepCode(data.getStepCode()).visitPlanInfoId(data.getVisitPlanInfoId()).formId(data.getFormId()).redisHashKey(data.getRedisHashKey()).build();
                SfaVisitStepOffLineValidator validator = new SfaVisitStepOffLineValidator(data.getStepCode());
                Object obj = validator.buildVisitStepOffLineData(reqVo);
                map.put(data.getStepCode(), obj);
            });
            return map;
        });
        return future;
    }
}

