/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.asexecution.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.asexecution.mapper.SfaAsTreatyMapper;
import com.biz.crm.asexecution.model.SfaAsTreatyConvertProductEntity;
import com.biz.crm.asexecution.model.SfaAsTreatyDisplayProductEntity;
import com.biz.crm.asexecution.model.SfaAsTreatyEntity;
import com.biz.crm.asexecution.model.SfaAsTreatySignEntity;
import com.biz.crm.asexecution.service.ISfaAsTreatyConvertProductService;
import com.biz.crm.asexecution.service.ISfaAsTreatyDisplayProductService;
import com.biz.crm.asexecution.service.ISfaAsTreatyService;
import com.biz.crm.asexecution.service.ISfaAsTreatySignService;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.sfa.SfaActivityEnum;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.mdm.user.MdmUserFeign;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.nebular.sfa.asexecution.req.SfaAsTreatyReqVo;
import com.biz.crm.nebular.sfa.asexecution.req.TemplateTreatyProductVo;
import com.biz.crm.nebular.sfa.asexecution.req.TemplateTreatyVo;
import com.biz.crm.nebular.sfa.asexecution.resp.SfaAsTreatyRespVo;
import com.biz.crm.nebular.sfa.tpmact.VisitBaseVo;
import com.biz.crm.nebular.sfa.tpmact.displaytreaty.CashTreatyVo;
import com.biz.crm.nebular.sfa.tpmact.displaytreaty.DisplayTreatyVo;
import com.biz.crm.nebular.sfa.tpmact.displaytreaty.GoodsTreatyVo;
import com.biz.crm.nebular.sfa.tpmact.displaytreaty.SfaTpmActTreatyRedisVo;
import com.biz.crm.nebular.upload.vo.UploadVo;
import com.biz.crm.nebular.upload.vo.WordTemplateDataVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.tpmact.model.SfaTpmActBaseEntity;
import com.biz.crm.tpmact.model.SfaTpmActDetailEntity;
import com.biz.crm.tpmact.model.SfaTpmActDetailProductEntity;
import com.biz.crm.tpmact.service.ISfaTpmActDetailProductService;
import com.biz.crm.tpmact.service.ISfaTpmActDetailService;
import com.biz.crm.upload.file.OfficeFileFeign;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstepbase.VisitBaseCheck;
import com.biz.crm.visitstepbase.VisitBaseComponent;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.sf.cglib.beans.BeanMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"sfaAsTreatyServiceExpandImpl"})
@Transactional
public class SfaAsTreatyServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaAsTreatyMapper, SfaAsTreatyEntity>
implements ISfaAsTreatyService {
    private static final Logger log = LoggerFactory.getLogger(SfaAsTreatyServiceImpl.class);
    @Resource
    private SfaAsTreatyMapper sfaAsTreatyMapper;
    @Autowired
    private ISfaAsTreatyConvertProductService sfaAsTreatyConvertProductService;
    @Autowired
    private ISfaAsTreatyDisplayProductService sfaAsTreatyDisplayProductService;
    @Autowired
    private ISfaAsTreatySignService sfaAsTreatySignService;
    @Resource
    private OfficeFileFeign officeFileFeign;
    @Resource
    private VisitBaseComponent visitBaseComponent;
    @Resource
    private RedisService redisService;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Resource
    private MdmUserFeign mdmUserFeign;
    @Autowired
    private ISfaTpmActDetailProductService sfaTpmActDetailProductService;
    @Autowired
    private ISfaTpmActDetailService sfaTpmActDetailService;

    @Override
    public PageResult<SfaAsTreatyRespVo> report(SfaAsTreatyReqVo params) {
        Page page = PageUtil.buildPage((Integer)params.getPageNum(), (Integer)params.getPageSize());
        List<SfaAsTreatyRespVo> list = this.sfaAsTreatyMapper.report((Page<SfaAsTreatyRespVo>)page, params);
        list.forEach(o -> {
            o.setUrlPath(o.getUrlPathPrefix() + o.getUrlPath());
            o.setTreatyStatusDesc((String)SfaActivityEnum.TreatyStatus.GETMAP.get(o.getTreatyStatus()));
        });
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public String saveWorkBenchGoodsTreaty(GoodsTreatyVo vo) {
        SfaAsTreatyEntity oldTreatyEntity;
        this.checkDisplayTreaty((DisplayTreatyVo)vo);
        AssertUtils.isNotEmpty((Collection)vo.getPayGoodList(), (String)"\u652f\u4ed8\u8d27\u54c1\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((Collection)vo.getRewardGoodList(), (String)"\u5956\u52b1\u8d27\u54c1\u4e3a\u7a7a");
        this.textCheck((DisplayTreatyVo)vo);
        BigDecimal totalPrice = this.checkGoodTreatyProduct(vo);
        SfaAsTreatyEntity entity = (SfaAsTreatyEntity)CrmBeanUtil.copy((Object)vo, SfaAsTreatyEntity.class);
        entity.setClientType(SfaVisitEnum.ClientType.TERMINAL.getVal());
        if (StringUtils.isNotEmpty((String)vo.getVisitPlanInfoId()) && null != (oldTreatyEntity = (SfaAsTreatyEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaTpmActBaseEntity::getVisitPlanInfoId, (Object)vo.getVisitPlanInfoId())).eq(SfaAsTreatyEntity::getActivityCode, (Object)vo.getActivityCode())).one())) {
            entity.setId(oldTreatyEntity.getId());
        }
        entity.setTreatySource(SfaCommonEnum.actTreatySource.TPM_ACTIVITY.getValue());
        if (StringUtils.isEmpty((String)vo.getTreatyCode())) {
            entity.setTreatyCode(CodeUtil.generateCode((String)SfaCodeEnum.schemeCode.SCHEME_ACTIVITY_TREATY_CODE.getVal()));
            entity.setTreatyStatus(SfaActivityEnum.TreatyStatus.IN_EXECUTION.getVal());
        }
        entity.setTotalPrice(totalPrice);
        this.visitBaseComponent.checkTpmActTreatyAmount(vo.getActivityCode(), totalPrice);
        this.saveOrUpdate(entity);
        vo.setId(entity.getId());
        this.sfaAsTreatyConvertProductService.remove((Wrapper)Wrappers.lambdaQuery(SfaAsTreatyConvertProductEntity.class).eq(SfaAsTreatyConvertProductEntity::getTreatyId, (Object)entity.getId()));
        ArrayList<SfaAsTreatyConvertProductEntity> convertProductEntities = new ArrayList<SfaAsTreatyConvertProductEntity>();
        vo.getPayGoodList().forEach(data -> {
            SfaAsTreatyConvertProductEntity productEntity = (SfaAsTreatyConvertProductEntity)((Object)((Object)CrmBeanUtil.copy((Object)data, SfaAsTreatyConvertProductEntity.class)));
            productEntity.setTreatyId(entity.getId());
            productEntity.setItemType(SfaCommonEnum.actDisplayProductType.pay.getValue());
            convertProductEntities.add(productEntity);
        });
        vo.getRewardGoodList().forEach(data -> {
            SfaAsTreatyConvertProductEntity productEntity = (SfaAsTreatyConvertProductEntity)((Object)((Object)CrmBeanUtil.copy((Object)data, SfaAsTreatyConvertProductEntity.class)));
            productEntity.setTreatyId(entity.getId());
            productEntity.setItemType(SfaCommonEnum.actDisplayProductType.reward.getValue());
            convertProductEntities.add(productEntity);
        });
        this.sfaAsTreatyConvertProductService.saveBatch(convertProductEntities);
        this.saveDisplayProduct(vo.getDisplayProductList(), entity.getId());
        this.saveSignPic(vo.getSignPic(), entity.getId());
        SfaTpmActTreatyRedisVo redisVo = (SfaTpmActTreatyRedisVo)CrmBeanUtil.copy((Object)vo, SfaTpmActTreatyRedisVo.class);
        this.createPdf(redisVo, entity, SfaActivityEnum.paymentMethod.HW.getVal(), convertProductEntities);
        String pdfUrlPath = entity.getUrlPathPrefix() + entity.getUrlPath();
        this.redisService.hmset(SfaTpmActTreatyRedisVo.getRedisHashKey((String)entity.getId()), SfaTpmActTreatyRedisVo.buildMap((String)entity.getId(), (String)pdfUrlPath), SfaTpmActTreatyRedisVo.REDIS_EXPIRE_TIME.longValue());
        entity.setId(entity.getActivityCode());
        this.visitBaseComponent.tpmDoListener(entity);
        return entity.getId();
    }

    @Override
    public String saveWorkBenchCashTreaty(CashTreatyVo vo) {
        SfaAsTreatyEntity oldTreatyEntity;
        this.checkDisplayTreaty((DisplayTreatyVo)vo);
        if (vo.getMonthPayAmount() == null) {
            throw new BusinessException("\u6bcf\u6708\u652f\u4ed8\u73b0\u91d1\u4e3a\u7a7a");
        }
        if (vo.getTotalAmount() == null) {
            throw new BusinessException("\u5408\u8ba1\u5956\u52b1\u73b0\u91d1\u4e3a\u7a7a");
        }
        AssertUtils.isNotEmpty((String)vo.getPayee(), (String)"\u5956\u52b1\u6536\u6b3e\u4eba\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)vo.getContactPhone(), (String)"\u8054\u7cfb\u7535\u8bdd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)vo.getRemarks(), (String)"\u9644\u52a0\u6761\u4ef6\u8bf4\u660e\u4e3a\u7a7a");
        this.textCheck((DisplayTreatyVo)vo);
        SfaAsTreatyEntity entity = (SfaAsTreatyEntity)CrmBeanUtil.copy((Object)vo, SfaAsTreatyEntity.class);
        entity.setClientType(SfaVisitEnum.ClientType.TERMINAL.getVal());
        if (StringUtils.isNotEmpty((String)vo.getVisitPlanInfoId()) && null != (oldTreatyEntity = (SfaAsTreatyEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaTpmActBaseEntity::getVisitPlanInfoId, (Object)vo.getVisitPlanInfoId())).eq(SfaAsTreatyEntity::getActivityCode, (Object)vo.getActivityCode())).one())) {
            entity.setId(oldTreatyEntity.getId());
        }
        entity.setTotalPrice(entity.getTotalAmount());
        this.visitBaseComponent.checkTpmActTreatyAmount(vo.getActivityCode(), entity.getTotalPrice());
        entity.setTreatySource(SfaCommonEnum.actTreatySource.TPM_ACTIVITY.getValue());
        if (StringUtils.isEmpty((String)vo.getActivityCode())) {
            entity.setTreatyCode(CodeUtil.generateCode((String)SfaCodeEnum.schemeCode.SCHEME_ACTIVITY_TREATY_CODE.getVal()));
            entity.setTreatyStatus(SfaActivityEnum.TreatyStatus.IN_EXECUTION.getVal());
        }
        this.saveOrUpdate(entity);
        vo.setId(entity.getId());
        this.saveDisplayProduct(vo.getDisplayProductList(), entity.getId());
        this.saveSignPic(vo.getSignPic(), entity.getId());
        SfaTpmActTreatyRedisVo redisVo = (SfaTpmActTreatyRedisVo)CrmBeanUtil.copy((Object)vo, SfaTpmActTreatyRedisVo.class);
        this.createPdf(redisVo, entity, SfaActivityEnum.paymentMethod.XJ.getVal(), null);
        String pdfUrlPath = entity.getUrlPathPrefix() + entity.getUrlPath();
        this.redisService.hmset(SfaTpmActTreatyRedisVo.getRedisHashKey((String)entity.getId()), SfaTpmActTreatyRedisVo.buildMap((String)entity.getId(), (String)pdfUrlPath), SfaTpmActTreatyRedisVo.REDIS_EXPIRE_TIME.longValue());
        entity.setId(entity.getActivityCode());
        this.visitBaseComponent.tpmDoListener(entity);
        return entity.getId();
    }

    @Override
    public String saveVisitStepGoodsTreaty(VisitBaseVo<GoodsTreatyVo> vo) {
        VisitBaseCheck.checkBaseData(vo);
        GoodsTreatyVo goodsTreatyVo = (GoodsTreatyVo)vo.getStepExecuteData();
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(vo.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.visitBaseComponent.loadAndCheckSfaVisitPlanInfoEntity(vo.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        goodsTreatyVo.setVisitPlanInfoId(sfaVisitPlanInfoEntity.getId());
        goodsTreatyVo.setStepCode(SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_TPM.getVal());
        SfaVisitStepFromRespVo fromRespVo = this.visitBaseComponent.getFormData(vo.getFormId());
        VisitBaseCheck.checkVisitStepDistance(sfaVisitPlanInfoEntity, fromRespVo, goodsTreatyVo.getLongitude(), goodsTreatyVo.getLatitude());
        this.visitBaseComponent.updateStepStatus(vo.getRedisHashKey(), fromRespVo.getStepCode(), visitRedisHashKey.getVisitBigType());
        return this.saveWorkBenchGoodsTreaty(goodsTreatyVo);
    }

    @Override
    public String saveVisitStepCashTreaty(VisitBaseVo<CashTreatyVo> vo) {
        VisitBaseCheck.checkBaseData(vo);
        CashTreatyVo cashTreatyVo = (CashTreatyVo)vo.getStepExecuteData();
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(vo.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.visitBaseComponent.loadAndCheckSfaVisitPlanInfoEntity(vo.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        cashTreatyVo.setVisitPlanInfoId(sfaVisitPlanInfoEntity.getId());
        cashTreatyVo.setStepCode(SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_TPM.getVal());
        SfaVisitStepFromRespVo fromRespVo = this.visitBaseComponent.getFormData(vo.getFormId());
        VisitBaseCheck.checkVisitStepDistance(sfaVisitPlanInfoEntity, fromRespVo, cashTreatyVo.getLongitude(), cashTreatyVo.getLatitude());
        this.visitBaseComponent.updateStepStatus(vo.getRedisHashKey(), fromRespVo.getStepCode(), visitRedisHashKey.getVisitBigType());
        return this.saveWorkBenchCashTreaty(cashTreatyVo);
    }

    @Override
    public String loadTpmActTreatyDetail(String id) {
        Object obj = this.redisService.hmget(SfaTpmActTreatyRedisVo.getRedisHashKey((String)id), (Object)id);
        String pdfUrlPath = null;
        if (obj == null) {
            SfaAsTreatyEntity treatyEntity = (SfaAsTreatyEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)id)).one();
            if (treatyEntity == null) {
                throw new BusinessException("\u4e3b\u952eid\u9519\u8bef,\u672a\u67e5\u8be2\u5230\u76f8\u5173\u7684\u9648\u5217\u534f\u8bae\u4fe1\u606f");
            }
            pdfUrlPath = treatyEntity.getUrlPathPrefix() + treatyEntity.getUrlPath();
            this.redisService.hmset(SfaTpmActTreatyRedisVo.getRedisHashKey((String)id), SfaTpmActTreatyRedisVo.buildMap((String)id, (String)pdfUrlPath), SfaTpmActTreatyRedisVo.REDIS_EXPIRE_TIME.longValue());
        } else {
            pdfUrlPath = (String)obj;
        }
        return pdfUrlPath;
    }

    protected void checkDisplayTreaty(DisplayTreatyVo vo) {
        AssertUtils.isNotEmpty((String)vo.getDealerCode(), (String)"\u7ecf\u9500\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)vo.getDealerName(), (String)"\u7ecf\u9500\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)vo.getActivityCode(), (String)"\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)vo.getDisplayBrand(), (String)"\u9648\u5217\u54c1\u724c\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)vo.getDisplayItem(), (String)"\u9648\u5217\u54c1\u9879\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)vo.getDisplayPlace(), (String)"\u9648\u5217\u4f4d\u7f6e\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)vo.getDisplaySpecs(), (String)"\u9648\u5217\u89c4\u683c\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)vo.getDisplayNumber(), (String)"\u9648\u5217\u4ef6\u6570\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)vo.getDisplayStartTime(), (String)"\u9648\u5217\u5f00\u59cb\u65f6\u95f4\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)vo.getDisplayEndTime(), (String)"\u9648\u5217\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)vo.getDisplayMonth(), (String)"\u9648\u5217\u6708\u4efd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)vo.getTerminalCode(), (String)"\u7ec8\u7aef\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)vo.getTerminalName(), (String)"\u7ec8\u7aef\u540d\u79f0\u4e3a\u7a7a");
        if (null == vo.getSignPic() && null == vo.getLineStatus()) {
            throw new BusinessException("\u7b7e\u540d\u7167\u4e3a\u7a7a");
        }
        SfaAsTreatyEntity entity = (SfaAsTreatyEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaAsTreatyEntity::getActivityCode, (Object)vo.getActivityCode())).eq(SfaAsTreatyEntity::getTerminalCode, (Object)vo.getTerminalCode())).one();
        if (null != entity) {
            throw new BusinessException("\u8be5\u6d3b\u52a8\u5df2\u7b7e\u7f72tpm\u6d3b\u52a8\u9648\u5217\u534f\u8bae,\u4e0d\u53ef\u5728\u8fdb\u884c\u7b7e\u7f72");
        }
    }

    protected BigDecimal checkGoodTreatyProduct(GoodsTreatyVo vo) {
        SfaTpmActDetailEntity actDetailEntity = (SfaTpmActDetailEntity)((Object)((LambdaQueryChainWrapper)this.sfaTpmActDetailService.lambdaQuery().eq(SfaTpmActDetailEntity::getActDetailCode, (Object)vo.getActivityCode())).select(new SFunction[]{SfaTpmActDetailEntity::getHdCommitment}).one());
        BigDecimal price = BigDecimal.ZERO;
        vo.getPayGoodList().forEach(data -> {
            AssertUtils.isNotEmpty((String)data.getProductCode(), (String)"\u652f\u4ed8\u8d27\u54c1\u4ea7\u54c1\u7f16\u7801\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)data.getProductName(), (String)"\u652f\u4ed8\u8d27\u54c1\u4ea7\u54c1\u540d\u79f0\u4e3a\u7a7a");
            if (data.getProductNum() == null) {
                throw new BusinessException("\u652f\u4ed8\u8d27\u54c1" + data.getProductName() + "\u6570\u91cf\u4e3a\u7a7a");
            }
        });
        for (GoodsTreatyVo.ConvertProduct data2 : vo.getRewardGoodList()) {
            AssertUtils.isNotEmpty((String)data2.getProductCode(), (String)"\u5956\u52b1\u8d27\u54c1\u4ea7\u54c1\u7f16\u7801\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)data2.getProductName(), (String)"\u5956\u52b1\u8d27\u54c1\u4ea7\u54c1\u540d\u79f0\u4e3a\u7a7a");
            if (data2.getProductNum() == null) {
                throw new BusinessException("\u5956\u52b1\u8d27\u54c1" + data2.getProductName() + "\u6570\u91cf\u4e3a\u7a7a");
            }
            if (data2.getPrice() == null) {
                throw new BusinessException("\u5956\u52b1\u8d27\u54c1" + data2.getProductName() + "\u4ef7\u683c\u4e3a\u7a7a");
            }
            if (actDetailEntity != null && actDetailEntity.getHdCommitment() != null) {
                price = price.add(actDetailEntity.getHdCommitment().multiply(new BigDecimal(data2.getProductNum())));
                continue;
            }
            price = price.add(data2.getPrice().multiply(new BigDecimal(data2.getProductNum())));
        }
        return price;
    }

    protected void saveDisplayProduct(List<DisplayTreatyVo.DisplayProduct> displayProductList, String treatyId) {
        this.sfaAsTreatyDisplayProductService.remove((Wrapper)Wrappers.lambdaQuery(SfaAsTreatyDisplayProductEntity.class).eq(SfaAsTreatyDisplayProductEntity::getTreatyId, (Object)treatyId));
        if (CollectionUtil.listNotEmptyNotSizeZero(displayProductList)) {
            ArrayList displayProductEntityList = new ArrayList();
            displayProductList.forEach(data -> {
                SfaAsTreatyDisplayProductEntity entity = (SfaAsTreatyDisplayProductEntity)((Object)((Object)CrmBeanUtil.copy((Object)data, SfaAsTreatyDisplayProductEntity.class)));
                entity.setTreatyId(treatyId);
                displayProductEntityList.add(entity);
            });
            this.sfaAsTreatyDisplayProductService.saveBatch(displayProductEntityList);
        }
    }

    protected void saveSignPic(DisplayTreatyVo.SignPic signPic, String treatyId) {
        this.sfaAsTreatySignService.remove((Wrapper)Wrappers.lambdaQuery(SfaAsTreatySignEntity.class).eq(SfaAsTreatySignEntity::getTreatyId, (Object)treatyId));
        SfaAsTreatySignEntity signEntity = (SfaAsTreatySignEntity)((Object)CrmBeanUtil.copy((Object)signPic, SfaAsTreatySignEntity.class));
        signEntity.setTreatyId(treatyId);
        this.sfaAsTreatySignService.save((Object)signEntity);
    }

    private void createPdf(SfaTpmActTreatyRedisVo reqVo, SfaAsTreatyEntity entity, String type, List<SfaAsTreatyConvertProductEntity> convertProductEntities) {
        Map<String, String> actProductMap = ((LambdaQueryChainWrapper)this.sfaTpmActDetailProductService.lambdaQuery().eq(SfaTpmActDetailProductEntity::getActDetailCode, (Object)entity.getActivityCode())).list().stream().filter(data -> StringUtils.isNotEmpty((String)data.getSpec())).collect(Collectors.toMap(SfaTpmActDetailProductEntity::getProductCode, SfaTpmActDetailProductEntity::getSpec));
        DisplayTreatyVo.SignPic asTreatySign = reqVo.getSignPic();
        TemplateTreatyVo templateTreatyVo = (TemplateTreatyVo)CrmBeanUtil.copy((Object)reqVo, TemplateTreatyVo.class);
        Result terminalResult = this.mdmTerminalFeign.query(null, reqVo.getTerminalCode());
        if (null != terminalResult && terminalResult.isSuccess() && terminalResult.getResult() != null) {
            MdmTerminalVo terminalVo = (MdmTerminalVo)terminalResult.getResult();
            templateTreatyVo.setTerminalAddr(terminalVo.getTerminalAddress());
            if (CollectionUtil.listNotEmptyNotSizeZero((List)terminalVo.getContacts())) {
                MdmTerminalContactVo contacts = (MdmTerminalContactVo)terminalVo.getContacts().get(0);
                templateTreatyVo.setTerminalPhone(contacts.getContactPhone());
            }
        } else {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u7ec8\u7aef\u4fe1\u606f");
        }
        templateTreatyVo.setRemarks(StringUtils.isEmpty((String)templateTreatyVo.getRemarks()) ? "\u65e0" : templateTreatyVo.getRemarks());
        final UserRedis userRedis = UserUtils.getUser();
        Result userRespVoResult = this.mdmUserFeign.query(new MdmUserReqVo(){
            {
                this.setUserName(userRedis.getUsername());
            }
        });
        MdmUserRespVo userRespVo = (MdmUserRespVo)ApiResultUtil.objResult((Result)userRespVoResult, (boolean)userRespVoResult.isSuccess());
        if (StringUtils.isNotEmpty((String)userRespVo.getUserPhone())) {
            templateTreatyVo.setCurrUserPhone(userRespVo.getUserPhone());
        }
        String currUserName = this.formatStrLength(userRedis.getRealname(), 10);
        String currUserPhone = templateTreatyVo.getCurrUserPhone();
        currUserPhone = currUserPhone + "&#160;&#160;&#160;&#160;&#160;&#160;";
        templateTreatyVo.setCurrUserPhone(currUserPhone);
        templateTreatyVo.setCurrUserName(currUserName);
        if (StringUtils.isEmpty((String)reqVo.getDisplayItem())) {
            templateTreatyVo.setDisplayInfo(reqVo.getDisplayBrand());
        } else if (CollectionUtil.listEmpty((List)reqVo.getDisplayProductList())) {
            templateTreatyVo.setDisplayInfo(reqVo.getDisplayItem());
        } else if (CollectionUtil.listNotEmpty((List)reqVo.getDisplayProductList())) {
            ArrayList productNames = Lists.newArrayList();
            reqVo.getDisplayProductList().forEach(o -> productNames.add(o.getProductName()));
            String displayInfo = Joiner.on((String)"\u3001").join((Iterable)productNames);
            templateTreatyVo.setDisplayInfo(displayInfo);
        }
        HashMap dataMap = Maps.newHashMap();
        if (templateTreatyVo != null) {
            BeanMap beanMap = BeanMap.create((Object)templateTreatyVo);
            for (Object key : beanMap.keySet()) {
                dataMap.put(key.toString(), beanMap.get(key));
            }
        }
        String[] startTime = reqVo.getDisplayStartTime().split("-");
        String[] endTime = reqVo.getDisplayEndTime().split("-");
        dataMap.put("startYear", startTime[0]);
        dataMap.put("startMonth", startTime[1]);
        dataMap.put("startDay", startTime[2]);
        dataMap.put("endYear", endTime[0]);
        dataMap.put("endMonth", endTime[1]);
        dataMap.put("endDay", endTime[2]);
        String date2Str = DateUtil.date2Str((SimpleDateFormat)DateUtil.date_sdf_wz);
        dataMap.put("currDate", date2Str);
        boolean equals = SfaActivityEnum.paymentMethod.XJ.getVal().equals(type);
        if (!equals) {
            Map<String, List<SfaAsTreatyConvertProductEntity>> listMap = convertProductEntities.stream().collect(Collectors.groupingBy(SfaAsTreatyConvertProductEntity::getItemType));
            listMap.forEach((k, v) -> {
                List productVos = v.stream().map(pd -> {
                    TemplateTreatyProductVo templateTreatyProductVo = (TemplateTreatyProductVo)CrmBeanUtil.copy((Object)pd, TemplateTreatyProductVo.class);
                    if (actProductMap != null && actProductMap.size() > 0 && actProductMap.containsKey(pd.getProductCode())) {
                        templateTreatyProductVo.setSpec((String)actProductMap.get(pd.getProductCode()));
                    } else {
                        templateTreatyProductVo.setSpec("\u65e0");
                    }
                    return templateTreatyProductVo;
                }).collect(Collectors.toList());
                if (SfaActivityEnum.bpItemType.bp.getVal().equals(k)) {
                    dataMap.put("products", productVos);
                } else {
                    dataMap.put("gifts", productVos);
                }
            });
        }
        if (!dataMap.containsKey("gifts") || dataMap.get("gifts") == null) {
            dataMap.put("gifts", new ArrayList());
        } else {
            List temp = (List)dataMap.get("gifts");
            if (CollectionUtil.listNotEmptyNotSizeZero((List)temp)) {
                dataMap.put("gifts", temp);
            }
        }
        WordTemplateDataVo dataVo = new WordTemplateDataVo();
        dataVo.setLeftOffset(Integer.valueOf(340));
        dataVo.setTopOffset(Integer.valueOf(equals ? -10 : -20));
        dataVo.setTemplateName(equals ? SfaActivityEnum.TemplateType.MONEY.getVal() : SfaActivityEnum.TemplateType.PRODUCT.getVal());
        dataVo.setZipTemplateName(equals ? SfaActivityEnum.TemplateType.MONEY.getDesc() : SfaActivityEnum.TemplateType.PRODUCT.getDesc());
        dataVo.setFileName(entity.getTreatyCode());
        dataVo.setTabText("\u4ee3\u8868\uff08\u7b7e\u5b57\uff09");
        dataVo.setSginImageUrl(asTreatySign.getUrlPathPrefix() + asTreatySign.getUrlPath());
        dataVo.setDataMap((Map)dataMap);
        Result uploadResult = this.officeFileFeign.createWordDocxToPdfFile(dataVo);
        List uploadVos = null;
        if (!uploadResult.isSuccess() || !CollectionUtil.listNotEmptyNotSizeZero((List)((List)uploadResult.getResult()))) {
            throw new BusinessException("\u751f\u6210PDF\u6587\u4ef6\u5931\u8d25");
        }
        uploadVos = (List)ApiResultUtil.objResult((Result)uploadResult, (boolean)true);
        if (!CollectionUtils.isEmpty((Collection)uploadVos)) {
            UploadVo uploadVo = (UploadVo)uploadVos.get(0);
            entity.setObjectName(uploadVo.getObjectName());
            entity.setUrlPath(uploadVo.getUrlPath());
            entity.setUrlPathPrefix(uploadVo.getUrlPathPrefix());
            this.updateById(entity);
        }
    }

    private String formatStrLength(String str, int len) {
        int length = str.length();
        int j = len - length;
        for (int i = 0; i < j; ++i) {
            str = str + "&#160;";
        }
        return str;
    }

    protected void textCheck(DisplayTreatyVo vo) {
        AssertUtils.isNotEmpty((String)vo.getStorePhone(), (String)"\u5e97\u4e3b\u624b\u673a\u53f7\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)vo.getVerificationCode(), (String)"\u9a8c\u8bc1\u7801\u4e3a\u7a7a");
    }
}

