/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpmact.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.attachment.ISfaAttachmentService;
import com.biz.crm.base.attachment.SfaAttachmentEntity;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.activiti.vo.AttachmentVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.sfa.tpmact.SfaTpmActOrderCollectVo;
import com.biz.crm.nebular.sfa.tpmact.VisitBaseVo;
import com.biz.crm.nebular.sfa.tpmact.actcollect.SfaTpmActCollectVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.tpmact.mapper.SfaVisitStepTpmActCollectMapper;
import com.biz.crm.tpmact.model.SfaTpmActBaseEntity;
import com.biz.crm.tpmact.model.SfaTpmAuditCollectExamplePictureEntity;
import com.biz.crm.tpmact.model.SfaVisitStepTpmActCollectEntity;
import com.biz.crm.tpmact.service.ISfaTpmAuditCollectExamplePictureService;
import com.biz.crm.tpmact.service.ISfaVisitStepTpmActCollectService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderService;
import com.biz.crm.visitstepbase.VisitBaseCheck;
import com.biz.crm.visitstepbase.VisitBaseComponent;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
@ConditionalOnMissingBean(name={"SfaVisitStepTpmActCollectServiceExpandImpl"})
@Transactional
public class SfaVisitStepTpmActCollectServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaVisitStepTpmActCollectMapper, SfaVisitStepTpmActCollectEntity>
implements ISfaVisitStepTpmActCollectService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitStepTpmActCollectServiceImpl.class);
    @Resource
    private SfaVisitStepTpmActCollectMapper sfaVisitStepTpmActCollectMapper;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Autowired
    private ISfaAttachmentService sfaAttachmentService;
    @Resource
    private RedisService redisService;
    @Resource
    private VisitBaseComponent visitBaseComponent;
    @Resource
    private ISfaTpmAuditCollectExamplePictureService sfaTpmAuditCollectExamplePictureService;
    @Resource
    private ISfaVisitStepOrderService sfaVisitStepOrderService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String saveWorkBenchActCollect(SfaTpmActCollectVo vo) {
        SfaVisitStepTpmActCollectEntity oldCollectEntity;
        AssertUtils.isNotEmpty((String)vo.getClientCode(), (String)"\u7ec8\u7aef\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)vo.getClientName(), (String)"\u7ec8\u7aef\u540d\u79f0\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)vo.getActDetailCode(), (String)"\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((Collection)vo.getCollectFormList(), (String)"\u6d3b\u52a8\u56fe\u7247\u91c7\u96c6\u4e3a\u7a7a");
        SfaVisitStepTpmActCollectEntity collectEntity = (SfaVisitStepTpmActCollectEntity)CrmBeanUtil.copy((Object)vo, SfaVisitStepTpmActCollectEntity.class);
        if (StringUtils.isNotEmpty((String)vo.getVisitPlanInfoId()) && (oldCollectEntity = (SfaVisitStepTpmActCollectEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaTpmActBaseEntity::getVisitPlanInfoId, (Object)vo.getVisitPlanInfoId())).eq(SfaVisitStepTpmActCollectEntity::getActDetailCode, (Object)vo.getActDetailCode())).one()) != null) {
            collectEntity = (SfaVisitStepTpmActCollectEntity)CrmBeanUtil.copy((Object)oldCollectEntity, SfaVisitStepTpmActCollectEntity.class);
        }
        this.buildEntity(collectEntity, vo.getClientCode());
        this.saveOrUpdate(collectEntity);
        vo.setId(collectEntity.getId());
        if (null == vo.getLineStatus()) {
            this.saveExtAttachmentList(vo.getCollectFormList(), collectEntity.getId());
        }
        this.redisService.hmset(SfaTpmActCollectVo.getRedisHashKey((String)collectEntity.getId()), SfaTpmActCollectVo.buildMap((String)collectEntity.getId(), (SfaTpmActCollectVo)vo), SfaTpmActCollectVo.redis_expire_time.longValue());
        collectEntity.setId(collectEntity.getActDetailCode());
        this.visitBaseComponent.tpmDoListener(collectEntity);
        return collectEntity.getId();
    }

    @Override
    public SfaTpmActCollectVo loadTpmActCollectDetail(String id) {
        SfaTpmActCollectVo collectVo = (SfaTpmActCollectVo)this.redisService.hmget(SfaTpmActCollectVo.getRedisHashKey((String)id), (Object)id);
        if (null == collectVo) {
            SfaVisitStepTpmActCollectEntity collectEntity = (SfaVisitStepTpmActCollectEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)id)).one();
            if (null == collectEntity) {
                throw new BusinessException("\u4e3b\u952eid\u9519\u8bef,\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u91c7\u96c6\u6570\u636e\u4fe1\u606f");
            }
            collectVo = (SfaTpmActCollectVo)CrmBeanUtil.copy((Object)collectEntity, SfaTpmActCollectVo.class);
            List attachmentEntities = ((LambdaQueryChainWrapper)this.sfaAttachmentService.lambdaQuery().eq(SfaAttachmentEntity::getBizId, (Object)id)).list();
            Map<String, List<SfaAttachmentEntity>> attachmentMap = attachmentEntities.stream().collect(Collectors.groupingBy(data -> data.getAttachmentBizType() + ":" + data.getAttachmentBizTypeName()));
            ArrayList<SfaTpmActCollectVo.CollectForm> collectFormList = new ArrayList<SfaTpmActCollectVo.CollectForm>();
            for (Map.Entry<String, List<SfaAttachmentEntity>> data2 : attachmentMap.entrySet()) {
                String[] param = data2.getKey().split(":");
                List attachmentVos = CrmBeanUtil.copyList(data2.getValue(), AttachmentVo.class);
                SfaTpmActCollectVo.CollectForm form = new SfaTpmActCollectVo.CollectForm();
                form.setExampleCode(param[0]);
                form.setExampleName(param[1]);
                form.setAttachmentList(attachmentVos);
                List pictureEntityList = ((LambdaQueryChainWrapper)this.sfaTpmAuditCollectExamplePictureService.lambdaQuery().eq(SfaTpmAuditCollectExamplePictureEntity::getExampleCode, (Object)param[0])).list();
                if (CollectionUtil.listNotEmptyNotSizeZero((List)pictureEntityList)) {
                    form.setPictList(pictureEntityList.stream().map(SfaTpmAuditCollectExamplePictureEntity::getUrlAddress).collect(Collectors.toList()));
                }
                collectFormList.add(form);
            }
            collectVo.setCollectFormList(collectFormList);
            String actDemand = attachmentEntities.stream().distinct().map(SfaAttachmentEntity::getAttachmentBizTypeName).collect(Collectors.toList()).stream().collect(Collectors.joining("\u3001"));
            collectVo.setActDemand(actDemand);
        }
        this.redisService.hmset(SfaTpmActCollectVo.getRedisHashKey((String)id), SfaTpmActCollectVo.buildMap((String)id, (SfaTpmActCollectVo)collectVo), SfaTpmActCollectVo.redis_expire_time.longValue());
        return collectVo;
    }

    @Override
    public String saveVisitStepActCollect(VisitBaseVo<SfaTpmActCollectVo> vo) {
        VisitBaseCheck.checkBaseData(vo);
        SfaTpmActCollectVo collectVo = (SfaTpmActCollectVo)vo.getStepExecuteData();
        collectVo.setStepCode("tpm");
        collectVo.setFormId(vo.getFormId());
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(vo.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.visitBaseComponent.loadAndCheckSfaVisitPlanInfoEntity(vo.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        collectVo.setVisitPlanInfoId(sfaVisitPlanInfoEntity.getId());
        collectVo.setStepCode(SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_TPM.getVal());
        SfaVisitStepFromRespVo fromRespVo = this.visitBaseComponent.getFormData(vo.getFormId());
        VisitBaseCheck.checkVisitStepDistance(sfaVisitPlanInfoEntity, fromRespVo, collectVo.getLongitude(), collectVo.getLatitude());
        this.visitBaseComponent.updateStepStatus(vo.getRedisHashKey(), fromRespVo.getStepCode(), visitRedisHashKey.getVisitBigType());
        return this.saveWorkBenchActCollect(collectVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveWorkBenchActOrderCollect(SfaTpmActOrderCollectVo vo) {
        if (vo != null) {
            if (vo.getCollectVo() != null) {
                this.saveWorkBenchActCollect(vo.getCollectVo());
            }
            if (vo.getOrderVo() != null) {
                this.sfaVisitStepOrderService.saveWorkBenchDistributionOrder(vo.getOrderVo());
            }
        }
    }

    @Override
    public List<SfaTpmActCollectVo> getTpmActExecuteDataByActDetailCode(String actDetailCode) {
        if (StringUtils.isEmpty((String)actDetailCode)) {
            throw new BusinessException("\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List sfaVisitStepTpmActCollectEntity = this.sfaVisitStepTpmActCollectMapper.selectList((Wrapper)Wrappers.lambdaQuery(SfaVisitStepTpmActCollectEntity.class).eq(SfaVisitStepTpmActCollectEntity::getActDetailCode, (Object)actDetailCode));
        if (null == sfaVisitStepTpmActCollectEntity) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u91c7\u96c6\u6570\u636e\u4fe1\u606f");
        }
        List sfaTpmActCollectVos = CrmBeanUtil.copyList((List)sfaVisitStepTpmActCollectEntity, SfaTpmActCollectVo.class);
        sfaTpmActCollectVos.forEach(o -> {
            SfaTpmActCollectVo sfaTpmActCollectVo = this.loadTpmActCollectDetail(o.getId());
            if (!ObjectUtils.isEmpty((Object)sfaTpmActCollectVo)) {
                o.setCollectFormList(sfaTpmActCollectVo.getCollectFormList());
            }
        });
        return sfaTpmActCollectVos;
    }

    protected void buildEntity(SfaVisitStepTpmActCollectEntity entity, String terminalCode) {
        Result terminalResult = this.mdmTerminalFeign.query(null, terminalCode);
        if (null == terminalResult || !terminalResult.isSuccess() || terminalResult.getResult() == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u7ec8\u7aef\u4fe1\u606f,\u7ec8\u7aef\u7f16\u7801[" + terminalResult + "]");
        }
        MdmTerminalVo terminalVo = (MdmTerminalVo)terminalResult.getResult();
        entity.setClientType(SfaVisitEnum.ClientType.TERMINAL.getVal());
        entity.setClientTypeName(SfaVisitEnum.ClientType.TERMINAL.getDesc());
        entity.setClientSubclass(terminalVo.getTerminalType());
        entity.setClientSubclassName(terminalVo.getTerminalTypeName());
        UserRedis userRedis = UserUtils.getUser();
        entity.setUserName(userRedis.getUsername());
        entity.setRealName(userRedis.getRealname());
        entity.setPosCode(userRedis.getPoscode());
        entity.setPosName(userRedis.getPosname());
        entity.setOrgCode(userRedis.getOrgcode());
        entity.setOrgName(userRedis.getOrgname());
        entity.setCollectTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        entity.setCollectDate(LocalDateTime.now().format(CrmDateUtils.yyyyMMdd));
    }

    protected void saveExtAttachmentList(List<SfaTpmActCollectVo.CollectForm> collectFormList, String bizId) {
        this.sfaAttachmentService.remove((Wrapper)Wrappers.lambdaQuery(SfaAttachmentEntity.class).eq(SfaAttachmentEntity::getBizId, (Object)bizId));
        ArrayList attachmentEntities = new ArrayList();
        collectFormList.forEach(data -> {
            AssertUtils.isNotEmpty((String)data.getExampleCode(), (String)"\u91c7\u96c6\u7c7b\u578b\u7f16\u7801\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)data.getExampleName(), (String)"\u91c7\u96c6\u7c7b\u578b\u540d\u79f0\u4e3a\u7a7a");
            List picList = CrmBeanUtil.copyList((List)data.getAttachmentList(), SfaAttachmentEntity.class);
            picList.forEach(p -> {
                p.setBizId(bizId);
                p.setAttachmentBizType(data.getExampleCode());
                p.setAttachmentBizTypeName(data.getExampleName());
            });
            attachmentEntities.addAll(picList);
        });
        this.sfaAttachmentService.saveBatch(attachmentEntities);
    }
}

