/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.visitoffline;

import com.biz.crm.moblie.visitoffline.SfaVisitStepOffLineValidator;
import com.biz.crm.moblie.visitoffline.stepcomponent.photoutil.SfaVisitStepOffLineUtil;
import com.biz.crm.moblie.visitoffline.stepdatavo.req.SfaVisitOffLineReqVo;
import com.biz.crm.nebular.activiti.vo.AttachmentOffLineVo;
import com.biz.crm.nebular.sfa.visitstep.visitoffline.VisitOfflineReqVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnMissingBean(name={"sfaVisitOffLineComponentExpandImpl"})
public class SfaVisitOffLineComponent {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitOffLineComponent.class);
    private static final Integer CORE_POOL_SIZE = 10;
    private static final Integer MAXIMUM_POOL_SIZE = 20;
    private static final Integer KEEP_ALIVE_TIME = 20;
    private static final Integer SIZE = 30;
    private static final BlockingQueue<Runnable> QUEUE = new LinkedBlockingQueue<Runnable>(SIZE);
    public static ThreadPoolExecutor THREAD_POOL_EXECUTOR = new ThreadPoolExecutor(CORE_POOL_SIZE, MAXIMUM_POOL_SIZE, KEEP_ALIVE_TIME.intValue(), TimeUnit.SECONDS, QUEUE);

    public Future<Map<String, Object>> buildVisitStepData(List<VisitOfflineReqVo> reqVos) {
        String token = UserUtils.getToken();
        Future<Map<String, Object>> future = THREAD_POOL_EXECUTOR.submit(() -> {
            UserUtils.setToken((String)token);
            HashMap map = new HashMap(reqVos.size());
            reqVos.forEach(data -> {
                VisitOfflineReqVo reqVo = VisitOfflineReqVo.builder().clientCode(data.getClientCode()).clientType(data.getClientType()).stepCode(data.getStepCode()).visitPlanInfoId(data.getVisitPlanInfoId()).formId(data.getFormId()).redisHashKey(data.getRedisHashKey()).build();
                SfaVisitStepOffLineValidator validator = new SfaVisitStepOffLineValidator(data.getStepCode());
                Object obj = validator.buildVisitStepOffLineData(reqVo);
                map.put(data.getStepCode(), obj);
            });
            return map;
        });
        return future;
    }

    public Future<String> saveSfaVisitStepData(List<SfaVisitOffLineReqVo> dataList) {
        String token = UserUtils.getToken();
        Future<String> future = THREAD_POOL_EXECUTOR.submit(() -> {
            UserUtils.setToken((String)token);
            StringJoiner resultMsg = new StringJoiner(";");
            dataList.forEach(data -> {
                SfaVisitStepOffLineValidator validator = new SfaVisitStepOffLineValidator(data.getStepCode());
                Result result = validator.saveVisitStepOffLine(data.getReq());
                if (!result.isSuccess()) {
                    resultMsg.add(result.getMessage());
                }
            });
            return resultMsg.toString();
        });
        log.info("\u62dc\u8bbf\u79bb\u7ebf\u6570\u636e\u63d0\u4ea4\u5b8c\u6210.........");
        return future;
    }

    public void saveOffLineFile(Map<String, List<AttachmentOffLineVo>> fileMap) {
        String token = UserUtils.getToken();
        THREAD_POOL_EXECUTOR.execute(() -> {
            UserUtils.setToken((String)token);
            fileMap.entrySet().forEach(map -> {
                String key = (String)map.getKey();
                SfaVisitStepOffLineUtil util = new SfaVisitStepOffLineUtil(key);
                List fileList = (List)map.getValue();
                SfaVisitStepOffLineValidator validator = new SfaVisitStepOffLineValidator(util.getStepCode());
                validator.saveVisitStepOffLineFile(fileList, util);
            });
        });
    }
}

