/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.ActivitiEnum;
import com.biz.crm.moblie.service.ISfaWorkSignAuditService;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.activiti.act.req.ReadCopyTaskReqVO;
import com.biz.crm.nebular.activiti.task.resp.OptRecordRspVO;
import com.biz.crm.nebular.activiti.task.resp.ProcessInfoRspVO;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditFinishReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditListLeaveCancelReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditReportListReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaCopyTaskReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaExceptionReportListReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaLeaveListReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaTravelReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkOvertimeListReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaAuditListExceptionRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaAuditListLeaveCancelRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaAuditListLeaveRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaAuditListOvertimeRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaAuditListTravelRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaCopyTaskRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sfaWorkSignAudit"})
@Api(tags={"\u5c0f\u7a0b\u5e8f\u7aef-\u8003\u52e4\u7ba1\u7406-\u8003\u52e4\u5ba1\u6279 "})
public class SfaWorkSignAuditController {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkSignAuditController.class);
    @Autowired
    private ISfaWorkSignAuditService service;

    @ApiOperation(value="\u5f85\u5ba1\u6279\u6c47\u603b")
    @GetMapping(value={"/backlogCount"})
    @CrmLog
    public Result<Map<String, Integer>> backlogCount() {
        return Result.ok(this.service.backlogCount());
    }

    @ApiOperation(value="\u63d0\u4ea4\u5ba1\u6838\u4fe1\u606f")
    @PostMapping(value={"/auditCommit"})
    @CrmLog
    public Result auditCommit(@RequestBody SfaAuditReqVo reqVo) {
        return this.service.auditCommit(reqVo);
    }

    @ApiOperation(value="\u8bf7\u5047\u5ba1\u6279-\u5217\u8868")
    @PostMapping(value={"/auditListLeave"})
    @CrmLog
    public Result<PageResult<SfaAuditListLeaveRespVo>> auditListLeave(@RequestBody SfaLeaveListReqVo reqVo) {
        return Result.ok(this.service.auditListLeave(reqVo));
    }

    @ApiOperation(value="\u5de5\u4f5c\u65e5\u8c03\u6574-\u5217\u8868")
    @PostMapping(value={"/auditListOvertime"})
    @CrmLog
    public Result<PageResult<SfaAuditListOvertimeRespVo>> auditListOvertime(@RequestBody SfaWorkOvertimeListReqVo reqVo) {
        return Result.ok(this.service.auditListOvertime(reqVo));
    }

    @ApiOperation(value="\u5f02\u5e38\u62a5\u5907-\u5217\u8868")
    @PostMapping(value={"/auditListException"})
    @CrmLog
    public Result<PageResult<SfaAuditListExceptionRespVo>> auditListException(@RequestBody SfaExceptionReportListReqVo reqVo) {
        return Result.ok(this.service.auditListException(reqVo));
    }

    @ApiOperation(value="\u9500\u5047\u5ba1\u6279-\u5217\u8868")
    @PostMapping(value={"/auditListLeaveCancel"})
    @CrmLog
    public Result<PageResult<SfaAuditListLeaveCancelRespVo>> auditListLeaveCancel(@RequestBody SfaAuditListLeaveCancelReqVo reqVo) {
        return Result.ok(this.service.auditListLeaveCancel(reqVo));
    }

    @ApiOperation(value="\u51fa\u5dee\u5ba1\u6279-\u5217\u8868")
    @PostMapping(value={"/auditListTravel"})
    @CrmLog
    public Result<PageResult<SfaAuditListTravelRespVo>> auditListTravel(@RequestBody SfaTravelReqVo reqVo) {
        return Result.ok(this.service.auditListTravel(reqVo));
    }

    @ApiOperation(value="\u6284\u9001\u7ed9\u6211\u7684-\u5217\u8868")
    @PostMapping(value={"/copyTaskList"})
    @CrmLog
    public Result<PageResult<SfaCopyTaskRespVo>> copyTaskList(@RequestBody SfaCopyTaskReqVo reqVO) {
        return Result.ok(this.service.copyTaskList(reqVO));
    }

    @ApiOperation(value="\u6284\u9001\u8282\u70b9\u5df2\u9605")
    @PostMapping(value={"/readCopyTask"})
    @CrmLog
    public Result readCopyTask(@RequestBody ReadCopyTaskReqVO readCopyTaskReqVO) {
        return this.service.readCopyTask(readCopyTaskReqVO);
    }

    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u5ba1\u6279\u8bb0\u5f55")
    @PostMapping(value={"/findAuditRecords"})
    @CrmLog
    public Result<List<OptRecordRspVO>> findAuditRecords(@RequestBody SfaAuditReportListReqVo reqVo) {
        return Result.ok(this.service.findAuditRecords(reqVo));
    }

    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u8be6\u7ec6\u4fe1\u606f")
    @PostMapping(value={"/getProcessInfo"})
    @CrmLog
    public Result<ProcessInfoRspVO> getProcessInfo(@RequestBody SfaAuditReportListReqVo reqVo) {
        return Result.ok((Object)this.service.getProcessInfo(reqVo));
    }

    @ApiOperation(value="\u8bf7\u5047\u5ba1\u6838\u6d41\u7a0b\u7ed3\u675f")
    @PostMapping(value={"/leaveEnd"})
    @CrmLog
    public Result leaveEnd(@RequestBody ActivitiCallBackVo activitiCallBackVo) {
        return this.auditFinish(activitiCallBackVo, ActivitiEnum.FormTypeEnum.LEAVE);
    }

    @ApiOperation(value="\u5de5\u4f5c\u65e5\u8c03\u6574\u5ba1\u6838\u6d41\u7a0b\u7ed3\u675f")
    @PostMapping(value={"/overtimeEnd"})
    @CrmLog
    public Result overtimeEnd(@RequestBody ActivitiCallBackVo activitiCallBackVo) {
        return this.auditFinish(activitiCallBackVo, ActivitiEnum.FormTypeEnum.OVERTIME);
    }

    @ApiOperation(value="\u5f02\u5e38\u62a5\u5907\u5ba1\u6838\u6d41\u7a0b\u7ed3\u675f")
    @PostMapping(value={"/exceptionEnd"})
    @CrmLog
    public Result exceptionEnd(@RequestBody ActivitiCallBackVo activitiCallBackVo) {
        return this.auditFinish(activitiCallBackVo, ActivitiEnum.FormTypeEnum.EXCEPTION);
    }

    @ApiOperation(value="\u9500\u5047\u5ba1\u6838\u6d41\u7a0b\u7ed3\u675f")
    @PostMapping(value={"/leaveCancelEnd"})
    @CrmLog
    public Result leaveCancelEnd(@RequestBody ActivitiCallBackVo activitiCallBackVo) {
        return this.auditFinish(activitiCallBackVo, ActivitiEnum.FormTypeEnum.LEAVECANCEL);
    }

    @ApiOperation(value="\u51fa\u5dee\u5ba1\u6838\u6d41\u7a0b\u7ed3\u675f")
    @PostMapping(value={"/travelEnd"})
    @CrmLog
    public Result travelEnd(@RequestBody ActivitiCallBackVo activitiCallBackVo) {
        return this.auditFinish(activitiCallBackVo, ActivitiEnum.FormTypeEnum.TRAVEL);
    }

    private Result auditFinish(ActivitiCallBackVo activitiCallBackVo, ActivitiEnum.FormTypeEnum formTypeEnum) {
        SfaAuditFinishReqVo reqVo = new SfaAuditFinishReqVo();
        reqVo.setCostType(formTypeEnum.getCostType());
        reqVo.setFormId(activitiCallBackVo.getFormNo());
        if (activitiCallBackVo.getProcessState() == 2) {
            reqVo.setResult(ActivitiEnum.AuditResultType.PASS.getVal());
        } else if (activitiCallBackVo.getProcessState() == 3) {
            reqVo.setResult(ActivitiEnum.AuditResultType.REJECT.getVal());
        } else if (activitiCallBackVo.getProcessState() == 5) {
            reqVo.setResult(ActivitiEnum.AuditResultType.RECOVER.getVal());
        }
        if (StringUtils.isNotEmpty((String)reqVo.getResult())) {
            this.service.auditFinish(reqVo);
        }
        return Result.ok();
    }
}

