/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.req;

import com.biz.crm.base.BusinessException;
import com.biz.crm.visitstep.req.VisitStepPageReq;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;

@ApiModel(value="\u67e5\u8be2\u5e93\u5b58\u76d8\u70b9\u62a5\u8868")
public class GetStockInventoryTableReq
extends VisitStepPageReq {
    @ApiModelProperty(value="\u5ba2\u6237\u7f16\u7801")
    private String clientCode;
    @ApiModelProperty(value="\u5ba2\u6237\u7c7b\u578b")
    private String clientType;
    @ApiModelProperty(value="\u5ba2\u6237\u540d\u79f0")
    private String clientName;
    @ApiModelProperty(value="\u4eba\u5458\u540d\u79f0")
    private String realName;
    @ApiModelProperty(value="\u4ea7\u54c1\u7f16\u7801")
    private String productCode;
    @ApiModelProperty(value="\u4ea7\u54c1\u540d\u79f0")
    private String productName;
    @ApiModelProperty(value="\u63d0\u4ea4\u65f6\u95f4")
    private String stockTime;
    @ApiModelProperty(value="\u4eba\u5458\u8d26\u53f7")
    private String userName;

    public NativeSearchQuery buildQuery() {
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        if (StringUtils.isBlank((CharSequence)this.getStepCode())) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u6b65\u9aa4\u7f16\u7801");
        }
        builder.must((QueryBuilder)QueryBuilders.termQuery((String)"stepCode.keyword", (String)this.getStepCode()));
        if (StringUtils.isNotEmpty((CharSequence)this.getClientCode())) {
            builder.must((QueryBuilder)QueryBuilders.termQuery((String)"clientCode.keyword", (String)this.getClientCode()));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getClientName())) {
            builder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"clientName", (Object)this.getClientName()));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getClientType())) {
            builder.must((QueryBuilder)QueryBuilders.termQuery((String)"clientType.keyword", (String)this.getClientType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getRealName())) {
            builder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"realName", (Object)this.getRealName()));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getProductCode())) {
            builder.must((QueryBuilder)QueryBuilders.termQuery((String)"productCode.keyword", (String)this.getProductCode()));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getProductName())) {
            builder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"productName", (Object)this.getProductName()));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getStockTime())) {
            builder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"stockTime", (Object)this.getStockTime()));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getUserName())) {
            builder.must((QueryBuilder)QueryBuilders.termQuery((String)"userName", (String)this.getUserName()));
        }
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        nativeSearchQueryBuilder.withQuery((QueryBuilder)builder);
        if (StringUtils.isNotEmpty((CharSequence)this.getPageNum().toString()) && StringUtils.isNotEmpty((CharSequence)this.getPageSize().toString())) {
            nativeSearchQueryBuilder.withPageable((Pageable)PageRequest.of((int)(this.getPageNum() - 1), (int)this.getPageSize()));
        }
        nativeSearchQueryBuilder.withSort(SortBuilders.fieldSort((String)"stockTime").order(SortOrder.DESC));
        NativeSearchQuery query = nativeSearchQueryBuilder.build();
        return query;
    }

    public String getClientCode() {
        return this.clientCode;
    }

    public String getClientType() {
        return this.clientType;
    }

    public String getClientName() {
        return this.clientName;
    }

    public String getRealName() {
        return this.realName;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getStockTime() {
        return this.stockTime;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }

    public void setClientType(String clientType) {
        this.clientType = clientType;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public void setStockTime(String stockTime) {
        this.stockTime = stockTime;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetStockInventoryTableReq)) {
            return false;
        }
        GetStockInventoryTableReq other = (GetStockInventoryTableReq)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$clientCode = this.getClientCode();
        String other$clientCode = other.getClientCode();
        if (this$clientCode == null ? other$clientCode != null : !this$clientCode.equals(other$clientCode)) {
            return false;
        }
        String this$clientType = this.getClientType();
        String other$clientType = other.getClientType();
        if (this$clientType == null ? other$clientType != null : !this$clientType.equals(other$clientType)) {
            return false;
        }
        String this$clientName = this.getClientName();
        String other$clientName = other.getClientName();
        if (this$clientName == null ? other$clientName != null : !this$clientName.equals(other$clientName)) {
            return false;
        }
        String this$realName = this.getRealName();
        String other$realName = other.getRealName();
        if (this$realName == null ? other$realName != null : !this$realName.equals(other$realName)) {
            return false;
        }
        String this$productCode = this.getProductCode();
        String other$productCode = other.getProductCode();
        if (this$productCode == null ? other$productCode != null : !this$productCode.equals(other$productCode)) {
            return false;
        }
        String this$productName = this.getProductName();
        String other$productName = other.getProductName();
        if (this$productName == null ? other$productName != null : !this$productName.equals(other$productName)) {
            return false;
        }
        String this$stockTime = this.getStockTime();
        String other$stockTime = other.getStockTime();
        if (this$stockTime == null ? other$stockTime != null : !this$stockTime.equals(other$stockTime)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        return !(this$userName == null ? other$userName != null : !this$userName.equals(other$userName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GetStockInventoryTableReq;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $clientCode = this.getClientCode();
        result = result * 59 + ($clientCode == null ? 43 : $clientCode.hashCode());
        String $clientType = this.getClientType();
        result = result * 59 + ($clientType == null ? 43 : $clientType.hashCode());
        String $clientName = this.getClientName();
        result = result * 59 + ($clientName == null ? 43 : $clientName.hashCode());
        String $realName = this.getRealName();
        result = result * 59 + ($realName == null ? 43 : $realName.hashCode());
        String $productCode = this.getProductCode();
        result = result * 59 + ($productCode == null ? 43 : $productCode.hashCode());
        String $productName = this.getProductName();
        result = result * 59 + ($productName == null ? 43 : $productName.hashCode());
        String $stockTime = this.getStockTime();
        result = result * 59 + ($stockTime == null ? 43 : $stockTime.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "GetStockInventoryTableReq(clientCode=" + this.getClientCode() + ", clientType=" + this.getClientType() + ", clientName=" + this.getClientName() + ", realName=" + this.getRealName() + ", productCode=" + this.getProductCode() + ", productName=" + this.getProductName() + ", stockTime=" + this.getStockTime() + ", userName=" + this.getUserName() + ")";
    }
}

