/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.integral.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.eunm.sfa.IntegralEnum;
import com.biz.crm.eunm.sfa.WorkSignEnum;
import com.biz.crm.integral.controller.SfaIntegralSaveUtil;
import com.biz.crm.integral.service.SfaIntegralDetailService;
import com.biz.crm.mq.AbstractRocketMQConsumer;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.nebular.sfa.integral.req.SfaIntegralDetailMqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaMonthSignReqVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaMonthSignRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.visitinfo.model.SfaVisitCompleteInfoEntity;
import com.biz.crm.visitinfo.service.ISfaVisitCompleteInfoService;
import com.biz.crm.worksign.service.ISfaSignFormsService;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component
@RocketMQMessageListener(topic="${rocketmq.topic}${rocketmq.environment-variable}", selectorExpression="INTEGRAL_DETAIL_TAG", consumerGroup="INTEGRAL_DETAIL${rocketmq.environment-variable}")
public class SfaIntegralDetailMQConsumer
extends AbstractRocketMQConsumer {
    private static final Logger log = LoggerFactory.getLogger(SfaIntegralDetailMQConsumer.class);
    @Resource
    private ISfaSignFormsService sfaSignFormsService;
    @Resource
    private ISfaVisitCompleteInfoService sfaVisitCompleteInfoService;
    @Resource
    private SfaIntegralDetailService sfaIntegralDetailService;

    protected Object handleMessage(RocketMQMessageBody message) throws InterruptedException {
        String msg = message.getMsgBody();
        if (StringUtils.isEmpty((Object)msg)) {
            return "\u6d88\u606f\u4e3a\u7a7a!";
        }
        SfaIntegralDetailMqVo sfaIntegralDetailReqVo = (SfaIntegralDetailMqVo)JsonPropertyUtil.toObject((String)msg, SfaIntegralDetailMqVo.class);
        if (StringUtils.isEmpty((Object)sfaIntegralDetailReqVo)) {
            return "\u8bb0\u5f55\u4e3a\u7a7a!";
        }
        if (StringUtils.isEmpty((Object)sfaIntegralDetailReqVo.getIntegralType())) {
            this.addIntegralDetailByMonth(sfaIntegralDetailReqVo);
        } else {
            this.sfaIntegralDetailService.saveIntegralDetail(sfaIntegralDetailReqVo);
        }
        return "\u64cd\u4f5c\u6210\u529f";
    }

    public void addIntegralDetailByMonth(SfaIntegralDetailMqVo user) {
        if (this.doCheckSign(user.getUserName())) {
            SfaIntegralSaveUtil.saveIntegralDetail(IntegralEnum.taskType.MONTH_SIGN.getValue(), user.getPosCode());
        }
        if (this.doCheckMonthVisit(user.getUserName())) {
            SfaIntegralSaveUtil.saveIntegralDetail(IntegralEnum.taskType.FINISH_VISIT_PLAN.getValue(), user.getPosCode());
        }
    }

    private boolean doCheckSign(String userName) {
        BigDecimal normal;
        SfaMonthSignReqVo sfaMonthSignReqVo = new SfaMonthSignReqVo();
        sfaMonthSignReqVo.setTimeType(WorkSignEnum.TimeType.SY.getVal());
        sfaMonthSignReqVo.setUserName(userName);
        SfaMonthSignRespVo sfaMonthSignRespVo = this.sfaSignFormsService.appUserByMonthSign(sfaMonthSignReqVo);
        if (ObjectUtils.isEmpty((Object)sfaMonthSignRespVo)) {
            return false;
        }
        BigDecimal goToWorkDays = sfaMonthSignRespVo.getGoToWorkDays();
        return goToWorkDays.compareTo(normal = sfaMonthSignRespVo.getNormal()) == 0;
    }

    private boolean doCheckMonthVisit(String userName) {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(2, -1);
        String lastMonth = DateUtil.yyyy_MM.format(c.getTime());
        List list = this.sfaVisitCompleteInfoService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaVisitCompleteInfoEntity.class).eq(SfaVisitCompleteInfoEntity::getVisitUserName, (Object)userName)).eq(SfaVisitCompleteInfoEntity::getVisitYearMonth, (Object)lastMonth));
        if (CollectionUtil.listEmpty((List)list)) {
            return false;
        }
        List collect = list.stream().filter(s -> !"100.00".equals(s.getCompleteHelpVisitPercent())).collect(Collectors.toList());
        return CollectionUtil.listEmpty(collect);
    }
}

