/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpmact.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.sfa.tpmact.actcollect.SfaTpmActCollectVo;
import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActReqVo;
import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActTableReqVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActRespVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActTableRespVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActDetailRespVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActRespVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmCostTypeFineRespVo;
import com.biz.crm.tpm.act.TpmActFeign;
import com.biz.crm.tpmact.mapper.SfaTpmActMapper;
import com.biz.crm.tpmact.model.SfaTpmActDetailEntity;
import com.biz.crm.tpmact.model.SfaTpmActDetailProductEntity;
import com.biz.crm.tpmact.model.SfaTpmActEntity;
import com.biz.crm.tpmact.model.SfaTpmAuditCollectExampleEntity;
import com.biz.crm.tpmact.model.SfaTpmAuditCollectExamplePictureEntity;
import com.biz.crm.tpmact.model.SfaTpmCostTypeFineEntity;
import com.biz.crm.tpmact.service.ISfaTpmActDetailProductService;
import com.biz.crm.tpmact.service.ISfaTpmActDetailService;
import com.biz.crm.tpmact.service.ISfaTpmActService;
import com.biz.crm.tpmact.service.ISfaTpmAuditCollectExamplePictureService;
import com.biz.crm.tpmact.service.ISfaTpmAuditCollectExampleService;
import com.biz.crm.tpmact.service.ISfaTpmCostTypeFineService;
import com.biz.crm.tpmact.service.ISfaVisitStepTpmActCollectService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
@ConditionalOnMissingBean(name={"SfaTpmActServiceExpandImpl"})
public class SfaTpmActServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaTpmActMapper, SfaTpmActEntity>
implements ISfaTpmActService {
    private static final Logger log = LoggerFactory.getLogger(SfaTpmActServiceImpl.class);
    @Resource
    private SfaTpmActMapper sfaTpmActMapper;
    @Resource
    private TpmActFeign tpmActFeign;
    @Autowired
    private ISfaTpmActDetailService sfaTpmActDetailService;
    @Autowired
    private ISfaTpmActDetailProductService sfaTpmActDetailProductService;
    @Autowired
    private ISfaTpmCostTypeFineService sfaTpmCostTypeFineService;
    @Autowired
    private ISfaTpmAuditCollectExampleService sfaTpmAuditCollectExampleService;
    @Autowired
    private ISfaTpmAuditCollectExamplePictureService sfaTpmAuditCollectExamplePictureService;
    @Resource
    private MdmProductFeign mdmProductFeign;
    @Resource
    private ISfaVisitStepTpmActCollectService sfaVisitStepTpmActCollectService;

    @Override
    public PageResult<SfaTpmActRespVo> findList(SfaTpmActReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<SfaTpmActRespVo> list = this.sfaTpmActMapper.findList((Page<SfaTpmActRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaTpmActRespVo query(SfaTpmActReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaTpmActReqVo reqVo) {
        SfaTpmActEntity entity = (SfaTpmActEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaTpmActEntity.class));
        this.save((Object)entity);
    }

    @Override
    public void saveTpmAct(String actId) {
        Result result = this.tpmActFeign.query(actId);
        if (result.isSuccess() && null != result.getResult()) {
            TpmActRespVo tpmActVo = (TpmActRespVo)result.getResult();
            SfaTpmActEntity actEntity = (SfaTpmActEntity)((Object)CrmBeanUtil.copy((Object)tpmActVo, SfaTpmActEntity.class));
            actEntity.setBeginDate(actEntity.getBeginDate().split(" ")[0]);
            actEntity.setEndDate(actEntity.getEndDate().split(" ")[0]);
            List tpmActDetailVos = tpmActVo.getDetailVos();
            List actDetailEntities = CrmBeanUtil.copyList((List)tpmActVo.getDetailVos(), SfaTpmActDetailEntity.class);
            ArrayList sfaTpmCostTypeFineEntities = new ArrayList();
            ArrayList tpmActDetailProductEntityList = new ArrayList();
            tpmActDetailVos.forEach(data -> {
                this.actDetailProductList((TpmActDetailRespVo)data, tpmActDetailProductEntityList);
                this.actCostTypeFine((TpmActDetailRespVo)data, sfaTpmCostTypeFineEntities);
            });
            this.saveOrUpdate((Object)actEntity);
            this.sfaTpmActDetailService.saveOrUpdateBatch(actDetailEntities);
        }
    }

    @Override
    public void closedTpmAct(String actId) {
        SfaTpmActEntity sfaTpmActEntity;
        Result result = this.tpmActFeign.query(actId);
        if (result.isSuccess() && null != result.getResult() && null != (sfaTpmActEntity = (SfaTpmActEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)actId)).or()).eq(SfaTpmActEntity::getActCode, (Object)((TpmActRespVo)result.getResult()).getActCode())).one()))) {
            sfaTpmActEntity = (SfaTpmActEntity)((Object)CrmBeanUtil.copy((Object)result.getResult(), SfaTpmActEntity.class));
            sfaTpmActEntity.setBeginDate(sfaTpmActEntity.getBeginDate().split(" ")[0]);
            sfaTpmActEntity.setEndDate(sfaTpmActEntity.getEndDate().split(" ")[0]);
            this.saveOrUpdate((Object)sfaTpmActEntity);
        }
    }

    @Override
    public void allAudit(String actId) {
        Result result = this.tpmActFeign.query(actId);
        if (result.isSuccess() && null != result.getResult()) {
            TpmActRespVo tpmActRespVo = (TpmActRespVo)result.getResult();
            List detailVos = tpmActRespVo.getDetailVos();
            SfaTpmActEntity sfaTpmActEntity = (SfaTpmActEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)actId)).or()).eq(SfaTpmActEntity::getActCode, (Object)tpmActRespVo.getActCode())).one());
            if (null != sfaTpmActEntity) {
                sfaTpmActEntity = (SfaTpmActEntity)((Object)CrmBeanUtil.copy((Object)result.getResult(), SfaTpmActEntity.class));
                sfaTpmActEntity.setBeginDate(sfaTpmActEntity.getBeginDate().split(" ")[0]);
                sfaTpmActEntity.setEndDate(sfaTpmActEntity.getEndDate().split(" ")[0]);
                this.saveOrUpdate((Object)sfaTpmActEntity);
            }
            detailVos.forEach(data -> {
                SfaTpmActDetailEntity actDetailEntity = (SfaTpmActDetailEntity)((Object)((Object)((LambdaQueryChainWrapper)this.sfaTpmActDetailService.lambdaQuery().eq(SfaTpmActDetailEntity::getActDetailCode, (Object)data.getActDetailCode())).one()));
                if (actDetailEntity != null) {
                    actDetailEntity = (SfaTpmActDetailEntity)((Object)((Object)CrmBeanUtil.copy((Object)data, SfaTpmActDetailEntity.class)));
                    this.sfaTpmActDetailService.saveOrUpdate((Object)actDetailEntity);
                }
            });
        }
    }

    @Override
    public PageResult<SfaTpmActTableRespVo> findTpmActExecuteDataTable(SfaTpmActTableReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaTpmActTableRespVo> result = this.sfaTpmActMapper.findTableList((Page<SfaTpmActTableRespVo>)page, reqVo);
        return PageResult.builder().data(result).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaTpmActTableRespVo loadTpmActCollectDetailTableById(String id) {
        Page page = new Page();
        SfaTpmActTableReqVo reqVo = new SfaTpmActTableReqVo();
        reqVo.setId(id);
        List<SfaTpmActTableRespVo> tableList = this.sfaTpmActMapper.findTableList((Page<SfaTpmActTableRespVo>)page, reqVo);
        if (tableList.isEmpty()) {
            return new SfaTpmActTableRespVo();
        }
        SfaTpmActTableRespVo result = tableList.get(0);
        SfaTpmActCollectVo sfaTpmActCollectVo = this.sfaVisitStepTpmActCollectService.loadTpmActCollectDetail(id);
        if (!ObjectUtils.isEmpty((Object)sfaTpmActCollectVo)) {
            result.setActDemand(sfaTpmActCollectVo.getActDemand());
            result.setCollectFormList(sfaTpmActCollectVo.getCollectFormList());
        }
        return result;
    }

    protected void actDetailProductList(TpmActDetailRespVo data, List<SfaTpmActDetailProductEntity> tpmActDetailProductEntityList) {
        if (CollectionUtil.listNotEmptyNotSizeZero((List)data.getGiftProductList())) {
            List zpProductList = data.getGiftProductList().stream().map(pd -> {
                SfaTpmActDetailProductEntity productEntity = (SfaTpmActDetailProductEntity)((Object)((Object)CrmBeanUtil.copy((Object)pd, SfaTpmActDetailProductEntity.class)));
                productEntity.setIsGiftProduct(YesNoEnum.yesNoEnum.Y.getValue());
                return productEntity;
            }).collect(Collectors.toList());
            tpmActDetailProductEntityList.addAll(zpProductList);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)data.getNormalProductList())) {
            List bpProductList = data.getNormalProductList().stream().map(pd -> {
                SfaTpmActDetailProductEntity productEntity = (SfaTpmActDetailProductEntity)((Object)((Object)CrmBeanUtil.copy((Object)pd, SfaTpmActDetailProductEntity.class)));
                productEntity.setIsGiftProduct(YesNoEnum.yesNoEnum.N.getValue());
                return productEntity;
            }).collect(Collectors.toList());
            tpmActDetailProductEntityList.addAll(bpProductList);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(tpmActDetailProductEntityList)) {
            List productCodeList = tpmActDetailProductEntityList.stream().map(SfaTpmActDetailProductEntity::getProductCode).collect(Collectors.toList());
            Result productResult = this.mdmProductFeign.queryBatchByProductCodeList(productCodeList);
            Map<String, MdmProductRespVo> productMap = ((List)ApiResultUtil.objResult((Result)productResult, (boolean)productResult.isSuccess())).stream().collect(Collectors.toMap(MdmProductRespVo::getProductCode, k -> k));
            tpmActDetailProductEntityList.forEach(pd -> {
                if (productMap.containsKey(pd.getProductCode())) {
                    MdmProductRespVo respVo = (MdmProductRespVo)productMap.get(pd.getProductCode());
                    pd.setSpec(StringUtils.isNotEmpty((String)respVo.getSpec()) ? respVo.getSpec() : "");
                    pd.setSfaPicUrl(StringUtils.isNotEmpty((String)respVo.getPicUrl()) ? respVo.getPicUrl() : "");
                    pd.setSaleUnit(respVo.getSaleUnit());
                    pd.setSaleUnitName(respVo.getSaleUnitName());
                    pd.setPrimaryPictureUrl(StringUtils.isNotEmpty((String)respVo.getPrimaryPictureUrl()) ? respVo.getPrimaryPictureUrl() : "");
                }
            });
            this.sfaTpmActDetailProductService.saveOrUpdateBatch(tpmActDetailProductEntityList);
        }
    }

    protected void actCostTypeFine(TpmActDetailRespVo data, List<SfaTpmCostTypeFineEntity> tpmCostTypeFineEntities) {
        if (null != data.getFineRespVo()) {
            TpmCostTypeFineRespVo costTypeFineRespVo = data.getFineRespVo();
            SfaTpmCostTypeFineEntity costTypeFineEntity = (SfaTpmCostTypeFineEntity)((Object)CrmBeanUtil.copy((Object)costTypeFineRespVo, SfaTpmCostTypeFineEntity.class));
            tpmCostTypeFineEntities.add(costTypeFineEntity);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)costTypeFineRespVo.getCollectRequires())) {
                List collectRequires = costTypeFineRespVo.getCollectRequires();
                ArrayList pictureEntities = new ArrayList();
                collectRequires.forEach(c -> {
                    if (CollectionUtil.listNotEmptyNotSizeZero((List)c.getPictureRespVos())) {
                        List pictureEntityList = CrmBeanUtil.copyList((List)c.getPictureRespVos(), SfaTpmAuditCollectExamplePictureEntity.class);
                        pictureEntities.addAll(pictureEntityList);
                    }
                });
                List collectExampleEntities = CrmBeanUtil.copyList((List)collectRequires, SfaTpmAuditCollectExampleEntity.class);
                this.sfaTpmAuditCollectExampleService.saveOrUpdateBatch(collectExampleEntities);
                if (CollectionUtil.listNotEmptyNotSizeZero(pictureEntities)) {
                    this.sfaTpmAuditCollectExamplePictureService.saveOrUpdateBatch(pictureEntities);
                }
            }
            this.sfaTpmCostTypeFineService.saveOrUpdate((Object)costTypeFineEntity);
        }
    }
}

