/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mqconsumer;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.activity.model.SfaActivityExecutionEntity;
import com.biz.crm.activity.req.ActivityExecutionResolveData;
import com.biz.crm.base.SfaClientData;
import com.biz.crm.eunm.sfa.SfaActivityEnum;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.component.VisitDataDurabilityService;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.mq.AbstractRocketMQConsumer;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.visitstep.model.SfaVisitStepActivityExecutionEntity;
import com.biz.crm.visitstep.model.SfaVisitStepActivityExecutionRedisData;
import com.biz.crm.visitstep.repositories.SfaVisitStepActivityCostExecutionEsDataRepositories;
import com.biz.crm.visitstep.repositories.SfaVisitStepActivityDisplayExecutionEsDataRepositories;
import com.biz.crm.visitstep.service.ISfaVisitStepActivityExecutionService;
import com.biz.crm.visitstep.service.impl.SfaVisitStepActivityExecutionServiceImpl;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@RocketMQMessageListener(topic="${rocketmq.topic}${rocketmq.environment-variable}", selectorExpression="SFA_ACTIVITY_EXECUTION_RESOLVE", consumerGroup="SFA_ACTIVITY_EXECUTION_RESOLVE${rocketmq.environment-variable}", consumeMode=ConsumeMode.CONCURRENTLY)
public class SfaActivityExecutionResolveConsumer
extends AbstractRocketMQConsumer {
    private static final Logger log = LoggerFactory.getLogger(SfaActivityExecutionResolveConsumer.class);
    @Resource
    private ISfaVisitStepActivityExecutionService sfaVisitStepActivityExecutionService;
    @Resource
    private SfaVisitStepActivityExecutionServiceImpl sfaVisitStepActivityExecutionServiceImpl;
    @Resource
    private SfaVisitStepActivityDisplayExecutionEsDataRepositories sfaVisitStepActivityDisplayExecutionEsDataRepositories;
    @Resource
    private SfaVisitStepActivityCostExecutionEsDataRepositories sfaVisitStepActivityCostExecutionEsDataRepositories;

    protected VisitDataDurabilityService getVisitDataDurabilityService() {
        return this.sfaVisitStepActivityExecutionServiceImpl;
    }

    protected Object handleMessage(RocketMQMessageBody message) {
        ArrayList executionRedisDataList = new ArrayList();
        String msgBody = message.getMsgBody();
        List resolveDataList = JsonPropertyUtil.toArray((String)msgBody, ActivityExecutionResolveData.class);
        resolveDataList.forEach(resolveData -> {
            if (this.hasOldData((ActivityExecutionResolveData)resolveData)) {
                return;
            }
            SfaVisitStepActivityExecutionRedisData redisData = this.buildRedisData((ActivityExecutionResolveData)resolveData);
            redisData.setLineType(SfaVisitEnum.VISIT_OFF_LINE.online);
            executionRedisDataList.add(redisData);
        });
        if (CollectionUtil.listNotEmptyNotSizeZero(executionRedisDataList)) {
            this.getVisitDataDurabilityService().dataDurability(executionRedisDataList, null);
        }
        return "SFA\u6d3b\u52a8\u6267\u884c\u660e\u7ec6\u89e3\u6790\u5b8c\u6210";
    }

    protected boolean hasOldData(ActivityExecutionResolveData resolveData) {
        SfaVisitStepActivityExecutionRedisData data;
        String resolveDate = resolveData.getResolveDate();
        SfaActivityExecutionEntity executionEntity = resolveData.getActivityExecutionEntity();
        SfaClientData clientData = resolveData.getClientData();
        LambdaQueryChainWrapper lambdaQueryChainWrapper = (LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sfaVisitStepActivityExecutionService.lambdaQuery().eq(SfaVisitStepActivityExecutionEntity::getActivityExecutionId, (Object)executionEntity.getId())).eq(SfaVisitStepActivityExecutionEntity::getClientCode, (Object)clientData.getClientCode());
        if (SfaActivityEnum.activityType.COST_ACTIVITY.getVal().equals(executionEntity.getActivityType())) {
            data = this.sfaVisitStepActivityCostExecutionEsDataRepositories.findByActivityExecutionIdAndClientCode(executionEntity.getId(), clientData.getClientCode());
        } else {
            data = this.sfaVisitStepActivityDisplayExecutionEsDataRepositories.findByActivityExecutionIdAndClientCodeAndActivityDate(executionEntity.getId(), clientData.getClientCode(), resolveDate);
            lambdaQueryChainWrapper.eq(SfaVisitStepActivityExecutionEntity::getActivityDate, (Object)resolveDate);
        }
        if (null != data) {
            return true;
        }
        SfaVisitStepActivityExecutionEntity stepActivityExecutionEntity = (SfaVisitStepActivityExecutionEntity)lambdaQueryChainWrapper.one();
        return null != stepActivityExecutionEntity;
    }

    protected SfaVisitStepActivityExecutionRedisData buildRedisData(ActivityExecutionResolveData resolveData) {
        SfaClientData clientData = resolveData.getClientData();
        LocalDate resolveDate = LocalDate.parse(resolveData.getResolveDate(), CrmDateUtils.yyyyMMdd);
        SfaActivityExecutionEntity executionEntity = resolveData.getActivityExecutionEntity();
        SfaVisitStepActivityExecutionRedisData redisData = new SfaVisitStepActivityExecutionRedisData();
        CrmBeanUtil.copyPropertiesIgnoreEmpty((Object)((Object)executionEntity), (Object)redisData);
        VisitStepListener.VisitStepListenerCommittedData.copyClientData(redisData, clientData);
        redisData.setExecuteStatus(SfaActivityEnum.StepActivityExecuteStatus.WAITING.getVal());
        if (SfaActivityEnum.activityType.COST_ACTIVITY.getVal().equals(executionEntity.getActivityType())) {
            redisData.setStepCode(SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_COST.getVal());
        } else {
            redisData.setStepCode(SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_DISPLAY.getVal());
        }
        redisData.setActivityDate(resolveDate.format(CrmDateUtils.yyyyMMdd));
        redisData.setActivityYearMonth(resolveDate.format(CrmDateUtils.yyyyMM));
        redisData.setActivityYear(resolveDate.format(CrmDateUtils.yyyy));
        redisData.setActivityExecutionId(executionEntity.getId());
        redisData.setId(null);
        redisData.buildActivityRequireReqVoList(executionEntity.getActivityRequire());
        return redisData;
    }
}

