/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpmact.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.asexecution.model.SfaAsTreatyEntity;
import com.biz.crm.asexecution.service.ISfaAsTreatyService;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.attachment.ISfaAttachmentService;
import com.biz.crm.base.attachment.SfaAttachmentEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.enums.SfaVisitStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaActivityEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.eunm.tpm.ActAdvancePayApproveStatusEnum;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.activiti.vo.AttachmentVo;
import com.biz.crm.nebular.mdm.terminal.MdmCustomerTerminalVo;
import com.biz.crm.nebular.sfa.tpmact.actcollect.SfaTpmActCollectFormVo;
import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActDetailProductReqVo;
import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActDetailReqVo;
import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActReportReqVo;
import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActReqVo;
import com.biz.crm.nebular.sfa.tpmact.resp.ExecuteDataRespVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActDetailProductRespVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActDetailRespVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActReportRespVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActRespVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.tpmact.mapper.SfaTpmActDetailMapper;
import com.biz.crm.tpmact.model.SfaTpmActBaseEntity;
import com.biz.crm.tpmact.model.SfaTpmActDetailEntity;
import com.biz.crm.tpmact.model.SfaTpmActDetailProductEntity;
import com.biz.crm.tpmact.model.SfaTpmAuditCollectExampleEntity;
import com.biz.crm.tpmact.model.SfaTpmAuditCollectExamplePictureEntity;
import com.biz.crm.tpmact.model.SfaTpmCostTypeFineEntity;
import com.biz.crm.tpmact.model.SfaVisitStepTpmActCollectEntity;
import com.biz.crm.tpmact.service.ISfaTpmActDetailProductService;
import com.biz.crm.tpmact.service.ISfaTpmActDetailService;
import com.biz.crm.tpmact.service.ISfaTpmAuditCollectExamplePictureService;
import com.biz.crm.tpmact.service.ISfaTpmAuditCollectExampleService;
import com.biz.crm.tpmact.service.ISfaTpmCostTypeFineService;
import com.biz.crm.tpmact.service.ISfaVisitStepTpmActCollectService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitstep.model.SfaVisitStepOrderEntity;
import com.biz.crm.visitstep.model.SfaVisitStepOrderItemEntity;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderItemService;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderService;
import com.biz.crm.visitstepbase.VisitBaseComponent;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"SfaTpmActDetailServiceExpandImpl"})
public class SfaTpmActDetailServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaTpmActDetailMapper, SfaTpmActDetailEntity>
implements ISfaTpmActDetailService {
    private static final Logger log = LoggerFactory.getLogger(SfaTpmActDetailServiceImpl.class);
    @Resource
    private SfaTpmActDetailMapper sfaTpmActDetailMapper;
    @Resource
    private MdmTerminalFeign mdmterminalfeign;
    @Resource
    private ISfaTpmActDetailProductService sfaTpmActDetailProductService;
    @Resource
    private RedisService redisService;
    @Autowired
    private ISfaTpmCostTypeFineService sfaTpmCostTypeFineService;
    @Autowired
    private ISfaTpmAuditCollectExampleService sfaTpmAuditCollectExampleService;
    @Autowired
    private ISfaTpmAuditCollectExamplePictureService sfaTpmAuditCollectExamplePictureService;
    @Autowired
    private ISfaVisitStepOrderService sfaVisitStepOrderService;
    @Autowired
    private ISfaAsTreatyService sfaAsTreatyService;
    @Autowired
    private ISfaVisitStepTpmActCollectService sfaVisitStepTpmActCollectService;
    @Resource
    private VisitBaseComponent visitBaseComponent;
    @Autowired
    private ISfaVisitStepOrderItemService sfaVisitStepOrderItemService;
    @Autowired
    private ISfaAttachmentService sfaAttachmentService;

    @Override
    public PageResult<SfaTpmActDetailRespVo> findList(SfaTpmActDetailReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<SfaTpmActDetailRespVo> list = this.sfaTpmActDetailMapper.findList((Page<SfaTpmActDetailRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaTpmActDetailRespVo query(SfaTpmActDetailReqVo reqVo) {
        return null;
    }

    @Override
    public PageResult<SfaTpmActRespVo> getTpmActList(SfaTpmActReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getTerminalCode(), (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.isNotEmpty((String)reqVo.getSfaTpmActStatus(), (String)"\u6d3b\u52a8\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        String now = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        List<String> actDetailIdList = this.getActDetailIdList(now, reqVo.getTerminalCode());
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaTpmActRespVo> list = null;
        if (SfaCommonEnum.sfaTpmActStatus.onGoing.getValue().equals(reqVo.getSfaTpmActStatus())) {
            list = this.sfaTpmActDetailMapper.findOnGoingWorkbench((Page<SfaTpmActRespVo>)page, reqVo, now, actDetailIdList);
        } else if (SfaCommonEnum.sfaTpmActStatus.alreadySuccess.getValue().equals(reqVo.getSfaTpmActStatus())) {
            list = this.sfaTpmActDetailMapper.findAlreadySuccessWorkbench((Page<SfaTpmActRespVo>)page, reqVo, now, actDetailIdList);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(data -> {
                List orderEntities = ((LambdaQueryChainWrapper)this.sfaVisitStepOrderService.lambdaQuery().eq(SfaVisitStepOrderEntity::getActDetailCode, (Object)data.getActDetailCode())).list();
                List treatyEntities = ((LambdaQueryChainWrapper)this.sfaAsTreatyService.lambdaQuery().eq(SfaAsTreatyEntity::getActivityCode, (Object)data.getActDetailCode())).list();
                BigDecimal orderPrice = orderEntities.stream().map(SfaVisitStepOrderEntity::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal treatyPrice = treatyEntities.stream().map(SfaAsTreatyEntity::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (YesNoEnum.yesNoEnum.Y.getValue().equals(data.getIsSignDisplayAgreement())) {
                    data.setUsedAmount(treatyPrice);
                } else {
                    data.setUsedAmount(orderPrice);
                }
                BigDecimal terminalOrderPrice = orderEntities.stream().filter(o -> o.getClientCode().equals(reqVo.getTerminalCode())).map(SfaVisitStepOrderEntity::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal terminalTreatyPrice = treatyEntities.stream().filter(t -> t.getTerminalCode().equals(reqVo.getTerminalCode())).map(SfaAsTreatyEntity::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                data.setCurrentUsedAmount(terminalOrderPrice);
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @CrmDictMethod
    public SfaTpmActDetailRespVo getTpmActDetailByActDetailCode(String actDetailCode, String terminalCode, String redisHashKey, String visitPlanInfoId) {
        AssertUtils.isNotEmpty((String)actDetailCode, (String)"\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)terminalCode, (String)"\u7ec8\u7aef\u7f16\u7801\u4e3a\u7a7a");
        SfaTpmActDetailRespVo respVo = this.sfaTpmActDetailMapper.findActDetailByActDetailCode(actDetailCode);
        Map<String, List<SfaTpmActDetailProductEntity>> productMap = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sfaTpmActDetailProductService.lambdaQuery().eq(SfaTpmActDetailProductEntity::getActDetailCode, (Object)respVo.getActDetailCode())).eq(SfaTpmActDetailProductEntity::getIsGiftProduct, (Object)YesNoEnum.yesNoEnum.Y.getValue())).list().stream().collect(Collectors.groupingBy(SfaTpmActDetailProductEntity::getIsGiftProduct));
        if (productMap != null && productMap.size() > 0) {
            respVo.setDistributionOrderType(SfaActivityEnum.bpItemType.zp.getVal());
            respVo.setDistributionOrderTypeName(SfaActivityEnum.bpItemType.zp.getDesc());
        } else {
            respVo.setDistributionOrderType(SfaActivityEnum.bpItemType.bp.getVal());
            respVo.setDistributionOrderTypeName(SfaActivityEnum.bpItemType.bp.getDesc());
        }
        this.redisService.hmset(SfaTpmActDetailRespVo.buildRedisKey((String)actDetailCode), SfaTpmActDetailRespVo.buildRedisDistributionOrderType((String)respVo.getDistributionOrderType()), SfaTpmActDetailRespVo.REDIS_EXPIRE_TIME.longValue());
        SfaAsTreatyEntity treatyEntity = (SfaAsTreatyEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sfaAsTreatyService.lambdaQuery().eq(SfaAsTreatyEntity::getActivityCode, (Object)actDetailCode)).eq(SfaAsTreatyEntity::getTerminalCode, (Object)terminalCode)).select(new SFunction[]{BaseIdEntity::getId}).one();
        if (YesNoEnum.yesNoEnum.Y.getValue().equals(respVo.getIsSignDisplayAgreement())) {
            if (treatyEntity != null) {
                respVo.setDisplayAgreementId(treatyEntity.getId());
            } else {
                respVo.setIsCollectDistributionOrder(YesNoEnum.yesNoEnum.N.getValue());
                respVo.setIsCollectActData(YesNoEnum.yesNoEnum.N.getValue());
            }
        }
        List<ExecuteDataRespVo> actCollectDataList = null;
        List<ExecuteDataRespVo> actCollectDistributionOrderList = null;
        if (StringUtils.isNotEmpty((String)redisHashKey)) {
            SfaVisitStepTpmActCollectEntity collectEntity;
            SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(redisHashKey);
            SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.visitBaseComponent.loadAndCheckSfaVisitPlanInfoEntity(redisHashKey, visitRedisHashKey.getVisitBigType());
            visitPlanInfoId = sfaVisitPlanInfoEntity.getId();
            SfaVisitStepOrderEntity orderEntity = (SfaVisitStepOrderEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sfaVisitStepOrderService.lambdaQuery().eq(SfaVisitStepOrderEntity::getActDetailCode, (Object)actDetailCode)).eq(SfaTpmActBaseEntity::getVisitPlanInfoId, (Object)visitPlanInfoId)).select(new SFunction[]{BaseIdEntity::getId}).one();
            if (orderEntity != null) {
                respVo.setDistributionOrderId(orderEntity.getId());
            }
            if ((collectEntity = (SfaVisitStepTpmActCollectEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sfaVisitStepTpmActCollectService.lambdaQuery().eq(SfaVisitStepTpmActCollectEntity::getActDetailCode, (Object)actDetailCode)).eq(SfaTpmActBaseEntity::getVisitPlanInfoId, (Object)visitPlanInfoId)).select(new SFunction[]{BaseIdEntity::getId}).one()) != null) {
                respVo.setActCollectDataId(collectEntity.getId());
            }
        } else if (StringUtils.isNotEmpty((String)visitPlanInfoId)) {
            actCollectDataList = this.sfaTpmActDetailMapper.findCollectDataList(actDetailCode, terminalCode, visitPlanInfoId);
            actCollectDistributionOrderList = this.sfaTpmActDetailMapper.findDistributionOrderList(actDetailCode, terminalCode, visitPlanInfoId);
        } else {
            actCollectDataList = this.sfaTpmActDetailMapper.findCollectDataList(actDetailCode, terminalCode, null);
            actCollectDistributionOrderList = this.sfaTpmActDetailMapper.findDistributionOrderList(actDetailCode, terminalCode, null);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(actCollectDataList)) {
            respVo.setActCollectDataList(actCollectDataList);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(actCollectDistributionOrderList)) {
            respVo.setActCollectDistributionOrderList(actCollectDistributionOrderList);
        }
        return respVo;
    }

    @Override
    public List<SfaTpmActCollectFormVo> findActCollectDataForm(String fineCode, String actDetailCode) {
        AssertUtils.isNotEmpty((String)fineCode, (String)"\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)actDetailCode, (String)"\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801\u4e3a\u7a7a");
        SfaTpmCostTypeFineEntity fineEntity = (SfaTpmCostTypeFineEntity)((Object)((LambdaQueryChainWrapper)this.sfaTpmCostTypeFineService.lambdaQuery().eq(SfaTpmCostTypeFineEntity::getFineCode, (Object)fineCode)).select(new SFunction[]{SfaTpmCostTypeFineEntity::getCollectRequireList}).one());
        List formVos = null;
        if (StringUtils.isNotEmpty((String)fineEntity.getCollectRequireList())) {
            List exampleList = JSONObject.parseArray((String)fineEntity.getCollectRequireList(), String.class);
            List exampleEntities = ((LambdaQueryChainWrapper)this.sfaTpmAuditCollectExampleService.lambdaQuery().in(SfaTpmAuditCollectExampleEntity::getExampleCode, (Collection)exampleList)).list();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)exampleEntities)) {
                formVos = CrmBeanUtil.copyList((List)exampleEntities, SfaTpmActCollectFormVo.class);
                formVos.forEach(data -> {
                    List picList = ((LambdaQueryChainWrapper)this.sfaTpmAuditCollectExamplePictureService.lambdaQuery().eq(SfaTpmAuditCollectExamplePictureEntity::getExampleCode, (Object)data.getExampleCode())).list().stream().map(SfaTpmAuditCollectExamplePictureEntity::getUrlAddress).collect(Collectors.toList());
                    data.setPictList(picList);
                });
            }
        } else {
            throw new BusinessException("tpm\u6d3b\u52a8\u672a\u914d\u7f6e\u6d3b\u52a8\u91c7\u96c6\u793a\u4f8b");
        }
        this.redisService.hmset(SfaTpmActCollectFormVo.buildRedisKey((String)actDetailCode), SfaTpmActCollectFormVo.buildRedisMap((String)actDetailCode, (List)formVos), SfaTpmActCollectFormVo.REDIS_EXPIRE_TIME.longValue());
        return formVos;
    }

    @Override
    public PageResult<SfaTpmActDetailProductRespVo> findActProductList(SfaTpmActDetailProductReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getActDetailCode(), (String)"\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getIsGiftProduct(), (String)"\u5546\u54c1\u7c7b\u578b\u4e3a\u7a7a");
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaTpmActDetailProductRespVo> list = this.sfaTpmActDetailMapper.findActProductList((Page<SfaTpmActDetailProductRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<SfaTpmActRespVo> getVisitSuccessTpmAct(String visitPlanInfoId) {
        List<SfaTpmActRespVo> respVoList = this.sfaTpmActDetailMapper.findVisitOldTpmAct(visitPlanInfoId);
        if (CollectionUtil.listNotEmptyNotSizeZero(respVoList)) {
            respVoList.forEach(respVo -> {
                List orderEntities = ((LambdaQueryChainWrapper)this.sfaVisitStepOrderService.lambdaQuery().eq(SfaVisitStepOrderEntity::getActDetailCode, (Object)respVo.getActDetailCode())).list();
                List treatyEntities = ((LambdaQueryChainWrapper)this.sfaAsTreatyService.lambdaQuery().eq(SfaAsTreatyEntity::getActivityCode, (Object)respVo.getActDetailCode())).list();
                BigDecimal orderPrice = BigDecimal.ZERO;
                BigDecimal treatyPrice = BigDecimal.ZERO;
                BigDecimal terminalOrderPrice = BigDecimal.ZERO;
                BigDecimal terminalTreatyPrice = BigDecimal.ZERO;
                if (CollectionUtil.listNotEmptyNotSizeZero((List)orderEntities)) {
                    orderPrice = orderEntities.stream().map(SfaVisitStepOrderEntity::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                    terminalOrderPrice = orderEntities.stream().filter(o -> o.getClientCode().equals(respVo.getTerminalCode())).map(SfaVisitStepOrderEntity::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                if (CollectionUtil.listNotEmptyNotSizeZero((List)treatyEntities)) {
                    treatyPrice = treatyEntities.stream().map(SfaAsTreatyEntity::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                    terminalTreatyPrice = treatyEntities.stream().filter(t -> t.getTerminalCode().equals(respVo.getTerminalCode())).map(SfaAsTreatyEntity::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                respVo.setUsedAmount(orderPrice.add(treatyPrice));
                respVo.setCurrentUsedAmount(terminalTreatyPrice.add(terminalOrderPrice));
            });
        }
        return respVoList;
    }

    @Override
    public List<SfaTpmActRespVo> loadVisitStepTpmReport(SfaTpmActReportReqVo req) {
        AssertUtils.isNotEmpty((String)req.getVisitPlanInfoId(), (String)"\u62dc\u8bbf\u660e\u7ec6id\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)req.getTerminalCode(), (String)"\u7ec8\u7aef\u7f16\u7801\u4e3a\u7a7a");
        List<SfaTpmActRespVo> respVoList = this.sfaTpmActDetailMapper.findVisitStepTpmActList(req.getVisitPlanInfoId(), req.getTerminalCode());
        return respVoList;
    }

    @Override
    public SfaTpmActReportRespVo getTpmActDetailReport(SfaTpmActReportReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getVisitPlanInfoId(), (String)"\u62dc\u8bbf\u660e\u7ec6id\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getTerminalCode(), (String)"\u7ec8\u7aef\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getActDetailCode(), (String)"\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801\u4e3a\u7a7a");
        SfaTpmActReportRespVo reportRespVo = (SfaTpmActReportRespVo)this.redisService.hmget(SfaTpmActReportRespVo.buildRedisHashKey((SfaTpmActReportReqVo)reqVo), (Object)"SFA_VISIT_STEP_TPM_REPORT");
        if (null == reportRespVo) {
            reportRespVo = this.sfaTpmActDetailMapper.findVisitStepTpmActDetail(reqVo.getActDetailCode());
            LocalDate now = LocalDate.now();
            LocalDate beginDate = LocalDate.parse(reportRespVo.getBeginDate());
            LocalDate endDate = LocalDate.parse(reportRespVo.getEndDate());
            if ((beginDate.isBefore(now) || beginDate.isEqual(now)) && (endDate.isAfter(now) || endDate.isEqual(now)) && ActAdvancePayApproveStatusEnum.APPROVED.getCode().equals(reportRespVo.getApproveStatus()) && reportRespVo.getAuditAmount() == null) {
                reportRespVo.setActStatusName(SfaVisitStatusEnum.PROCESSING.getDesc());
            } else {
                reportRespVo.setActStatusName(SfaVisitStatusEnum.FINISHED.getDesc());
            }
            List orderEntities = ((LambdaQueryChainWrapper)this.sfaVisitStepOrderService.lambdaQuery().eq(SfaVisitStepOrderEntity::getActDetailCode, (Object)reqVo.getActDetailCode())).list();
            List treatyEntities = ((LambdaQueryChainWrapper)this.sfaAsTreatyService.lambdaQuery().eq(SfaAsTreatyEntity::getActivityCode, (Object)reqVo.getActDetailCode())).list();
            BigDecimal orderPrice = BigDecimal.ZERO;
            BigDecimal treatyPrice = BigDecimal.ZERO;
            BigDecimal terminalOrderPrice = BigDecimal.ZERO;
            BigDecimal terminalTreatyPrice = BigDecimal.ZERO;
            if (CollectionUtil.listNotEmptyNotSizeZero((List)orderEntities)) {
                orderPrice = orderEntities.stream().map(SfaVisitStepOrderEntity::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                terminalOrderPrice = orderEntities.stream().filter(o -> o.getClientCode().equals(reqVo.getTerminalCode())).map(SfaVisitStepOrderEntity::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            if (CollectionUtil.listNotEmptyNotSizeZero((List)treatyEntities)) {
                treatyPrice = treatyEntities.stream().map(SfaAsTreatyEntity::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                terminalTreatyPrice = treatyEntities.stream().filter(t -> t.getTerminalCode().equals(reqVo.getTerminalCode())).map(SfaAsTreatyEntity::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            reportRespVo.setUsedAmount(orderPrice.add(treatyPrice));
            reportRespVo.setCurrentUsedAmount(terminalTreatyPrice.add(terminalOrderPrice));
            SfaVisitStepTpmActCollectEntity actCollectEntity = (SfaVisitStepTpmActCollectEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sfaVisitStepTpmActCollectService.lambdaQuery().eq(SfaVisitStepTpmActCollectEntity::getActDetailCode, (Object)reqVo.getActDetailCode())).eq(SfaTpmActBaseEntity::getVisitPlanInfoId, (Object)reqVo.getVisitPlanInfoId())).one();
            this.buildVisitStepTpmActReport(orderEntities, treatyEntities, actCollectEntity, reportRespVo, reqVo);
        }
        this.redisService.hmset(SfaTpmActReportRespVo.buildRedisHashKey((SfaTpmActReportReqVo)reqVo), SfaTpmActReportRespVo.buildRedisMap((SfaTpmActReportRespVo)reportRespVo), SfaTpmActReportRespVo.REDIS_EXPIRE_TIME.longValue());
        return reportRespVo;
    }

    protected List<String> getActDetailIdList(String now, String terminalCode) {
        ArrayList<String> actDetailIdList = new ArrayList<String>();
        Map<String, List<SfaTpmActDetailEntity>> orgAndCusMap = this.sfaTpmActDetailMapper.findOrgAndCustomerList(now).stream().collect(Collectors.groupingBy(BaseIdEntity::getId));
        orgAndCusMap.entrySet().forEach(data -> {
            Result terminalBoolean;
            List customerCodeList = ((List)data.getValue()).stream().filter(c -> StringUtils.isNotEmpty((String)c.getCustomerCode())).map(SfaTpmActDetailEntity::getCustomerCode).collect(Collectors.toList());
            List orgCodeList = ((List)data.getValue()).stream().filter(c -> StringUtils.isNotEmpty((String)c.getOrgCode())).map(SfaTpmActDetailEntity::getOrgCode).collect(Collectors.toList());
            List terminalCodeList = ((List)data.getValue()).stream().filter(c -> StringUtils.isNotEmpty((String)c.getTerminalCode())).map(SfaTpmActDetailEntity::getTerminalCode).collect(Collectors.toList());
            if (CollectionUtil.listNotEmptyNotSizeZero(terminalCodeList)) {
                if (terminalCodeList.contains(terminalCode)) {
                    actDetailIdList.add((String)data.getKey());
                }
            } else if (CollectionUtil.listNotEmptyNotSizeZero(customerCodeList)) {
                MdmCustomerTerminalVo customerTerminalVo = new MdmCustomerTerminalVo();
                customerTerminalVo.setCustomerCodeList(customerCodeList);
                Result customerBoolean = this.mdmterminalfeign.checkTerminalCodeRelByCustomerCodeList(customerCodeList, terminalCode);
                if (((Boolean)customerBoolean.getResult()).booleanValue()) {
                    actDetailIdList.add((String)data.getKey());
                }
            } else if (CollectionUtil.listNotEmptyNotSizeZero(orgCodeList) && ((Boolean)(terminalBoolean = this.mdmterminalfeign.checkTerminalCodeRelByOrgCodeList(orgCodeList = OrgUtil.getChildrenOrgCodeListIncludeSelf(orgCodeList), terminalCode)).getResult()).booleanValue()) {
                actDetailIdList.add((String)data.getKey());
            }
        });
        return actDetailIdList;
    }

    protected void buildVisitStepTpmActReport(List<SfaVisitStepOrderEntity> orderEntities, List<SfaAsTreatyEntity> treatyEntities, SfaVisitStepTpmActCollectEntity actCollectEntity, SfaTpmActReportRespVo reportRespVo, SfaTpmActReportReqVo reqVo) {
        if (CollectionUtil.listNotEmptyNotSizeZero(orderEntities)) {
            SfaTpmActReportRespVo.DistributionOrder order = new SfaTpmActReportRespVo.DistributionOrder();
            orderEntities.forEach(data -> {
                if (StringUtils.isNotEmpty((String)data.getVisitPlanInfoId()) && data.getVisitPlanInfoId().equals(reqVo.getVisitPlanInfoId())) {
                    Map<String, List<SfaVisitStepOrderItemEntity>> itemEntityMap = ((LambdaQueryChainWrapper)this.sfaVisitStepOrderItemService.lambdaQuery().eq(SfaVisitStepOrderItemEntity::getOrderId, (Object)data.getId())).list().stream().collect(Collectors.groupingBy(SfaVisitStepOrderItemEntity::getItmeType));
                    itemEntityMap.entrySet().forEach(item -> {
                        List itemList = CrmBeanUtil.copyList((List)((List)item.getValue()), SfaTpmActReportRespVo.DistributionOrderItem.class);
                        if (SfaActivityEnum.bpItemType.bp.getVal().equals(item)) {
                            order.setBpProductList(itemList);
                        } else {
                            order.setZpProductList(itemList);
                        }
                    });
                    reportRespVo.setDistributionOrder(order);
                }
            });
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(treatyEntities)) {
            treatyEntities.forEach(data -> {
                if (StringUtils.isNotEmpty((String)data.getTerminalCode()) && data.getTerminalCode().equals(reqVo.getTerminalCode())) {
                    reportRespVo.setTreatyPdfUrl(data.getUrlPathPrefix() + data.getUrlPath());
                }
            });
        }
        if (null != actCollectEntity) {
            SfaTpmActReportRespVo.ActCollectData actCollectData = new SfaTpmActReportRespVo.ActCollectData();
            Map<String, List<SfaAttachmentEntity>> attachmentMap = ((LambdaQueryChainWrapper)this.sfaAttachmentService.lambdaQuery().eq(SfaAttachmentEntity::getBizId, (Object)actCollectEntity.getId())).list().stream().collect(Collectors.groupingBy(at -> at.getAttachmentBizType() + ":" + at.getAttachmentBizTypeName()));
            ArrayList collectFormList = new ArrayList();
            attachmentMap.entrySet().forEach(am -> {
                String[] expandType = ((String)am.getKey()).split(":");
                List attachmentVos = CrmBeanUtil.copyList((List)((List)am.getValue()), AttachmentVo.class);
                SfaTpmActReportRespVo.CollectForm collectForm = new SfaTpmActReportRespVo.CollectForm();
                collectForm.setExampleCode(expandType[0]);
                collectForm.setExampleName(expandType[1]);
                collectForm.setAttachmentList(attachmentVos);
                collectFormList.add(collectForm);
            });
            actCollectData.setCollectFormList(collectFormList);
            reportRespVo.setActCollectData(actCollectData);
        }
    }
}

