/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.integral.service.component;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.sfa.IntegralEnum;
import com.biz.crm.integral.controller.SfaIntegralSaveUtil;
import com.biz.crm.integral.req.SfaIntegralDetailAddReq;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.mdm.position.req.MdmPositionPageReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionPageRespVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaMonthSignReqVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaMonthSignRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.JobHelper;
import com.biz.crm.util.PageDataAdviser;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.visitinfo.model.SfaVisitCompleteInfoEntity;
import com.biz.crm.visitinfo.service.ISfaVisitCompleteInfoService;
import com.biz.crm.worksign.service.ISfaSignFormsService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
@ConditionalOnMissingBean(name={"sfaIntegralMonthJobExecutorExtend"})
public class SfaIntegralMonthJobExecutor
implements JobHelper.JobExecutor {
    private static final Logger log = LoggerFactory.getLogger(SfaIntegralMonthJobExecutor.class);
    @Resource
    private MdmPositionFeign mdmPositionFeign;
    @Resource
    private ISfaSignFormsService sfaSignFormsService;
    @Resource
    private ISfaVisitCompleteInfoService sfaVisitCompleteInfoService;
    @Resource
    private JobHelper jobHelper;

    @Transactional
    public void executeJob(Object jobParam) {
        this.doSettlementJob((String)jobParam);
    }

    public void integralDetailJob(String yearMonth) {
        if (StringUtils.isEmpty((String)yearMonth)) {
            LocalDate yearMonthDate = LocalDate.now().plusMonths(-1L);
            yearMonth = yearMonthDate.format(CrmDateUtils.yyyyMM);
        } else {
            CrmDateUtils.checkTimeFormatThrows((String)yearMonth, (DateTimeFormatter)CrmDateUtils.yyyyMM, null);
        }
        JobHelper.JobContext context = new JobHelper.JobContext();
        context.setJob(JobHelper.Job.INTEGRAL_MONTH_JOB);
        context.setExecutorBeanClass(SfaIntegralMonthJobExecutor.class);
        context.setJobParam((Object)yearMonth);
        this.jobHelper.executeJobSaveContext(context);
    }

    protected void doSettlementJob(String yearMonth) {
        PageDataAdviser pageDataAdviser = new PageDataAdviser(this.jobHelper.getJobBizDataPageSize());
        long total = this.jobHelper.getJobBizDataPageSize();
        while (pageDataAdviser.hasNext(Long.valueOf(total))) {
            MdmPositionPageReqVo reqVo = new MdmPositionPageReqVo();
            reqVo.setPageNum(pageDataAdviser.nextPage());
            reqVo.setPageSize(pageDataAdviser.getPageSize());
            PageResult pageResult = (PageResult)ApiResultUtil.objResult((Result)this.mdmPositionFeign.positionAndUserPage(reqVo), (boolean)true);
            List users = pageResult.getData();
            this.doIntegral(yearMonth, users);
            total = pageResult.getCount();
        }
    }

    private void doIntegral(String yearMonth, List<MdmPositionPageRespVo> userList) {
        Map<String, List<String>> userMapPositions = userList.stream().collect(Collectors.groupingBy(MdmPositionPageRespVo::getUserName, Collectors.mapping(MdmPositionPageRespVo::getPositionCode, Collectors.toList())));
        this.signMonthIntegral(yearMonth, userMapPositions);
        this.visitMonthIntegral(yearMonth, userMapPositions);
    }

    protected void signMonthIntegral(String yearMonth, Map<String, List<String>> userMapPositions) {
        SfaMonthSignReqVo sfaMonthSignReqVo = new SfaMonthSignReqVo();
        sfaMonthSignReqVo.setUserNameList((List)Lists.newArrayList(userMapPositions.keySet()));
        sfaMonthSignReqVo.setYearMonth(yearMonth);
        List<SfaMonthSignRespVo> sfaMonthSignRespVos = this.sfaSignFormsService.monthSignListByUsers(sfaMonthSignReqVo);
        if (null == sfaMonthSignRespVos) {
            return;
        }
        for (SfaMonthSignRespVo sfaMonthSignRespVo : sfaMonthSignRespVos) {
            BigDecimal goToWorkDays = sfaMonthSignRespVo.getGoToWorkDays();
            BigDecimal normal = sfaMonthSignRespVo.getNormal();
            if (goToWorkDays.compareTo(BigDecimal.ZERO) <= 0 || goToWorkDays.compareTo(normal) != 0) continue;
            SfaIntegralDetailAddReq integralDetailAddReq = new SfaIntegralDetailAddReq();
            String integralTaskType = IntegralEnum.taskType.MONTH_SIGN.getValue();
            String userName = sfaMonthSignRespVo.getUserName();
            integralDetailAddReq.setBizId(integralTaskType + userName + yearMonth);
            integralDetailAddReq.setIntegralTaskType(integralTaskType);
            List<String> posCodes = userMapPositions.get(userName);
            String posCode = CollectionUtils.isEmpty(posCodes) ? userName : posCodes.get(0);
            integralDetailAddReq.setPosCode(posCode);
            integralDetailAddReq.setUserName(userName);
            integralDetailAddReq.setExtParam(null);
            SfaIntegralSaveUtil.saveIntegralDetail(integralDetailAddReq);
        }
    }

    protected void visitMonthIntegral(String yearMonth, Map<String, List<String>> userMapPositions) {
        List list = this.sfaVisitCompleteInfoService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaVisitCompleteInfoEntity.class).in(SfaVisitCompleteInfoEntity::getVisitUserName, (Collection)Lists.newArrayList(userMapPositions.keySet()))).eq(SfaVisitCompleteInfoEntity::getVisitYearMonth, (Object)yearMonth));
        if (CollectionUtil.listEmpty((List)list)) {
            return;
        }
        String completedTag = "100.00";
        Map<String, List<SfaVisitCompleteInfoEntity>> userVisitData = list.stream().collect(Collectors.groupingBy(v -> v.getVisitUserName() + ":" + v.getVisitPosCode()));
        SfaIntegralDetailAddReq integralDetailAddReq = new SfaIntegralDetailAddReq();
        userVisitData.forEach((s, sfaVisitCompleteInfoEntities) -> {
            boolean completedHelpVisit = true;
            boolean completedVisit = true;
            String userName = null;
            String posCode = null;
            for (SfaVisitCompleteInfoEntity sfaVisitCompleteInfoEntity : sfaVisitCompleteInfoEntities) {
                if (!"100.00".equals(sfaVisitCompleteInfoEntity.getCompleteHelpVisitPercent())) {
                    completedHelpVisit = false;
                }
                if (!"100.00".equals(sfaVisitCompleteInfoEntity.getCompleteVisitPercent())) {
                    completedVisit = false;
                }
                userName = sfaVisitCompleteInfoEntity.getVisitUserName();
                posCode = sfaVisitCompleteInfoEntity.getVisitPosCode();
            }
            if (completedHelpVisit) {
                this.visitMonthIntegralAdd(integralDetailAddReq, userName, posCode, yearMonth, IntegralEnum.taskType.FINISH_VISIT_HELP_PLAN);
            }
            if (completedVisit) {
                this.visitMonthIntegralAdd(integralDetailAddReq, userName, posCode, yearMonth, IntegralEnum.taskType.FINISH_VISIT_PLAN);
            }
        });
    }

    protected void visitMonthIntegralAdd(SfaIntegralDetailAddReq integralDetailAddReq, String userName, String posCode, String yearMonth, IntegralEnum.taskType taskType2) {
        String integralTaskType = taskType2.getValue();
        StringJoiner bizId = new StringJoiner(":");
        bizId.add(integralTaskType);
        bizId.add(userName);
        bizId.add(posCode);
        bizId.add(yearMonth);
        integralDetailAddReq.setBizId(bizId.toString());
        integralDetailAddReq.setIntegralTaskType(integralTaskType);
        integralDetailAddReq.setPosCode(posCode);
        integralDetailAddReq.setUserName(userName);
        integralDetailAddReq.setExtParam(null);
        SfaIntegralSaveUtil.saveIntegralDetail(integralDetailAddReq);
    }
}

