/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksign.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.ActivitiEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.task.resp.TaskRspVO;
import com.biz.crm.nebular.sfa.worksign.req.SfaApplyTimeInfoReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditFinishReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditListLeaveCancelReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaLeaveCancelReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaAuditListLeaveCancelRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaLeaveCancelInfoRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaLeaveCancelRespVo;
import com.biz.crm.util.ActivityUtils;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.SfaActivitiUtils;
import com.biz.crm.util.SfaSignUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.worksign.mapper.SfaLeaveCancelMapper;
import com.biz.crm.worksign.model.SfaLeaveCancelEntity;
import com.biz.crm.worksign.service.ISfaLeaveCancelService;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"sfaLeaveCancelServiceExpandImpl"})
public class SfaLeaveCancelServiceImpl
extends ServiceImpl<SfaLeaveCancelMapper, SfaLeaveCancelEntity>
implements ISfaLeaveCancelService {
    private static final Logger log = LoggerFactory.getLogger(SfaLeaveCancelServiceImpl.class);
    @Resource
    private SfaLeaveCancelMapper mapper;
    @Autowired
    private TaActBaseFeign taActBaseFeign;

    @Override
    public List<SfaLeaveCancelRespVo> findList(SfaLeaveCancelReqVo reqVo) {
        List<SfaLeaveCancelRespVo> list = this.mapper.findList(reqVo);
        list.forEach(vo -> {
            vo.setTimeInfoList(JSON.parseArray((String)vo.getTimeInfoListJson(), SfaApplyTimeInfoReqVo.class));
            vo.setBpmStatusName(SfaCommonEnum.dataBpmStatus.getDesc((String)vo.getBpmStatus()));
        });
        return list;
    }

    @Override
    public SfaLeaveCancelEntity save(SfaLeaveCancelReqVo reqVo, boolean isAudit) {
        UserRedis userRedis = UserUtils.getUser();
        if (userRedis == null) {
            throw new BusinessException("\u8bf7\u767b\u5f55");
        }
        List<SfaLeaveCancelRespVo> list = this.findList(new SfaLeaveCancelReqVo(reqVo.getLeaveId()));
        this.verifyDateRepeat(list, reqVo.getBeginTime(), reqVo.getEndTime(), reqVo.getTimeInfoList());
        SfaLeaveCancelEntity entity = (SfaLeaveCancelEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaLeaveCancelEntity.class));
        entity.setTimeInfoListJson(JSON.toJSONString((Object)reqVo.getTimeInfoList()));
        entity.setApplicationDate(CrmDateUtils.yyyyMMddHHmmss.format(LocalDateTime.now()));
        if (isAudit) {
            entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.COMMIT.getValue());
            this.saveOrUpdate((Object)entity);
            entity.setAuditTaskId(entity.getId());
            StartProcessReqVo startProcessReqVO = SfaActivitiUtils.createStartProcessReqVO((String)userRedis.getUsername(), (String)userRedis.getPoscode(), (String)entity.getAuditTaskId(), (ActivitiEnum.FormTypeEnum)ActivitiEnum.FormTypeEnum.LEAVECANCEL, (String)entity.getBeginTime(), (String)entity.getEndTime(), (String)userRedis.getOrgcode());
            String string = ActivityUtils.startProcess((StartProcessReqVo)startProcessReqVO);
        } else {
            entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.PASS.getValue());
        }
        this.saveOrUpdate((Object)entity);
        return entity;
    }

    @Override
    public void verifyDateRepeat(List<SfaLeaveCancelRespVo> list, String beginTime, String endTime, List<SfaApplyTimeInfoReqVo> timeInfoList) {
        if (list != null && list.size() > 0) {
            for (SfaLeaveCancelRespVo vo : list) {
                if (SfaCommonEnum.dataBpmStatus.REJECT.getValue().equals(vo.getBpmStatus())) continue;
                SfaSignUtils.verifyDateRepeat((String)beginTime, (String)endTime, (String)vo.getBeginTime(), (String)vo.getEndTime(), timeInfoList, (List)vo.getTimeInfoList());
            }
        }
    }

    @Override
    public PageResult<SfaLeaveCancelInfoRespVo> findInfoList(SfaAuditListLeaveCancelReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaLeaveCancelInfoRespVo> list = this.mapper.findInfoList((Page<SfaLeaveCancelInfoRespVo>)page, reqVo);
        if (list != null) {
            list.forEach(vo -> {
                vo.setBpmStatusName(SfaCommonEnum.dataBpmStatus.getDesc((String)vo.getBpmStatus()));
                vo.setLeaveTypeName(SfaCommonEnum.leaveTypeEnum.getDesc((String)vo.getLeaveType()));
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public Result auditCommit(String id) {
        SfaLeaveCancelEntity entity = (SfaLeaveCancelEntity)((Object)this.mapper.selectById((Serializable)((Object)id)));
        AssertUtils.isNotNull((Object)((Object)entity), (String)"\u9500\u5047\u4fe1\u606fid\u9519\u8bef");
        if (!entity.getBpmStatus().equals(SfaCommonEnum.dataBpmStatus.COMMIT.getValue()) && !entity.getBpmStatus().equals(SfaCommonEnum.dataBpmStatus.APPROVAL.getValue())) {
            return Result.error((String)"\u8be5\u7533\u8bf7\u5ba1\u6279\u72b6\u6001\u9519\u8bef");
        }
        if (!SfaCommonEnum.dataBpmStatus.APPROVAL.getValue().equals(entity.getBpmStatus())) {
            entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.APPROVAL.getValue());
            this.saveOrUpdate((Object)entity);
        }
        return Result.ok();
    }

    @Override
    public SfaLeaveCancelEntity auditCancelFinish(SfaAuditFinishReqVo reqVo) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaLeaveCancelEntity::getAuditTaskId, (Object)reqVo.getFormId());
        SfaLeaveCancelEntity entity = (SfaLeaveCancelEntity)((Object)this.mapper.selectOne((Wrapper)wrapper));
        if (entity == null) {
            throw new BusinessException("\u9500\u5047\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (ActivitiEnum.AuditResultType.PASS.getVal().equals(reqVo.getResult())) {
            entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.PASS.getValue());
            entity.setPassStatusDate(CrmDateUtils.yyyyMMddHHmmss.format(LocalDateTime.now()));
        } else if (ActivitiEnum.AuditResultType.REJECT.getVal().equals(reqVo.getResult())) {
            entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.REJECT.getValue());
        } else if (ActivitiEnum.AuditResultType.RECOVER.getVal().equals(reqVo.getResult())) {
            entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.ROLLBACK.getValue());
        } else {
            throw new BusinessException("\u5ba1\u6279\u5931\u8d25");
        }
        this.saveOrUpdate((Object)entity);
        return entity;
    }

    @Override
    public PageResult<SfaAuditListLeaveCancelRespVo> findAuditList(PageResult<TaskRspVO> taskRspVOPageResult, SfaAuditListLeaveCancelReqVo reqVo) {
        if (taskRspVOPageResult != null && taskRspVOPageResult.getCount() > 0L) {
            Map<String, TaskRspVO> taskMap = taskRspVOPageResult.getData().stream().collect(Collectors.toMap(TaskRspVO::getFormNo, vo -> vo, (key1, key2) -> key2));
            reqVo.setAuditTaskIdList(new ArrayList<String>(taskMap.keySet()));
            PageResult<SfaLeaveCancelInfoRespVo> pageResult = this.findInfoList(reqVo);
            if (pageResult.getCount() > 0L) {
                List data = pageResult.getData().stream().sorted((x, y) -> CrmDateUtils.parseyyyyMMddHHmmss((String)y.getApplicationDate()).compareTo(CrmDateUtils.parseyyyyMMddHHmmss((String)x.getApplicationDate()))).collect(Collectors.toList());
                pageResult.setData(data);
                ArrayList list = new ArrayList();
                pageResult.getData().forEach(vo -> list.add(new SfaAuditListLeaveCancelRespVo(vo, (TaskRspVO)taskMap.get(vo.getAuditTaskId()))));
                return PageResult.builder().data(list).count(pageResult.getCount()).build();
            }
        }
        return PageResult.builder().data(null).count(Long.valueOf(0L)).build();
    }
}

