/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.visitoffline.stepcomponent;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.attachment.SfaAttachmentEntity;
import com.biz.crm.base.utils.SfaAttachmentUtil;
import com.biz.crm.moblie.controller.visit.component.impl.OrderVisitStepExecutor;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.OrderStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.step.OrderStepExecuteDataResp;
import com.biz.crm.moblie.visitoffline.SfaVisitStepOffLineStrategy;
import com.biz.crm.moblie.visitoffline.stepcomponent.photoutil.SfaVisitStepOffLineUtil;
import com.biz.crm.moblie.visitoffline.stepdatavo.SfaVisitStepOrderVo;
import com.biz.crm.moblie.visitoffline.stepdatavo.req.VisitStepOffLineExecuteReq;
import com.biz.crm.nebular.activiti.vo.AttachmentOffLineVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.nebular.sfa.visitstep.visitoffline.VisitOfflineReqVo;
import com.biz.crm.tpmact.model.SfaTpmActBaseEntity;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.biz.crm.visitstep.model.SfaVisitStepOrderEntity;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderService;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

@Component(value="sfa_step_code_order_expandBean")
@ConditionalOnMissingBean(name={"SfaStepOrderComponentExpandImpl"})
public class SfaStepOrderComponent
implements SfaVisitStepOffLineStrategy {
    private static final Logger log = LoggerFactory.getLogger(SfaStepOrderComponent.class);
    private static String STEP_CODE;
    @Resource
    private OrderVisitStepExecutor orderVisitStepExecutor;
    @Resource
    private ISfaVisitStepOrderService sfaVisitStepOrderService;

    public Object buildVisitStepOffLineData(VisitOfflineReqVo reqVo) {
        SfaVisitStepOrderVo vo = new SfaVisitStepOrderVo();
        ExecutorLoadReq req = (ExecutorLoadReq)((Object)CrmBeanUtil.copy((Object)reqVo, ExecutorLoadReq.class));
        OrderStepExecuteDataResp dataResp = (OrderStepExecuteDataResp)this.orderVisitStepExecutor.load(req);
        vo.setSfaVisitStepFrom(dataResp.getSfaVisitStepFrom());
        List<MdmTerminalSupplyVo> mdmTerminalSupplyVos = this.sfaVisitStepOrderService.findTerminalSupplyList(reqVo.getClientCode());
        vo.setSupplyVoList(mdmTerminalSupplyVos);
        return vo;
    }

    @Override
    public Result saveVisitStepOffLine(VisitStepOffLineExecuteReq req) {
        Result result = new Result();
        try {
            VisitStepExecuteReq visitStepExecuteReq = (VisitStepExecuteReq)CrmBeanUtil.copy((Object)req, VisitStepExecuteReq.class);
            OrderStepExecuteData executeData = (OrderStepExecuteData)JSONObject.parseObject((String)JSONObject.toJSONString((Object)req.getStepExecuteData()), OrderStepExecuteData.class);
            visitStepExecuteReq.setStepExecuteData(executeData);
            this.orderVisitStepExecutor.executeOffLine(visitStepExecuteReq);
        }
        catch (BusinessException e) {
            log.error("\u4ee3\u5ba2\u4e0b\u5355\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMsg());
            result.setSuccess(false);
            result.setMessage("\u4ee3\u5ba2\u4e0b\u5355:\u9519\u8bef\u4fe1\u606f[" + e.getMsg() + "]");
        }
        return result;
    }

    @Override
    public void saveVisitStepOffLineFile(List<AttachmentOffLineVo> list, SfaVisitStepOffLineUtil util) {
        SfaVisitStepOrderEntity entity = (SfaVisitStepOrderEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sfaVisitStepOrderService.lambdaQuery().eq(SfaTpmActBaseEntity::getVisitPlanInfoId, (Object)util.getVisitPlanInfoId())).eq(SfaTpmActBaseEntity::getStepCode, (Object)util.getStepCode())).select(new SFunction[]{BaseIdEntity::getId}).one();
        if (null != entity) {
            List<SfaAttachmentEntity> fileEntity = list.stream().map(data -> {
                SfaAttachmentEntity file = (SfaAttachmentEntity)((Object)((Object)CrmBeanUtil.copy((Object)data, SfaAttachmentEntity.class)));
                file.setBizId(entity.getId());
                file.setAttachmentBizType(util.getType());
                file.setAttachmentBizTypeName(util.getTypeName());
                return file;
            }).collect(Collectors.toList());
            SfaAttachmentUtil.insert(fileEntity);
        }
    }

    @Override
    public String getStepCode() {
        return STEP_CODE;
    }

    @Override
    public void setStepCode(String stepCode) {
        STEP_CODE = stepCode;
    }
}

