/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cache.util;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.calculatesalary.service.ISfaCalculateSalaryDateService;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.WorkSignEnum;
import com.biz.crm.mdm.org.MdmOrgRedisFeign;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgParentChildrenRedisVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignRuleReqVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignRuleRespVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.worksignrule.mapper.SfaWorkSignRuleMapper;
import com.biz.crm.worksignrule.model.SfaWorkSignPersonnelEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignRuleEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignSpecialEntity;
import com.biz.crm.worksignrule.service.ISfaWorkSignPersonnelService;
import com.biz.crm.worksignrule.service.ISfaWorkSignRuleService;
import com.biz.crm.worksignrule.service.ISfaWorkSignSpecialService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SfaWorkSignRuleUtil {
    public static final String redisKey = "SFA_WORK_SIGN_RULE:v1:";
    @Autowired
    private RedisService redisService;
    @Resource
    private SfaWorkSignRuleMapper sfaWorkSignRuleMapper;
    @Resource
    private ISfaWorkSignRuleService iSfaWorkSignRuleService;
    @Resource
    private ISfaWorkSignPersonnelService iSfaWorkSignPersonnelService;
    @Resource
    private MdmOrgRedisFeign mdmOrgRedisFeign;
    @Resource
    private ISfaWorkSignSpecialService iSfaWorkSignSpecialService;
    @Resource
    private ISfaCalculateSalaryDateService dateService;

    public List<SfaWorkSignRuleEntity> getAllRule() {
        QueryWrapper wrappers = new QueryWrapper();
        wrappers.eq((Object)"enable_status", (Object)CrmEnableStatusEnum.ENABLE.getCode());
        wrappers.eq((Object)"del_flag", (Object)CrmDelFlagEnum.NORMAL.getCode());
        List rules = this.sfaWorkSignRuleMapper.selectList((Wrapper)wrappers);
        rules = rules == null ? new ArrayList() : rules;
        return rules;
    }

    public boolean checkPositionLevel(SfaWorkSignRuleEntity entity) {
        if (entity == null) {
            return false;
        }
        List<SfaWorkSignPersonnelEntity> entities = this.iSfaWorkSignPersonnelService.findByRuleCodeAndCodeType(entity.getRuleCode(), WorkSignEnum.codeType.POS_LEVEL.getVal());
        return CollectionUtil.listNotEmpty(entities);
    }

    public boolean checkPositionLevel(SfaWorkSignRuleEntity entity, List<MdmPositionRespVo> mdmPositionRespVos) {
        if (entity == null) {
            return false;
        }
        List<SfaWorkSignPersonnelEntity> entities = this.iSfaWorkSignPersonnelService.findByRuleCodeAndCodeType(entity.getRuleCode(), WorkSignEnum.codeType.POS_LEVEL.getVal());
        if (CollectionUtil.listEmpty(entities)) {
            return true;
        }
        Set positionLevelSet = mdmPositionRespVos.stream().map(MdmPositionRespVo::getPositionLevelCode).collect(Collectors.toSet());
        entities = entities.stream().filter(en -> positionLevelSet.contains(en.getWspCode())).collect(Collectors.toList());
        return CollectionUtil.listNotEmpty(entities);
    }

    public boolean checkPositionOrg(SfaWorkSignRuleEntity entity, List<MdmPositionRespVo> mdmPositionRespVos) {
        if (entity == null) {
            return false;
        }
        List<SfaWorkSignPersonnelEntity> entities = this.iSfaWorkSignPersonnelService.findByRuleCodeAndCodeType(entity.getRuleCode(), WorkSignEnum.codeType.ORG.getVal());
        if (CollectionUtil.listEmpty(entities)) {
            return false;
        }
        boolean flag = false;
        Set orgCodeSet = mdmPositionRespVos.stream().map(MdmPositionRespVo::getOrgCode).collect(Collectors.toSet());
        List mdmOrgParentChildrenRedisVos = (List)this.mdmOrgRedisFeign.findRedisOrgChildrenListByCodeList((List)Lists.newArrayList(orgCodeSet)).getResult();
        if (mdmOrgParentChildrenRedisVos == null) {
            mdmOrgParentChildrenRedisVos = Lists.newArrayList();
        }
        HashSet childrenOrgCodes = CollectionUtil.listEmpty((List)mdmOrgParentChildrenRedisVos) ? Sets.newHashSet() : mdmOrgParentChildrenRedisVos.stream().map(MdmOrgParentChildrenRedisVo::getOrgCode).collect(Collectors.toSet());
        for (SfaWorkSignPersonnelEntity en : entities) {
            if (Objects.equals(en.getCurrentAble(), CommonConstant.GLOBAL.YesOrNo.Y.getItemCode())) {
                if (!orgCodeSet.contains(en.getWspCode())) continue;
                flag = true;
                break;
            }
            if (!childrenOrgCodes.contains(en.getWspCode())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public boolean checkMust(SfaWorkSignRuleEntity entity, String executeDate) {
        if (entity == null) {
            return false;
        }
        SfaWorkSignSpecialEntity specialEntity = this.iSfaWorkSignSpecialService.findByRuleCodeAndWssDate(entity.getRuleCode(), executeDate);
        if (specialEntity != null && Objects.equals(specialEntity.getWssType(), YesNoEnum.yesNoEnum.ONE.getValue())) {
            return true;
        }
        if (specialEntity != null && Objects.equals(specialEntity.getWssType(), YesNoEnum.yesNoEnum.TWO.getValue())) {
            return false;
        }
        boolean holiday = this.dateService.isHoliday(executeDate);
        if (holiday) {
            return false;
        }
        return StringUtils.isNotEmpty((String)entity.getWorkingDay()) && entity.getWorkingDay().contains(DateUtil.getWeek((String)executeDate));
    }

    public String getKey(String ruleCode) {
        if (StringUtils.isEmpty((String)ruleCode)) {
            throw new BusinessException("\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return redisKey + ruleCode;
    }

    public void deleteKey(String ruleCode) {
        this.redisService.del(new String[]{this.getKey(ruleCode)});
    }

    public void setObj(SfaWorkSignRuleRespVo sfaWorkSignRuleRespVo) {
        String key = this.getKey(sfaWorkSignRuleRespVo.getRuleCode());
        this.redisService.set(key, (Object)sfaWorkSignRuleRespVo);
    }

    public SfaWorkSignRuleRespVo getObj(String ruleCode) {
        Object o = this.redisService.get(this.getKey(ruleCode));
        if (o == null) {
            return this.compensate(ruleCode);
        }
        SfaWorkSignRuleRespVo sfaWorkSignRuleRespVo = (SfaWorkSignRuleRespVo)o;
        if (StringUtils.isEmpty((String)sfaWorkSignRuleRespVo.getRuleCode())) {
            return null;
        }
        return sfaWorkSignRuleRespVo;
    }

    public SfaWorkSignRuleRespVo compensate(String ruleCode) {
        if (StringUtils.isEmpty((String)ruleCode)) {
            this.redisService.set(this.getKey(new String()), null);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"rule_code", (Object)ruleCode);
        SfaWorkSignRuleEntity entity = (SfaWorkSignRuleEntity)((Object)this.iSfaWorkSignRuleService.getOne((Wrapper)queryWrapper));
        SfaWorkSignRuleReqVo param = new SfaWorkSignRuleReqVo();
        param.setId(entity.getId());
        SfaWorkSignRuleRespVo vo = this.iSfaWorkSignRuleService.query(param);
        if (vo == null) {
            this.redisService.set(this.getKey(ruleCode), null);
        }
        this.setObj(vo);
        return vo;
    }
}

