/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.moblie.controller.visit.component.VisitDataDurabilityService;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.moblie.controller.visit.req.step.HelpScoreStepExecuteData;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.visitstep.mapper.SfaVisitStepHelpScoreMapper;
import com.biz.crm.visitstep.model.SfaVisitStepHelpScoreDetailEntity;
import com.biz.crm.visitstep.model.SfaVisitStepHelpScoreEntity;
import com.biz.crm.visitstep.model.SfaVisitStepHelpScoreEsData;
import com.biz.crm.visitstep.model.SfaVisitStepHelpScoreRedisData;
import com.biz.crm.visitstep.repositories.SfaVisitStepHelpScoreEsDataRepositories;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstep.service.ISfaVisitStepHelpScoreDetailService;
import com.biz.crm.visitstep.service.ISfaVisitStepHelpScoreService;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"sfaVisitStepHelpScoreServiceExpandImpl"})
@Transactional
public class SfaVisitStepHelpScoreServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaVisitStepHelpScoreMapper, SfaVisitStepHelpScoreEntity>
implements ISfaVisitStepHelpScoreService,
VisitDataDurabilityService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitStepHelpScoreServiceImpl.class);
    @Resource
    private SfaVisitStepHelpScoreEsDataRepositories sfaVisitStepHelpScoreEsDataRepositories;
    @Resource
    private ISfaVisitStepHelpScoreDetailService sfaVisitStepHelpScoreDetailService;

    @Override
    @Transactional
    public List<? extends VisitStepListener.VisitStepListenerCommittedData> dataDurability(List<? extends VisitStepListener.VisitStepListenerCommittedData> baseEntity, SfaVisitStepFromRespVo fromRespVo) {
        if (CollectionUtils.isEmpty(baseEntity)) {
            return Lists.newArrayList();
        }
        SfaVisitStepHelpScoreRedisData redisData = (SfaVisitStepHelpScoreRedisData)baseEntity.get(0);
        baseEntity = Lists.newArrayList((Object[])new SfaVisitStepHelpScoreRedisData[]{this.save(redisData)});
        this.doTransToEs(redisData, fromRespVo);
        return baseEntity;
    }

    @Override
    @Transactional
    public SfaVisitStepHelpScoreRedisData save(SfaVisitStepHelpScoreRedisData redisData) {
        this.saveOrUpdate(redisData);
        this.sfaVisitStepHelpScoreDetailService.remove((Wrapper)Wrappers.lambdaQuery(SfaVisitStepHelpScoreDetailEntity.class).eq(SfaVisitStepHelpScoreDetailEntity::getHelpScoreId, (Object)redisData.getId()));
        List<HelpScoreStepExecuteData.HelpScoreDetailReqVo> helpScoreDetailList = redisData.getHelpScoreDetailList();
        if (!CollectionUtils.isEmpty(helpScoreDetailList)) {
            List itemEntities = helpScoreDetailList.stream().map(v -> {
                SfaVisitStepHelpScoreDetailEntity copy = (SfaVisitStepHelpScoreDetailEntity)((Object)((Object)CrmBeanUtil.copy((Object)v, SfaVisitStepHelpScoreDetailEntity.class)));
                copy.setHelpScoreId(redisData.getId());
                return copy;
            }).collect(Collectors.toList());
            this.sfaVisitStepHelpScoreDetailService.saveOrUpdateBatch(itemEntities);
        }
        return redisData;
    }

    protected void doTransToEs(SfaVisitStepHelpScoreRedisData redisData, SfaVisitStepFromRespVo fromRespVo) {
        SfaVisitStepHelpScoreEsData oldData;
        SfaVisitStepHelpScoreEsData dataResp = (SfaVisitStepHelpScoreEsData)CrmBeanUtil.copy((Object)redisData, SfaVisitStepHelpScoreEsData.class);
        dataResp.setHelpScoreDetailList(redisData.getHelpScoreDetailList());
        dataResp.setSfaVisitStepFrom(fromRespVo);
        if (StringUtils.isNotBlank((CharSequence)dataResp.getVisitPlanInfoId()) && null != (oldData = this.sfaVisitStepHelpScoreEsDataRepositories.findByVisitPlanInfoIdAndStepCode(dataResp.getVisitPlanInfoId(), dataResp.getStepCode()))) {
            dataResp.setId(oldData.getId());
        }
        this.sfaVisitStepHelpScoreEsDataRepositories.save(dataResp);
    }
}

