/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.achievement.model.SfaAchievementAccomplishRecordEntity;
import com.biz.crm.achievement.service.ISfaAchievementAccomplishRecordService;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.enums.SfaOrderSourceEnum;
import com.biz.crm.enums.SfaWorkSummaryEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaActivityEnum;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.moblie.controller.visit.component.VisitDataDurabilityService;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.moblie.controller.workbench.req.OrderAsDataReq;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.sfa.tpmact.VisitBaseVo;
import com.biz.crm.nebular.sfa.tpmact.distributionorder.DistributionOrderVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActDetailRespVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepOrderReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepOrderRespVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.tpmact.model.SfaTpmActBaseEntity;
import com.biz.crm.tpmact.model.SfaTpmActDetailProductEntity;
import com.biz.crm.tpmact.service.ISfaTpmActDetailProductService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitstep.mapper.SfaVisitStepOrderMapper;
import com.biz.crm.visitstep.model.SfaVisitStepOrderEntity;
import com.biz.crm.visitstep.model.SfaVisitStepOrderEsData;
import com.biz.crm.visitstep.model.SfaVisitStepOrderItemEntity;
import com.biz.crm.visitstep.model.SfaVisitStepOrderRedisData;
import com.biz.crm.visitstep.repositories.SfaVisitStepOrderEsDataRepositories;
import com.biz.crm.visitstep.req.GetOrderPageReq;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderItemService;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderService;
import com.biz.crm.visitstepbase.VisitBaseCheck;
import com.biz.crm.visitstepbase.VisitBaseComponent;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"sfaVisitStepOrderServiceExpandImpl"})
@Transactional
public class SfaVisitStepOrderServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaVisitStepOrderMapper, SfaVisitStepOrderEntity>
implements ISfaVisitStepOrderService,
VisitDataDurabilityService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitStepOrderServiceImpl.class);
    @Resource
    private ISfaVisitStepOrderItemService sfaVisitStepOrderItemService;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Resource
    private ISfaAchievementAccomplishRecordService sfaAchievementAccomplishRecordService;
    @Resource
    private SfaVisitStepOrderEsDataRepositories sfaVisitStepOrderEsDataRepositories;
    @Resource
    private RedisService redisService;
    @Resource
    private VisitBaseComponent visitBaseComponent;
    @Autowired
    private ISfaTpmActDetailProductService sfaTpmActDetailProductService;
    @Resource
    private SfaVisitStepOrderMapper sfaVisitStepOrderMapper;

    @Override
    @Transactional
    public List<? extends VisitStepListener.VisitStepListenerCommittedData> dataDurability(List<? extends VisitStepListener.VisitStepListenerCommittedData> baseEntity, SfaVisitStepFromRespVo fromRespVo) {
        if (CollectionUtils.isEmpty(baseEntity)) {
            return Lists.newArrayList();
        }
        SfaVisitStepOrderRedisData redisData = (SfaVisitStepOrderRedisData)baseEntity.get(0);
        baseEntity = Lists.newArrayList((Object[])new SfaVisitStepOrderRedisData[]{this.save(redisData)});
        this.doTransToEs(redisData, fromRespVo);
        return baseEntity;
    }

    @Override
    @Transactional
    public SfaVisitStepOrderRedisData save(SfaVisitStepOrderRedisData redisData) {
        if (StringUtils.isBlank((CharSequence)redisData.getOrderCode())) {
            redisData.setOrderCode(CodeUtil.generateCode((String)SfaCodeEnum.ORDER_CODE.SFA_ORDER_CODE.getVal()));
        }
        this.saveOrUpdate(redisData);
        this.sfaVisitStepOrderItemService.remove((Wrapper)Wrappers.lambdaQuery(SfaVisitStepOrderItemEntity.class).eq(SfaVisitStepOrderItemEntity::getOrderId, (Object)redisData.getId()));
        List<OrderAsDataReq.OrderItemAsReqVo> orderItems = redisData.getSfaVisitStepOrderItems();
        if (!CollectionUtils.isEmpty(orderItems)) {
            List itemEntities = orderItems.stream().map(v -> {
                SfaVisitStepOrderItemEntity copy = (SfaVisitStepOrderItemEntity)((Object)((Object)CrmBeanUtil.copy((Object)v, SfaVisitStepOrderItemEntity.class)));
                copy.setOrderId(redisData.getId());
                return copy;
            }).collect(Collectors.toList());
            this.sfaVisitStepOrderItemService.saveOrUpdateBatch(itemEntities);
        }
        return redisData;
    }

    protected void doTransToEs(SfaVisitStepOrderRedisData redisData, SfaVisitStepFromRespVo fromRespVo) {
        SfaVisitStepOrderEsData dataResp = (SfaVisitStepOrderEsData)CrmBeanUtil.copy((Object)redisData, SfaVisitStepOrderEsData.class);
        dataResp.setSfaVisitStepOrderItems(redisData.getSfaVisitStepOrderItems());
        dataResp.setSfaVisitStepFrom(fromRespVo);
        if (StringUtils.isBlank((CharSequence)dataResp.getOrderCode())) {
            redisData.setOrderCode(CodeUtil.generateCode((String)SfaCodeEnum.ORDER_CODE.SFA_ORDER_CODE.getVal()));
        }
        this.sfaVisitStepOrderEsDataRepositories.save(dataResp);
    }

    @Override
    public List<MdmTerminalSupplyVo> findTerminalSupplyList(String terminalCode) {
        List mdmTerminalSupplyVos = Lists.newArrayList();
        Result mdmTerminalVoResult = this.mdmTerminalFeign.query(null, terminalCode);
        if (mdmTerminalVoResult.isSuccess() && mdmTerminalVoResult.getResult() != null && CollectionUtil.listNotEmptyNotSizeZero((List)((MdmTerminalVo)mdmTerminalVoResult.getResult()).getSupplys())) {
            mdmTerminalSupplyVos = ((MdmTerminalVo)mdmTerminalVoResult.getResult()).getSupplys();
        }
        return mdmTerminalSupplyVos;
    }

    @Override
    public Integer getOrderNum(String dateFlag2) {
        AssertUtils.isNotEmpty((String)dateFlag2, (String)"\u8bf7\u4f20\u5165\u67e5\u8be2\u65f6\u95f4\u8303\u56f4\u7c7b\u578b\u2014\u2014\u672c\u65e5\u3001\u672c\u5468\u3001\u672c\u6708");
        UserRedis user = UserUtils.getUser();
        LocalDate nowTime = LocalDate.now();
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaAchievementAccomplishRecordEntity.class).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).eq(SfaAchievementAccomplishRecordEntity::getIndexCode, (Object)SfaVisitEnum.indexType.XD.getCode())).eq(CrmBaseEntity::getCreateCode, (Object)user.getUsername());
        if (SfaWorkSummaryEnum.dateFlag.TODAY.getCode().equals(dateFlag2)) {
            String dayTime = nowTime.format(CrmDateUtils.yyyyMMdd);
            queryWrapper.eq(CrmBaseEntity::getCreateDate, (Object)dayTime);
        }
        if (SfaWorkSummaryEnum.dateFlag.WEEK.getCode().equals(dateFlag2)) {
            String weekTime = nowTime.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).format(CrmDateUtils.yyyyMMdd);
            String nowDayTime = nowTime.format(CrmDateUtils.yyyyMMdd);
            queryWrapper.between(CrmBaseEntity::getCreateDate, (Object)weekTime, (Object)nowDayTime);
        }
        if (SfaWorkSummaryEnum.dateFlag.MONTH.getCode().equals(dateFlag2)) {
            String monthTime = nowTime.format(DateTimeFormatter.ofPattern("yyyy-MM"));
            queryWrapper.like(CrmBaseEntity::getCreateDate, (Object)monthTime);
        }
        int count = this.sfaAchievementAccomplishRecordService.count((Wrapper)queryWrapper);
        return count;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String saveWorkBenchDistributionOrder(DistributionOrderVo vo) {
        SfaVisitStepOrderEntity oldEntity;
        List<DistributionOrderVo.DistributionOrderItem> orderItemList = this.checkDistributionOrder(vo);
        SfaVisitStepOrderEntity orderEntity = (SfaVisitStepOrderEntity)CrmBeanUtil.copy((Object)vo, SfaVisitStepOrderEntity.class);
        if (StringUtils.isBlank((CharSequence)vo.getOrderCode())) {
            orderEntity.setOrderCode(CodeUtil.generateCode((String)SfaCodeEnum.ORDER_CODE.SFA_ORDER_CODE.getVal()));
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getVisitPlanInfoId()) && (oldEntity = (SfaVisitStepOrderEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaTpmActBaseEntity::getVisitPlanInfoId, (Object)vo.getVisitPlanInfoId())).eq(SfaVisitStepOrderEntity::getActDetailCode, (Object)vo.getActDetailCode())).one()) != null) {
            orderEntity.setId(oldEntity.getId());
        }
        this.buildEntity(orderEntity, vo.getClientCode());
        this.visitBaseComponent.checkTpmActDistributionOrderAmount(vo.getActDetailCode(), vo.getTotalPrice(), vo.getClientCode());
        this.saveOrUpdate(orderEntity);
        vo.setId(orderEntity.getId());
        this.sfaVisitStepOrderItemService.remove((Wrapper)Wrappers.lambdaQuery(SfaVisitStepOrderItemEntity.class).eq(SfaVisitStepOrderItemEntity::getOrderId, (Object)orderEntity.getId()));
        List itemEntities = orderItemList.stream().map(item -> {
            SfaVisitStepOrderItemEntity itemEntity = (SfaVisitStepOrderItemEntity)((Object)((Object)CrmBeanUtil.copy((Object)item, SfaVisitStepOrderItemEntity.class)));
            itemEntity.setUnit(item.getSaleUnit());
            itemEntity.setUnitName(item.getSaleUnitName());
            itemEntity.setOrderId(orderEntity.getId());
            return itemEntity;
        }).collect(Collectors.toList());
        this.sfaVisitStepOrderItemService.saveBatch(itemEntities);
        this.redisService.hmset(DistributionOrderVo.getRedisHashKey((String)orderEntity.getId()), DistributionOrderVo.buildMap((String)orderEntity.getId(), (DistributionOrderVo)vo), DistributionOrderVo.redis_expire_time.longValue());
        this.visitBaseComponent.saveOrderSetTpmActAmount(vo.getActDetailCode(), vo.getClientCode());
        orderEntity.setId(orderEntity.getActDetailCode());
        this.visitBaseComponent.tpmDoListener(orderEntity);
        return orderEntity.getId();
    }

    @Override
    public DistributionOrderVo loadTpmActDistributionOrderDetail(String id) {
        Object obj = this.redisService.hmget(DistributionOrderVo.getRedisHashKey((String)id), (Object)id);
        DistributionOrderVo orderVo = new DistributionOrderVo();
        if (null == obj) {
            SfaVisitStepOrderEntity entity = (SfaVisitStepOrderEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)id)).one();
            if (null == entity) {
                throw new BusinessException("\u4e3b\u952eid\u9519\u8bef,\u672a\u67e5\u8be2\u5230\u5206\u9500\u8ba2\u5355\u4fe1\u606f");
            }
            orderVo = (DistributionOrderVo)CrmBeanUtil.copy((Object)entity, DistributionOrderVo.class);
            List itemEntityList = ((LambdaQueryChainWrapper)this.sfaVisitStepOrderItemService.lambdaQuery().eq(SfaVisitStepOrderItemEntity::getOrderId, (Object)id)).list();
            Map<String, List<SfaVisitStepOrderItemEntity>> itemMap = itemEntityList.stream().collect(Collectors.groupingBy(SfaVisitStepOrderItemEntity::getItmeType));
            if (null != itemMap && itemMap.size() > 0) {
                for (Map.Entry<String, List<SfaVisitStepOrderItemEntity>> data : itemMap.entrySet()) {
                    List orderItems = CrmBeanUtil.copyList(data.getValue(), DistributionOrderVo.DistributionOrderItem.class);
                    if (data.getKey().equals(SfaActivityEnum.bpItemType.bp.getVal())) {
                        orderVo.setBpProductList(orderItems);
                        continue;
                    }
                    orderVo.setZpProductList(orderItems);
                }
            }
        } else {
            orderVo = (DistributionOrderVo)obj;
        }
        this.redisService.hmset(DistributionOrderVo.getRedisHashKey((String)id), DistributionOrderVo.buildMap((String)id, (DistributionOrderVo)orderVo), DistributionOrderVo.redis_expire_time.longValue());
        return orderVo;
    }

    @Override
    public String saveVisitStepDistributionOrder(VisitBaseVo<DistributionOrderVo> vo) {
        VisitBaseCheck.checkBaseData(vo);
        DistributionOrderVo orderVo = (DistributionOrderVo)vo.getStepExecuteData();
        orderVo.setStepCode("tpm");
        orderVo.setFormId(vo.getFormId());
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(vo.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.visitBaseComponent.loadAndCheckSfaVisitPlanInfoEntity(vo.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        orderVo.setVisitPlanInfoId(sfaVisitPlanInfoEntity.getId());
        orderVo.setStepCode(SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_TPM.getVal());
        SfaVisitStepFromRespVo fromRespVo = this.visitBaseComponent.getFormData(vo.getFormId(), SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_TPM.getVal());
        if (null == orderVo.getLineStatus() || SfaVisitEnum.VISIT_OFF_LINE.online.getVal().equals(orderVo.getLineStatus())) {
            VisitBaseCheck.checkVisitStepDistance(sfaVisitPlanInfoEntity, fromRespVo, orderVo.getLongitude(), orderVo.getLatitude());
        }
        this.visitBaseComponent.updateStepStatus(vo.getRedisHashKey(), fromRespVo.getStepCode(), visitRedisHashKey.getVisitBigType());
        return this.saveWorkBenchDistributionOrder(orderVo);
    }

    @Override
    public PageResult<SfaVisitStepOrderRespVo> orderDetailReport(SfaVisitStepOrderReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitStepOrderRespVo> list = this.sfaVisitStepOrderMapper.findOrderReportList((Page<SfaVisitStepOrderRespVo>)page, reqVo);
        return PageResult.builder().count(Long.valueOf(page.getTotal())).data(list).build();
    }

    @Override
    public PageResult<SfaVisitStepOrderRespVo> getWorkbenchOrderPage(GetOrderPageReq req) {
        List<SfaVisitStepOrderRespVo> list;
        Page page = new Page((long)req.getPageNum().intValue(), (long)req.getPageSize().intValue());
        if (StringUtils.isBlank((CharSequence)req.getPosCode()) && StringUtils.isBlank((CharSequence)req.getPosName())) {
            req.setPosCode(UserUtils.getUser().getPoscode());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(list = this.sfaVisitStepOrderMapper.findWorkbenchOrderPage((Page<SfaVisitStepOrderRespVo>)page, req))) {
            List orderIds = list.stream().map(UuidVo::getId).collect(Collectors.toList());
            Map<String, List<SfaVisitStepOrderItemEntity>> itemListMap = ((LambdaQueryChainWrapper)this.sfaVisitStepOrderItemService.lambdaQuery().in(SfaVisitStepOrderItemEntity::getOrderId, orderIds)).select(new SFunction[]{SfaVisitStepOrderItemEntity::getQuantity, SfaVisitStepOrderItemEntity::getPrice, SfaVisitStepOrderItemEntity::getProductCode, SfaVisitStepOrderItemEntity::getProductName, SfaVisitStepOrderItemEntity::getSeriesCode, SfaVisitStepOrderItemEntity::getSeriesName, SfaVisitStepOrderItemEntity::getOrderId}).list().stream().collect(Collectors.groupingBy(SfaVisitStepOrderItemEntity::getOrderId));
            list.forEach(resp -> {
                if (itemListMap.containsKey(resp.getId())) {
                    List itemList = (List)itemListMap.get(resp.getId());
                    BigDecimal priceTotal = itemList.stream().filter(item -> item.getPrice() != null).map(SfaVisitStepOrderItemEntity::getPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal quantityTotal = itemList.stream().filter(item -> item.getQuantity() != null).map(SfaVisitStepOrderItemEntity::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                    StringJoiner productName = new StringJoiner(",");
                    StringJoiner productCode = new StringJoiner(",");
                    StringJoiner seriesCode = new StringJoiner(",");
                    StringJoiner seriesName = new StringJoiner(",");
                    itemList.forEach(item -> {
                        productName.add(item.getProductName());
                        productCode.add(item.getProductCode());
                        seriesCode.add(item.getSeriesCode());
                        seriesName.add(item.getSeriesName());
                    });
                    resp.setProductCode(productCode.toString());
                    resp.setProductName(productName.toString());
                    resp.setSeriesCode(seriesCode.toString());
                    resp.setSeriesName(seriesName.toString());
                    resp.setQuantity(quantityTotal);
                    resp.setTotalPrice(priceTotal);
                }
            });
        }
        return PageResult.builder().count(Long.valueOf(page.getTotal())).data(list).build();
    }

    protected List<DistributionOrderVo.DistributionOrderItem> checkDistributionOrder(DistributionOrderVo vo) {
        ArrayList<DistributionOrderVo.DistributionOrderItem> orderItems = new ArrayList<DistributionOrderVo.DistributionOrderItem>();
        AssertUtils.isNotEmpty((String)vo.getActDetailCode(), (String)"\u6d3b\u52a8\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)vo.getClientCode(), (String)"\u7ec8\u7aef\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)vo.getClientName(), (String)"\u7ec8\u7aef\u540d\u79f0\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)vo.getCustomerCode(), (String)"\u4e0a\u7ea7\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)vo.getCustomerName(), (String)"\u4e0a\u7ea7\u5ba2\u6237\u540d\u79f0\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)vo.getContacts(), (String)"\u8054\u7cfb\u4eba\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)vo.getTelephone(), (String)"\u8054\u7cfb\u7535\u8bdd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)vo.getAddress(), (String)"\u6536\u8d27\u5730\u5740\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)vo.getExpectReceive(), (String)"\u671f\u671b\u5230\u8d27\u65f6\u95f4\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((Collection)vo.getBpProductList(), (String)"\u672c\u54c1\u5217\u8868\u4e3a\u7a7a");
        Map<String, SfaTpmActDetailProductEntity> productMap = ((LambdaQueryChainWrapper)this.sfaTpmActDetailProductService.lambdaQuery().eq(SfaTpmActDetailProductEntity::getActDetailCode, (Object)vo.getActDetailCode())).list().stream().collect(Collectors.toMap(data -> data.getProductCode() + data.getIsGiftProduct(), k -> k));
        vo.getBpProductList().forEach(data -> {
            AssertUtils.isNotEmpty((String)data.getProductCode(), (String)"\u672c\u54c1-\u4ea7\u54c1\u7f16\u7801\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)data.getProductName(), (String)"\u672c\u54c1-\u4ea7\u54c1\u540d\u79f0\u4e3a\u7a7a");
            if (data.getQuantity() == null) {
                throw new BusinessException("\u672c\u54c1-" + data.getProductName() + "\u6570\u91cf\u4e3a\u7a7a");
            }
            if (data.getPrice() == null) {
                throw new BusinessException("\u672c\u54c1-" + data.getProductName() + "\u4ef7\u683c\u4e3a\u7a7a");
            }
            String key = data.getProductCode() + YesNoEnum.yesNoEnum.Y.getValue();
            if (productMap.containsKey(key)) {
                data.setSaleUnit(((SfaTpmActDetailProductEntity)((Object)((Object)productMap.get(key)))).getSaleUnit());
                data.setSaleUnitName(((SfaTpmActDetailProductEntity)((Object)((Object)productMap.get(key)))).getSaleUnitName());
            }
            data.setItmeType(SfaActivityEnum.bpItemType.bp.getVal());
            orderItems.add((DistributionOrderVo.DistributionOrderItem)data);
        });
        vo.setTotalPrice(vo.getBpProductList().stream().map(data -> data.getPrice().multiply(data.getQuantity())).reduce(BigDecimal.ZERO, BigDecimal::add));
        Map map = this.redisService.hmget(SfaTpmActDetailRespVo.buildRedisKey((String)vo.getActDetailCode()));
        if (map.containsValue(SfaActivityEnum.bpItemType.zp.getVal())) {
            AssertUtils.isNotEmpty((Collection)vo.getZpProductList(), (String)"\u8d60\u54c1\u5217\u8868\u4e3a\u7a7a");
            vo.getZpProductList().forEach(data -> {
                AssertUtils.isNotEmpty((String)data.getProductCode(), (String)"\u8d60\u54c1-\u4ea7\u54c1\u7f16\u7801\u4e3a\u7a7a");
                AssertUtils.isNotEmpty((String)data.getProductName(), (String)"\u8d60\u54c1-\u4ea7\u54c1\u540d\u79f0\u4e3a\u7a7a");
                if (data.getQuantity() == null) {
                    throw new BusinessException("\u8d60\u54c1-" + data.getProductName() + "\u6570\u91cf\u4e3a\u7a7a");
                }
                data.setItmeType(SfaActivityEnum.bpItemType.zp.getVal());
                orderItems.add((DistributionOrderVo.DistributionOrderItem)data);
            });
            vo.setTotalPrice(vo.getZpProductList().stream().map(data -> data.getPrice().multiply(data.getQuantity())).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        return orderItems;
    }

    protected void buildEntity(SfaVisitStepOrderEntity entity, String terminalCode) {
        MdmTerminalVo terminalVo;
        Result terminalResult = this.mdmTerminalFeign.query(null, terminalCode);
        if (null != terminalResult && terminalResult.isSuccess() && terminalResult.getResult() != null) {
            terminalVo = (MdmTerminalVo)terminalResult.getResult();
            entity.setClientPhoto(terminalVo.getShopImagePath());
            entity.setClientType(SfaVisitEnum.ClientType.TERMINAL.getVal());
            entity.setClientTypeName(SfaVisitEnum.ClientType.TERMINAL.getDesc());
            List mdmTerminalContactVos = terminalVo.getContacts();
            if (!CollectionUtils.isEmpty((Collection)mdmTerminalContactVos)) {
                entity.setClientPhone(((MdmTerminalContactVo)mdmTerminalContactVos.get(0)).getContactPhone());
            }
        } else {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u7ec8\u7aef\u4fe1\u606f,\u7ec8\u7aef\u7f16\u7801[" + terminalResult + "]");
        }
        entity.setClientSubclass(terminalVo.getTerminalType());
        entity.setClientSubclassName(terminalVo.getTerminalTypeName());
        UserRedis userRedis = UserUtils.getUser();
        entity.setUserName(userRedis.getUsername());
        entity.setRealName(userRedis.getRealname());
        entity.setPosCode(userRedis.getPoscode());
        entity.setPosName(userRedis.getPosname());
        entity.setOrgCode(userRedis.getOrgcode());
        entity.setOrgName(userRedis.getOrgname());
        entity.setOrderTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        entity.setOrderDate(LocalDateTime.now().format(CrmDateUtils.yyyyMMdd));
        entity.setOrderYearMonth(LocalDateTime.now().format(CrmDateUtils.yyyyMM));
        entity.setOrderYear(LocalDateTime.now().format(CrmDateUtils.yyyy));
        entity.setOrderSource(SfaOrderSourceEnum.TPMACT.getCode());
        entity.setOrderSourceName(SfaOrderSourceEnum.TPMACT.getDesc());
        entity.setApprovalStatus(SfaCommonEnum.orderApporvalEnum.NORMAL.getValue());
        entity.setApprovalStatusName(SfaCommonEnum.orderApporvalEnum.NORMAL.getDesc());
    }
}

